package spark.accessibility
{
   import mx.accessibility.AccImpl;
   import mx.core.mx_internal;
   import spark.components.supportClasses.ButtonBase;
   import mx.core.UIComponent;
   import flash.events.KeyboardEvent;
   import flash.ui.Keyboard;
   import flash.events.Event;
   import flash.accessibility.Accessibility;
   import mx.accessibility.AccConst;
   
   use namespace mx_internal;
   
   public class ButtonBaseAccImpl extends AccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function ButtonBaseAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_PUSHBUTTON;
      }
      
      public static function enableAccessibility() : void
      {
         ButtonBase.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityImplementation = new ButtonBaseAccImpl(component);
      }
      
      override protected function get eventsToHandle() : Array
      {
         return super.eventsToHandle.concat(["click","labelChanged"]);
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = getState(childID);
         return accState;
      }
      
      override public function get_accDefaultAction(childID:uint) : String
      {
         return "Press";
      }
      
      override public function accDoDefaultAction(childID:uint) : void
      {
         var event:KeyboardEvent = null;
         if(master.enabled)
         {
            event = new KeyboardEvent(KeyboardEvent.KEY_DOWN);
            event.keyCode = Keyboard.SPACE;
            master.dispatchEvent(event);
            event = new KeyboardEvent(KeyboardEvent.KEY_UP);
            event.keyCode = Keyboard.SPACE;
            master.dispatchEvent(event);
         }
      }
      
      override protected function getName(childID:uint) : String
      {
         var label:String = ButtonBase(master).label;
         return Boolean(label != null) && Boolean(label != "")?label:"";
      }
      
      override protected function eventHandler(event:Event) : void
      {
         $eventHandler(event);
         switch(event.type)
         {
            case "click":
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_STATECHANGE);
               Accessibility.updateProperties();
               break;
            case "labelChanged":
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_NAMECHANGE);
               Accessibility.updateProperties();
         }
      }
   }
}
