package org.alivepdf.fonts
{
   public final class FontDescription
   {
       
      private var _ascent:int;
      
      private var _descent:int;
      
      private var _capHeight:int;
      
      private var _flags:int;
      
      private var _boundingBox:Array;
      
      private var _italicAngle:int;
      
      private var _stemV:int;
      
      private var _missingWidth:int;
      
      private var _fontWeight:String;
      
      private var _averageWidth:int;
      
      public function FontDescription(fontWeight:String, averageWidth:int, ascent:int, descent:int, capHeight:int, flags:int, fontBoundingBox:Array, italicAngle:int, stemV:int, missingWidth:int)
      {
         super();
         this._fontWeight = fontWeight;
         this._averageWidth = averageWidth;
         this._ascent = ascent;
         this._descent = descent;
         this._capHeight = capHeight;
         this._flags = flags;
         this._boundingBox = fontBoundingBox;
         this._italicAngle = italicAngle;
         this._stemV = stemV;
         this._missingWidth = missingWidth;
      }
      
      public function get fontWeight() : String
      {
         return this._fontWeight;
      }
      
      public function get averageWidth() : int
      {
         return this._averageWidth;
      }
      
      public function get ascent() : int
      {
         return this._ascent;
      }
      
      public function get descent() : int
      {
         return this._descent;
      }
      
      public function get capHeight() : int
      {
         return this._capHeight;
      }
      
      public function get flags() : int
      {
         return this._flags;
      }
      
      public function get boundingBox() : Array
      {
         return this._boundingBox;
      }
      
      public function get italicAngle() : int
      {
         return this._italicAngle;
      }
      
      public function get stemV() : int
      {
         return this._stemV;
      }
      
      public function get missingWidth() : int
      {
         return this._missingWidth;
      }
      
      public function toString() : String
      {
         return "[FontDescription weight=" + this.fontWeight + " width=" + this.averageWidth + " ascent=" + this.ascent + " descent=" + this.descent + " capHeight=" + this.capHeight + " flags=" + this.flags + " boundingBox=" + this.boundingBox + " italicAngle=" + this.italicAngle + " stemV=" + this.stemV + " missingWidth=" + this.missingWidth + "]";
      }
   }
}
