package mx.managers
{
   import mx.core.mx_internal;
   import mx.core.Singleton;
   import mx.managers.dragClasses.DragProxy;
   import mx.core.IUIComponent;
   import mx.core.DragSource;
   import flash.events.MouseEvent;
   import mx.core.IFlexDisplayObject;
   
   use namespace mx_internal;
   
   [Style(inherit="no",name="rejectCursor",type="Class")]
   [Style(inherit="no",name="moveCursor",type="Class")]
   [Style(inherit="no",name="linkCursor",type="Class")]
   [Style(inherit="no",name="defaultDragImageSkin",type="Class")]
   [Style(inherit="no",name="copyCursor",type="Class")]
   public class DragManager
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      public static const NONE:String = "none";
      
      public static const COPY:String = "copy";
      
      public static const MOVE:String = "move";
      
      public static const LINK:String = "link";
      
      private static var implClassDependency:mx.managers.DragManagerImpl;
      
      private static var _impl:mx.managers.IDragManager;
       
      public function DragManager()
      {
         super();
      }
      
      private static function get impl() : mx.managers.IDragManager
      {
         if(!_impl)
         {
            _impl = IDragManager(Singleton.getInstance("mx.managers::IDragManager"));
         }
         return _impl;
      }
      
      mx_internal static function get dragProxy() : DragProxy
      {
         return Object(impl).dragProxy;
      }
      
      public static function get isDragging() : Boolean
      {
         return impl.isDragging;
      }
      
      public static function doDrag(dragInitiator:IUIComponent, dragSource:DragSource, mouseEvent:MouseEvent, dragImage:IFlexDisplayObject = null, xOffset:Number = 0, yOffset:Number = 0, imageAlpha:Number = 0.5, allowMove:Boolean = true) : void
      {
         impl.doDrag(dragInitiator,dragSource,mouseEvent,dragImage,xOffset,yOffset,imageAlpha,allowMove);
      }
      
      public static function acceptDragDrop(target:IUIComponent) : void
      {
         impl.acceptDragDrop(target);
      }
      
      public static function showFeedback(feedback:String) : void
      {
         impl.showFeedback(feedback);
      }
      
      public static function getFeedback() : String
      {
         return impl.getFeedback();
      }
      
      mx_internal static function endDrag() : void
      {
         impl.endDrag();
      }
   }
}
