package mx.events
{
   import flash.events.Event;
   import mx.core.mx_internal;
   
   use namespace mx_internal;
   
   public class ValidationResultEvent extends Event
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      public static const INVALID:String = "invalid";
      
      public static const VALID:String = "valid";
       
      public var field:String;
      
      public var results:Array;
      
      public function ValidationResultEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, field:String = null, results:Array = null)
      {
         super(type,bubbles,cancelable);
         this.field = field;
         this.results = results;
      }
      
      public function get message() : String
      {
         var msg:String = "";
         var n:int = this.results.length;
         for(var i:int = 0; i < n; i++)
         {
            if(this.results[i].isError)
            {
               msg = msg + (msg == ""?"":"\n");
               msg = msg + this.results[i].errorMessage;
            }
         }
         return msg;
      }
      
      override public function clone() : Event
      {
         return new ValidationResultEvent(type,bubbles,cancelable,this.field,this.results);
      }
   }
}
