package mx.effects.effectClasses
{
   import mx.core.mx_internal;
   import flash.events.Event;
   import mx.events.MoveEvent;
   import mx.core.EdgeMetrics;
   import mx.effects.EffectManager;
   import mx.core.IUIComponent;
   import mx.core.Container;
   import mx.styles.IStyleClient;
   
   use namespace mx_internal;
   
   public class MoveInstance extends TweenEffectInstance
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var left;
      
      private var right;
      
      private var top;
      
      private var bottom;
      
      private var horizontalCenter;
      
      private var verticalCenter;
      
      private var forceClipping:Boolean = false;
      
      private var checkClipping:Boolean = true;
      
      private var oldWidth:Number;
      
      private var oldHeight:Number;
      
      public var xBy:Number;
      
      public var xFrom:Number;
      
      public var xTo:Number;
      
      public var yBy:Number;
      
      public var yFrom:Number;
      
      public var yTo:Number;
      
      public function MoveInstance(target:Object)
      {
         super(target);
      }
      
      override public function initEffect(event:Event) : void
      {
         super.initEffect(event);
         if(Boolean(event is MoveEvent) && Boolean(event.type == MoveEvent.MOVE))
         {
            if(Boolean(isNaN(this.xFrom)) && Boolean(isNaN(this.xTo)) && Boolean(isNaN(this.xBy)) && Boolean(isNaN(this.yFrom)) && Boolean(isNaN(this.yTo)) && Boolean(isNaN(this.yBy)))
            {
               this.xFrom = MoveEvent(event).oldX;
               this.xTo = target.x;
               this.yFrom = MoveEvent(event).oldY;
               this.yTo = target.y;
            }
         }
      }
      
      override public function play() : void
      {
         var vm:EdgeMetrics = null;
         var l:Number = NaN;
         var r:Number = NaN;
         var t:Number = NaN;
         var b:Number = NaN;
         var w:Number = NaN;
         var h:Number = NaN;
         super.play();
         EffectManager.startBitmapEffect(IUIComponent(target));
         if(isNaN(this.xFrom))
         {
            this.xFrom = Boolean(!isNaN(this.xTo)) && Boolean(!isNaN(this.xBy))?Number(this.xTo - this.xBy):Number(target.x);
         }
         if(isNaN(this.xTo))
         {
            if(Boolean(isNaN(this.xBy)) && Boolean(propertyChanges) && Boolean(propertyChanges.end["x"] !== undefined))
            {
               this.xTo = propertyChanges.end["x"];
            }
            else
            {
               this.xTo = !isNaN(this.xBy)?Number(this.xFrom + this.xBy):Number(target.x);
            }
         }
         if(isNaN(this.yFrom))
         {
            this.yFrom = Boolean(!isNaN(this.yTo)) && Boolean(!isNaN(this.yBy))?Number(this.yTo - this.yBy):Number(target.y);
         }
         if(isNaN(this.yTo))
         {
            if(Boolean(isNaN(this.yBy)) && Boolean(propertyChanges) && Boolean(propertyChanges.end["y"] !== undefined))
            {
               this.yTo = propertyChanges.end["y"];
            }
            else
            {
               this.yTo = !isNaN(this.yBy)?Number(this.yFrom + this.yBy):Number(target.y);
            }
         }
         tween = createTween(this,[this.xFrom,this.yFrom],[this.xTo,this.yTo],duration);
         var p:Container = target.parent as Container;
         if(p)
         {
            vm = p.viewMetrics;
            l = vm.left;
            r = p.width - vm.right;
            t = vm.top;
            b = p.height - vm.bottom;
            if(Boolean(this.xFrom < l) || Boolean(this.xTo < l) || Boolean(this.xFrom + target.width > r) || Boolean(this.xTo + target.width > r) || Boolean(this.yFrom < t) || Boolean(this.yTo < t) || Boolean(this.yFrom + target.height > b) || Boolean(this.yTo + target.height > b))
            {
               this.forceClipping = true;
               p.forceClipping = true;
            }
         }
         applyTweenStartValues();
         if(target is IStyleClient)
         {
            this.left = target.getStyle("left");
            if(this.left != undefined)
            {
               target.setStyle("left",undefined);
            }
            this.right = target.getStyle("right");
            if(this.right != undefined)
            {
               target.setStyle("right",undefined);
            }
            this.top = target.getStyle("top");
            if(this.top != undefined)
            {
               target.setStyle("top",undefined);
            }
            this.bottom = target.getStyle("bottom");
            if(this.bottom != undefined)
            {
               target.setStyle("bottom",undefined);
            }
            this.horizontalCenter = target.getStyle("horizontalCenter");
            if(this.horizontalCenter != undefined)
            {
               target.setStyle("horizontalCenter",undefined);
            }
            this.verticalCenter = target.getStyle("verticalCenter");
            if(this.verticalCenter != undefined)
            {
               target.setStyle("verticalCenter",undefined);
            }
            if(Boolean(this.left != undefined) && Boolean(this.right != undefined))
            {
               w = target.width;
               this.oldWidth = target.explicitWidth;
               target.width = w;
            }
            if(Boolean(this.top != undefined) && Boolean(this.bottom != undefined))
            {
               h = target.height;
               this.oldHeight = target.explicitHeight;
               target.height = h;
            }
         }
      }
      
      override public function onTweenUpdate(value:Object) : void
      {
         var p:Container = null;
         var vm:EdgeMetrics = null;
         var l:Number = NaN;
         var r:Number = NaN;
         var t:Number = NaN;
         var b:Number = NaN;
         EffectManager.suspendEventHandling();
         if(Boolean(!this.forceClipping) && Boolean(this.checkClipping))
         {
            p = target.parent as Container;
            if(p)
            {
               vm = p.viewMetrics;
               l = vm.left;
               r = p.width - vm.right;
               t = vm.top;
               b = p.height - vm.bottom;
               if(Boolean(value[0] < l) || Boolean(value[0] + target.width > r) || Boolean(value[1] < t) || Boolean(value[1] + target.height > b))
               {
                  this.forceClipping = true;
                  p.forceClipping = true;
               }
            }
         }
         target.move(value[0],value[1]);
         EffectManager.resumeEventHandling();
      }
      
      override public function onTweenEnd(value:Object) : void
      {
         var p:Container = null;
         EffectManager.endBitmapEffect(IUIComponent(target));
         if(this.left != undefined)
         {
            target.setStyle("left",this.left);
         }
         if(this.right != undefined)
         {
            target.setStyle("right",this.right);
         }
         if(this.top != undefined)
         {
            target.setStyle("top",this.top);
         }
         if(this.bottom != undefined)
         {
            target.setStyle("bottom",this.bottom);
         }
         if(this.horizontalCenter != undefined)
         {
            target.setStyle("horizontalCenter",this.horizontalCenter);
         }
         if(this.verticalCenter != undefined)
         {
            target.setStyle("verticalCenter",this.verticalCenter);
         }
         if(Boolean(this.left != undefined) && Boolean(this.right != undefined))
         {
            target.explicitWidth = this.oldWidth;
         }
         if(Boolean(this.top != undefined) && Boolean(this.bottom != undefined))
         {
            target.explicitHeight = this.oldHeight;
         }
         if(this.forceClipping)
         {
            p = target.parent as Container;
            if(p)
            {
               this.forceClipping = false;
               p.forceClipping = false;
            }
         }
         this.checkClipping = false;
         super.onTweenEnd(value);
      }
   }
}
