package mx.effects
{
   import mx.core.mx_internal;
   import mx.effects.effectClasses.TweenEffectInstance;
   import flash.events.EventDispatcher;
   import mx.events.TweenEvent;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.effects.Animate",since="4.0")]
   [Event(name="tweenEnd",type="mx.events.TweenEvent")]
   [Event(name="tweenUpdate",type="mx.events.TweenEvent")]
   [Event(name="tweenStart",type="mx.events.TweenEvent")]
   public class TweenEffect extends Effect
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public var easingFunction:Function = null;
      
      public function TweenEffect(target:Object = null)
      {
         super(target);
         instanceClass = TweenEffectInstance;
      }
      
      override protected function initInstance(instance:IEffectInstance) : void
      {
         super.initInstance(instance);
         TweenEffectInstance(instance).easingFunction = this.easingFunction;
         EventDispatcher(instance).addEventListener(TweenEvent.TWEEN_START,this.tweenEventHandler);
         EventDispatcher(instance).addEventListener(TweenEvent.TWEEN_UPDATE,this.tweenEventHandler);
         EventDispatcher(instance).addEventListener(TweenEvent.TWEEN_END,this.tweenEventHandler);
      }
      
      protected function tweenEventHandler(event:TweenEvent) : void
      {
         dispatchEvent(event);
      }
   }
}
