package mx.effects
{
   import mx.core.mx_internal;
   import mx.effects.effectClasses.BlurInstance;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.effects.AnimateFilter",since="4.0")]
   public class Blur extends TweenEffect
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var AFFECTED_PROPERTIES:Array = ["filters"];
       
      [Inspectable(defaultValue="4",category="General")]
      public var blurXFrom:Number = 4;
      
      [Inspectable(defaultValue="0",category="General")]
      public var blurXTo:Number = 0;
      
      [Inspectable(defaultValue="4",category="General")]
      public var blurYFrom:Number = 4;
      
      [Inspectable(defaultValue="0",category="General")]
      public var blurYTo:Number = 0;
      
      public function Blur(target:Object = null)
      {
         super(target);
         instanceClass = BlurInstance;
      }
      
      override public function getAffectedProperties() : Array
      {
         return AFFECTED_PROPERTIES;
      }
      
      override protected function initInstance(instance:IEffectInstance) : void
      {
         super.initInstance(instance);
         var blurInstance:BlurInstance = BlurInstance(instance);
         blurInstance.blurXFrom = this.blurXFrom;
         blurInstance.blurXTo = this.blurXTo;
         blurInstance.blurYFrom = this.blurYFrom;
         blurInstance.blurYTo = this.blurYTo;
      }
   }
}
