package mx.binding
{
   import mx.core.mx_internal;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class BindingManager
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      static var debugDestinationStrings:Object = {};
       
      public function BindingManager()
      {
         super();
      }
      
      public static function addBinding(document:Object, destStr:String, b:Binding) : void
      {
         if(!document._bindingsByDestination)
         {
            document._bindingsByDestination = {};
            document._bindingsBeginWithWord = {};
         }
         document._bindingsByDestination[destStr] = b;
         document._bindingsBeginWithWord[getFirstWord(destStr)] = true;
      }
      
      public static function setEnabled(document:Object, isEnabled:Boolean) : void
      {
         var bindings:Array = null;
         var i:uint = 0;
         var binding:Binding = null;
         if(Boolean(document is IBindingClient) && Boolean(document._bindings))
         {
            bindings = document._bindings as Array;
            for(i = 0; i < bindings.length; i++)
            {
               binding = bindings[i];
               binding.isEnabled = isEnabled;
            }
         }
      }
      
      public static function executeBindings(document:Object, destStr:String, destObj:Object) : void
      {
         var binding:* = null;
         if(Boolean(!destStr) || Boolean(destStr == ""))
         {
            return;
         }
         if(Boolean(document) && (Boolean(document is IBindingClient || document.hasOwnProperty("_bindingsByDestination"))) && Boolean(document._bindingsByDestination) && Boolean(document._bindingsBeginWithWord[getFirstWord(destStr)]))
         {
            for(binding in document._bindingsByDestination)
            {
               if(binding.charAt(0) == destStr.charAt(0))
               {
                  if(Boolean(binding.indexOf(destStr + ".") == 0) || Boolean(binding.indexOf(destStr + "[") == 0) || Boolean(binding == destStr))
                  {
                     document._bindingsByDestination[binding].execute(destObj);
                  }
               }
            }
         }
      }
      
      private static function getFirstWord(destStr:String) : String
      {
         var indexPeriod:int = destStr.indexOf(".");
         var indexBracket:int = destStr.indexOf("[");
         if(indexPeriod == indexBracket)
         {
            return destStr;
         }
         var minIndex:int = Math.min(indexPeriod,indexBracket);
         if(minIndex == -1)
         {
            minIndex = Math.max(indexPeriod,indexBracket);
         }
         return destStr.substr(0,minIndex);
      }
      
      public static function debugBinding(destinationString:String) : void
      {
         debugDestinationStrings[destinationString] = true;
      }
   }
}
