package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.FormatValue;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class NumberProperty extends Property
   {
       
      private var _minValue:Number;
      
      private var _maxValue:Number;
      
      public function NumberProperty(nameValue:String, defaultValue:Number, inherited:Boolean, category:String, minValue:Number, maxValue:Number)
      {
         super(nameValue,defaultValue,inherited,category);
         this._minValue = minValue;
         this._maxValue = maxValue;
      }
      
      tlf_internal static function doHash(num:Number, seed:uint) : uint
      {
         var fraction:uint = 0;
         var trunc:uint = uint(num);
         var hash:uint = UintProperty.doHash(trunc,seed);
         if(trunc != num)
         {
            fraction = uint((num - trunc) * 10000000000);
            hash = UintProperty.doHash(fraction,hash);
         }
         return hash;
      }
      
      public function get minValue() : Number
      {
         return this._minValue;
      }
      
      public function get maxValue() : Number
      {
         return this._maxValue;
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject == FormatValue.INHERIT))
         {
            return newObject;
         }
         var newVal:Number = newObject is String?Number(parseFloat(newObject)):Number(Number(newObject));
         if(isNaN(newVal))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         if(Boolean(checkLowerLimit()) && Boolean(newVal < this._minValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         if(Boolean(checkUpperLimit()) && Boolean(newVal > this._maxValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         return newVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         if(val == FormatValue.INHERIT)
         {
            return UintProperty.doHash(inheritHashValue,seed);
         }
         return NumberProperty.doHash(val as Number,seed);
      }
   }
}
