package flashx.textLayout.operations
{
   import flashx.textLayout.edit.SelectionState;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.edit.ElementRange;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.edit.ParaEdit;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.ParagraphElement;
   
   use namespace tlf_internal;
   
   public class InsertTextOperation extends FlowTextOperation
   {
       
      private var _deleteSelectionState:SelectionState;
      
      private var delSelOp:flashx.textLayout.operations.DeleteTextOperation = null;
      
      public var _text:String;
      
      private var adjustedForInsert:Boolean = false;
      
      private var _characterFormat:ITextLayoutFormat;
      
      public function InsertTextOperation(operationState:SelectionState, text:String, deleteSelectionState:SelectionState = null)
      {
         super(operationState);
         this._characterFormat = operationState.pointFormat;
         this._text = text;
         this.initialize(deleteSelectionState);
      }
      
      private function initialize(deleteSelectionState:SelectionState) : void
      {
         if(deleteSelectionState == null)
         {
            deleteSelectionState = originalSelectionState;
         }
         if(deleteSelectionState.anchorPosition != deleteSelectionState.activePosition)
         {
            this._deleteSelectionState = deleteSelectionState;
            this.delSelOp = new flashx.textLayout.operations.DeleteTextOperation(this._deleteSelectionState);
         }
      }
      
      public function get text() : String
      {
         return this._text;
      }
      
      public function set text(value:String) : void
      {
         this._text = value;
      }
      
      public function get deleteSelectionState() : SelectionState
      {
         return this._deleteSelectionState;
      }
      
      public function set deleteSelectionState(value:SelectionState) : void
      {
         this._deleteSelectionState = value;
      }
      
      public function get characterFormat() : ITextLayoutFormat
      {
         return this._characterFormat;
      }
      
      public function set characterFormat(value:ITextLayoutFormat) : void
      {
         this._characterFormat = new TextLayoutFormat(value);
      }
      
      private function doInternal() : void
      {
         var range:ElementRange = null;
         var deleteFormat:ITextLayoutFormat = null;
         var pos:int = 0;
         var leafEl:FlowLeafElement = textFlow.findLeaf(absoluteStart);
         var tcyEl:TCYElement = null;
         if(Boolean(leafEl is InlineGraphicElement) && Boolean(leafEl.parent is TCYElement))
         {
            tcyEl = leafEl.parent as TCYElement;
         }
         if(this.delSelOp != null)
         {
            deleteFormat = new TextLayoutFormat(textFlow.findLeaf(absoluteStart).format);
            if(this.delSelOp.doOperation())
            {
               if(Boolean(this.characterFormat == null) && Boolean(absoluteStart < absoluteEnd))
               {
                  this._characterFormat = deleteFormat;
               }
               else if(leafEl.textLength == 0)
               {
                  pos = leafEl.parent.getChildIndex(leafEl);
                  leafEl.parent.replaceChildren(pos,pos + 1,null);
               }
               if(Boolean(tcyEl) && Boolean(tcyEl.numChildren == 0))
               {
                  leafEl = new SpanElement();
                  tcyEl.replaceChildren(0,0,leafEl);
               }
            }
         }
         var useExistingLeaf:Boolean = false;
         if(Boolean(absoluteStart >= absoluteEnd) || Boolean(leafEl.getParagraph() == null) || Boolean(leafEl.getTextFlow() == null))
         {
            range = ElementRange.createElementRange(textFlow,absoluteStart,absoluteStart);
         }
         else
         {
            range = new ElementRange();
            range.firstParagraph = leafEl.getParagraph();
            range.firstLeaf = leafEl;
            useExistingLeaf = true;
         }
         var paraSelBegIdx:int = absoluteStart - range.firstParagraph.getAbsoluteStart();
         ParaEdit.insertText(range.firstParagraph,range.firstLeaf,paraSelBegIdx,this._text,useExistingLeaf);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,this._text.length);
         }
         if(Boolean(this._characterFormat) && Boolean(!TextLayoutFormat.isEqual(this._characterFormat,range.firstLeaf.format)))
         {
            ParaEdit.applyTextStyleChange(textFlow,absoluteStart,absoluteStart + this._text.length,this._characterFormat,null);
         }
      }
      
      override public function doOperation() : Boolean
      {
         var state:SelectionState = null;
         this.doInternal();
         if(Boolean(originalSelectionState.selectionManagerOperationState) && Boolean(textFlow.interactionManager))
         {
            state = textFlow.interactionManager.getSelectionState();
            if(state.pointFormat)
            {
               state.pointFormat = null;
               textFlow.interactionManager.setSelectionState(state);
            }
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         var newBegIdx:int = 0;
         var newEndIdx:int = 0;
         var para:ParagraphElement = textFlow.findAbsoluteParagraph(absoluteStart);
         var paraSelBegIdx:int = absoluteStart - para.getAbsoluteStart();
         ParaEdit.deleteText(para,paraSelBegIdx,this._text.length);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-this._text.length);
         }
         var newSelectionState:SelectionState = originalSelectionState;
         if(this.delSelOp != null)
         {
            newSelectionState = this.delSelOp.undo();
         }
         if(this.adjustedForInsert)
         {
            newBegIdx = newSelectionState.anchorPosition;
            newEndIdx = newSelectionState.activePosition;
            if(newEndIdx > newBegIdx)
            {
               newEndIdx--;
            }
            else
            {
               newBegIdx--;
            }
            if(absoluteStart < absoluteEnd)
            {
               return new SelectionState(textFlow,newBegIdx,newEndIdx,newSelectionState.pointFormat);
            }
            return new SelectionState(textFlow,newBegIdx,newEndIdx,originalSelectionState.pointFormat);
         }
         return originalSelectionState;
      }
      
      override public function redo() : SelectionState
      {
         this.doInternal();
         return new SelectionState(textFlow,absoluteStart + this._text.length,absoluteStart + this._text.length,null);
      }
      
      override tlf_internal function merge(op2:FlowOperation) : FlowOperation
      {
         if(absoluteStart < absoluteEnd)
         {
            return null;
         }
         if(this.endGeneration != op2.beginGeneration)
         {
            return null;
         }
         var insertOp:InsertTextOperation = null;
         if(op2 is InsertTextOperation)
         {
            insertOp = op2 as InsertTextOperation;
         }
         if(insertOp)
         {
            if(Boolean(insertOp.deleteSelectionState != null) || Boolean(this.deleteSelectionState != null))
            {
               return null;
            }
            if(Boolean(insertOp.originalSelectionState.pointFormat == null) && Boolean(originalSelectionState.pointFormat != null))
            {
               return null;
            }
            if(Boolean(originalSelectionState.pointFormat == null) && Boolean(insertOp.originalSelectionState.pointFormat != null))
            {
               return null;
            }
            if(originalSelectionState.absoluteStart + this._text.length != insertOp.originalSelectionState.absoluteStart)
            {
               return null;
            }
            if(Boolean(originalSelectionState.pointFormat == null) && Boolean(insertOp.originalSelectionState.pointFormat == null) || Boolean(TextLayoutFormat.isEqual(originalSelectionState.pointFormat,insertOp.originalSelectionState.pointFormat)))
            {
               this._text = this._text + insertOp.text;
               setGenerations(beginGeneration,insertOp.endGeneration);
               return this;
            }
            return null;
         }
         if(op2 is SplitParagraphOperation)
         {
            return new CompositeOperation([this,op2]);
         }
         return null;
      }
   }
}
