package flashx.textLayout.formats
{
   import flashx.textLayout.property.UintProperty;
   import flashx.textLayout.property.UintWithEnumProperty;
   import flashx.textLayout.property.BooleanProperty;
   import flashx.textLayout.property.NumberProperty;
   import flashx.textLayout.property.NumberOrPercentOrEnumProperty;
   import flashx.textLayout.property.NumberOrPercentProperty;
   import flashx.textLayout.property.EnumStringProperty;
   import flashx.textLayout.property.StringProperty;
   import flashx.textLayout.property.TabStopsProperty;
   import flashx.textLayout.property.IntWithEnumProperty;
   import flashx.textLayout.property.NumberWithEnumProperty;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.property.Property;
   import flash.text.engine.BreakOpportunity;
   import flash.text.engine.DigitCase;
   import flash.text.engine.DigitWidth;
   import flash.text.engine.TextBaseline;
   import flash.text.engine.Kerning;
   import flash.text.engine.LigatureLevel;
   import flash.text.engine.FontWeight;
   import flash.text.engine.FontPosture;
   import flash.text.engine.RenderingMode;
   import flash.text.engine.CFFHinting;
   import flash.text.engine.FontLookup;
   import flash.text.engine.TextRotation;
   import flash.text.engine.JustificationStyle;
   
   use namespace tlf_internal;
   
   public class TextLayoutFormat implements flashx.textLayout.formats.ITextLayoutFormat
   {
      
      private static var _colorProperty:UintProperty = new UintProperty("color",0,true,Category.CHARACTER);
      
      private static var _backgroundColorProperty:UintWithEnumProperty = new UintWithEnumProperty("backgroundColor",BackgroundColor.TRANSPARENT,false,Category.CHARACTER,BackgroundColor.TRANSPARENT);
      
      private static var _lineThroughProperty:BooleanProperty = new BooleanProperty("lineThrough",false,true,Category.CHARACTER);
      
      private static var _textAlphaProperty:NumberProperty = new NumberProperty("textAlpha",1,true,Category.CHARACTER,0,1);
      
      private static var _backgroundAlphaProperty:NumberProperty = new NumberProperty("backgroundAlpha",1,false,Category.CHARACTER,0,1);
      
      private static var _fontSizeProperty:NumberProperty = new NumberProperty("fontSize",12,true,Category.CHARACTER,1,720);
      
      private static var _baselineShiftProperty:NumberOrPercentOrEnumProperty = new NumberOrPercentOrEnumProperty("baselineShift",0,true,Category.CHARACTER,-1000,1000,"-1000%","1000%",BaselineShift.SUPERSCRIPT,BaselineShift.SUBSCRIPT);
      
      private static var _trackingLeftProperty:NumberOrPercentProperty = new NumberOrPercentProperty("trackingLeft",0,true,Category.CHARACTER,-1000,1000,"-1000%","1000%");
      
      private static var _trackingRightProperty:NumberOrPercentProperty = new NumberOrPercentProperty("trackingRight",0,true,Category.CHARACTER,-1000,1000,"-1000%","1000%");
      
      private static var _lineHeightProperty:NumberOrPercentProperty = new NumberOrPercentProperty("lineHeight","120%",true,Category.CHARACTER,-720,720,"-1000%","1000%");
      
      private static var _breakOpportunityProperty:EnumStringProperty = new EnumStringProperty("breakOpportunity",BreakOpportunity.AUTO,true,Category.CHARACTER,BreakOpportunity.ALL,BreakOpportunity.ANY,BreakOpportunity.AUTO,BreakOpportunity.NONE);
      
      private static var _digitCaseProperty:EnumStringProperty = new EnumStringProperty("digitCase",DigitCase.DEFAULT,true,Category.CHARACTER,DigitCase.DEFAULT,DigitCase.LINING,DigitCase.OLD_STYLE);
      
      private static var _digitWidthProperty:EnumStringProperty = new EnumStringProperty("digitWidth",DigitWidth.DEFAULT,true,Category.CHARACTER,DigitWidth.DEFAULT,DigitWidth.PROPORTIONAL,DigitWidth.TABULAR);
      
      private static var _dominantBaselineProperty:EnumStringProperty = new EnumStringProperty("dominantBaseline",FormatValue.AUTO,true,Category.CHARACTER,FormatValue.AUTO,TextBaseline.ROMAN,TextBaseline.ASCENT,TextBaseline.DESCENT,TextBaseline.IDEOGRAPHIC_TOP,TextBaseline.IDEOGRAPHIC_CENTER,TextBaseline.IDEOGRAPHIC_BOTTOM);
      
      private static var _kerningProperty:EnumStringProperty = new EnumStringProperty("kerning",Kerning.AUTO,true,Category.CHARACTER,Kerning.ON,Kerning.OFF,Kerning.AUTO);
      
      private static var _ligatureLevelProperty:EnumStringProperty = new EnumStringProperty("ligatureLevel",LigatureLevel.COMMON,true,Category.CHARACTER,LigatureLevel.MINIMUM,LigatureLevel.COMMON,LigatureLevel.UNCOMMON,LigatureLevel.EXOTIC);
      
      private static var _alignmentBaselineProperty:EnumStringProperty = new EnumStringProperty("alignmentBaseline",TextBaseline.USE_DOMINANT_BASELINE,true,Category.CHARACTER,TextBaseline.ROMAN,TextBaseline.ASCENT,TextBaseline.DESCENT,TextBaseline.IDEOGRAPHIC_TOP,TextBaseline.IDEOGRAPHIC_CENTER,TextBaseline.IDEOGRAPHIC_BOTTOM,TextBaseline.USE_DOMINANT_BASELINE);
      
      private static var _localeProperty:StringProperty = new StringProperty("locale","en",true,Category.CHARACTER);
      
      private static var _typographicCaseProperty:EnumStringProperty = new EnumStringProperty("typographicCase",TLFTypographicCase.DEFAULT,true,Category.CHARACTER,TLFTypographicCase.DEFAULT,TLFTypographicCase.CAPS_TO_SMALL_CAPS,TLFTypographicCase.UPPERCASE,TLFTypographicCase.LOWERCASE,TLFTypographicCase.LOWERCASE_TO_SMALL_CAPS);
      
      private static var _fontFamilyProperty:StringProperty = new StringProperty("fontFamily","Arial",true,Category.CHARACTER);
      
      private static var _textDecorationProperty:EnumStringProperty = new EnumStringProperty("textDecoration",TextDecoration.NONE,true,Category.CHARACTER,TextDecoration.NONE,TextDecoration.UNDERLINE);
      
      private static var _fontWeightProperty:EnumStringProperty = new EnumStringProperty("fontWeight",FontWeight.NORMAL,true,Category.CHARACTER,FontWeight.NORMAL,FontWeight.BOLD);
      
      private static var _fontStyleProperty:EnumStringProperty = new EnumStringProperty("fontStyle",FontPosture.NORMAL,true,Category.CHARACTER,FontPosture.NORMAL,FontPosture.ITALIC);
      
      private static var _whiteSpaceCollapseProperty:EnumStringProperty = new EnumStringProperty("whiteSpaceCollapse",WhiteSpaceCollapse.COLLAPSE,true,Category.CHARACTER,WhiteSpaceCollapse.PRESERVE,WhiteSpaceCollapse.COLLAPSE);
      
      private static var _renderingModeProperty:EnumStringProperty = new EnumStringProperty("renderingMode",RenderingMode.CFF,true,Category.CHARACTER,RenderingMode.NORMAL,RenderingMode.CFF);
      
      private static var _cffHintingProperty:EnumStringProperty = new EnumStringProperty("cffHinting",CFFHinting.HORIZONTAL_STEM,true,Category.CHARACTER,CFFHinting.NONE,CFFHinting.HORIZONTAL_STEM);
      
      private static var _fontLookupProperty:EnumStringProperty = new EnumStringProperty("fontLookup",FontLookup.DEVICE,true,Category.CHARACTER,FontLookup.DEVICE,FontLookup.EMBEDDED_CFF);
      
      private static var _textRotationProperty:EnumStringProperty = new EnumStringProperty("textRotation",TextRotation.AUTO,true,Category.CHARACTER,TextRotation.ROTATE_0,TextRotation.ROTATE_180,TextRotation.ROTATE_270,TextRotation.ROTATE_90,TextRotation.AUTO);
      
      private static var _textIndentProperty:NumberProperty = new NumberProperty("textIndent",0,true,Category.PARAGRAPH,-1000,1000);
      
      private static var _paragraphStartIndentProperty:NumberProperty = new NumberProperty("paragraphStartIndent",0,true,Category.PARAGRAPH,0,1000);
      
      private static var _paragraphEndIndentProperty:NumberProperty = new NumberProperty("paragraphEndIndent",0,true,Category.PARAGRAPH,0,1000);
      
      private static var _paragraphSpaceBeforeProperty:NumberProperty = new NumberProperty("paragraphSpaceBefore",0,true,Category.PARAGRAPH,0,1000);
      
      private static var _paragraphSpaceAfterProperty:NumberProperty = new NumberProperty("paragraphSpaceAfter",0,true,Category.PARAGRAPH,0,1000);
      
      private static var _textAlignProperty:EnumStringProperty = new EnumStringProperty("textAlign",TextAlign.START,true,Category.PARAGRAPH,TextAlign.LEFT,TextAlign.RIGHT,TextAlign.CENTER,TextAlign.JUSTIFY,TextAlign.START,TextAlign.END);
      
      private static var _textAlignLastProperty:EnumStringProperty = new EnumStringProperty("textAlignLast",TextAlign.START,true,Category.PARAGRAPH,TextAlign.LEFT,TextAlign.RIGHT,TextAlign.CENTER,TextAlign.JUSTIFY,TextAlign.START,TextAlign.END);
      
      private static var _textJustifyProperty:EnumStringProperty = new EnumStringProperty("textJustify",TextJustify.INTER_WORD,true,Category.PARAGRAPH,TextJustify.INTER_WORD,TextJustify.DISTRIBUTE);
      
      private static var _justificationRuleProperty:EnumStringProperty = new EnumStringProperty("justificationRule",FormatValue.AUTO,true,Category.PARAGRAPH,JustificationRule.EAST_ASIAN,JustificationRule.SPACE,FormatValue.AUTO);
      
      private static var _justificationStyleProperty:EnumStringProperty = new EnumStringProperty("justificationStyle",FormatValue.AUTO,true,Category.PARAGRAPH,JustificationStyle.PRIORITIZE_LEAST_ADJUSTMENT,JustificationStyle.PUSH_IN_KINSOKU,JustificationStyle.PUSH_OUT_ONLY,FormatValue.AUTO);
      
      private static var _directionProperty:EnumStringProperty = new EnumStringProperty("direction",Direction.LTR,true,Category.PARAGRAPH,Direction.LTR,Direction.RTL);
      
      private static var _tabStopsProperty:TabStopsProperty = new TabStopsProperty("tabStops",null,true,Category.PARAGRAPH);
      
      private static var _leadingModelProperty:EnumStringProperty = new EnumStringProperty("leadingModel",LeadingModel.AUTO,true,Category.PARAGRAPH,LeadingModel.ROMAN_UP,LeadingModel.IDEOGRAPHIC_TOP_UP,LeadingModel.IDEOGRAPHIC_CENTER_UP,LeadingModel.IDEOGRAPHIC_TOP_DOWN,LeadingModel.IDEOGRAPHIC_CENTER_DOWN,LeadingModel.APPROXIMATE_TEXT_FIELD,LeadingModel.ASCENT_DESCENT_UP,LeadingModel.AUTO);
      
      private static var _columnGapProperty:NumberProperty = new NumberProperty("columnGap",20,false,Category.CONTAINER,0,1000);
      
      private static var _paddingLeftProperty:NumberProperty = new NumberProperty("paddingLeft",0,false,Category.CONTAINER,0,1000);
      
      private static var _paddingTopProperty:NumberProperty = new NumberProperty("paddingTop",0,false,Category.CONTAINER,0,1000);
      
      private static var _paddingRightProperty:NumberProperty = new NumberProperty("paddingRight",0,false,Category.CONTAINER,0,1000);
      
      private static var _paddingBottomProperty:NumberProperty = new NumberProperty("paddingBottom",0,false,Category.CONTAINER,0,1000);
      
      private static var _columnCountProperty:IntWithEnumProperty = new IntWithEnumProperty("columnCount",FormatValue.AUTO,false,Category.CONTAINER,1,50,FormatValue.AUTO);
      
      private static var _columnWidthProperty:NumberWithEnumProperty = new NumberWithEnumProperty("columnWidth",FormatValue.AUTO,false,Category.CONTAINER,0,8000,FormatValue.AUTO);
      
      private static var _firstBaselineOffsetProperty:NumberWithEnumProperty = new NumberWithEnumProperty("firstBaselineOffset",BaselineOffset.AUTO,true,Category.CONTAINER,0,1000,BaselineOffset.AUTO,BaselineOffset.ASCENT,BaselineOffset.LINE_HEIGHT);
      
      private static var _verticalAlignProperty:EnumStringProperty = new EnumStringProperty("verticalAlign",VerticalAlign.TOP,false,Category.CONTAINER,VerticalAlign.TOP,VerticalAlign.MIDDLE,VerticalAlign.BOTTOM,VerticalAlign.JUSTIFY);
      
      private static var _blockProgressionProperty:EnumStringProperty = new EnumStringProperty("blockProgression",BlockProgression.TB,true,Category.CONTAINER,BlockProgression.RL,BlockProgression.TB);
      
      private static var _lineBreakProperty:EnumStringProperty = new EnumStringProperty("lineBreak",LineBreak.TO_FIT,false,Category.CONTAINER,LineBreak.EXPLICIT,LineBreak.TO_FIT);
      
      private static var _description:Object = {
         "color":_colorProperty,
         "backgroundColor":_backgroundColorProperty,
         "lineThrough":_lineThroughProperty,
         "textAlpha":_textAlphaProperty,
         "backgroundAlpha":_backgroundAlphaProperty,
         "fontSize":_fontSizeProperty,
         "baselineShift":_baselineShiftProperty,
         "trackingLeft":_trackingLeftProperty,
         "trackingRight":_trackingRightProperty,
         "lineHeight":_lineHeightProperty,
         "breakOpportunity":_breakOpportunityProperty,
         "digitCase":_digitCaseProperty,
         "digitWidth":_digitWidthProperty,
         "dominantBaseline":_dominantBaselineProperty,
         "kerning":_kerningProperty,
         "ligatureLevel":_ligatureLevelProperty,
         "alignmentBaseline":_alignmentBaselineProperty,
         "locale":_localeProperty,
         "typographicCase":_typographicCaseProperty,
         "fontFamily":_fontFamilyProperty,
         "textDecoration":_textDecorationProperty,
         "fontWeight":_fontWeightProperty,
         "fontStyle":_fontStyleProperty,
         "whiteSpaceCollapse":_whiteSpaceCollapseProperty,
         "renderingMode":_renderingModeProperty,
         "cffHinting":_cffHintingProperty,
         "fontLookup":_fontLookupProperty,
         "textRotation":_textRotationProperty,
         "textIndent":_textIndentProperty,
         "paragraphStartIndent":_paragraphStartIndentProperty,
         "paragraphEndIndent":_paragraphEndIndentProperty,
         "paragraphSpaceBefore":_paragraphSpaceBeforeProperty,
         "paragraphSpaceAfter":_paragraphSpaceAfterProperty,
         "textAlign":_textAlignProperty,
         "textAlignLast":_textAlignLastProperty,
         "textJustify":_textJustifyProperty,
         "justificationRule":_justificationRuleProperty,
         "justificationStyle":_justificationStyleProperty,
         "direction":_directionProperty,
         "tabStops":_tabStopsProperty,
         "leadingModel":_leadingModelProperty,
         "columnGap":_columnGapProperty,
         "paddingLeft":_paddingLeftProperty,
         "paddingTop":_paddingTopProperty,
         "paddingRight":_paddingRightProperty,
         "paddingBottom":_paddingBottomProperty,
         "columnCount":_columnCountProperty,
         "columnWidth":_columnWidthProperty,
         "firstBaselineOffset":_firstBaselineOffsetProperty,
         "verticalAlign":_verticalAlignProperty,
         "blockProgression":_blockProgressionProperty,
         "lineBreak":_lineBreakProperty
      };
      
      private static var _emptyTextLayoutFormat:flashx.textLayout.formats.ITextLayoutFormat;
      
      private static var _defaults:flashx.textLayout.formats.TextLayoutFormat;
       
      private var _color;
      
      private var _backgroundColor;
      
      private var _lineThrough;
      
      private var _textAlpha;
      
      private var _backgroundAlpha;
      
      private var _fontSize;
      
      private var _baselineShift;
      
      private var _trackingLeft;
      
      private var _trackingRight;
      
      private var _lineHeight;
      
      private var _breakOpportunity;
      
      private var _digitCase;
      
      private var _digitWidth;
      
      private var _dominantBaseline;
      
      private var _kerning;
      
      private var _ligatureLevel;
      
      private var _alignmentBaseline;
      
      private var _locale;
      
      private var _typographicCase;
      
      private var _fontFamily;
      
      private var _textDecoration;
      
      private var _fontWeight;
      
      private var _fontStyle;
      
      private var _whiteSpaceCollapse;
      
      private var _renderingMode;
      
      private var _cffHinting;
      
      private var _fontLookup;
      
      private var _textRotation;
      
      private var _textIndent;
      
      private var _paragraphStartIndent;
      
      private var _paragraphEndIndent;
      
      private var _paragraphSpaceBefore;
      
      private var _paragraphSpaceAfter;
      
      private var _textAlign;
      
      private var _textAlignLast;
      
      private var _textJustify;
      
      private var _justificationRule;
      
      private var _justificationStyle;
      
      private var _direction;
      
      private var _tabStops;
      
      private var _leadingModel;
      
      private var _columnGap;
      
      private var _paddingLeft;
      
      private var _paddingTop;
      
      private var _paddingRight;
      
      private var _paddingBottom;
      
      private var _columnCount;
      
      private var _columnWidth;
      
      private var _firstBaselineOffset;
      
      private var _verticalAlign;
      
      private var _blockProgression;
      
      private var _lineBreak;
      
      public function TextLayoutFormat(initialValues:flashx.textLayout.formats.ITextLayoutFormat = null)
      {
         super();
         if(initialValues)
         {
            this.apply(initialValues);
         }
      }
      
      tlf_internal static function get colorProperty() : UintProperty
      {
         return _colorProperty;
      }
      
      tlf_internal static function get backgroundColorProperty() : UintWithEnumProperty
      {
         return _backgroundColorProperty;
      }
      
      tlf_internal static function get lineThroughProperty() : BooleanProperty
      {
         return _lineThroughProperty;
      }
      
      tlf_internal static function get textAlphaProperty() : NumberProperty
      {
         return _textAlphaProperty;
      }
      
      tlf_internal static function get backgroundAlphaProperty() : NumberProperty
      {
         return _backgroundAlphaProperty;
      }
      
      tlf_internal static function get fontSizeProperty() : NumberProperty
      {
         return _fontSizeProperty;
      }
      
      tlf_internal static function get baselineShiftProperty() : NumberOrPercentOrEnumProperty
      {
         return _baselineShiftProperty;
      }
      
      tlf_internal static function get trackingLeftProperty() : NumberOrPercentProperty
      {
         return _trackingLeftProperty;
      }
      
      tlf_internal static function get trackingRightProperty() : NumberOrPercentProperty
      {
         return _trackingRightProperty;
      }
      
      tlf_internal static function get lineHeightProperty() : NumberOrPercentProperty
      {
         return _lineHeightProperty;
      }
      
      tlf_internal static function get breakOpportunityProperty() : EnumStringProperty
      {
         return _breakOpportunityProperty;
      }
      
      tlf_internal static function get digitCaseProperty() : EnumStringProperty
      {
         return _digitCaseProperty;
      }
      
      tlf_internal static function get digitWidthProperty() : EnumStringProperty
      {
         return _digitWidthProperty;
      }
      
      tlf_internal static function get dominantBaselineProperty() : EnumStringProperty
      {
         return _dominantBaselineProperty;
      }
      
      tlf_internal static function get kerningProperty() : EnumStringProperty
      {
         return _kerningProperty;
      }
      
      tlf_internal static function get ligatureLevelProperty() : EnumStringProperty
      {
         return _ligatureLevelProperty;
      }
      
      tlf_internal static function get alignmentBaselineProperty() : EnumStringProperty
      {
         return _alignmentBaselineProperty;
      }
      
      tlf_internal static function get localeProperty() : StringProperty
      {
         return _localeProperty;
      }
      
      tlf_internal static function get typographicCaseProperty() : EnumStringProperty
      {
         return _typographicCaseProperty;
      }
      
      tlf_internal static function get fontFamilyProperty() : StringProperty
      {
         return _fontFamilyProperty;
      }
      
      tlf_internal static function get textDecorationProperty() : EnumStringProperty
      {
         return _textDecorationProperty;
      }
      
      tlf_internal static function get fontWeightProperty() : EnumStringProperty
      {
         return _fontWeightProperty;
      }
      
      tlf_internal static function get fontStyleProperty() : EnumStringProperty
      {
         return _fontStyleProperty;
      }
      
      tlf_internal static function get whiteSpaceCollapseProperty() : EnumStringProperty
      {
         return _whiteSpaceCollapseProperty;
      }
      
      tlf_internal static function get renderingModeProperty() : EnumStringProperty
      {
         return _renderingModeProperty;
      }
      
      tlf_internal static function get cffHintingProperty() : EnumStringProperty
      {
         return _cffHintingProperty;
      }
      
      tlf_internal static function get fontLookupProperty() : EnumStringProperty
      {
         return _fontLookupProperty;
      }
      
      tlf_internal static function get textRotationProperty() : EnumStringProperty
      {
         return _textRotationProperty;
      }
      
      tlf_internal static function get textIndentProperty() : NumberProperty
      {
         return _textIndentProperty;
      }
      
      tlf_internal static function get paragraphStartIndentProperty() : NumberProperty
      {
         return _paragraphStartIndentProperty;
      }
      
      tlf_internal static function get paragraphEndIndentProperty() : NumberProperty
      {
         return _paragraphEndIndentProperty;
      }
      
      tlf_internal static function get paragraphSpaceBeforeProperty() : NumberProperty
      {
         return _paragraphSpaceBeforeProperty;
      }
      
      tlf_internal static function get paragraphSpaceAfterProperty() : NumberProperty
      {
         return _paragraphSpaceAfterProperty;
      }
      
      tlf_internal static function get textAlignProperty() : EnumStringProperty
      {
         return _textAlignProperty;
      }
      
      tlf_internal static function get textAlignLastProperty() : EnumStringProperty
      {
         return _textAlignLastProperty;
      }
      
      tlf_internal static function get textJustifyProperty() : EnumStringProperty
      {
         return _textJustifyProperty;
      }
      
      tlf_internal static function get justificationRuleProperty() : EnumStringProperty
      {
         return _justificationRuleProperty;
      }
      
      tlf_internal static function get justificationStyleProperty() : EnumStringProperty
      {
         return _justificationStyleProperty;
      }
      
      tlf_internal static function get directionProperty() : EnumStringProperty
      {
         return _directionProperty;
      }
      
      tlf_internal static function get tabStopsProperty() : TabStopsProperty
      {
         return _tabStopsProperty;
      }
      
      tlf_internal static function get leadingModelProperty() : EnumStringProperty
      {
         return _leadingModelProperty;
      }
      
      tlf_internal static function get columnGapProperty() : NumberProperty
      {
         return _columnGapProperty;
      }
      
      tlf_internal static function get paddingLeftProperty() : NumberProperty
      {
         return _paddingLeftProperty;
      }
      
      tlf_internal static function get paddingTopProperty() : NumberProperty
      {
         return _paddingTopProperty;
      }
      
      tlf_internal static function get paddingRightProperty() : NumberProperty
      {
         return _paddingRightProperty;
      }
      
      tlf_internal static function get paddingBottomProperty() : NumberProperty
      {
         return _paddingBottomProperty;
      }
      
      tlf_internal static function get columnCountProperty() : IntWithEnumProperty
      {
         return _columnCountProperty;
      }
      
      tlf_internal static function get columnWidthProperty() : NumberWithEnumProperty
      {
         return _columnWidthProperty;
      }
      
      tlf_internal static function get firstBaselineOffsetProperty() : NumberWithEnumProperty
      {
         return _firstBaselineOffsetProperty;
      }
      
      tlf_internal static function get verticalAlignProperty() : EnumStringProperty
      {
         return _verticalAlignProperty;
      }
      
      tlf_internal static function get blockProgressionProperty() : EnumStringProperty
      {
         return _blockProgressionProperty;
      }
      
      tlf_internal static function get lineBreakProperty() : EnumStringProperty
      {
         return _lineBreakProperty;
      }
      
      tlf_internal static function get description() : Object
      {
         return _description;
      }
      
      tlf_internal static function get emptyTextLayoutFormat() : flashx.textLayout.formats.ITextLayoutFormat
      {
         if(_emptyTextLayoutFormat == null)
         {
            _emptyTextLayoutFormat = new TextLayoutFormatValueHolder();
         }
         return _emptyTextLayoutFormat;
      }
      
      public static function isEqual(p1:flashx.textLayout.formats.ITextLayoutFormat, p2:flashx.textLayout.formats.ITextLayoutFormat) : Boolean
      {
         if(p1 == null)
         {
            p1 = emptyTextLayoutFormat;
         }
         if(p2 == null)
         {
            p2 = emptyTextLayoutFormat;
         }
         if(p1 == p2)
         {
            return true;
         }
         var p1Holder:TextLayoutFormatValueHolder = p1 as TextLayoutFormatValueHolder;
         var p2Holder:TextLayoutFormatValueHolder = p2 as TextLayoutFormatValueHolder;
         if(Boolean(p1Holder) && Boolean(p2Holder))
         {
            return Property.equalCoreStyles(p1Holder.coreStyles,p2Holder.coreStyles,TextLayoutFormat.description);
         }
         if(!_colorProperty.equalHelper(p1.color,p2.color))
         {
            return false;
         }
         if(!_backgroundColorProperty.equalHelper(p1.backgroundColor,p2.backgroundColor))
         {
            return false;
         }
         if(!_lineThroughProperty.equalHelper(p1.lineThrough,p2.lineThrough))
         {
            return false;
         }
         if(!_textAlphaProperty.equalHelper(p1.textAlpha,p2.textAlpha))
         {
            return false;
         }
         if(!_backgroundAlphaProperty.equalHelper(p1.backgroundAlpha,p2.backgroundAlpha))
         {
            return false;
         }
         if(!_fontSizeProperty.equalHelper(p1.fontSize,p2.fontSize))
         {
            return false;
         }
         if(!_baselineShiftProperty.equalHelper(p1.baselineShift,p2.baselineShift))
         {
            return false;
         }
         if(!_trackingLeftProperty.equalHelper(p1.trackingLeft,p2.trackingLeft))
         {
            return false;
         }
         if(!_trackingRightProperty.equalHelper(p1.trackingRight,p2.trackingRight))
         {
            return false;
         }
         if(!_lineHeightProperty.equalHelper(p1.lineHeight,p2.lineHeight))
         {
            return false;
         }
         if(!_breakOpportunityProperty.equalHelper(p1.breakOpportunity,p2.breakOpportunity))
         {
            return false;
         }
         if(!_digitCaseProperty.equalHelper(p1.digitCase,p2.digitCase))
         {
            return false;
         }
         if(!_digitWidthProperty.equalHelper(p1.digitWidth,p2.digitWidth))
         {
            return false;
         }
         if(!_dominantBaselineProperty.equalHelper(p1.dominantBaseline,p2.dominantBaseline))
         {
            return false;
         }
         if(!_kerningProperty.equalHelper(p1.kerning,p2.kerning))
         {
            return false;
         }
         if(!_ligatureLevelProperty.equalHelper(p1.ligatureLevel,p2.ligatureLevel))
         {
            return false;
         }
         if(!_alignmentBaselineProperty.equalHelper(p1.alignmentBaseline,p2.alignmentBaseline))
         {
            return false;
         }
         if(!_localeProperty.equalHelper(p1.locale,p2.locale))
         {
            return false;
         }
         if(!_typographicCaseProperty.equalHelper(p1.typographicCase,p2.typographicCase))
         {
            return false;
         }
         if(!_fontFamilyProperty.equalHelper(p1.fontFamily,p2.fontFamily))
         {
            return false;
         }
         if(!_textDecorationProperty.equalHelper(p1.textDecoration,p2.textDecoration))
         {
            return false;
         }
         if(!_fontWeightProperty.equalHelper(p1.fontWeight,p2.fontWeight))
         {
            return false;
         }
         if(!_fontStyleProperty.equalHelper(p1.fontStyle,p2.fontStyle))
         {
            return false;
         }
         if(!_whiteSpaceCollapseProperty.equalHelper(p1.whiteSpaceCollapse,p2.whiteSpaceCollapse))
         {
            return false;
         }
         if(!_renderingModeProperty.equalHelper(p1.renderingMode,p2.renderingMode))
         {
            return false;
         }
         if(!_cffHintingProperty.equalHelper(p1.cffHinting,p2.cffHinting))
         {
            return false;
         }
         if(!_fontLookupProperty.equalHelper(p1.fontLookup,p2.fontLookup))
         {
            return false;
         }
         if(!_textRotationProperty.equalHelper(p1.textRotation,p2.textRotation))
         {
            return false;
         }
         if(!_textIndentProperty.equalHelper(p1.textIndent,p2.textIndent))
         {
            return false;
         }
         if(!_paragraphStartIndentProperty.equalHelper(p1.paragraphStartIndent,p2.paragraphStartIndent))
         {
            return false;
         }
         if(!_paragraphEndIndentProperty.equalHelper(p1.paragraphEndIndent,p2.paragraphEndIndent))
         {
            return false;
         }
         if(!_paragraphSpaceBeforeProperty.equalHelper(p1.paragraphSpaceBefore,p2.paragraphSpaceBefore))
         {
            return false;
         }
         if(!_paragraphSpaceAfterProperty.equalHelper(p1.paragraphSpaceAfter,p2.paragraphSpaceAfter))
         {
            return false;
         }
         if(!_textAlignProperty.equalHelper(p1.textAlign,p2.textAlign))
         {
            return false;
         }
         if(!_textAlignLastProperty.equalHelper(p1.textAlignLast,p2.textAlignLast))
         {
            return false;
         }
         if(!_textJustifyProperty.equalHelper(p1.textJustify,p2.textJustify))
         {
            return false;
         }
         if(!_justificationRuleProperty.equalHelper(p1.justificationRule,p2.justificationRule))
         {
            return false;
         }
         if(!_justificationStyleProperty.equalHelper(p1.justificationStyle,p2.justificationStyle))
         {
            return false;
         }
         if(!_directionProperty.equalHelper(p1.direction,p2.direction))
         {
            return false;
         }
         if(!_tabStopsProperty.equalHelper(p1.tabStops,p2.tabStops))
         {
            return false;
         }
         if(!_leadingModelProperty.equalHelper(p1.leadingModel,p2.leadingModel))
         {
            return false;
         }
         if(!_columnGapProperty.equalHelper(p1.columnGap,p2.columnGap))
         {
            return false;
         }
         if(!_paddingLeftProperty.equalHelper(p1.paddingLeft,p2.paddingLeft))
         {
            return false;
         }
         if(!_paddingTopProperty.equalHelper(p1.paddingTop,p2.paddingTop))
         {
            return false;
         }
         if(!_paddingRightProperty.equalHelper(p1.paddingRight,p2.paddingRight))
         {
            return false;
         }
         if(!_paddingBottomProperty.equalHelper(p1.paddingBottom,p2.paddingBottom))
         {
            return false;
         }
         if(!_columnCountProperty.equalHelper(p1.columnCount,p2.columnCount))
         {
            return false;
         }
         if(!_columnWidthProperty.equalHelper(p1.columnWidth,p2.columnWidth))
         {
            return false;
         }
         if(!_firstBaselineOffsetProperty.equalHelper(p1.firstBaselineOffset,p2.firstBaselineOffset))
         {
            return false;
         }
         if(!_verticalAlignProperty.equalHelper(p1.verticalAlign,p2.verticalAlign))
         {
            return false;
         }
         if(!_blockProgressionProperty.equalHelper(p1.blockProgression,p2.blockProgression))
         {
            return false;
         }
         if(!_lineBreakProperty.equalHelper(p1.lineBreak,p2.lineBreak))
         {
            return false;
         }
         return true;
      }
      
      public static function get defaultFormat() : flashx.textLayout.formats.ITextLayoutFormat
      {
         if(_defaults == null)
         {
            _defaults = new flashx.textLayout.formats.TextLayoutFormat();
            Property.defaultsAllHelper(_description,_defaults);
         }
         return _defaults;
      }
      
      public function get color() : *
      {
         return this._color;
      }
      
      public function set color(newValue:*) : void
      {
         this._color = _colorProperty.setHelper(this._color,newValue);
      }
      
      public function get backgroundColor() : *
      {
         return this._backgroundColor;
      }
      
      public function set backgroundColor(newValue:*) : void
      {
         this._backgroundColor = _backgroundColorProperty.setHelper(this._backgroundColor,newValue);
      }
      
      public function get lineThrough() : *
      {
         return this._lineThrough;
      }
      
      public function set lineThrough(newValue:*) : void
      {
         this._lineThrough = _lineThroughProperty.setHelper(this._lineThrough,newValue);
      }
      
      public function get textAlpha() : *
      {
         return this._textAlpha;
      }
      
      public function set textAlpha(newValue:*) : void
      {
         this._textAlpha = _textAlphaProperty.setHelper(this._textAlpha,newValue);
      }
      
      public function get backgroundAlpha() : *
      {
         return this._backgroundAlpha;
      }
      
      public function set backgroundAlpha(newValue:*) : void
      {
         this._backgroundAlpha = _backgroundAlphaProperty.setHelper(this._backgroundAlpha,newValue);
      }
      
      public function get fontSize() : *
      {
         return this._fontSize;
      }
      
      public function set fontSize(newValue:*) : void
      {
         this._fontSize = _fontSizeProperty.setHelper(this._fontSize,newValue);
      }
      
      public function get baselineShift() : *
      {
         return this._baselineShift;
      }
      
      public function set baselineShift(newValue:*) : void
      {
         this._baselineShift = _baselineShiftProperty.setHelper(this._baselineShift,newValue);
      }
      
      public function get trackingLeft() : *
      {
         return this._trackingLeft;
      }
      
      public function set trackingLeft(newValue:*) : void
      {
         this._trackingLeft = _trackingLeftProperty.setHelper(this._trackingLeft,newValue);
      }
      
      public function get trackingRight() : *
      {
         return this._trackingRight;
      }
      
      public function set trackingRight(newValue:*) : void
      {
         this._trackingRight = _trackingRightProperty.setHelper(this._trackingRight,newValue);
      }
      
      public function get lineHeight() : *
      {
         return this._lineHeight;
      }
      
      public function set lineHeight(newValue:*) : void
      {
         this._lineHeight = _lineHeightProperty.setHelper(this._lineHeight,newValue);
      }
      
      public function get breakOpportunity() : *
      {
         return this._breakOpportunity;
      }
      
      public function set breakOpportunity(newValue:*) : void
      {
         this._breakOpportunity = _breakOpportunityProperty.setHelper(this._breakOpportunity,newValue);
      }
      
      public function get digitCase() : *
      {
         return this._digitCase;
      }
      
      public function set digitCase(newValue:*) : void
      {
         this._digitCase = _digitCaseProperty.setHelper(this._digitCase,newValue);
      }
      
      public function get digitWidth() : *
      {
         return this._digitWidth;
      }
      
      public function set digitWidth(newValue:*) : void
      {
         this._digitWidth = _digitWidthProperty.setHelper(this._digitWidth,newValue);
      }
      
      public function get dominantBaseline() : *
      {
         return this._dominantBaseline;
      }
      
      public function set dominantBaseline(newValue:*) : void
      {
         this._dominantBaseline = _dominantBaselineProperty.setHelper(this._dominantBaseline,newValue);
      }
      
      public function get kerning() : *
      {
         return this._kerning;
      }
      
      public function set kerning(newValue:*) : void
      {
         this._kerning = _kerningProperty.setHelper(this._kerning,newValue);
      }
      
      public function get ligatureLevel() : *
      {
         return this._ligatureLevel;
      }
      
      public function set ligatureLevel(newValue:*) : void
      {
         this._ligatureLevel = _ligatureLevelProperty.setHelper(this._ligatureLevel,newValue);
      }
      
      public function get alignmentBaseline() : *
      {
         return this._alignmentBaseline;
      }
      
      public function set alignmentBaseline(newValue:*) : void
      {
         this._alignmentBaseline = _alignmentBaselineProperty.setHelper(this._alignmentBaseline,newValue);
      }
      
      public function get locale() : *
      {
         return this._locale;
      }
      
      public function set locale(newValue:*) : void
      {
         this._locale = _localeProperty.setHelper(this._locale,newValue);
      }
      
      public function get typographicCase() : *
      {
         return this._typographicCase;
      }
      
      public function set typographicCase(newValue:*) : void
      {
         this._typographicCase = _typographicCaseProperty.setHelper(this._typographicCase,newValue);
      }
      
      public function get fontFamily() : *
      {
         return this._fontFamily;
      }
      
      public function set fontFamily(newValue:*) : void
      {
         this._fontFamily = _fontFamilyProperty.setHelper(this._fontFamily,newValue);
      }
      
      public function get textDecoration() : *
      {
         return this._textDecoration;
      }
      
      public function set textDecoration(newValue:*) : void
      {
         this._textDecoration = _textDecorationProperty.setHelper(this._textDecoration,newValue);
      }
      
      public function get fontWeight() : *
      {
         return this._fontWeight;
      }
      
      public function set fontWeight(newValue:*) : void
      {
         this._fontWeight = _fontWeightProperty.setHelper(this._fontWeight,newValue);
      }
      
      public function get fontStyle() : *
      {
         return this._fontStyle;
      }
      
      public function set fontStyle(newValue:*) : void
      {
         this._fontStyle = _fontStyleProperty.setHelper(this._fontStyle,newValue);
      }
      
      public function get whiteSpaceCollapse() : *
      {
         return this._whiteSpaceCollapse;
      }
      
      public function set whiteSpaceCollapse(newValue:*) : void
      {
         this._whiteSpaceCollapse = _whiteSpaceCollapseProperty.setHelper(this._whiteSpaceCollapse,newValue);
      }
      
      public function get renderingMode() : *
      {
         return this._renderingMode;
      }
      
      public function set renderingMode(newValue:*) : void
      {
         this._renderingMode = _renderingModeProperty.setHelper(this._renderingMode,newValue);
      }
      
      public function get cffHinting() : *
      {
         return this._cffHinting;
      }
      
      public function set cffHinting(newValue:*) : void
      {
         this._cffHinting = _cffHintingProperty.setHelper(this._cffHinting,newValue);
      }
      
      public function get fontLookup() : *
      {
         return this._fontLookup;
      }
      
      public function set fontLookup(newValue:*) : void
      {
         this._fontLookup = _fontLookupProperty.setHelper(this._fontLookup,newValue);
      }
      
      public function get textRotation() : *
      {
         return this._textRotation;
      }
      
      public function set textRotation(newValue:*) : void
      {
         this._textRotation = _textRotationProperty.setHelper(this._textRotation,newValue);
      }
      
      public function get textIndent() : *
      {
         return this._textIndent;
      }
      
      public function set textIndent(newValue:*) : void
      {
         this._textIndent = _textIndentProperty.setHelper(this._textIndent,newValue);
      }
      
      public function get paragraphStartIndent() : *
      {
         return this._paragraphStartIndent;
      }
      
      public function set paragraphStartIndent(newValue:*) : void
      {
         this._paragraphStartIndent = _paragraphStartIndentProperty.setHelper(this._paragraphStartIndent,newValue);
      }
      
      public function get paragraphEndIndent() : *
      {
         return this._paragraphEndIndent;
      }
      
      public function set paragraphEndIndent(newValue:*) : void
      {
         this._paragraphEndIndent = _paragraphEndIndentProperty.setHelper(this._paragraphEndIndent,newValue);
      }
      
      public function get paragraphSpaceBefore() : *
      {
         return this._paragraphSpaceBefore;
      }
      
      public function set paragraphSpaceBefore(newValue:*) : void
      {
         this._paragraphSpaceBefore = _paragraphSpaceBeforeProperty.setHelper(this._paragraphSpaceBefore,newValue);
      }
      
      public function get paragraphSpaceAfter() : *
      {
         return this._paragraphSpaceAfter;
      }
      
      public function set paragraphSpaceAfter(newValue:*) : void
      {
         this._paragraphSpaceAfter = _paragraphSpaceAfterProperty.setHelper(this._paragraphSpaceAfter,newValue);
      }
      
      public function get textAlign() : *
      {
         return this._textAlign;
      }
      
      public function set textAlign(newValue:*) : void
      {
         this._textAlign = _textAlignProperty.setHelper(this._textAlign,newValue);
      }
      
      public function get textAlignLast() : *
      {
         return this._textAlignLast;
      }
      
      public function set textAlignLast(newValue:*) : void
      {
         this._textAlignLast = _textAlignLastProperty.setHelper(this._textAlignLast,newValue);
      }
      
      public function get textJustify() : *
      {
         return this._textJustify;
      }
      
      public function set textJustify(newValue:*) : void
      {
         this._textJustify = _textJustifyProperty.setHelper(this._textJustify,newValue);
      }
      
      public function get justificationRule() : *
      {
         return this._justificationRule;
      }
      
      public function set justificationRule(newValue:*) : void
      {
         this._justificationRule = _justificationRuleProperty.setHelper(this._justificationRule,newValue);
      }
      
      public function get justificationStyle() : *
      {
         return this._justificationStyle;
      }
      
      public function set justificationStyle(newValue:*) : void
      {
         this._justificationStyle = _justificationStyleProperty.setHelper(this._justificationStyle,newValue);
      }
      
      public function get direction() : *
      {
         return this._direction;
      }
      
      public function set direction(newValue:*) : void
      {
         this._direction = _directionProperty.setHelper(this._direction,newValue);
      }
      
      public function get tabStops() : *
      {
         return this._tabStops;
      }
      
      public function set tabStops(newValue:*) : void
      {
         this._tabStops = _tabStopsProperty.setHelper(this._tabStops,newValue);
      }
      
      public function get leadingModel() : *
      {
         return this._leadingModel;
      }
      
      public function set leadingModel(newValue:*) : void
      {
         this._leadingModel = _leadingModelProperty.setHelper(this._leadingModel,newValue);
      }
      
      public function get columnGap() : *
      {
         return this._columnGap;
      }
      
      public function set columnGap(newValue:*) : void
      {
         this._columnGap = _columnGapProperty.setHelper(this._columnGap,newValue);
      }
      
      public function get paddingLeft() : *
      {
         return this._paddingLeft;
      }
      
      public function set paddingLeft(newValue:*) : void
      {
         this._paddingLeft = _paddingLeftProperty.setHelper(this._paddingLeft,newValue);
      }
      
      public function get paddingTop() : *
      {
         return this._paddingTop;
      }
      
      public function set paddingTop(newValue:*) : void
      {
         this._paddingTop = _paddingTopProperty.setHelper(this._paddingTop,newValue);
      }
      
      public function get paddingRight() : *
      {
         return this._paddingRight;
      }
      
      public function set paddingRight(newValue:*) : void
      {
         this._paddingRight = _paddingRightProperty.setHelper(this._paddingRight,newValue);
      }
      
      public function get paddingBottom() : *
      {
         return this._paddingBottom;
      }
      
      public function set paddingBottom(newValue:*) : void
      {
         this._paddingBottom = _paddingBottomProperty.setHelper(this._paddingBottom,newValue);
      }
      
      public function get columnCount() : *
      {
         return this._columnCount;
      }
      
      public function set columnCount(newValue:*) : void
      {
         this._columnCount = _columnCountProperty.setHelper(this._columnCount,newValue);
      }
      
      public function get columnWidth() : *
      {
         return this._columnWidth;
      }
      
      public function set columnWidth(newValue:*) : void
      {
         this._columnWidth = _columnWidthProperty.setHelper(this._columnWidth,newValue);
      }
      
      public function get firstBaselineOffset() : *
      {
         return this._firstBaselineOffset;
      }
      
      public function set firstBaselineOffset(newValue:*) : void
      {
         this._firstBaselineOffset = _firstBaselineOffsetProperty.setHelper(this._firstBaselineOffset,newValue);
      }
      
      public function get verticalAlign() : *
      {
         return this._verticalAlign;
      }
      
      public function set verticalAlign(newValue:*) : void
      {
         this._verticalAlign = _verticalAlignProperty.setHelper(this._verticalAlign,newValue);
      }
      
      public function get blockProgression() : *
      {
         return this._blockProgression;
      }
      
      public function set blockProgression(newValue:*) : void
      {
         this._blockProgression = _blockProgressionProperty.setHelper(this._blockProgression,newValue);
      }
      
      public function get lineBreak() : *
      {
         return this._lineBreak;
      }
      
      public function set lineBreak(newValue:*) : void
      {
         this._lineBreak = _lineBreakProperty.setHelper(this._lineBreak,newValue);
      }
      
      public function copy(values:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         if(values == null)
         {
            values = emptyTextLayoutFormat;
         }
         this.color = values.color;
         this.backgroundColor = values.backgroundColor;
         this.lineThrough = values.lineThrough;
         this.textAlpha = values.textAlpha;
         this.backgroundAlpha = values.backgroundAlpha;
         this.fontSize = values.fontSize;
         this.baselineShift = values.baselineShift;
         this.trackingLeft = values.trackingLeft;
         this.trackingRight = values.trackingRight;
         this.lineHeight = values.lineHeight;
         this.breakOpportunity = values.breakOpportunity;
         this.digitCase = values.digitCase;
         this.digitWidth = values.digitWidth;
         this.dominantBaseline = values.dominantBaseline;
         this.kerning = values.kerning;
         this.ligatureLevel = values.ligatureLevel;
         this.alignmentBaseline = values.alignmentBaseline;
         this.locale = values.locale;
         this.typographicCase = values.typographicCase;
         this.fontFamily = values.fontFamily;
         this.textDecoration = values.textDecoration;
         this.fontWeight = values.fontWeight;
         this.fontStyle = values.fontStyle;
         this.whiteSpaceCollapse = values.whiteSpaceCollapse;
         this.renderingMode = values.renderingMode;
         this.cffHinting = values.cffHinting;
         this.fontLookup = values.fontLookup;
         this.textRotation = values.textRotation;
         this.textIndent = values.textIndent;
         this.paragraphStartIndent = values.paragraphStartIndent;
         this.paragraphEndIndent = values.paragraphEndIndent;
         this.paragraphSpaceBefore = values.paragraphSpaceBefore;
         this.paragraphSpaceAfter = values.paragraphSpaceAfter;
         this.textAlign = values.textAlign;
         this.textAlignLast = values.textAlignLast;
         this.textJustify = values.textJustify;
         this.justificationRule = values.justificationRule;
         this.justificationStyle = values.justificationStyle;
         this.direction = values.direction;
         this.tabStops = values.tabStops;
         this.leadingModel = values.leadingModel;
         this.columnGap = values.columnGap;
         this.paddingLeft = values.paddingLeft;
         this.paddingTop = values.paddingTop;
         this.paddingRight = values.paddingRight;
         this.paddingBottom = values.paddingBottom;
         this.columnCount = values.columnCount;
         this.columnWidth = values.columnWidth;
         this.firstBaselineOffset = values.firstBaselineOffset;
         this.verticalAlign = values.verticalAlign;
         this.blockProgression = values.blockProgression;
         this.lineBreak = values.lineBreak;
      }
      
      public function concat(incoming:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            for(key in holder.coreStyles)
            {
               this[key] = description[key].concatHelper(this[key],holder.coreStyles[key]);
            }
            return;
         }
         this.color = _colorProperty.concatHelper(this.color,incoming.color);
         this.backgroundColor = _backgroundColorProperty.concatHelper(this.backgroundColor,incoming.backgroundColor);
         this.lineThrough = _lineThroughProperty.concatHelper(this.lineThrough,incoming.lineThrough);
         this.textAlpha = _textAlphaProperty.concatHelper(this.textAlpha,incoming.textAlpha);
         this.backgroundAlpha = _backgroundAlphaProperty.concatHelper(this.backgroundAlpha,incoming.backgroundAlpha);
         this.fontSize = _fontSizeProperty.concatHelper(this.fontSize,incoming.fontSize);
         this.baselineShift = _baselineShiftProperty.concatHelper(this.baselineShift,incoming.baselineShift);
         this.trackingLeft = _trackingLeftProperty.concatHelper(this.trackingLeft,incoming.trackingLeft);
         this.trackingRight = _trackingRightProperty.concatHelper(this.trackingRight,incoming.trackingRight);
         this.lineHeight = _lineHeightProperty.concatHelper(this.lineHeight,incoming.lineHeight);
         this.breakOpportunity = _breakOpportunityProperty.concatHelper(this.breakOpportunity,incoming.breakOpportunity);
         this.digitCase = _digitCaseProperty.concatHelper(this.digitCase,incoming.digitCase);
         this.digitWidth = _digitWidthProperty.concatHelper(this.digitWidth,incoming.digitWidth);
         this.dominantBaseline = _dominantBaselineProperty.concatHelper(this.dominantBaseline,incoming.dominantBaseline);
         this.kerning = _kerningProperty.concatHelper(this.kerning,incoming.kerning);
         this.ligatureLevel = _ligatureLevelProperty.concatHelper(this.ligatureLevel,incoming.ligatureLevel);
         this.alignmentBaseline = _alignmentBaselineProperty.concatHelper(this.alignmentBaseline,incoming.alignmentBaseline);
         this.locale = _localeProperty.concatHelper(this.locale,incoming.locale);
         this.typographicCase = _typographicCaseProperty.concatHelper(this.typographicCase,incoming.typographicCase);
         this.fontFamily = _fontFamilyProperty.concatHelper(this.fontFamily,incoming.fontFamily);
         this.textDecoration = _textDecorationProperty.concatHelper(this.textDecoration,incoming.textDecoration);
         this.fontWeight = _fontWeightProperty.concatHelper(this.fontWeight,incoming.fontWeight);
         this.fontStyle = _fontStyleProperty.concatHelper(this.fontStyle,incoming.fontStyle);
         this.whiteSpaceCollapse = _whiteSpaceCollapseProperty.concatHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse);
         this.renderingMode = _renderingModeProperty.concatHelper(this.renderingMode,incoming.renderingMode);
         this.cffHinting = _cffHintingProperty.concatHelper(this.cffHinting,incoming.cffHinting);
         this.fontLookup = _fontLookupProperty.concatHelper(this.fontLookup,incoming.fontLookup);
         this.textRotation = _textRotationProperty.concatHelper(this.textRotation,incoming.textRotation);
         this.textIndent = _textIndentProperty.concatHelper(this.textIndent,incoming.textIndent);
         this.paragraphStartIndent = _paragraphStartIndentProperty.concatHelper(this.paragraphStartIndent,incoming.paragraphStartIndent);
         this.paragraphEndIndent = _paragraphEndIndentProperty.concatHelper(this.paragraphEndIndent,incoming.paragraphEndIndent);
         this.paragraphSpaceBefore = _paragraphSpaceBeforeProperty.concatHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore);
         this.paragraphSpaceAfter = _paragraphSpaceAfterProperty.concatHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter);
         this.textAlign = _textAlignProperty.concatHelper(this.textAlign,incoming.textAlign);
         this.textAlignLast = _textAlignLastProperty.concatHelper(this.textAlignLast,incoming.textAlignLast);
         this.textJustify = _textJustifyProperty.concatHelper(this.textJustify,incoming.textJustify);
         this.justificationRule = _justificationRuleProperty.concatHelper(this.justificationRule,incoming.justificationRule);
         this.justificationStyle = _justificationStyleProperty.concatHelper(this.justificationStyle,incoming.justificationStyle);
         this.direction = _directionProperty.concatHelper(this.direction,incoming.direction);
         this.tabStops = _tabStopsProperty.concatHelper(this.tabStops,incoming.tabStops);
         this.leadingModel = _leadingModelProperty.concatHelper(this.leadingModel,incoming.leadingModel);
         this.columnGap = _columnGapProperty.concatHelper(this.columnGap,incoming.columnGap);
         this.paddingLeft = _paddingLeftProperty.concatHelper(this.paddingLeft,incoming.paddingLeft);
         this.paddingTop = _paddingTopProperty.concatHelper(this.paddingTop,incoming.paddingTop);
         this.paddingRight = _paddingRightProperty.concatHelper(this.paddingRight,incoming.paddingRight);
         this.paddingBottom = _paddingBottomProperty.concatHelper(this.paddingBottom,incoming.paddingBottom);
         this.columnCount = _columnCountProperty.concatHelper(this.columnCount,incoming.columnCount);
         this.columnWidth = _columnWidthProperty.concatHelper(this.columnWidth,incoming.columnWidth);
         this.firstBaselineOffset = _firstBaselineOffsetProperty.concatHelper(this.firstBaselineOffset,incoming.firstBaselineOffset);
         this.verticalAlign = _verticalAlignProperty.concatHelper(this.verticalAlign,incoming.verticalAlign);
         this.blockProgression = _blockProgressionProperty.concatHelper(this.blockProgression,incoming.blockProgression);
         this.lineBreak = _lineBreakProperty.concatHelper(this.lineBreak,incoming.lineBreak);
      }
      
      public function concatInheritOnly(incoming:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            for(key in holder.coreStyles)
            {
               this[key] = description[key].concatInheritOnlyHelper(this[key],holder.coreStyles[key]);
            }
            return;
         }
         this.color = _colorProperty.concatInheritOnlyHelper(this.color,incoming.color);
         this.backgroundColor = _backgroundColorProperty.concatInheritOnlyHelper(this.backgroundColor,incoming.backgroundColor);
         this.lineThrough = _lineThroughProperty.concatInheritOnlyHelper(this.lineThrough,incoming.lineThrough);
         this.textAlpha = _textAlphaProperty.concatInheritOnlyHelper(this.textAlpha,incoming.textAlpha);
         this.backgroundAlpha = _backgroundAlphaProperty.concatInheritOnlyHelper(this.backgroundAlpha,incoming.backgroundAlpha);
         this.fontSize = _fontSizeProperty.concatInheritOnlyHelper(this.fontSize,incoming.fontSize);
         this.baselineShift = _baselineShiftProperty.concatInheritOnlyHelper(this.baselineShift,incoming.baselineShift);
         this.trackingLeft = _trackingLeftProperty.concatInheritOnlyHelper(this.trackingLeft,incoming.trackingLeft);
         this.trackingRight = _trackingRightProperty.concatInheritOnlyHelper(this.trackingRight,incoming.trackingRight);
         this.lineHeight = _lineHeightProperty.concatInheritOnlyHelper(this.lineHeight,incoming.lineHeight);
         this.breakOpportunity = _breakOpportunityProperty.concatInheritOnlyHelper(this.breakOpportunity,incoming.breakOpportunity);
         this.digitCase = _digitCaseProperty.concatInheritOnlyHelper(this.digitCase,incoming.digitCase);
         this.digitWidth = _digitWidthProperty.concatInheritOnlyHelper(this.digitWidth,incoming.digitWidth);
         this.dominantBaseline = _dominantBaselineProperty.concatInheritOnlyHelper(this.dominantBaseline,incoming.dominantBaseline);
         this.kerning = _kerningProperty.concatInheritOnlyHelper(this.kerning,incoming.kerning);
         this.ligatureLevel = _ligatureLevelProperty.concatInheritOnlyHelper(this.ligatureLevel,incoming.ligatureLevel);
         this.alignmentBaseline = _alignmentBaselineProperty.concatInheritOnlyHelper(this.alignmentBaseline,incoming.alignmentBaseline);
         this.locale = _localeProperty.concatInheritOnlyHelper(this.locale,incoming.locale);
         this.typographicCase = _typographicCaseProperty.concatInheritOnlyHelper(this.typographicCase,incoming.typographicCase);
         this.fontFamily = _fontFamilyProperty.concatInheritOnlyHelper(this.fontFamily,incoming.fontFamily);
         this.textDecoration = _textDecorationProperty.concatInheritOnlyHelper(this.textDecoration,incoming.textDecoration);
         this.fontWeight = _fontWeightProperty.concatInheritOnlyHelper(this.fontWeight,incoming.fontWeight);
         this.fontStyle = _fontStyleProperty.concatInheritOnlyHelper(this.fontStyle,incoming.fontStyle);
         this.whiteSpaceCollapse = _whiteSpaceCollapseProperty.concatInheritOnlyHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse);
         this.renderingMode = _renderingModeProperty.concatInheritOnlyHelper(this.renderingMode,incoming.renderingMode);
         this.cffHinting = _cffHintingProperty.concatInheritOnlyHelper(this.cffHinting,incoming.cffHinting);
         this.fontLookup = _fontLookupProperty.concatInheritOnlyHelper(this.fontLookup,incoming.fontLookup);
         this.textRotation = _textRotationProperty.concatInheritOnlyHelper(this.textRotation,incoming.textRotation);
         this.textIndent = _textIndentProperty.concatInheritOnlyHelper(this.textIndent,incoming.textIndent);
         this.paragraphStartIndent = _paragraphStartIndentProperty.concatInheritOnlyHelper(this.paragraphStartIndent,incoming.paragraphStartIndent);
         this.paragraphEndIndent = _paragraphEndIndentProperty.concatInheritOnlyHelper(this.paragraphEndIndent,incoming.paragraphEndIndent);
         this.paragraphSpaceBefore = _paragraphSpaceBeforeProperty.concatInheritOnlyHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore);
         this.paragraphSpaceAfter = _paragraphSpaceAfterProperty.concatInheritOnlyHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter);
         this.textAlign = _textAlignProperty.concatInheritOnlyHelper(this.textAlign,incoming.textAlign);
         this.textAlignLast = _textAlignLastProperty.concatInheritOnlyHelper(this.textAlignLast,incoming.textAlignLast);
         this.textJustify = _textJustifyProperty.concatInheritOnlyHelper(this.textJustify,incoming.textJustify);
         this.justificationRule = _justificationRuleProperty.concatInheritOnlyHelper(this.justificationRule,incoming.justificationRule);
         this.justificationStyle = _justificationStyleProperty.concatInheritOnlyHelper(this.justificationStyle,incoming.justificationStyle);
         this.direction = _directionProperty.concatInheritOnlyHelper(this.direction,incoming.direction);
         this.tabStops = _tabStopsProperty.concatInheritOnlyHelper(this.tabStops,incoming.tabStops);
         this.leadingModel = _leadingModelProperty.concatInheritOnlyHelper(this.leadingModel,incoming.leadingModel);
         this.columnGap = _columnGapProperty.concatInheritOnlyHelper(this.columnGap,incoming.columnGap);
         this.paddingLeft = _paddingLeftProperty.concatInheritOnlyHelper(this.paddingLeft,incoming.paddingLeft);
         this.paddingTop = _paddingTopProperty.concatInheritOnlyHelper(this.paddingTop,incoming.paddingTop);
         this.paddingRight = _paddingRightProperty.concatInheritOnlyHelper(this.paddingRight,incoming.paddingRight);
         this.paddingBottom = _paddingBottomProperty.concatInheritOnlyHelper(this.paddingBottom,incoming.paddingBottom);
         this.columnCount = _columnCountProperty.concatInheritOnlyHelper(this.columnCount,incoming.columnCount);
         this.columnWidth = _columnWidthProperty.concatInheritOnlyHelper(this.columnWidth,incoming.columnWidth);
         this.firstBaselineOffset = _firstBaselineOffsetProperty.concatInheritOnlyHelper(this.firstBaselineOffset,incoming.firstBaselineOffset);
         this.verticalAlign = _verticalAlignProperty.concatInheritOnlyHelper(this.verticalAlign,incoming.verticalAlign);
         this.blockProgression = _blockProgressionProperty.concatInheritOnlyHelper(this.blockProgression,incoming.blockProgression);
         this.lineBreak = _lineBreakProperty.concatInheritOnlyHelper(this.lineBreak,incoming.lineBreak);
      }
      
      public function apply(incoming:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         var val:* = undefined;
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            for(key in holder.coreStyles)
            {
               this[key] = holder.coreStyles[key];
            }
            return;
         }
         if((val = incoming.color) !== undefined)
         {
            this.color = val;
         }
         if((val = incoming.backgroundColor) !== undefined)
         {
            this.backgroundColor = val;
         }
         if((val = incoming.lineThrough) !== undefined)
         {
            this.lineThrough = val;
         }
         if((val = incoming.textAlpha) !== undefined)
         {
            this.textAlpha = val;
         }
         if((val = incoming.backgroundAlpha) !== undefined)
         {
            this.backgroundAlpha = val;
         }
         if((val = incoming.fontSize) !== undefined)
         {
            this.fontSize = val;
         }
         if((val = incoming.baselineShift) !== undefined)
         {
            this.baselineShift = val;
         }
         if((val = incoming.trackingLeft) !== undefined)
         {
            this.trackingLeft = val;
         }
         if((val = incoming.trackingRight) !== undefined)
         {
            this.trackingRight = val;
         }
         if((val = incoming.lineHeight) !== undefined)
         {
            this.lineHeight = val;
         }
         if((val = incoming.breakOpportunity) !== undefined)
         {
            this.breakOpportunity = val;
         }
         if((val = incoming.digitCase) !== undefined)
         {
            this.digitCase = val;
         }
         if((val = incoming.digitWidth) !== undefined)
         {
            this.digitWidth = val;
         }
         if((val = incoming.dominantBaseline) !== undefined)
         {
            this.dominantBaseline = val;
         }
         if((val = incoming.kerning) !== undefined)
         {
            this.kerning = val;
         }
         if((val = incoming.ligatureLevel) !== undefined)
         {
            this.ligatureLevel = val;
         }
         if((val = incoming.alignmentBaseline) !== undefined)
         {
            this.alignmentBaseline = val;
         }
         if((val = incoming.locale) !== undefined)
         {
            this.locale = val;
         }
         if((val = incoming.typographicCase) !== undefined)
         {
            this.typographicCase = val;
         }
         if((val = incoming.fontFamily) !== undefined)
         {
            this.fontFamily = val;
         }
         if((val = incoming.textDecoration) !== undefined)
         {
            this.textDecoration = val;
         }
         if((val = incoming.fontWeight) !== undefined)
         {
            this.fontWeight = val;
         }
         if((val = incoming.fontStyle) !== undefined)
         {
            this.fontStyle = val;
         }
         if((val = incoming.whiteSpaceCollapse) !== undefined)
         {
            this.whiteSpaceCollapse = val;
         }
         if((val = incoming.renderingMode) !== undefined)
         {
            this.renderingMode = val;
         }
         if((val = incoming.cffHinting) !== undefined)
         {
            this.cffHinting = val;
         }
         if((val = incoming.fontLookup) !== undefined)
         {
            this.fontLookup = val;
         }
         if((val = incoming.textRotation) !== undefined)
         {
            this.textRotation = val;
         }
         if((val = incoming.textIndent) !== undefined)
         {
            this.textIndent = val;
         }
         if((val = incoming.paragraphStartIndent) !== undefined)
         {
            this.paragraphStartIndent = val;
         }
         if((val = incoming.paragraphEndIndent) !== undefined)
         {
            this.paragraphEndIndent = val;
         }
         if((val = incoming.paragraphSpaceBefore) !== undefined)
         {
            this.paragraphSpaceBefore = val;
         }
         if((val = incoming.paragraphSpaceAfter) !== undefined)
         {
            this.paragraphSpaceAfter = val;
         }
         if((val = incoming.textAlign) !== undefined)
         {
            this.textAlign = val;
         }
         if((val = incoming.textAlignLast) !== undefined)
         {
            this.textAlignLast = val;
         }
         if((val = incoming.textJustify) !== undefined)
         {
            this.textJustify = val;
         }
         if((val = incoming.justificationRule) !== undefined)
         {
            this.justificationRule = val;
         }
         if((val = incoming.justificationStyle) !== undefined)
         {
            this.justificationStyle = val;
         }
         if((val = incoming.direction) !== undefined)
         {
            this.direction = val;
         }
         if((val = incoming.tabStops) !== undefined)
         {
            this.tabStops = val;
         }
         if((val = incoming.leadingModel) !== undefined)
         {
            this.leadingModel = val;
         }
         if((val = incoming.columnGap) !== undefined)
         {
            this.columnGap = val;
         }
         if((val = incoming.paddingLeft) !== undefined)
         {
            this.paddingLeft = val;
         }
         if((val = incoming.paddingTop) !== undefined)
         {
            this.paddingTop = val;
         }
         if((val = incoming.paddingRight) !== undefined)
         {
            this.paddingRight = val;
         }
         if((val = incoming.paddingBottom) !== undefined)
         {
            this.paddingBottom = val;
         }
         if((val = incoming.columnCount) !== undefined)
         {
            this.columnCount = val;
         }
         if((val = incoming.columnWidth) !== undefined)
         {
            this.columnWidth = val;
         }
         if((val = incoming.firstBaselineOffset) !== undefined)
         {
            this.firstBaselineOffset = val;
         }
         if((val = incoming.verticalAlign) !== undefined)
         {
            this.verticalAlign = val;
         }
         if((val = incoming.blockProgression) !== undefined)
         {
            this.blockProgression = val;
         }
         if((val = incoming.lineBreak) !== undefined)
         {
            this.lineBreak = val;
         }
      }
      
      public function removeMatching(incoming:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         var key:* = null;
         if(incoming == null)
         {
            return;
         }
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            for(key in holder.coreStyles)
            {
               if(description[key].equalHelper(this[key],holder.coreStyles[key]))
               {
                  this[key] = undefined;
               }
            }
            return;
         }
         if(_colorProperty.equalHelper(this.color,incoming.color))
         {
            this.color = undefined;
         }
         if(_backgroundColorProperty.equalHelper(this.backgroundColor,incoming.backgroundColor))
         {
            this.backgroundColor = undefined;
         }
         if(_lineThroughProperty.equalHelper(this.lineThrough,incoming.lineThrough))
         {
            this.lineThrough = undefined;
         }
         if(_textAlphaProperty.equalHelper(this.textAlpha,incoming.textAlpha))
         {
            this.textAlpha = undefined;
         }
         if(_backgroundAlphaProperty.equalHelper(this.backgroundAlpha,incoming.backgroundAlpha))
         {
            this.backgroundAlpha = undefined;
         }
         if(_fontSizeProperty.equalHelper(this.fontSize,incoming.fontSize))
         {
            this.fontSize = undefined;
         }
         if(_baselineShiftProperty.equalHelper(this.baselineShift,incoming.baselineShift))
         {
            this.baselineShift = undefined;
         }
         if(_trackingLeftProperty.equalHelper(this.trackingLeft,incoming.trackingLeft))
         {
            this.trackingLeft = undefined;
         }
         if(_trackingRightProperty.equalHelper(this.trackingRight,incoming.trackingRight))
         {
            this.trackingRight = undefined;
         }
         if(_lineHeightProperty.equalHelper(this.lineHeight,incoming.lineHeight))
         {
            this.lineHeight = undefined;
         }
         if(_breakOpportunityProperty.equalHelper(this.breakOpportunity,incoming.breakOpportunity))
         {
            this.breakOpportunity = undefined;
         }
         if(_digitCaseProperty.equalHelper(this.digitCase,incoming.digitCase))
         {
            this.digitCase = undefined;
         }
         if(_digitWidthProperty.equalHelper(this.digitWidth,incoming.digitWidth))
         {
            this.digitWidth = undefined;
         }
         if(_dominantBaselineProperty.equalHelper(this.dominantBaseline,incoming.dominantBaseline))
         {
            this.dominantBaseline = undefined;
         }
         if(_kerningProperty.equalHelper(this.kerning,incoming.kerning))
         {
            this.kerning = undefined;
         }
         if(_ligatureLevelProperty.equalHelper(this.ligatureLevel,incoming.ligatureLevel))
         {
            this.ligatureLevel = undefined;
         }
         if(_alignmentBaselineProperty.equalHelper(this.alignmentBaseline,incoming.alignmentBaseline))
         {
            this.alignmentBaseline = undefined;
         }
         if(_localeProperty.equalHelper(this.locale,incoming.locale))
         {
            this.locale = undefined;
         }
         if(_typographicCaseProperty.equalHelper(this.typographicCase,incoming.typographicCase))
         {
            this.typographicCase = undefined;
         }
         if(_fontFamilyProperty.equalHelper(this.fontFamily,incoming.fontFamily))
         {
            this.fontFamily = undefined;
         }
         if(_textDecorationProperty.equalHelper(this.textDecoration,incoming.textDecoration))
         {
            this.textDecoration = undefined;
         }
         if(_fontWeightProperty.equalHelper(this.fontWeight,incoming.fontWeight))
         {
            this.fontWeight = undefined;
         }
         if(_fontStyleProperty.equalHelper(this.fontStyle,incoming.fontStyle))
         {
            this.fontStyle = undefined;
         }
         if(_whiteSpaceCollapseProperty.equalHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse))
         {
            this.whiteSpaceCollapse = undefined;
         }
         if(_renderingModeProperty.equalHelper(this.renderingMode,incoming.renderingMode))
         {
            this.renderingMode = undefined;
         }
         if(_cffHintingProperty.equalHelper(this.cffHinting,incoming.cffHinting))
         {
            this.cffHinting = undefined;
         }
         if(_fontLookupProperty.equalHelper(this.fontLookup,incoming.fontLookup))
         {
            this.fontLookup = undefined;
         }
         if(_textRotationProperty.equalHelper(this.textRotation,incoming.textRotation))
         {
            this.textRotation = undefined;
         }
         if(_textIndentProperty.equalHelper(this.textIndent,incoming.textIndent))
         {
            this.textIndent = undefined;
         }
         if(_paragraphStartIndentProperty.equalHelper(this.paragraphStartIndent,incoming.paragraphStartIndent))
         {
            this.paragraphStartIndent = undefined;
         }
         if(_paragraphEndIndentProperty.equalHelper(this.paragraphEndIndent,incoming.paragraphEndIndent))
         {
            this.paragraphEndIndent = undefined;
         }
         if(_paragraphSpaceBeforeProperty.equalHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore))
         {
            this.paragraphSpaceBefore = undefined;
         }
         if(_paragraphSpaceAfterProperty.equalHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter))
         {
            this.paragraphSpaceAfter = undefined;
         }
         if(_textAlignProperty.equalHelper(this.textAlign,incoming.textAlign))
         {
            this.textAlign = undefined;
         }
         if(_textAlignLastProperty.equalHelper(this.textAlignLast,incoming.textAlignLast))
         {
            this.textAlignLast = undefined;
         }
         if(_textJustifyProperty.equalHelper(this.textJustify,incoming.textJustify))
         {
            this.textJustify = undefined;
         }
         if(_justificationRuleProperty.equalHelper(this.justificationRule,incoming.justificationRule))
         {
            this.justificationRule = undefined;
         }
         if(_justificationStyleProperty.equalHelper(this.justificationStyle,incoming.justificationStyle))
         {
            this.justificationStyle = undefined;
         }
         if(_directionProperty.equalHelper(this.direction,incoming.direction))
         {
            this.direction = undefined;
         }
         if(_tabStopsProperty.equalHelper(this.tabStops,incoming.tabStops))
         {
            this.tabStops = undefined;
         }
         if(_leadingModelProperty.equalHelper(this.leadingModel,incoming.leadingModel))
         {
            this.leadingModel = undefined;
         }
         if(_columnGapProperty.equalHelper(this.columnGap,incoming.columnGap))
         {
            this.columnGap = undefined;
         }
         if(_paddingLeftProperty.equalHelper(this.paddingLeft,incoming.paddingLeft))
         {
            this.paddingLeft = undefined;
         }
         if(_paddingTopProperty.equalHelper(this.paddingTop,incoming.paddingTop))
         {
            this.paddingTop = undefined;
         }
         if(_paddingRightProperty.equalHelper(this.paddingRight,incoming.paddingRight))
         {
            this.paddingRight = undefined;
         }
         if(_paddingBottomProperty.equalHelper(this.paddingBottom,incoming.paddingBottom))
         {
            this.paddingBottom = undefined;
         }
         if(_columnCountProperty.equalHelper(this.columnCount,incoming.columnCount))
         {
            this.columnCount = undefined;
         }
         if(_columnWidthProperty.equalHelper(this.columnWidth,incoming.columnWidth))
         {
            this.columnWidth = undefined;
         }
         if(_firstBaselineOffsetProperty.equalHelper(this.firstBaselineOffset,incoming.firstBaselineOffset))
         {
            this.firstBaselineOffset = undefined;
         }
         if(_verticalAlignProperty.equalHelper(this.verticalAlign,incoming.verticalAlign))
         {
            this.verticalAlign = undefined;
         }
         if(_blockProgressionProperty.equalHelper(this.blockProgression,incoming.blockProgression))
         {
            this.blockProgression = undefined;
         }
         if(_lineBreakProperty.equalHelper(this.lineBreak,incoming.lineBreak))
         {
            this.lineBreak = undefined;
         }
      }
      
      public function removeClashing(incoming:flashx.textLayout.formats.ITextLayoutFormat) : void
      {
         var key:* = null;
         if(incoming == null)
         {
            return;
         }
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            for(key in holder.coreStyles)
            {
               if(!description[key].equalHelper(this[key],holder.coreStyles[key]))
               {
                  this[key] = undefined;
               }
            }
            return;
         }
         if(!_colorProperty.equalHelper(this.color,incoming.color))
         {
            this.color = undefined;
         }
         if(!_backgroundColorProperty.equalHelper(this.backgroundColor,incoming.backgroundColor))
         {
            this.backgroundColor = undefined;
         }
         if(!_lineThroughProperty.equalHelper(this.lineThrough,incoming.lineThrough))
         {
            this.lineThrough = undefined;
         }
         if(!_textAlphaProperty.equalHelper(this.textAlpha,incoming.textAlpha))
         {
            this.textAlpha = undefined;
         }
         if(!_backgroundAlphaProperty.equalHelper(this.backgroundAlpha,incoming.backgroundAlpha))
         {
            this.backgroundAlpha = undefined;
         }
         if(!_fontSizeProperty.equalHelper(this.fontSize,incoming.fontSize))
         {
            this.fontSize = undefined;
         }
         if(!_baselineShiftProperty.equalHelper(this.baselineShift,incoming.baselineShift))
         {
            this.baselineShift = undefined;
         }
         if(!_trackingLeftProperty.equalHelper(this.trackingLeft,incoming.trackingLeft))
         {
            this.trackingLeft = undefined;
         }
         if(!_trackingRightProperty.equalHelper(this.trackingRight,incoming.trackingRight))
         {
            this.trackingRight = undefined;
         }
         if(!_lineHeightProperty.equalHelper(this.lineHeight,incoming.lineHeight))
         {
            this.lineHeight = undefined;
         }
         if(!_breakOpportunityProperty.equalHelper(this.breakOpportunity,incoming.breakOpportunity))
         {
            this.breakOpportunity = undefined;
         }
         if(!_digitCaseProperty.equalHelper(this.digitCase,incoming.digitCase))
         {
            this.digitCase = undefined;
         }
         if(!_digitWidthProperty.equalHelper(this.digitWidth,incoming.digitWidth))
         {
            this.digitWidth = undefined;
         }
         if(!_dominantBaselineProperty.equalHelper(this.dominantBaseline,incoming.dominantBaseline))
         {
            this.dominantBaseline = undefined;
         }
         if(!_kerningProperty.equalHelper(this.kerning,incoming.kerning))
         {
            this.kerning = undefined;
         }
         if(!_ligatureLevelProperty.equalHelper(this.ligatureLevel,incoming.ligatureLevel))
         {
            this.ligatureLevel = undefined;
         }
         if(!_alignmentBaselineProperty.equalHelper(this.alignmentBaseline,incoming.alignmentBaseline))
         {
            this.alignmentBaseline = undefined;
         }
         if(!_localeProperty.equalHelper(this.locale,incoming.locale))
         {
            this.locale = undefined;
         }
         if(!_typographicCaseProperty.equalHelper(this.typographicCase,incoming.typographicCase))
         {
            this.typographicCase = undefined;
         }
         if(!_fontFamilyProperty.equalHelper(this.fontFamily,incoming.fontFamily))
         {
            this.fontFamily = undefined;
         }
         if(!_textDecorationProperty.equalHelper(this.textDecoration,incoming.textDecoration))
         {
            this.textDecoration = undefined;
         }
         if(!_fontWeightProperty.equalHelper(this.fontWeight,incoming.fontWeight))
         {
            this.fontWeight = undefined;
         }
         if(!_fontStyleProperty.equalHelper(this.fontStyle,incoming.fontStyle))
         {
            this.fontStyle = undefined;
         }
         if(!_whiteSpaceCollapseProperty.equalHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse))
         {
            this.whiteSpaceCollapse = undefined;
         }
         if(!_renderingModeProperty.equalHelper(this.renderingMode,incoming.renderingMode))
         {
            this.renderingMode = undefined;
         }
         if(!_cffHintingProperty.equalHelper(this.cffHinting,incoming.cffHinting))
         {
            this.cffHinting = undefined;
         }
         if(!_fontLookupProperty.equalHelper(this.fontLookup,incoming.fontLookup))
         {
            this.fontLookup = undefined;
         }
         if(!_textRotationProperty.equalHelper(this.textRotation,incoming.textRotation))
         {
            this.textRotation = undefined;
         }
         if(!_textIndentProperty.equalHelper(this.textIndent,incoming.textIndent))
         {
            this.textIndent = undefined;
         }
         if(!_paragraphStartIndentProperty.equalHelper(this.paragraphStartIndent,incoming.paragraphStartIndent))
         {
            this.paragraphStartIndent = undefined;
         }
         if(!_paragraphEndIndentProperty.equalHelper(this.paragraphEndIndent,incoming.paragraphEndIndent))
         {
            this.paragraphEndIndent = undefined;
         }
         if(!_paragraphSpaceBeforeProperty.equalHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore))
         {
            this.paragraphSpaceBefore = undefined;
         }
         if(!_paragraphSpaceAfterProperty.equalHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter))
         {
            this.paragraphSpaceAfter = undefined;
         }
         if(!_textAlignProperty.equalHelper(this.textAlign,incoming.textAlign))
         {
            this.textAlign = undefined;
         }
         if(!_textAlignLastProperty.equalHelper(this.textAlignLast,incoming.textAlignLast))
         {
            this.textAlignLast = undefined;
         }
         if(!_textJustifyProperty.equalHelper(this.textJustify,incoming.textJustify))
         {
            this.textJustify = undefined;
         }
         if(!_justificationRuleProperty.equalHelper(this.justificationRule,incoming.justificationRule))
         {
            this.justificationRule = undefined;
         }
         if(!_justificationStyleProperty.equalHelper(this.justificationStyle,incoming.justificationStyle))
         {
            this.justificationStyle = undefined;
         }
         if(!_directionProperty.equalHelper(this.direction,incoming.direction))
         {
            this.direction = undefined;
         }
         if(!_tabStopsProperty.equalHelper(this.tabStops,incoming.tabStops))
         {
            this.tabStops = undefined;
         }
         if(!_leadingModelProperty.equalHelper(this.leadingModel,incoming.leadingModel))
         {
            this.leadingModel = undefined;
         }
         if(!_columnGapProperty.equalHelper(this.columnGap,incoming.columnGap))
         {
            this.columnGap = undefined;
         }
         if(!_paddingLeftProperty.equalHelper(this.paddingLeft,incoming.paddingLeft))
         {
            this.paddingLeft = undefined;
         }
         if(!_paddingTopProperty.equalHelper(this.paddingTop,incoming.paddingTop))
         {
            this.paddingTop = undefined;
         }
         if(!_paddingRightProperty.equalHelper(this.paddingRight,incoming.paddingRight))
         {
            this.paddingRight = undefined;
         }
         if(!_paddingBottomProperty.equalHelper(this.paddingBottom,incoming.paddingBottom))
         {
            this.paddingBottom = undefined;
         }
         if(!_columnCountProperty.equalHelper(this.columnCount,incoming.columnCount))
         {
            this.columnCount = undefined;
         }
         if(!_columnWidthProperty.equalHelper(this.columnWidth,incoming.columnWidth))
         {
            this.columnWidth = undefined;
         }
         if(!_firstBaselineOffsetProperty.equalHelper(this.firstBaselineOffset,incoming.firstBaselineOffset))
         {
            this.firstBaselineOffset = undefined;
         }
         if(!_verticalAlignProperty.equalHelper(this.verticalAlign,incoming.verticalAlign))
         {
            this.verticalAlign = undefined;
         }
         if(!_blockProgressionProperty.equalHelper(this.blockProgression,incoming.blockProgression))
         {
            this.blockProgression = undefined;
         }
         if(!_lineBreakProperty.equalHelper(this.lineBreak,incoming.lineBreak))
         {
            this.lineBreak = undefined;
         }
      }
   }
}
