package flashx.textLayout.elements
{
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.property.Property;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.events.ModelChange;
   import flash.utils.getDefinitionByName;
   import flash.utils.getQualifiedClassName;
   import flashx.textLayout.formats.FlowElementDisplayType;
   import flash.display.DisplayObjectContainer;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.compose.IFlowComposer;
   
   use namespace tlf_internal;
   
   [IMXMLObject]
   public class FlowElement implements ITextLayoutFormat
   {
      
      private static const idString:String = "id";
      
      private static const styleNameString:String = "styleName";
      
      private static const impliedElementString:String = "impliedElement";
      
      tlf_internal static var _scratchTextLayoutFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
      
      private static var defaultStylesPrototype:Object;
      
      private static function factory():void
      {
      }
      {
         createDefaultStylesPrototyope();
      }
      
      private var _parent:flashx.textLayout.elements.FlowGroupElement;
      
      tlf_internal var _formatValueHolder:flashx.textLayout.elements.FlowValueHolder;
      
      protected var _computedFormat:TextLayoutFormatValueHolder;
      
      private var _parentRelativeStart:int = 0;
      
      private var _textLength:int = 0;
      
      public function FlowElement()
      {
         super();
         if(this.abstract)
         {
            throw new Error(GlobalSettings.resourceStringFunction("invalidFlowElementConstruct"));
         }
      }
      
      private static function createDefaultStylesPrototyope() : void
      {
         defaultStylesPrototype = new Object();
         defaultStylesPrototype.hasNonInheritedStyles = false;
         defaultStylesPrototype.setPropertyIsEnumerable("hasNonInheritedStyles",false);
         Property.defaultsAllHelper(TextLayoutFormat.description,defaultStylesPrototype);
      }
      
      tlf_internal static function createTextLayoutFormatPrototype(localStyles:ITextLayoutFormat, parentPrototype:TextLayoutFormatValueHolder) : TextLayoutFormatValueHolder
      {
         var key:* = null;
         var val:* = undefined;
         var prop:Property = null;
         var lvh:TextLayoutFormatValueHolder = null;
         var coreStyles:Object = null;
         var parentStylesPrototype:Object = Boolean(parentPrototype)?parentPrototype.coreStyles:defaultStylesPrototype;
         factory.prototype = parentStylesPrototype;
         var stylesObject:Object = new factory();
         var hasNonInheritedStyles:Boolean = false;
         var hasStylesSet:Boolean = parentStylesPrototype.hasNonInheritedStyles;
         if(hasStylesSet)
         {
            TextLayoutFormatValueHolder.resetModifiedNoninheritedStyles(stylesObject);
         }
         if(localStyles != null)
         {
            lvh = localStyles as TextLayoutFormatValueHolder;
            if(lvh)
            {
               coreStyles = lvh.coreStyles;
               for(key in coreStyles)
               {
                  prop = TextLayoutFormat.description[key];
                  val = coreStyles[key];
                  if(val == FormatValue.INHERIT)
                  {
                     if(parentPrototype)
                     {
                        if(!prop.inherited)
                        {
                           val = parentPrototype[key];
                           if(stylesObject[key] != val)
                           {
                              stylesObject[key] = val;
                              hasNonInheritedStyles = true;
                           }
                        }
                     }
                  }
                  else if(stylesObject[key] != val)
                  {
                     if(!prop.inherited)
                     {
                        hasNonInheritedStyles = true;
                     }
                     stylesObject[key] = val;
                     hasStylesSet = true;
                  }
               }
            }
            else
            {
               for each(prop in TextLayoutFormat.description)
               {
                  key = prop.name;
                  val = localStyles[key];
                  if(val !== undefined)
                  {
                     if(val == FormatValue.INHERIT)
                     {
                        if(parentPrototype)
                        {
                           if(!prop.inherited)
                           {
                              val = parentPrototype[key];
                              if(stylesObject[key] != val)
                              {
                                 stylesObject[key] = val;
                                 hasNonInheritedStyles = true;
                              }
                           }
                        }
                     }
                     else if(stylesObject[key] != val)
                     {
                        if(!prop.inherited)
                        {
                           hasNonInheritedStyles = true;
                        }
                        stylesObject[key] = val;
                        hasStylesSet = true;
                     }
                  }
               }
            }
         }
         var rslt:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         if(!hasStylesSet)
         {
            rslt.coreStyles = parentStylesPrototype;
         }
         else
         {
            if(stylesObject.hasNonInheritedStyles != hasNonInheritedStyles)
            {
               stylesObject.hasNonInheritedStyles = hasNonInheritedStyles;
               stylesObject.setPropertyIsEnumerable("hasNonInheritedStyles",false);
            }
            rslt.coreStyles = stylesObject;
         }
         return rslt;
      }
      
      public function initialized(document:Object, id:String) : void
      {
         this.id = id;
      }
      
      protected function get abstract() : Boolean
      {
         return true;
      }
      
      public function get userStyles() : Object
      {
         var styles:Object = this._formatValueHolder == null?null:this._formatValueHolder.userStyles;
         return Boolean(styles)?Property.shallowCopy(styles):null;
      }
      
      public function set userStyles(styles:Object) : void
      {
         var newStyles:Object = null;
         var val:* = null;
         if(styles)
         {
            newStyles = new Object();
            for(val in styles)
            {
               newStyles[val] = styles[val];
            }
         }
         this.writableTextLayoutFormatValueHolder().userStyles = newStyles;
         this.modelChanged(ModelChange.USER_STYLE_CHANGED,0,this.textLength,true);
      }
      
      public function get coreStyles() : Object
      {
         var styles:Object = this._formatValueHolder == null?null:this._formatValueHolder.coreStyles;
         return Boolean(styles)?Property.shallowCopy(styles):null;
      }
      
      tlf_internal function setCoreStylesInternal(styles:Object) : void
      {
         var newStyles:Object = null;
         var val:* = null;
         var value:* = undefined;
         if(styles)
         {
            newStyles = new Object();
            for(val in styles)
            {
               value = styles[val];
               if(value != undefined)
               {
                  newStyles[val] = value;
               }
            }
         }
         this.writableTextLayoutFormatValueHolder().coreStyles = newStyles;
         this.formatChanged();
      }
      
      public function set linkNormalFormat(value:*) : void
      {
         this.setStyle(LinkElement.LINK_NORMAL_FORMAT_NAME,value);
      }
      
      public function get linkNormalFormat() : *
      {
         return this.getStyle(LinkElement.LINK_NORMAL_FORMAT_NAME);
      }
      
      public function set linkActiveFormat(value:*) : void
      {
         this.setStyle(LinkElement.LINK_ACTIVE_FORMAT_NAME,value);
      }
      
      public function get linkActiveFormat() : *
      {
         return this.getStyle(LinkElement.LINK_ACTIVE_FORMAT_NAME);
      }
      
      public function set linkHoverFormat(value:*) : void
      {
         this.setStyle(LinkElement.LINK_HOVER_FORMAT_NAME,value);
      }
      
      public function get linkHoverFormat() : *
      {
         return this.getStyle(LinkElement.LINK_HOVER_FORMAT_NAME);
      }
      
      public function equalUserStyles(otherElement:FlowElement) : Boolean
      {
         var myStyles:Object = Boolean(this._formatValueHolder)?this._formatValueHolder.userStyles:null;
         var elemStyles:Object = Boolean(otherElement._formatValueHolder)?otherElement._formatValueHolder.userStyles:null;
         return Property.equalStyleObjects(myStyles,elemStyles);
      }
      
      tlf_internal function equalStylesForMerge(elem:FlowElement) : Boolean
      {
         return Boolean(this.id == elem.id) && Boolean(this.styleName == elem.styleName) && Boolean(TextLayoutFormat.isEqual(elem.format,this.format)) && Boolean(this.equalUserStyles(elem));
      }
      
      public function shallowCopy(relativeStart:int = 0, relativeEnd:int = -1) : FlowElement
      {
         if(relativeEnd == -1)
         {
            relativeEnd = this.textLength;
         }
         var retFlow:FlowElement = new (getDefinitionByName(getQualifiedClassName(this)) as Class)();
         retFlow.styleName = this.styleName;
         retFlow.id = this.id;
         if(this._formatValueHolder != null)
         {
            retFlow._formatValueHolder = new flashx.textLayout.elements.FlowValueHolder(this._formatValueHolder);
         }
         return retFlow;
      }
      
      public function deepCopy(relativeStart:int = 0, relativeEnd:int = -1) : FlowElement
      {
         if(relativeEnd == -1)
         {
            relativeEnd = this.textLength;
         }
         return this.shallowCopy(relativeStart,relativeEnd);
      }
      
      public function getText(relativeStart:int = 0, relativeEnd:int = -1, paragraphSeparator:String = "\n") : String
      {
         return "";
      }
      
      public function splitAtPosition(relativePosition:int) : FlowElement
      {
         if(Boolean(relativePosition < 0) || Boolean(relativePosition > this.textLength))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSplitAtPosition"));
         }
         return this;
      }
      
      tlf_internal function get bindableElement() : Boolean
      {
         return this.getPrivateStyle("bindable") == true;
      }
      
      tlf_internal function set bindableElement(value:Boolean) : void
      {
         this.setPrivateStyle("bindable",value);
      }
      
      tlf_internal function mergeToPreviousIfPossible() : Boolean
      {
         return false;
      }
      
      tlf_internal function createContentElement() : void
      {
      }
      
      tlf_internal function releaseContentElement() : void
      {
      }
      
      tlf_internal function canReleaseContentElement() : Boolean
      {
         return true;
      }
      
      public function get parent() : flashx.textLayout.elements.FlowGroupElement
      {
         return this._parent;
      }
      
      tlf_internal function setParentAndRelativeStart(newParent:flashx.textLayout.elements.FlowGroupElement, newStart:int) : void
      {
         this._parent = newParent;
         this._parentRelativeStart = newStart;
         this.attributesChanged(false);
      }
      
      tlf_internal function setParentAndRelativeStartOnly(newParent:flashx.textLayout.elements.FlowGroupElement, newStart:int) : void
      {
         this._parent = newParent;
         this._parentRelativeStart = newStart;
      }
      
      public function get textLength() : int
      {
         return this._textLength;
      }
      
      tlf_internal function setTextLength(newLength:int) : void
      {
         this._textLength = newLength;
      }
      
      public function get parentRelativeStart() : int
      {
         return this._parentRelativeStart;
      }
      
      tlf_internal function setParentRelativeStart(newStart:int) : void
      {
         this._parentRelativeStart = newStart;
      }
      
      public function get parentRelativeEnd() : int
      {
         return this._parentRelativeStart + this._textLength;
      }
      
      tlf_internal function getAncestorWithContainer() : ContainerFormattedElement
      {
         var contElement:ContainerFormattedElement = null;
         var elem:FlowElement = this;
         while(elem)
         {
            contElement = elem as ContainerFormattedElement;
            if(contElement)
            {
               if(Boolean(!contElement._parent) || Boolean(contElement.flowComposer))
               {
                  return contElement;
               }
            }
            elem = elem._parent;
         }
         return null;
      }
      
      tlf_internal function getPrivateStyle(styleName:String) : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.getPrivateData(styleName):undefined;
      }
      
      tlf_internal function setPrivateStyle(styleName:String, val:*) : void
      {
         if(this.getPrivateStyle(styleName) != val)
         {
            this.writableTextLayoutFormatValueHolder().setPrivateData(styleName,val);
            this.modelChanged(ModelChange.STYLE_SELECTOR_CHANGED,0,this.textLength);
         }
      }
      
      public function get id() : String
      {
         return this.getPrivateStyle(idString);
      }
      
      public function set id(val:String) : void
      {
         return this.setPrivateStyle(idString,val);
      }
      
      public function get styleName() : String
      {
         return this.getPrivateStyle(styleNameString);
      }
      
      public function set styleName(val:String) : void
      {
         return this.setPrivateStyle(styleNameString,val);
      }
      
      tlf_internal function get impliedElement() : Boolean
      {
         return this.getPrivateStyle(impliedElementString) !== undefined;
      }
      
      tlf_internal function set impliedElement(value:Boolean) : void
      {
         this.setPrivateStyle(impliedElementString,"true");
      }
      
      public function get color() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.color:undefined;
      }
      
      public function set color(colorValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().color = colorValue;
         this.formatChanged();
      }
      
      public function get backgroundColor() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.backgroundColor:undefined;
      }
      
      public function set backgroundColor(backgroundColorValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().backgroundColor = backgroundColorValue;
         this.formatChanged();
      }
      
      public function get lineThrough() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineThrough:undefined;
      }
      
      public function set lineThrough(lineThroughValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineThrough = lineThroughValue;
         this.formatChanged();
      }
      
      public function get textAlpha() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlpha:undefined;
      }
      
      public function set textAlpha(textAlphaValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlpha = textAlphaValue;
         this.formatChanged();
      }
      
      public function get backgroundAlpha() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.backgroundAlpha:undefined;
      }
      
      public function set backgroundAlpha(backgroundAlphaValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().backgroundAlpha = backgroundAlphaValue;
         this.formatChanged();
      }
      
      public function get fontSize() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontSize:undefined;
      }
      
      public function set fontSize(fontSizeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontSize = fontSizeValue;
         this.formatChanged();
      }
      
      public function get baselineShift() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.baselineShift:undefined;
      }
      
      public function set baselineShift(baselineShiftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().baselineShift = baselineShiftValue;
         this.formatChanged();
      }
      
      public function get trackingLeft() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.trackingLeft:undefined;
      }
      
      public function set trackingLeft(trackingLeftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().trackingLeft = trackingLeftValue;
         this.formatChanged();
      }
      
      public function get trackingRight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.trackingRight:undefined;
      }
      
      public function set trackingRight(trackingRightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().trackingRight = trackingRightValue;
         this.formatChanged();
      }
      
      public function get lineHeight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineHeight:undefined;
      }
      
      public function set lineHeight(lineHeightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineHeight = lineHeightValue;
         this.formatChanged();
      }
      
      public function get breakOpportunity() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.breakOpportunity:undefined;
      }
      
      public function set breakOpportunity(breakOpportunityValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().breakOpportunity = breakOpportunityValue;
         this.formatChanged();
      }
      
      public function get digitCase() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.digitCase:undefined;
      }
      
      public function set digitCase(digitCaseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().digitCase = digitCaseValue;
         this.formatChanged();
      }
      
      public function get digitWidth() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.digitWidth:undefined;
      }
      
      public function set digitWidth(digitWidthValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().digitWidth = digitWidthValue;
         this.formatChanged();
      }
      
      public function get dominantBaseline() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.dominantBaseline:undefined;
      }
      
      public function set dominantBaseline(dominantBaselineValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().dominantBaseline = dominantBaselineValue;
         this.formatChanged();
      }
      
      public function get kerning() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.kerning:undefined;
      }
      
      public function set kerning(kerningValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().kerning = kerningValue;
         this.formatChanged();
      }
      
      public function get ligatureLevel() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.ligatureLevel:undefined;
      }
      
      public function set ligatureLevel(ligatureLevelValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().ligatureLevel = ligatureLevelValue;
         this.formatChanged();
      }
      
      public function get alignmentBaseline() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.alignmentBaseline:undefined;
      }
      
      public function set alignmentBaseline(alignmentBaselineValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().alignmentBaseline = alignmentBaselineValue;
         this.formatChanged();
      }
      
      public function get locale() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.locale:undefined;
      }
      
      public function set locale(localeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().locale = localeValue;
         this.formatChanged();
      }
      
      public function get typographicCase() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.typographicCase:undefined;
      }
      
      public function set typographicCase(typographicCaseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().typographicCase = typographicCaseValue;
         this.formatChanged();
      }
      
      public function get fontFamily() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontFamily:undefined;
      }
      
      public function set fontFamily(fontFamilyValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontFamily = fontFamilyValue;
         this.formatChanged();
      }
      
      public function get textDecoration() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textDecoration:undefined;
      }
      
      public function set textDecoration(textDecorationValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textDecoration = textDecorationValue;
         this.formatChanged();
      }
      
      public function get fontWeight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontWeight:undefined;
      }
      
      public function set fontWeight(fontWeightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontWeight = fontWeightValue;
         this.formatChanged();
      }
      
      public function get fontStyle() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontStyle:undefined;
      }
      
      public function set fontStyle(fontStyleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontStyle = fontStyleValue;
         this.formatChanged();
      }
      
      public function get whiteSpaceCollapse() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.whiteSpaceCollapse:undefined;
      }
      
      public function set whiteSpaceCollapse(whiteSpaceCollapseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().whiteSpaceCollapse = whiteSpaceCollapseValue;
         this.formatChanged();
      }
      
      public function get renderingMode() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.renderingMode:undefined;
      }
      
      public function set renderingMode(renderingModeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().renderingMode = renderingModeValue;
         this.formatChanged();
      }
      
      public function get cffHinting() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.cffHinting:undefined;
      }
      
      public function set cffHinting(cffHintingValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().cffHinting = cffHintingValue;
         this.formatChanged();
      }
      
      public function get fontLookup() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontLookup:undefined;
      }
      
      public function set fontLookup(fontLookupValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontLookup = fontLookupValue;
         this.formatChanged();
      }
      
      public function get textRotation() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textRotation:undefined;
      }
      
      public function set textRotation(textRotationValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textRotation = textRotationValue;
         this.formatChanged();
      }
      
      public function get textIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textIndent:undefined;
      }
      
      public function set textIndent(textIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textIndent = textIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphStartIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphStartIndent:undefined;
      }
      
      public function set paragraphStartIndent(paragraphStartIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphStartIndent = paragraphStartIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphEndIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphEndIndent:undefined;
      }
      
      public function set paragraphEndIndent(paragraphEndIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphEndIndent = paragraphEndIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphSpaceBefore() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphSpaceBefore:undefined;
      }
      
      public function set paragraphSpaceBefore(paragraphSpaceBeforeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphSpaceBefore = paragraphSpaceBeforeValue;
         this.formatChanged();
      }
      
      public function get paragraphSpaceAfter() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphSpaceAfter:undefined;
      }
      
      public function set paragraphSpaceAfter(paragraphSpaceAfterValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphSpaceAfter = paragraphSpaceAfterValue;
         this.formatChanged();
      }
      
      public function get textAlign() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlign:undefined;
      }
      
      public function set textAlign(textAlignValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlign = textAlignValue;
         this.formatChanged();
      }
      
      public function get textAlignLast() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlignLast:undefined;
      }
      
      public function set textAlignLast(textAlignLastValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlignLast = textAlignLastValue;
         this.formatChanged();
      }
      
      public function get textJustify() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textJustify:undefined;
      }
      
      public function set textJustify(textJustifyValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textJustify = textJustifyValue;
         this.formatChanged();
      }
      
      public function get justificationRule() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.justificationRule:undefined;
      }
      
      public function set justificationRule(justificationRuleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().justificationRule = justificationRuleValue;
         this.formatChanged();
      }
      
      public function get justificationStyle() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.justificationStyle:undefined;
      }
      
      public function set justificationStyle(justificationStyleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().justificationStyle = justificationStyleValue;
         this.formatChanged();
      }
      
      public function get direction() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.direction:undefined;
      }
      
      public function set direction(directionValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().direction = directionValue;
         this.formatChanged();
      }
      
      public function get tabStops() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.tabStops:undefined;
      }
      
      public function set tabStops(tabStopsValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().tabStops = tabStopsValue;
         this.formatChanged();
      }
      
      public function get leadingModel() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.leadingModel:undefined;
      }
      
      public function set leadingModel(leadingModelValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().leadingModel = leadingModelValue;
         this.formatChanged();
      }
      
      public function get columnGap() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnGap:undefined;
      }
      
      public function set columnGap(columnGapValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnGap = columnGapValue;
         this.formatChanged();
      }
      
      public function get paddingLeft() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingLeft:undefined;
      }
      
      public function set paddingLeft(paddingLeftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingLeft = paddingLeftValue;
         this.formatChanged();
      }
      
      public function get paddingTop() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingTop:undefined;
      }
      
      public function set paddingTop(paddingTopValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingTop = paddingTopValue;
         this.formatChanged();
      }
      
      public function get paddingRight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingRight:undefined;
      }
      
      public function set paddingRight(paddingRightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingRight = paddingRightValue;
         this.formatChanged();
      }
      
      public function get paddingBottom() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingBottom:undefined;
      }
      
      public function set paddingBottom(paddingBottomValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingBottom = paddingBottomValue;
         this.formatChanged();
      }
      
      public function get columnCount() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnCount:undefined;
      }
      
      public function set columnCount(columnCountValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnCount = columnCountValue;
         this.formatChanged();
      }
      
      public function get columnWidth() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnWidth:undefined;
      }
      
      public function set columnWidth(columnWidthValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnWidth = columnWidthValue;
         this.formatChanged();
      }
      
      public function get firstBaselineOffset() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.firstBaselineOffset:undefined;
      }
      
      public function set firstBaselineOffset(firstBaselineOffsetValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().firstBaselineOffset = firstBaselineOffsetValue;
         this.formatChanged();
      }
      
      public function get verticalAlign() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.verticalAlign:undefined;
      }
      
      public function set verticalAlign(verticalAlignValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().verticalAlign = verticalAlignValue;
         this.formatChanged();
      }
      
      public function get blockProgression() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.blockProgression:undefined;
      }
      
      public function set blockProgression(blockProgressionValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().blockProgression = blockProgressionValue;
         this.formatChanged();
      }
      
      public function get lineBreak() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineBreak:undefined;
      }
      
      public function set lineBreak(lineBreakValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineBreak = lineBreakValue;
         this.formatChanged();
      }
      
      public function get format() : ITextLayoutFormat
      {
         return this._formatValueHolder;
      }
      
      public function set format(value:ITextLayoutFormat) : void
      {
         if(value == null)
         {
            if(Boolean(this._formatValueHolder == null) || Boolean(this._formatValueHolder.coreStyles == null))
            {
               return;
            }
            this._formatValueHolder.coreStyles = null;
         }
         else
         {
            this.writableTextLayoutFormatValueHolder().format = value;
         }
         this.formatChanged();
      }
      
      private function writableTextLayoutFormatValueHolder() : flashx.textLayout.elements.FlowValueHolder
      {
         if(this._formatValueHolder == null)
         {
            this._formatValueHolder = new flashx.textLayout.elements.FlowValueHolder();
         }
         return this._formatValueHolder;
      }
      
      tlf_internal function formatChanged(notifyModelChanged:Boolean = true) : void
      {
         if(notifyModelChanged)
         {
            this.modelChanged(ModelChange.TEXTLAYOUT_FORMAT_CHANGED,0,this.textLength);
         }
         this._computedFormat = null;
      }
      
      tlf_internal function get formatForCascade() : TextLayoutFormatValueHolder
      {
         var elemStyle:TextLayoutFormatValueHolder = null;
         var localFormat:ITextLayoutFormat = null;
         var rslt:TextLayoutFormatValueHolder = null;
         var tf:TextFlow = this.getTextFlow();
         if(tf)
         {
            elemStyle = tf.getTextLayoutFormatStyle(this);
            if(elemStyle)
            {
               localFormat = this.format;
               if(localFormat == null)
               {
                  return elemStyle;
               }
               rslt = new TextLayoutFormatValueHolder();
               rslt.apply(elemStyle);
               rslt.apply(localFormat);
               return rslt;
            }
         }
         return this._formatValueHolder;
      }
      
      public function get computedFormat() : ITextLayoutFormat
      {
         if(this._computedFormat == null)
         {
            this._computedFormat = this.doComputeTextLayoutFormat();
         }
         return this._computedFormat;
      }
      
      tlf_internal function doComputeTextLayoutFormat() : TextLayoutFormatValueHolder
      {
         var parentPrototype:TextLayoutFormatValueHolder = Boolean(this.parent)?TextLayoutFormatValueHolder(this.parent.computedFormat):null;
         return FlowElement.createTextLayoutFormatPrototype(this.formatForCascade,parentPrototype);
      }
      
      tlf_internal function attributesChanged(notifyModelChanged:Boolean = true) : void
      {
         this.formatChanged(notifyModelChanged);
      }
      
      public function getStyle(styleProp:String) : *
      {
         if(TextLayoutFormat.description.hasOwnProperty(styleProp))
         {
            return this.computedFormat[styleProp];
         }
         return this.getUserStyleWorker(styleProp);
      }
      
      public function setStyle(styleProp:String, newValue:*) : void
      {
         if(TextLayoutFormat.description[styleProp] !== undefined)
         {
            this[styleProp] = newValue;
         }
         else
         {
            this.writableTextLayoutFormatValueHolder().setUserStyle(styleProp,newValue);
            this.modelChanged(ModelChange.USER_STYLE_CHANGED,0,this.textLength,true);
         }
      }
      
      public function clearStyle(styleProp:String) : void
      {
         this.setStyle(styleProp,undefined);
      }
      
      tlf_internal function getUserStyleWorker(styleProp:String) : *
      {
         var userStyle:* = undefined;
         if(this._formatValueHolder != null)
         {
            userStyle = this._formatValueHolder.getUserStyle(styleProp);
            if(userStyle !== undefined)
            {
               return userStyle;
            }
         }
         var tf:TextFlow = this.getTextFlow();
         if(Boolean(tf) && Boolean(tf.formatResolver))
         {
            userStyle = tf.formatResolver.resolveUserFormat(this,styleProp);
            if(userStyle !== undefined)
            {
               return userStyle;
            }
         }
         return Boolean(this.parent)?this.parent.getUserStyleWorker(styleProp):undefined;
      }
      
      tlf_internal function modelChanged(changeType:String, changeStart:int, changeLen:int, needNormalize:Boolean = true, bumpGeneration:Boolean = true) : void
      {
         var tf:TextFlow = this.getTextFlow();
         if(tf)
         {
            tf.processModelChanged(changeType,this,changeStart,changeLen,needNormalize,bumpGeneration);
         }
      }
      
      tlf_internal function appendElementsForDelayedUpdate(tf:TextFlow) : void
      {
      }
      
      tlf_internal function applyDelayedElementUpdate(textFlow:TextFlow, okToUnloadGraphics:Boolean, hasController:Boolean) : void
      {
      }
      
      public function get display() : String
      {
         return FlowElementDisplayType.INLINE;
      }
      
      public function set tracking(trackingValue:Object) : void
      {
         this.trackingRight = trackingValue;
      }
      
      tlf_internal function createGeometry(parentToBe:DisplayObjectContainer) : void
      {
      }
      
      tlf_internal function applyWhiteSpaceCollapse(collapse:String) : void
      {
         if(this.whiteSpaceCollapse !== undefined)
         {
            this.whiteSpaceCollapse = undefined;
         }
         this.setPrivateStyle(impliedElementString,undefined);
      }
      
      tlf_internal function isReadOnlyFlowElement() : Boolean
      {
         return false;
      }
      
      tlf_internal function getHighestReadOnlyFlowElement() : FlowElement
      {
         var highestReadOnlyFlowElement:FlowElement = null;
         if(this.isReadOnlyFlowElement())
         {
            highestReadOnlyFlowElement = this;
         }
         var curFlowElement:FlowElement = this.parent;
         while(curFlowElement != null)
         {
            if(curFlowElement.isReadOnlyFlowElement())
            {
               highestReadOnlyFlowElement = curFlowElement;
            }
            curFlowElement = curFlowElement.parent;
         }
         return highestReadOnlyFlowElement;
      }
      
      public function getAbsoluteStart() : int
      {
         var rslt:int = this.parentRelativeStart;
         for(var elem:FlowElement = this.parent; elem; elem = elem.parent)
         {
            rslt = rslt + elem.parentRelativeStart;
         }
         return rslt;
      }
      
      public function getElementRelativeStart(ancestorElement:FlowElement) : int
      {
         var rslt:int = this.parentRelativeStart;
         var elem:FlowElement = this.parent;
         while(Boolean(elem) && Boolean(elem != ancestorElement))
         {
            rslt = rslt + elem.parentRelativeStart;
            elem = elem.parent;
         }
         return rslt;
      }
      
      public function getTextFlow() : TextFlow
      {
         var elem:FlowElement = this;
         while(elem.parent != null)
         {
            elem = elem.parent;
         }
         return elem as TextFlow;
      }
      
      public function getParagraph() : ParagraphElement
      {
         var rslt:FlowElement = this;
         while(rslt)
         {
            if(rslt is ParagraphElement)
            {
               return rslt as ParagraphElement;
            }
            rslt = rslt.parent;
         }
         return null;
      }
      
      public function getParentByType(elementType:Class) : FlowElement
      {
         var curElement:FlowElement = this.parent;
         while(curElement)
         {
            if(curElement is elementType)
            {
               return curElement;
            }
            curElement = curElement.parent;
         }
         return null;
      }
      
      public function getPreviousSibling() : FlowElement
      {
         if(!this.parent)
         {
            return null;
         }
         var idx:int = this.parent.getChildIndex(this);
         return idx == 0?null:this.parent.getChildAt(idx - 1);
      }
      
      public function getNextSibling() : FlowElement
      {
         if(!this.parent)
         {
            return null;
         }
         var idx:int = this.parent.getChildIndex(this);
         return idx == this.parent.numChildren - 1?null:this.parent.getChildAt(idx + 1);
      }
      
      public function getCharAtPosition(relativePosition:int) : String
      {
         return null;
      }
      
      public function getCharCodeAtPosition(relativePosition:int) : int
      {
         var str:String = this.getCharAtPosition(relativePosition);
         return Boolean(str) && Boolean(str.length > 0)?int(str.charCodeAt(0)):int(0);
      }
      
      tlf_internal function getElementByIDHelper(idName:String) : FlowElement
      {
         if(this.id == idName)
         {
            return this;
         }
         return null;
      }
      
      tlf_internal function getElementsByStyleNameHelper(a:Array, styleName:String) : void
      {
         if(this.styleName == styleName)
         {
            a.push(this);
         }
      }
      
      private function updateRange(len:int) : void
      {
         this.setParentRelativeStart(this.parentRelativeStart + len);
      }
      
      tlf_internal function updateLengths(startIdx:int, len:int, updateLines:Boolean) : void
      {
         var idx:int = 0;
         var pElementCount:int = 0;
         var child:FlowElement = null;
         this.setTextLength(this.textLength + len);
         var p:flashx.textLayout.elements.FlowGroupElement = this.parent;
         if(p)
         {
            idx = p.getChildIndex(this) + 1;
            pElementCount = p.numChildren;
            while(idx < pElementCount)
            {
               child = p.getChildAt(idx++);
               child.updateRange(len);
            }
            p.updateLengths(startIdx,len,updateLines);
         }
      }
      
      tlf_internal function getEnclosingController(relativePos:int) : ContainerController
      {
         var textFlow:TextFlow = this.getTextFlow();
         if(Boolean(textFlow == null) || Boolean(textFlow.flowComposer == null) || Boolean(textFlow.flowComposer.numLines == 0))
         {
            return null;
         }
         var curItem:FlowElement = this;
         while(Boolean(curItem) && (Boolean(!(curItem is ContainerFormattedElement)) || Boolean(ContainerFormattedElement(curItem).flowComposer == null)))
         {
            curItem = curItem.parent;
         }
         var flowComposer:IFlowComposer = ContainerFormattedElement(curItem).flowComposer;
         if(!flowComposer)
         {
            return null;
         }
         var controllerIndex:int = ContainerFormattedElement(curItem).flowComposer.findControllerIndexAtPosition(this.getAbsoluteStart() + relativePos,false);
         return controllerIndex != -1?flowComposer.getControllerAt(controllerIndex):null;
      }
      
      tlf_internal function deleteContainerText(endPos:int, deleteTotal:int) : void
      {
         var absoluteEndPos:int = 0;
         var absStartIdx:int = 0;
         var charsDeletedFromCurContainer:int = 0;
         var enclosingController:ContainerController = null;
         var enclosingControllerBeginningPos:int = 0;
         var containerTextLengthDelta:int = 0;
         var flowComposer:IFlowComposer = null;
         var myIdx:int = 0;
         if(this.getTextFlow())
         {
            absoluteEndPos = this.getAbsoluteStart() + endPos;
            absStartIdx = absoluteEndPos - deleteTotal;
            while(deleteTotal > 0)
            {
               enclosingController = this.getEnclosingController(endPos - 1);
               if(!enclosingController)
               {
                  enclosingController = this.getEnclosingController(endPos - deleteTotal);
                  if(enclosingController)
                  {
                     flowComposer = enclosingController.flowComposer;
                     myIdx = flowComposer.getControllerIndex(enclosingController);
                     while(Boolean(myIdx + 1 < flowComposer.numControllers) && Boolean(enclosingController.absoluteStart + enclosingController.textLength < endPos))
                     {
                        enclosingController = flowComposer.getControllerAt(myIdx + 1);
                        if(enclosingController.textLength)
                        {
                           break;
                        }
                        myIdx++;
                     }
                  }
                  if(!enclosingController)
                  {
                     break;
                  }
               }
               enclosingControllerBeginningPos = enclosingController.absoluteStart;
               if(absStartIdx < enclosingControllerBeginningPos)
               {
                  charsDeletedFromCurContainer = absoluteEndPos - enclosingControllerBeginningPos + 1;
               }
               else if(absStartIdx < enclosingControllerBeginningPos + enclosingController.textLength)
               {
                  charsDeletedFromCurContainer = deleteTotal;
               }
               containerTextLengthDelta = enclosingController.textLength < charsDeletedFromCurContainer?int(enclosingController.textLength):int(charsDeletedFromCurContainer);
               if(containerTextLengthDelta <= 0)
               {
                  break;
               }
               ContainerController(enclosingController).setTextLengthOnly(enclosingController.textLength - containerTextLengthDelta);
               deleteTotal = deleteTotal - containerTextLengthDelta;
               absoluteEndPos = absoluteEndPos - containerTextLengthDelta;
               endPos = endPos - containerTextLengthDelta;
            }
         }
      }
      
      tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
      }
      
      tlf_internal function quickCloneTextLayoutFormat(sibling:FlowElement) : void
      {
         this._formatValueHolder = Boolean(sibling._formatValueHolder)?new flashx.textLayout.elements.FlowValueHolder(sibling._formatValueHolder):null;
      }
      
      tlf_internal function updateForMustUseComposer(textFlow:TextFlow) : Boolean
      {
         return false;
      }
   }
}
