package flashx.textLayout.elements
{
   import flash.utils.Dictionary;
   import flashx.textLayout.compose.TextFlowLine;
   import flash.geom.Rectangle;
   import flash.text.engine.TextLine;
   import flashx.textLayout.tlf_internal;
   import flash.display.Shape;
   import flashx.textLayout.container.ContainerController;
   import flash.display.DisplayObjectContainer;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class BackgroundManager
   {
       
      private var _textFlow:flashx.textLayout.elements.TextFlow;
      
      private var _lineDict:Dictionary;
      
      public function BackgroundManager()
      {
         super();
         this._lineDict = new Dictionary(true);
      }
      
      public function set textFlow(t:flashx.textLayout.elements.TextFlow) : void
      {
         this._textFlow = t;
      }
      
      public function get textFlow() : flashx.textLayout.elements.TextFlow
      {
         return this._textFlow;
      }
      
      public function addRect(line:TextFlowLine, fle:FlowLeafElement, r:Rectangle, color:uint, alpha:Number) : void
      {
         var tl:TextLine = line.getTextLine();
         if(this._lineDict[tl] == null)
         {
            this._lineDict[tl] = new Array();
         }
         var obj:Object = new Object();
         obj.rect = r;
         obj.fle = fle;
         obj.color = color;
         obj.alpha = alpha;
         var insert:Boolean = true;
         var fleAbsoluteStart:int = fle.getAbsoluteStart();
         for(var i:int = 0; i < this._lineDict[tl].length; i++)
         {
            if(this._lineDict[tl][i].fle.getAbsoluteStart() == fleAbsoluteStart)
            {
               this._lineDict[tl][i] = obj;
               insert = false;
            }
         }
         if(insert)
         {
            this._lineDict[tl].push(obj);
         }
      }
      
      public function finalizeLine(line:TextFlowLine) : void
      {
      }
      
      tlf_internal function get lineDict() : Dictionary
      {
         return this._lineDict;
      }
      
      public function drawAllRects(bgShape:Shape, controller:ContainerController) : void
      {
         var line:* = null;
         var a:Array = null;
         var columnRect:Rectangle = null;
         var r:Rectangle = null;
         var obj:Object = null;
         var i:int = 0;
         for(line in this._lineDict)
         {
            a = this._lineDict[line];
            if(a.length)
            {
               columnRect = a[0].columnRect;
               for(i = 0; i < a.length; i++)
               {
                  obj = a[i];
                  r = obj.rect;
                  r.x = r.x + line.x;
                  r.y = r.y + line.y;
                  TextFlowLine.constrainRectToColumn(this.textFlow,r,columnRect,0,0,controller.compositionWidth,controller.compositionHeight);
                  bgShape.graphics.beginFill(obj.color,obj.alpha);
                  bgShape.graphics.moveTo(r.left,r.top);
                  bgShape.graphics.lineTo(r.right,r.top);
                  bgShape.graphics.lineTo(r.right,r.bottom);
                  bgShape.graphics.lineTo(r.left,r.bottom);
                  bgShape.graphics.endFill();
               }
               continue;
            }
         }
      }
      
      public function removeLineFromCache(tl:TextLine) : void
      {
         delete this._lineDict[tl];
      }
      
      public function onUpdateComplete(controller:ContainerController) : void
      {
         var bgShape:Shape = null;
         var childIdx:int = 0;
         var tl:TextLine = null;
         var i:int = 0;
         var r:Rectangle = null;
         var tfl:TextFlowLine = null;
         var container:DisplayObjectContainer = controller.container as DisplayObjectContainer;
         if(Boolean(container) && Boolean(container.numChildren))
         {
            bgShape = controller.getBackgroundShape();
            bgShape.graphics.clear();
            for(childIdx = 0; childIdx < controller.textLines.length; childIdx++)
            {
               tl = controller.textLines[childIdx];
               if(this._lineDict[tl])
               {
                  if(this._lineDict[tl].length)
                  {
                     for(i = 0; i < this._lineDict[tl].length; i++)
                     {
                        r = this._lineDict[tl][i].rect.clone();
                        tfl = tl.userData as TextFlowLine;
                        if(tfl)
                        {
                           tfl.convertLineRectToContainer(r,true);
                        }
                        bgShape.graphics.beginFill(this._lineDict[tl][i].color,this._lineDict[tl][i].alpha);
                        bgShape.graphics.moveTo(r.left,r.top);
                        bgShape.graphics.lineTo(r.right,r.top);
                        bgShape.graphics.lineTo(r.right,r.bottom);
                        bgShape.graphics.lineTo(r.left,r.bottom);
                        bgShape.graphics.endFill();
                     }
                  }
               }
            }
         }
      }
   }
}
