package flashx.textLayout.edit
{
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.ContainerFormattedElement;
   import flashx.textLayout.elements.DivElement;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.elements.LinkElement;
   import flashx.textLayout.elements.SubParagraphGroupElement;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class TextFlowEdit
   {
      
      private static var processedFirstFlowElement:Boolean = false;
       
      public function TextFlowEdit()
      {
         super();
      }
      
      private static function deleteRange(theFlow:FlowGroupElement, startPos:int, endPos:int) : int
      {
         var curFlowElement:FlowElement = null;
         var s:SpanElement = null;
         var tempFlowElement:FlowElement = null;
         var numItems:int = 0;
         var blockDeleteNumElements:int = 0;
         var blockDeleteLength:int = 0;
         var skippingTerminator:Boolean = false;
         var curFlowElementIdx:int = 0;
         var needToMergeWhenDone:Boolean = false;
         var relStart:int = 0;
         var relEnd:int = 0;
         var processedAnElement:Boolean = false;
         var totalItemsDeleted:int = 0;
         var curNumDeleted:int = 0;
         var beginBlockDeleteIdx:int = -1;
         while(curFlowElementIdx < theFlow.numChildren)
         {
            curFlowElement = theFlow.getChildAt(curFlowElementIdx);
            relStart = startPos - curFlowElement.parentRelativeStart;
            if(relStart < 0)
            {
               relStart = 0;
            }
            relEnd = endPos - curFlowElement.parentRelativeStart;
            if(Boolean(relStart < curFlowElement.textLength) && Boolean(relEnd > 0))
            {
               if(Boolean(relStart <= 0) && (Boolean(relEnd > curFlowElement.textLength) || Boolean(relEnd >= curFlowElement.textLength) && Boolean(curFlowElement is ParagraphElement)))
               {
                  curNumDeleted = curFlowElement.textLength;
                  skippingTerminator = Boolean(curFlowElementIdx == theFlow.numChildren - 1) && Boolean(curFlowElement is SpanElement) && Boolean(theFlow is ParagraphElement);
                  if(skippingTerminator)
                  {
                     if(beginBlockDeleteIdx != -1)
                     {
                        theFlow.replaceChildren(beginBlockDeleteIdx,beginBlockDeleteIdx + blockDeleteNumElements);
                        curFlowElementIdx = curFlowElementIdx - blockDeleteNumElements;
                        totalItemsDeleted = totalItemsDeleted + blockDeleteLength;
                        endPos = endPos - blockDeleteLength;
                        beginBlockDeleteIdx = -1;
                     }
                     theFlow.replaceChildren(curFlowElementIdx,curFlowElementIdx + 1,null);
                     curFlowElementIdx++;
                     totalItemsDeleted = totalItemsDeleted + curNumDeleted;
                     endPos = endPos - curNumDeleted;
                  }
                  else
                  {
                     if(beginBlockDeleteIdx == -1)
                     {
                        beginBlockDeleteIdx = curFlowElementIdx;
                        blockDeleteNumElements = 0;
                        blockDeleteLength = 0;
                     }
                     blockDeleteNumElements++;
                     blockDeleteLength = blockDeleteLength + curNumDeleted;
                     curFlowElementIdx++;
                  }
               }
               else
               {
                  if(beginBlockDeleteIdx != -1)
                  {
                     theFlow.replaceChildren(beginBlockDeleteIdx,beginBlockDeleteIdx + blockDeleteNumElements);
                     curFlowElementIdx = curFlowElementIdx - blockDeleteNumElements;
                     totalItemsDeleted = totalItemsDeleted + blockDeleteLength;
                     endPos = endPos - blockDeleteLength;
                     beginBlockDeleteIdx = -1;
                  }
                  if(curFlowElement is SpanElement)
                  {
                     s = curFlowElement as SpanElement;
                     if(relEnd > s.textLength)
                     {
                        relEnd = s.textLength;
                     }
                     s.replaceText(relStart,relEnd,"");
                     curNumDeleted = relEnd - relStart;
                     totalItemsDeleted = totalItemsDeleted + curNumDeleted;
                     endPos = endPos - curNumDeleted;
                  }
                  else if(!(curFlowElement is FlowGroupElement))
                  {
                     curNumDeleted = curFlowElement.textLength;
                     totalItemsDeleted = totalItemsDeleted + curFlowElement.textLength;
                     endPos = endPos - curNumDeleted;
                     theFlow.replaceChildren(curFlowElementIdx,curFlowElementIdx + 1,null);
                  }
                  else
                  {
                     if(Boolean(!processedAnElement) && Boolean(relEnd >= curFlowElement.textLength))
                     {
                        if(curFlowElement is ParagraphElement)
                        {
                           needToMergeWhenDone = true;
                        }
                        else if(curFlowElement is FlowGroupElement)
                        {
                           numItems = (curFlowElement as FlowGroupElement).numChildren;
                           if(numItems > 0)
                           {
                              tempFlowElement = (curFlowElement as FlowGroupElement).getChildAt(numItems - 1);
                              if(tempFlowElement is ParagraphElement)
                              {
                                 needToMergeWhenDone = true;
                              }
                           }
                        }
                     }
                     curNumDeleted = TextFlowEdit.deleteRange(curFlowElement as FlowGroupElement,relStart,relEnd);
                     totalItemsDeleted = totalItemsDeleted + curNumDeleted;
                     endPos = endPos - curNumDeleted;
                     if(needToMergeWhenDone == true)
                     {
                        endPos++;
                     }
                     if(!(curFlowElement is ParagraphElement))
                     {
                        needToMergeWhenDone = false;
                     }
                  }
                  if(processedAnElement)
                  {
                     break;
                  }
                  curFlowElementIdx++;
               }
               processedAnElement = true;
            }
            else
            {
               if(processedAnElement)
               {
                  break;
               }
               curFlowElementIdx++;
            }
         }
         if(beginBlockDeleteIdx != -1)
         {
            theFlow.replaceChildren(beginBlockDeleteIdx,beginBlockDeleteIdx + blockDeleteNumElements);
            curFlowElementIdx = curFlowElementIdx - blockDeleteNumElements;
            totalItemsDeleted = totalItemsDeleted + blockDeleteLength;
            endPos = endPos - blockDeleteLength;
         }
         if(needToMergeWhenDone)
         {
            joinNextParagraph(ParagraphElement(curFlowElement.getPreviousSibling()));
         }
         return totalItemsDeleted;
      }
      
      private static function isFlowElementInArray(arr:Array, fl:FlowElement) : Boolean
      {
         var arrLen:int = 0;
         var currPos:int = 0;
         if(arr != null)
         {
            arrLen = arr.length;
            currPos = 0;
            while(currPos < arrLen)
            {
               if(arr[currPos] == fl)
               {
                  return true;
               }
               currPos++;
            }
         }
         return false;
      }
      
      private static function getContainer(flEl:FlowElement) : ContainerFormattedElement
      {
         while(!(flEl.parent is ContainerFormattedElement))
         {
            flEl = flEl.parent;
         }
         return flEl.parent as ContainerFormattedElement;
      }
      
      private static function isInsertableItem(flItem:FlowElement, missingBeginElements:Array, missingEndElements:Array) : Boolean
      {
         return Boolean(flItem is ParagraphElement) || Boolean(!TextFlowEdit.isFlowElementInArray(missingBeginElements,flItem)) && Boolean(!TextFlowEdit.isFlowElementInArray(missingEndElements,flItem));
      }
      
      private static function putDivAtEndOfContainer(container:ContainerFormattedElement) : DivElement
      {
         var tempDiv:DivElement = new DivElement();
         var tempPar:ParagraphElement = new ParagraphElement();
         tempPar.replaceChildren(0,0,new SpanElement());
         tempDiv.replaceChildren(0,0,tempPar);
         container.replaceChildren(container.numChildren,container.numChildren,tempDiv);
         return tempDiv;
      }
      
      private static function putDivAtEndOfContainerAndInsertTextFlow(theFlow:TextFlow, pos:int, insertedTextFlow:FlowGroupElement, missingBeginElements:Array, missingEndElements:Array, separatorArray:Array) : int
      {
         var tempFlChild:FlowElement = null;
         var elementIdx:int = 0;
         var nextInsertionPosition:int = pos;
         var insertContainer:ContainerFormattedElement = TextFlowEdit.getContainer(theFlow.findAbsoluteParagraph(nextInsertionPosition));
         var tempDiv:DivElement = TextFlowEdit.putDivAtEndOfContainer(insertContainer);
         separatorArray.push(tempDiv);
         var childArray:Array = insertedTextFlow.mxmlChildren;
         insertedTextFlow.replaceChildren(0,insertedTextFlow.numChildren);
         for each(tempFlChild in childArray)
         {
            nextInsertionPosition = TextFlowEdit.insertTextFlow(theFlow,nextInsertionPosition,tempFlChild as FlowGroupElement,missingBeginElements,missingEndElements,separatorArray);
         }
         elementIdx = tempDiv.parent.getChildIndex(tempDiv);
         tempDiv.parent.replaceChildren(elementIdx,elementIdx + 1,null);
         separatorArray.pop();
         return nextInsertionPosition;
      }
      
      private static function isContainerSeparator(fl:FlowElement, separatorArray:Array) : Boolean
      {
         var i:int = 0;
         var numItemsInArray:int = separatorArray.length;
         while(i < numItemsInArray)
         {
            if(separatorArray[i] == fl)
            {
               return true;
            }
            i++;
         }
         return false;
      }
      
      private static function insertTextFlow(theFlow:TextFlow, pos:int, insertedTextFlow:FlowGroupElement, missingBeginElementsInFlow:Array = null, missingEndElementsInFlow:Array = null, separatorArray:Array = null) : int
      {
         var tempFlChild:FlowElement = null;
         var tempDiv:DivElement = null;
         var leafEl:FlowLeafElement = null;
         var para:ParagraphElement = null;
         var paraSplitIndex:int = 0;
         var flowElIndex:int = 0;
         var okToMergeWithAfter:Boolean = false;
         var paragraphContainer:FlowGroupElement = null;
         var missingEnd:Boolean = false;
         var prevSibling:ParagraphElement = null;
         var absolutePar:ParagraphElement = null;
         var absoluteParIndex:int = 0;
         var nextInsertionPosition:int = pos;
         if(Boolean(!TextFlowEdit.isInsertableItem(insertedTextFlow,missingBeginElementsInFlow,missingEndElementsInFlow)) || Boolean(insertedTextFlow is TextFlow))
         {
            if(insertedTextFlow is TextFlow)
            {
               processedFirstFlowElement = false;
               tempDiv = TextFlowEdit.putDivAtEndOfContainer(theFlow as ContainerFormattedElement);
               separatorArray = new Array();
               separatorArray.push(tempDiv);
            }
            tempFlChild = insertedTextFlow.getChildAt(0);
            if(TextFlowEdit.isInsertableItem(tempFlChild,missingBeginElementsInFlow,missingEndElementsInFlow))
            {
               nextInsertionPosition = TextFlowEdit.putDivAtEndOfContainerAndInsertTextFlow(theFlow,nextInsertionPosition,insertedTextFlow,missingBeginElementsInFlow,missingEndElementsInFlow,separatorArray);
            }
            else
            {
               while(insertedTextFlow.numChildren > 0)
               {
                  tempFlChild = insertedTextFlow.getChildAt(0);
                  insertedTextFlow.replaceChildren(0,1,null);
                  nextInsertionPosition = TextFlowEdit.insertTextFlow(theFlow,nextInsertionPosition,tempFlChild as FlowGroupElement,missingBeginElementsInFlow,missingEndElementsInFlow,separatorArray);
               }
            }
            if(insertedTextFlow is TextFlow)
            {
               theFlow.replaceChildren(theFlow.numChildren - 1,theFlow.numChildren,null);
               if(nextInsertionPosition >= theFlow.textLength)
               {
                  nextInsertionPosition = theFlow.textLength - 1;
               }
               separatorArray.pop();
            }
         }
         else
         {
            leafEl = null;
            if(pos > 0)
            {
               leafEl = theFlow.findLeaf(pos - 1);
            }
            para = theFlow.findAbsoluteParagraph(pos);
            paraSplitIndex = pos - para.getAbsoluteStart();
            flowElIndex = para.parent.getChildIndex(para);
            okToMergeWithAfter = true;
            if(paraSplitIndex > 0)
            {
               if(paraSplitIndex < para.textLength - 1)
               {
                  para.splitAtPosition(paraSplitIndex);
               }
               else if(Boolean(insertedTextFlow.textLength == 1) && Boolean(!processedFirstFlowElement))
               {
                  if(Boolean(TextFlowEdit.isFlowElementInArray(missingEndElementsInFlow,insertedTextFlow)) || Boolean(TextFlowEdit.isFlowElementInArray(missingBeginElementsInFlow,insertedTextFlow)))
                  {
                     processedFirstFlowElement = true;
                     return nextInsertionPosition;
                  }
                  para.splitAtPosition(paraSplitIndex);
               }
               else
               {
                  okToMergeWithAfter = false;
               }
               pos++;
            }
            else
            {
               flowElIndex = flowElIndex - 1;
            }
            paragraphContainer = para.parent;
            if(TextFlowEdit.isContainerSeparator(paragraphContainer,separatorArray))
            {
               flowElIndex = paragraphContainer.parent.getChildIndex(paragraphContainer);
               paragraphContainer = paragraphContainer.parent;
               flowElIndex--;
            }
            paragraphContainer.replaceChildren(flowElIndex + 1,flowElIndex + 1,insertedTextFlow);
            nextInsertionPosition = pos + insertedTextFlow.textLength;
            if(insertedTextFlow is ParagraphElement)
            {
               missingEnd = TextFlowEdit.isFlowElementInArray(missingEndElementsInFlow,insertedTextFlow);
               if(Boolean(okToMergeWithAfter) && Boolean(missingEnd))
               {
                  if(paraSplitIndex == 0)
                  {
                     if(joinToNextParagraph(ParagraphElement(insertedTextFlow)))
                     {
                        nextInsertionPosition--;
                     }
                  }
                  else if(joinNextParagraph(ParagraphElement(insertedTextFlow)))
                  {
                     nextInsertionPosition--;
                  }
               }
               if(!processedFirstFlowElement)
               {
                  if(paraSplitIndex > 0)
                  {
                     prevSibling = insertedTextFlow.getPreviousSibling() as ParagraphElement;
                     if(Boolean(prevSibling) && Boolean(joinNextParagraph(prevSibling)))
                     {
                        nextInsertionPosition--;
                     }
                  }
               }
               if(missingEnd)
               {
                  absolutePar = paragraphContainer.getTextFlow().findAbsoluteParagraph(nextInsertionPosition);
                  absoluteParIndex = absolutePar.getAbsoluteStart();
                  if(nextInsertionPosition - absolutePar.getAbsoluteStart() == 0)
                  {
                     nextInsertionPosition--;
                  }
               }
            }
            processedFirstFlowElement = true;
         }
         return nextInsertionPosition;
      }
      
      public static function replaceRange(theFlow:TextFlow, startPos:int, endPos:int, textScrap:TextScrap = null) : int
      {
         var nextInsertPosition:int = startPos;
         if(endPos > startPos)
         {
            deleteRange(theFlow,startPos,endPos);
         }
         if(textScrap != null)
         {
            textScrap = textScrap.clone();
            nextInsertPosition = insertTextFlow(theFlow,startPos,textScrap.textFlow,textScrap.beginMissingArray,textScrap.endMissingArray);
         }
         return nextInsertPosition;
      }
      
      public static function createTextScrap(theFlow:TextFlow, startPos:int, endPos:int) : TextScrap
      {
         var fl:FlowElement = null;
         var srcElem:FlowElement = null;
         var copyElem:FlowElement = null;
         if(Boolean(!theFlow) || Boolean(startPos >= endPos))
         {
            return null;
         }
         var newTextFlow:TextFlow = theFlow.deepCopy(startPos,endPos) as TextFlow;
         newTextFlow.normalize();
         var retTextScrap:TextScrap = new TextScrap(newTextFlow);
         if(newTextFlow.textLength > 0)
         {
            fl = newTextFlow.getLastLeaf();
            srcElem = theFlow.findLeaf(startPos);
            copyElem = newTextFlow.getFirstLeaf();
            while(Boolean(copyElem) && Boolean(srcElem))
            {
               if(startPos - srcElem.getAbsoluteStart() > 0)
               {
                  retTextScrap.addToBeginMissing(copyElem);
               }
               copyElem = copyElem.parent;
               srcElem = srcElem.parent;
            }
            srcElem = theFlow.findLeaf(endPos - 1);
            copyElem = newTextFlow.getLastLeaf();
            if(Boolean(copyElem is SpanElement) && Boolean(!(srcElem is SpanElement)))
            {
               copyElem = newTextFlow.findLeaf(newTextFlow.textLength - 2);
            }
            while(Boolean(copyElem) && Boolean(srcElem))
            {
               if(endPos < srcElem.getAbsoluteStart() + srcElem.textLength)
               {
                  retTextScrap.addToEndMissing(copyElem);
               }
               copyElem = copyElem.parent;
               srcElem = srcElem.parent;
            }
            return retTextScrap;
         }
         return null;
      }
      
      public static function makeTCY(theFlow:TextFlow, startPos:int, endPos:int) : Boolean
      {
         var paraEnd:int = 0;
         var curEndPos:int = 0;
         var new_tcyElem:TCYElement = null;
         var madeTCY:Boolean = true;
         var curPara:ParagraphElement = theFlow.findAbsoluteParagraph(startPos);
         if(!curPara)
         {
            return false;
         }
         while(curPara)
         {
            paraEnd = curPara.getAbsoluteStart() + curPara.textLength;
            curEndPos = Math.min(paraEnd,endPos);
            if(Boolean(canInsertSPBlock(theFlow,startPos,curEndPos,TCYElement)) && Boolean(curPara.textLength > 1))
            {
               new_tcyElem = new TCYElement();
               if(madeTCY)
               {
                  madeTCY = insertNewSPBlock(theFlow,startPos,curEndPos,new_tcyElem,TCYElement);
               }
               else
               {
                  insertNewSPBlock(theFlow,startPos,curEndPos,new_tcyElem,TCYElement);
               }
            }
            else
            {
               madeTCY = false;
            }
            if(paraEnd < endPos)
            {
               curPara = theFlow.findAbsoluteParagraph(curEndPos);
               startPos = curEndPos;
            }
            else
            {
               curPara = null;
            }
         }
         return madeTCY;
      }
      
      public static function makeLink(theFlow:TextFlow, startPos:int, endPos:int, urlString:String, target:String) : Boolean
      {
         var paraEnd:int = 0;
         var curEndPos:int = 0;
         var linkEndPos:int = 0;
         var newLinkElement:LinkElement = null;
         var madeLink:Boolean = true;
         var curPara:ParagraphElement = theFlow.findAbsoluteParagraph(startPos);
         if(!curPara)
         {
            return false;
         }
         while(curPara)
         {
            paraEnd = curPara.getAbsoluteStart() + curPara.textLength;
            curEndPos = Math.min(paraEnd,endPos);
            linkEndPos = curEndPos == paraEnd?int(curEndPos - 1):int(curEndPos);
            if(linkEndPos > startPos)
            {
               if(!canInsertSPBlock(theFlow,startPos,linkEndPos,LinkElement))
               {
                  return false;
               }
               newLinkElement = new LinkElement();
               newLinkElement.href = urlString;
               newLinkElement.target = target;
               if(madeLink)
               {
                  madeLink = insertNewSPBlock(theFlow,startPos,linkEndPos,newLinkElement,LinkElement);
               }
               else
               {
                  insertNewSPBlock(theFlow,startPos,linkEndPos,newLinkElement,LinkElement);
               }
            }
            if(paraEnd < endPos)
            {
               curPara = theFlow.findAbsoluteParagraph(curEndPos);
               startPos = curEndPos;
            }
            else
            {
               curPara = null;
            }
         }
         return madeLink;
      }
      
      public static function removeTCY(theFlow:TextFlow, startPos:int, endPos:int) : Boolean
      {
         if(endPos <= startPos)
         {
            return false;
         }
         return findAndRemoveFlowGroupElement(theFlow,startPos,endPos,TCYElement);
      }
      
      public static function removeLink(theFlow:TextFlow, startPos:int, endPos:int) : Boolean
      {
         if(endPos <= startPos)
         {
            return false;
         }
         return findAndRemoveFlowGroupElement(theFlow,startPos,endPos,LinkElement);
      }
      
      tlf_internal static function insertNewSPBlock(theFlow:TextFlow, startPos:int, endPos:int, newSPB:SubParagraphGroupElement, spgClass:Class) : Boolean
      {
         var curPos:int = startPos;
         var curFBE:FlowGroupElement = theFlow.findAbsoluteFlowGroupElement(curPos);
         var elementIdx:int = 0;
         var paraEl:ParagraphElement = curFBE.getParagraph();
         if(endPos == paraEl.getAbsoluteStart() + paraEl.textLength - 1)
         {
            endPos++;
         }
         var parentStart:int = curFBE.parent.getAbsoluteStart();
         var curFBEStart:int = curFBE.getAbsoluteStart();
         if(Boolean(curFBE.parent) && Boolean(curFBE.parent is spgClass) && Boolean(!(Boolean(parentStart == curFBEStart) && Boolean(parentStart + curFBE.parent.textLength == curFBEStart + curFBE.textLength))))
         {
            return false;
         }
         if(Boolean(!(curFBE is ParagraphElement)) && Boolean(curPos == curFBEStart) && Boolean(curPos + curFBE.textLength <= endPos))
         {
            elementIdx = curFBE.parent.getChildIndex(curFBE);
            curFBE = curFBE.parent;
         }
         if(curPos >= curFBEStart)
         {
            if(!(curFBE is spgClass))
            {
               elementIdx = findAndSplitElement(curFBE,elementIdx,curPos,true);
            }
            else
            {
               elementIdx = findAndSplitElement(curFBE.parent,curFBE.parent.getChildIndex(curFBE),curPos,false);
               curFBE = curFBE.parent;
            }
         }
         if(curFBE is spgClass)
         {
            curFBEStart = curFBE.getAbsoluteStart();
            elementIdx = curFBE.parent.getChildIndex(curFBE);
            if(curPos > curFBEStart)
            {
               elementIdx = elementIdx + 1;
            }
            while(endPos >= curFBEStart + curFBE.textLength)
            {
               curFBE = curFBE.parent;
            }
            curFBE.replaceChildren(elementIdx,elementIdx,newSPB);
         }
         else
         {
            curFBE.replaceChildren(elementIdx,elementIdx,newSPB);
         }
         subsumeElementsToSPBlock(curFBE,elementIdx + 1,curPos,endPos,newSPB,spgClass);
         return true;
      }
      
      tlf_internal static function splitElement(elem:FlowElement, splitPos:int, splitSubBlockContents:Boolean) : void
      {
         var subBlock:SubParagraphGroupElement = null;
         var tempElem:SpanElement = null;
         if(elem is SpanElement)
         {
            SpanElement(elem).splitAtPosition(splitPos);
         }
         else if(Boolean(elem is SubParagraphGroupElement) && Boolean(splitSubBlockContents))
         {
            subBlock = SubParagraphGroupElement(elem);
            tempElem = subBlock.findLeaf(splitPos) as SpanElement;
            if(tempElem)
            {
               tempElem.splitAtPosition(splitPos - tempElem.getElementRelativeStart(subBlock));
            }
         }
         else if(elem is FlowGroupElement)
         {
            FlowGroupElement(elem).splitAtPosition(splitPos);
         }
      }
      
      tlf_internal static function findAndSplitElement(fbe:FlowGroupElement, elementIdx:int, startIdx:int, splitSubBlockContents:Boolean) : int
      {
         var curFlowEl:FlowElement = null;
         var curIndexInPar:int = startIdx - fbe.getAbsoluteStart();
         while(elementIdx < fbe.numChildren)
         {
            curFlowEl = fbe.getChildAt(elementIdx);
            if(curIndexInPar == curFlowEl.parentRelativeStart)
            {
               return elementIdx;
            }
            if(Boolean(curIndexInPar > curFlowEl.parentRelativeStart) && Boolean(curIndexInPar < curFlowEl.parentRelativeEnd))
            {
               splitElement(curFlowEl,curIndexInPar - curFlowEl.parentRelativeStart,splitSubBlockContents);
            }
            elementIdx++;
         }
         return elementIdx;
      }
      
      tlf_internal static function subsumeElementsToSPBlock(parentFBE:FlowGroupElement, elementIdx:int, curPos:int, endPos:int, newSPB:SubParagraphGroupElement, spgClass:Class) : int
      {
         var subBlock:SubParagraphGroupElement = null;
         var fe:FlowElement = null;
         var childSPGE:SubParagraphGroupElement = null;
         var myIdx:int = 0;
         var tempFE:FlowElement = null;
         var curFlowEl:FlowElement = null;
         if(elementIdx >= parentFBE.numChildren)
         {
            return curPos;
         }
         while(curPos < endPos)
         {
            curFlowEl = parentFBE.getChildAt(elementIdx);
            if(curPos + curFlowEl.textLength > endPos)
            {
               splitElement(curFlowEl,endPos - curFlowEl.getAbsoluteStart(),!(curFlowEl is spgClass));
            }
            curPos = curPos + curFlowEl.textLength;
            parentFBE.replaceChildren(elementIdx,elementIdx + 1,null);
            if(curFlowEl is spgClass)
            {
               subBlock = curFlowEl as SubParagraphGroupElement;
               while(subBlock.numChildren > 0)
               {
                  fe = subBlock.getChildAt(0);
                  subBlock.replaceChildren(0,1,null);
                  newSPB.replaceChildren(newSPB.numChildren,newSPB.numChildren,fe);
               }
            }
            else
            {
               if(curFlowEl is SubParagraphGroupElement)
               {
                  flushSPBlock(curFlowEl as SubParagraphGroupElement,spgClass);
               }
               newSPB.replaceChildren(newSPB.numChildren,newSPB.numChildren,curFlowEl);
               if(Boolean(newSPB.numChildren == 1) && Boolean(curFlowEl is SubParagraphGroupElement))
               {
                  childSPGE = curFlowEl as SubParagraphGroupElement;
                  if(Boolean(childSPGE.textLength == newSPB.textLength) && Boolean(curPos >= endPos))
                  {
                     if(childSPGE.precedence > newSPB.precedence)
                     {
                        newSPB.replaceChildren(0,1,null);
                        while(childSPGE.numChildren > 0)
                        {
                           tempFE = childSPGE.getChildAt(0);
                           childSPGE.replaceChildren(0,1,null);
                           newSPB.replaceChildren(newSPB.numChildren,newSPB.numChildren,tempFE);
                        }
                        myIdx = newSPB.parent.getChildIndex(newSPB);
                        newSPB.parent.replaceChildren(myIdx,myIdx + 1,childSPGE);
                        childSPGE.replaceChildren(0,0,newSPB);
                     }
                  }
               }
            }
         }
         return curPos;
      }
      
      tlf_internal static function findAndRemoveFlowGroupElement(theFlow:TextFlow, startPos:int, endPos:int, fbeClass:Class) : Boolean
      {
         var curEl:FlowElement = null;
         var containerFBE:FlowGroupElement = null;
         var ancestorOfFBE:FlowGroupElement = null;
         var containerFBEStart:int = 0;
         var childIdx:int = 0;
         var curFBE:FlowGroupElement = null;
         var parentBlock:FlowGroupElement = null;
         var idxInParent:int = 0;
         var childFE:FlowElement = null;
         var curSPB:SubParagraphGroupElement = null;
         var curPos:int = startPos;
         while(curPos < endPos)
         {
            containerFBE = theFlow.findAbsoluteFlowGroupElement(curPos);
            while(Boolean(containerFBE.parent) && Boolean(containerFBE.parent.getAbsoluteStart() == containerFBE.getAbsoluteStart()) && Boolean(!(containerFBE.parent is ParagraphElement)))
            {
               containerFBE = containerFBE.parent;
            }
            if(containerFBE is fbeClass)
            {
               containerFBE = containerFBE.parent;
            }
            ancestorOfFBE = containerFBE.parent;
            while(Boolean(ancestorOfFBE != null) && Boolean(!(ancestorOfFBE is fbeClass)))
            {
               if(ancestorOfFBE.parent is fbeClass)
               {
                  return false;
               }
               ancestorOfFBE = ancestorOfFBE.parent;
            }
            containerFBEStart = containerFBE.getAbsoluteStart();
            if(Boolean(ancestorOfFBE is fbeClass) && (Boolean(containerFBEStart >= curPos) && Boolean(containerFBEStart + containerFBE.textLength <= endPos)))
            {
               containerFBE = ancestorOfFBE.parent;
            }
            childIdx = containerFBE.findChildIndexAtPosition(curPos - containerFBEStart);
            curEl = containerFBE.getChildAt(childIdx);
            if(curEl is fbeClass)
            {
               curFBE = curEl as FlowGroupElement;
               parentBlock = curFBE.parent;
               idxInParent = parentBlock.getChildIndex(curFBE);
               if(curPos > curFBE.getAbsoluteStart())
               {
                  splitElement(curFBE,curPos - curFBE.getAbsoluteStart(),false);
                  curPos = curFBE.getAbsoluteStart() + curFBE.textLength;
               }
               else
               {
                  if(curFBE.getAbsoluteStart() + curFBE.textLength > endPos)
                  {
                     splitElement(curFBE,endPos - curFBE.getAbsoluteStart(),false);
                  }
                  curPos = curFBE.getAbsoluteStart() + curFBE.textLength;
                  while(curFBE.numChildren > 0)
                  {
                     childFE = curFBE.getChildAt(0);
                     curFBE.replaceChildren(0,1,null);
                     parentBlock.replaceChildren(idxInParent,idxInParent,childFE);
                     idxInParent++;
                  }
                  parentBlock.replaceChildren(idxInParent,idxInParent + 1,null);
               }
            }
            else if(curEl is SubParagraphGroupElement)
            {
               curSPB = SubParagraphGroupElement(curEl);
               if(curSPB.numChildren == 1)
               {
                  curPos = curSPB.getAbsoluteStart() + curSPB.textLength;
               }
               else
               {
                  curEl = curSPB.getChildAt(curSPB.findChildIndexAtPosition(curPos - curSPB.getAbsoluteStart()));
                  curPos = curEl.getAbsoluteStart() + curEl.textLength;
               }
            }
            else
            {
               curPos = curEl.getAbsoluteStart() + curEl.textLength;
            }
         }
         return true;
      }
      
      tlf_internal static function canInsertSPBlock(theFlow:TextFlow, startPos:int, endPos:int, blockClass:Class) : Boolean
      {
         var anchorStart:int = 0;
         var tailStart:int = 0;
         if(endPos <= startPos)
         {
            return false;
         }
         var anchorFBE:FlowGroupElement = theFlow.findAbsoluteFlowGroupElement(startPos);
         if(anchorFBE.getParentByType(blockClass))
         {
            anchorFBE = anchorFBE.getParentByType(blockClass) as FlowGroupElement;
         }
         var tailFBE:FlowGroupElement = theFlow.findAbsoluteFlowGroupElement(endPos - 1);
         if(tailFBE.getParentByType(blockClass))
         {
            tailFBE = tailFBE.getParentByType(blockClass) as FlowGroupElement;
         }
         if(anchorFBE == tailFBE)
         {
            return true;
         }
         if(anchorFBE.getParagraph() != tailFBE.getParagraph())
         {
            return false;
         }
         if(Boolean(anchorFBE is blockClass) && Boolean(tailFBE is blockClass))
         {
            return true;
         }
         if(Boolean(anchorFBE is SubParagraphGroupElement) && Boolean(!(anchorFBE is blockClass)))
         {
            anchorStart = anchorFBE.getAbsoluteStart();
            if(Boolean(startPos > anchorStart) && Boolean(endPos > anchorStart + anchorFBE.textLength))
            {
               return false;
            }
         }
         else if((Boolean(anchorFBE.parent is SubParagraphGroupElement) || Boolean(tailFBE.parent is SubParagraphGroupElement)) && Boolean(anchorFBE.parent != tailFBE.parent))
         {
            return false;
         }
         if(Boolean(tailFBE is SubParagraphGroupElement) && Boolean(!(tailFBE is blockClass)) && Boolean(endPos > tailFBE.getAbsoluteStart()))
         {
            tailStart = tailFBE.getAbsoluteStart();
            if(Boolean(startPos < tailStart) && Boolean(endPos < tailStart + tailFBE.textLength))
            {
               return false;
            }
         }
         return true;
      }
      
      tlf_internal static function flushSPBlock(subPB:SubParagraphGroupElement, spgClass:Class) : void
      {
         var subFE:FlowElement = null;
         var subChildFBE:FlowGroupElement = null;
         var subFEChild:FlowElement = null;
         var subParaIter:int = 0;
         while(subParaIter < subPB.numChildren)
         {
            subFE = subPB.getChildAt(subParaIter);
            if(subFE is spgClass)
            {
               subChildFBE = subFE as FlowGroupElement;
               while(subChildFBE.numChildren > 0)
               {
                  subFEChild = subChildFBE.getChildAt(0);
                  subChildFBE.replaceChildren(0,1,null);
                  subPB.replaceChildren(subParaIter,subParaIter,subFEChild);
               }
               subParaIter++;
               subPB.replaceChildren(subParaIter,subParaIter + 1,null);
            }
            else if(subFE is SubParagraphGroupElement)
            {
               flushSPBlock(subFE as SubParagraphGroupElement,spgClass);
               subParaIter++;
            }
            else
            {
               subParaIter++;
            }
         }
      }
      
      public static function joinNextParagraph(para:ParagraphElement) : Boolean
      {
         var myidx:int = 0;
         var sibParagraph:ParagraphElement = null;
         var curFlowElement:FlowElement = null;
         if(Boolean(para) && Boolean(para.parent))
         {
            myidx = para.parent.getChildIndex(para);
            if(myidx != para.parent.numChildren - 1)
            {
               sibParagraph = para.parent.getChildAt(myidx + 1) as ParagraphElement;
               if(sibParagraph)
               {
                  while(sibParagraph.numChildren > 0)
                  {
                     curFlowElement = sibParagraph.getChildAt(0);
                     sibParagraph.replaceChildren(0,1,null);
                     para.replaceChildren(para.numChildren,para.numChildren,curFlowElement);
                  }
                  para.parent.replaceChildren(myidx + 1,myidx + 2,null);
                  return true;
               }
            }
         }
         return false;
      }
      
      public static function joinToNextParagraph(para:ParagraphElement) : Boolean
      {
         var myidx:int = 0;
         var sibParagraph:ParagraphElement = null;
         var addAtIndex:int = 0;
         var curFlowElement:FlowElement = null;
         if(Boolean(para) && Boolean(para.parent))
         {
            myidx = para.parent.getChildIndex(para);
            if(myidx != para.parent.numChildren - 1)
            {
               sibParagraph = para.parent.getChildAt(myidx + 1) as ParagraphElement;
               if(sibParagraph)
               {
                  addAtIndex = 0;
                  while(para.numChildren > 0)
                  {
                     curFlowElement = para.getChildAt(0);
                     para.replaceChildren(0,1,null);
                     sibParagraph.replaceChildren(addAtIndex,addAtIndex,curFlowElement);
                     addAtIndex++;
                  }
                  para.parent.replaceChildren(myidx,myidx + 1,null);
                  return true;
               }
            }
         }
         return false;
      }
   }
}
