package flashx.textLayout.edit
{
   import flashx.textLayout.tlf_internal;
   import flash.desktop.Clipboard;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.conversion.TextConverter;
   import flash.desktop.ClipboardFormats;
   import flashx.textLayout.conversion.ITextExporter;
   import flashx.textLayout.conversion.ConversionType;
   import flashx.textLayout.conversion.PlainTextExporter;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.elements.FlowGroupElement;
   
   use namespace tlf_internal;
   
   public class TextClipboard
   {
      
      tlf_internal static const TEXT_LAYOUT_MARKUP:String = "TEXT_LAYOUT_MARKUP";
       
      public function TextClipboard()
      {
         super();
      }
      
      tlf_internal static function getTextOnClipboardForFormat(format:String) : String
      {
         var systemClipboard:Clipboard = Clipboard.generalClipboard;
         return !!systemClipboard.hasFormat(format)?String(systemClipboard.getData(format)):null;
      }
      
      public static function getContents() : TextScrap
      {
         var textFlow:TextFlow = null;
         var textOnClipboard:String = null;
         var originalSettings:Object = null;
         var xmlTree:XML = null;
         var beginArrayChild:XML = null;
         var endArrayChild:XML = null;
         var textLayoutMarkup:XML = null;
         var firstLeaf:FlowLeafElement = null;
         var lastLeaf:FlowLeafElement = null;
         var retTextScrap:TextScrap = null;
         textOnClipboard = getTextOnClipboardForFormat(TEXT_LAYOUT_MARKUP);
         if(Boolean(textOnClipboard != null) && Boolean(textOnClipboard != ""))
         {
            originalSettings = XML.settings();
            try
            {
               XML.ignoreProcessingInstructions = false;
               XML.ignoreWhitespace = false;
               xmlTree = new XML(textOnClipboard);
               beginArrayChild = xmlTree..BeginMissingElements[0];
               endArrayChild = xmlTree..EndMissingElements[0];
               textLayoutMarkup = xmlTree..TextFlow[0];
               textFlow = TextConverter.importToFlow(textLayoutMarkup,TextConverter.TEXT_LAYOUT_FORMAT);
               if(textFlow != null)
               {
                  retTextScrap = new TextScrap(textFlow);
                  retTextScrap.beginMissingArray = getBeginArray(beginArrayChild,textFlow);
                  retTextScrap.endMissingArray = getEndArray(endArrayChild,textFlow);
               }
            }
            finally
            {
               XML.setSettings(originalSettings);
            }
         }
         if(retTextScrap == null)
         {
            textOnClipboard = getTextOnClipboardForFormat(ClipboardFormats.TEXT_FORMAT);
            if(Boolean(textOnClipboard != null) && Boolean(textOnClipboard != ""))
            {
               textFlow = TextConverter.importToFlow(textOnClipboard,TextConverter.PLAIN_TEXT_FORMAT);
               if(textFlow)
               {
                  retTextScrap = new TextScrap(textFlow);
                  firstLeaf = textFlow.getFirstLeaf();
                  if(firstLeaf)
                  {
                     retTextScrap.beginMissingArray.push(firstLeaf);
                     retTextScrap.beginMissingArray.push(firstLeaf.parent);
                     retTextScrap.beginMissingArray.push(textFlow);
                     lastLeaf = textFlow.getLastLeaf();
                     retTextScrap.endMissingArray.push(lastLeaf);
                     retTextScrap.endMissingArray.push(lastLeaf.parent);
                     retTextScrap.endMissingArray.push(textFlow);
                  }
               }
            }
         }
         return retTextScrap;
      }
      
      tlf_internal static function createTextFlowExportString(scrap:TextScrap) : String
      {
         var originalSettings:Object = null;
         var exporter:ITextExporter = null;
         var result:String = null;
         var xmlExport:XML = null;
         var textFlowExportString:String = "";
         originalSettings = XML.settings();
         try
         {
            XML.ignoreProcessingInstructions = false;
            XML.ignoreWhitespace = false;
            XML.prettyPrinting = false;
            exporter = TextConverter.getExporter(TextConverter.TEXT_LAYOUT_FORMAT);
            result = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            result = result + "<TextScrap>\n";
            result = result + getPartialElementString(scrap);
            xmlExport = exporter.export(scrap.textFlow,ConversionType.XML_TYPE) as XML;
            result = result + xmlExport;
            result = result + "</TextScrap>\n";
            textFlowExportString = result.toString();
            XML.setSettings(originalSettings);
         }
         catch(e:Error)
         {
            XML.setSettings(originalSettings);
         }
         return textFlowExportString;
      }
      
      tlf_internal static function createPlainTextExportString(scrap:TextScrap) : String
      {
         var plainTextExporter:PlainTextExporter = new PlainTextExporter();
         var plainTextExportString:String = plainTextExporter.export(scrap.textFlow,ConversionType.STRING_TYPE) as String;
         var lastPara:ParagraphElement = scrap.textFlow.getLastLeaf().getParagraph();
         if(!scrap.isEndMissing(lastPara))
         {
            plainTextExportString = plainTextExportString + plainTextExporter.paragraphSeparator;
         }
         return plainTextExportString;
      }
      
      tlf_internal static function setClipboardContents(textFlowExportString:String, plainTextExportString:String) : void
      {
         var systemClipboard:Clipboard = Clipboard.generalClipboard;
         systemClipboard.clear();
         systemClipboard.setData(TEXT_LAYOUT_MARKUP,textFlowExportString);
         systemClipboard.setData(ClipboardFormats.TEXT_FORMAT,plainTextExportString);
      }
      
      public static function setContents(scrap:TextScrap) : void
      {
         if(scrap == null)
         {
            return;
         }
         var textFlowExportString:String = createTextFlowExportString(scrap);
         var plainTextExportString:String = createPlainTextExportString(scrap);
         setClipboardContents(textFlowExportString,plainTextExportString);
      }
      
      private static function getPartialElementString(scrap:TextScrap) : String
      {
         var curFlElement:FlowElement = null;
         var curFlElementIndex:int = 0;
         var beginMissingArray:Array = scrap.beginMissingArray;
         var endMissingArray:Array = scrap.endMissingArray;
         var beginMissingString:String = "";
         var endMissingString:String = "";
         var resultString:String = "";
         var curPos:int = beginMissingArray.length - 2;
         if(beginMissingArray.length > 0)
         {
            beginMissingString = "0";
            while(curPos >= 0)
            {
               curFlElement = beginMissingArray[curPos];
               curFlElementIndex = curFlElement.parent.getChildIndex(curFlElement);
               beginMissingString = beginMissingString + "," + curFlElementIndex;
               curPos--;
            }
         }
         curPos = endMissingArray.length - 2;
         if(endMissingArray.length > 0)
         {
            endMissingString = "0";
            while(curPos >= 0)
            {
               curFlElement = endMissingArray[curPos];
               curFlElementIndex = curFlElement.parent.getChildIndex(curFlElement);
               endMissingString = endMissingString + "," + curFlElementIndex;
               curPos--;
            }
         }
         if(beginMissingString != "")
         {
            resultString = "<BeginMissingElements value=\"";
            resultString = resultString + beginMissingString;
            resultString = resultString + "\"";
            resultString = resultString + "/>\n";
         }
         if(endMissingString != "")
         {
            resultString = resultString + "<EndMissingElements value=\"";
            resultString = resultString + endMissingString;
            resultString = resultString + "\"";
            resultString = resultString + "/>\n";
         }
         return resultString;
      }
      
      private static function getBeginArray(beginArrayChild:XML, textFlow:TextFlow) : Array
      {
         var value:String = null;
         var posOfComma:int = 0;
         var startPos:int = 0;
         var endPos:int = 0;
         var curStr:String = null;
         var indexIntoFlowElement:int = 0;
         var beginArray:Array = new Array();
         var curFlElement:FlowElement = textFlow;
         if(beginArrayChild != null)
         {
            value = beginArrayChild.@value != undefined?String(beginArrayChild.@value):"";
            beginArray.push(textFlow);
            posOfComma = value.indexOf(",");
            while(posOfComma >= 0)
            {
               startPos = posOfComma + 1;
               posOfComma = value.indexOf(",",startPos);
               if(posOfComma >= 0)
               {
                  endPos = posOfComma;
               }
               else
               {
                  endPos = value.length;
               }
               curStr = value.substring(startPos,endPos);
               if(curStr.length > 0)
               {
                  indexIntoFlowElement = parseInt(curStr);
                  if(curFlElement is FlowGroupElement)
                  {
                     curFlElement = (curFlElement as FlowGroupElement).getChildAt(indexIntoFlowElement);
                     beginArray.push(curFlElement);
                  }
               }
            }
         }
         return beginArray.reverse();
      }
      
      private static function getEndArray(endArrayChild:XML, textFlow:TextFlow) : Array
      {
         var value:String = null;
         var posOfComma:int = 0;
         var startPos:int = 0;
         var endPos:int = 0;
         var curStr:String = null;
         var indexIntoFlowElement:int = 0;
         var endArray:Array = new Array();
         var curFlElement:FlowElement = textFlow;
         if(endArrayChild != null)
         {
            value = endArrayChild.@value != undefined?String(endArrayChild.@value):"";
            endArray.push(textFlow);
            posOfComma = value.indexOf(",");
            while(posOfComma >= 0)
            {
               startPos = posOfComma + 1;
               posOfComma = value.indexOf(",",startPos);
               if(posOfComma >= 0)
               {
                  endPos = posOfComma;
               }
               else
               {
                  endPos = value.length;
               }
               curStr = value.substring(startPos,endPos);
               if(curStr.length > 0)
               {
                  indexIntoFlowElement = parseInt(curStr);
                  if(curFlElement is FlowGroupElement)
                  {
                     curFlElement = (curFlElement as FlowGroupElement).getChildAt(indexIntoFlowElement);
                     endArray.push(curFlElement);
                  }
               }
            }
         }
         return endArray.reverse();
      }
   }
}

class TextClipboardSingletonEnforcer
{
    
   function TextClipboardSingletonEnforcer()
   {
      super();
   }
}
