package flashx.textLayout.edit
{
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.elements.SubParagraphGroupElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.formats.Float;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.container.ContainerController;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class ParaEdit
   {
       
      public function ParaEdit()
      {
         super();
      }
      
      public static function insertText(para:ParagraphElement, elem:FlowLeafElement, paraSelBegIdx:int, insertText:String, forceIntoLeafGiven:Boolean = false) : void
      {
         var runInsertionPoint:int = 0;
         var subParInsertionPoint:int = 0;
         var newSpan:SpanElement = null;
         var insertIdx:int = 0;
         var paraRelativeStart:int = 0;
         if(insertText.length == 0)
         {
            return;
         }
         var createNewSpan:Boolean = false;
         var insertParent:FlowGroupElement = elem.parent;
         var curSPGElement:SubParagraphGroupElement = elem.getParentByType(SubParagraphGroupElement) as SubParagraphGroupElement;
         while(curSPGElement != null)
         {
            subParInsertionPoint = paraSelBegIdx - curSPGElement.getElementRelativeStart(para);
            if(Boolean(subParInsertionPoint == 0) && Boolean(!curSPGElement.acceptTextBefore()) || Boolean(!curSPGElement.acceptTextAfter()) && (Boolean(subParInsertionPoint == curSPGElement.textLength) || Boolean(subParInsertionPoint == curSPGElement.textLength - 1) && Boolean(elem == para.getLastLeaf())))
            {
               createNewSpan = !forceIntoLeafGiven;
               insertParent = insertParent.parent;
               curSPGElement = curSPGElement.getParentByType(SubParagraphGroupElement) as SubParagraphGroupElement;
               continue;
            }
            break;
         }
         if(Boolean(!(elem is SpanElement)) || Boolean(createNewSpan == true))
         {
            paraRelativeStart = elem.getElementRelativeStart(para);
            if(paraRelativeStart == paraSelBegIdx)
            {
               elem = elem.getPreviousLeaf(para);
               if(!(elem is SpanElement))
               {
                  newSpan = new SpanElement();
                  if(elem)
                  {
                     newSpan.format = elem.format;
                     insertIdx = insertParent.getChildIndex(elem) + 1;
                  }
                  else
                  {
                     newSpan.format = para.getFirstLeaf().format;
                     insertIdx = 0;
                  }
                  insertParent.replaceChildren(insertIdx,insertIdx,newSpan);
                  elem = newSpan;
               }
            }
            else
            {
               newSpan = new SpanElement();
               newSpan.format = elem.format;
               if(elem.parent == insertParent)
               {
                  insertIdx = insertParent.getChildIndex(elem) + 1;
               }
               else
               {
                  insertIdx = insertParent.getChildIndex(elem.parent) + 1;
               }
               insertParent.replaceChildren(insertIdx,insertIdx,newSpan);
               elem = newSpan;
            }
         }
         var curSpan:SpanElement = elem as SpanElement;
         runInsertionPoint = paraSelBegIdx - curSpan.getElementRelativeStart(para);
         curSpan.replaceText(runInsertionPoint,runInsertionPoint,insertText);
      }
      
      private static function deleteTextInternal(para:ParagraphElement, paraSelBegIdx:int, totalToDelete:int) : void
      {
         var composeNode:FlowElement = null;
         var curSpan:SpanElement = null;
         var curNumToDelete:int = 0;
         var curSpanRelativeStart:int = 0;
         var delIdx:int = 0;
         var curSpanDeletePos:int = 0;
         while(totalToDelete > 0)
         {
            composeNode = para.findLeaf(paraSelBegIdx);
            curSpan = composeNode as SpanElement;
            curSpanRelativeStart = curSpan.getElementRelativeStart(para);
            curSpanDeletePos = paraSelBegIdx - curSpanRelativeStart;
            if(paraSelBegIdx > curSpanRelativeStart + curSpan.textLength)
            {
               curNumToDelete = curSpan.textLength;
            }
            else
            {
               curNumToDelete = curSpanRelativeStart + curSpan.textLength - paraSelBegIdx;
            }
            if(totalToDelete < curNumToDelete)
            {
               curNumToDelete = totalToDelete;
            }
            curSpan.replaceText(curSpanDeletePos,curSpanDeletePos + curNumToDelete,"");
            if(curSpan.textLength == 0)
            {
               delIdx = curSpan.parent.getChildIndex(curSpan);
               curSpan.parent.replaceChildren(delIdx,delIdx + 1,null);
            }
            totalToDelete = totalToDelete - curNumToDelete;
         }
      }
      
      public static function deleteText(para:ParagraphElement, paraSelBegIdx:int, totalToDelete:int) : void
      {
         var lastParPos:int = para.textLength - 1;
         if(Boolean(paraSelBegIdx < 0) || Boolean(paraSelBegIdx > lastParPos))
         {
            return;
         }
         if(totalToDelete <= 0)
         {
            return;
         }
         var endPos:int = paraSelBegIdx + totalToDelete - 1;
         if(endPos > lastParPos)
         {
            endPos = lastParPos;
            totalToDelete = endPos - paraSelBegIdx + 1;
         }
         deleteTextInternal(para,paraSelBegIdx,totalToDelete);
      }
      
      public static function createImage(flowBlock:FlowGroupElement, flowSelBegIdx:int, source:Object, width:Object, height:Object, options:Object, pointFormat:ITextLayoutFormat) : InlineGraphicElement
      {
         var searchStr:String = null;
         var index:int = 0;
         var imageElemFormat:TextLayoutFormat = null;
         var curComposeNode:FlowElement = flowBlock.findLeaf(flowSelBegIdx);
         var posInCurComposeNode:int = 0;
         if(curComposeNode != null)
         {
            posInCurComposeNode = flowSelBegIdx - curComposeNode.getElementRelativeStart(flowBlock);
         }
         if(Boolean(curComposeNode != null) && Boolean(posInCurComposeNode > 0) && Boolean(posInCurComposeNode < curComposeNode.textLength))
         {
            (curComposeNode as SpanElement).splitAtPosition(posInCurComposeNode);
         }
         var imgElem:InlineGraphicElement = new InlineGraphicElement();
         imgElem.height = height;
         imgElem.width = width;
         imgElem.float = Boolean(options)?options.toString():Float.NONE;
         var src:Object = source;
         var embedStr:String = "@Embed";
         if(Boolean(src is String) && Boolean(src.length > embedStr.length) && Boolean(src.substr(0,embedStr.length) == embedStr))
         {
            searchStr = "source=";
            index = src.indexOf(searchStr,embedStr.length);
            if(index > 0)
            {
               index = index + searchStr.length;
               index = src.indexOf("\'",index);
               src = src.substring(index + 1,src.indexOf("\'",index + 1));
            }
         }
         imgElem.source = src;
         while(Boolean(curComposeNode) && Boolean(curComposeNode.parent != flowBlock))
         {
            curComposeNode = curComposeNode.parent;
         }
         var elementIdx:int = curComposeNode != null?int(flowBlock.getChildIndex(curComposeNode)):int(flowBlock.numChildren);
         if(Boolean(curComposeNode) && Boolean(posInCurComposeNode > 0))
         {
            elementIdx++;
         }
         flowBlock.replaceChildren(elementIdx,elementIdx,imgElem);
         var p:ParagraphElement = imgElem.getParagraph();
         var attrElem:FlowLeafElement = imgElem.getPreviousLeaf(p);
         if(!attrElem)
         {
            attrElem = imgElem.getNextLeaf(p);
         }
         if(Boolean(attrElem.format) || Boolean(pointFormat))
         {
            imageElemFormat = new TextLayoutFormat(attrElem.format);
            if(pointFormat)
            {
               imageElemFormat.apply(pointFormat);
            }
            imgElem.format = imageElemFormat;
         }
         return imgElem;
      }
      
      private static function splitForChange(span:SpanElement, begIdx:int, rangeLength:int) : SpanElement
      {
         var elemToUpdate:SpanElement = null;
         var startOffset:int = span.getAbsoluteStart();
         if(Boolean(begIdx == startOffset) && Boolean(rangeLength == span.textLength))
         {
            return span;
         }
         var origLength:int = span.textLength;
         var begRelativeIdx:int = begIdx - startOffset;
         if(begRelativeIdx > 0)
         {
            elemToUpdate = span.splitAtPosition(begRelativeIdx) as SpanElement;
            if(begRelativeIdx + rangeLength < origLength)
            {
               elemToUpdate.splitAtPosition(rangeLength);
            }
         }
         else
         {
            span.splitAtPosition(rangeLength);
            elemToUpdate = span;
         }
         return elemToUpdate;
      }
      
      private static function undefineDefinedFormats(target:TextLayoutFormatValueHolder, undefineFormat:ITextLayoutFormat) : void
      {
         var prop:* = null;
         if(undefineFormat)
         {
            for(prop in TextLayoutFormat.description)
            {
               if(undefineFormat[prop] !== undefined)
               {
                  target[prop] = undefined;
               }
            }
         }
      }
      
      private static function applyCharacterFormat(leaf:FlowLeafElement, begIdx:int, rangeLength:int, applyFormat:ITextLayoutFormat, undefineFormat:ITextLayoutFormat) : int
      {
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder(leaf.format);
         if(applyFormat)
         {
            newFormat.apply(applyFormat);
         }
         undefineDefinedFormats(newFormat,undefineFormat);
         return setCharacterFormat(leaf,newFormat,begIdx,rangeLength);
      }
      
      private static function setCharacterFormat(leaf:FlowLeafElement, format:Object, begIdx:int, rangeLength:int) : int
      {
         var para:ParagraphElement = null;
         var paraStartOffset:int = 0;
         var begRelativeIdx:int = 0;
         var elemToUpdate:FlowLeafElement = null;
         var startOffset:int = leaf.getAbsoluteStart();
         if(Boolean(!(format is ITextLayoutFormat)) || Boolean(!TextLayoutFormat.isEqual(ITextLayoutFormat(format),leaf.format)))
         {
            para = leaf.getParagraph();
            paraStartOffset = para.getAbsoluteStart();
            begRelativeIdx = begIdx - startOffset;
            if(begRelativeIdx + rangeLength > leaf.textLength)
            {
               rangeLength = leaf.textLength - begRelativeIdx;
            }
            if(Boolean(begRelativeIdx + rangeLength == leaf.textLength - 1) && Boolean(leaf is SpanElement) && Boolean(SpanElement(leaf).hasParagraphTerminator))
            {
               rangeLength++;
            }
            if(leaf is SpanElement)
            {
               elemToUpdate = splitForChange(SpanElement(leaf),begIdx,rangeLength);
            }
            else
            {
               elemToUpdate = leaf;
            }
            if(format is ITextLayoutFormat)
            {
               elemToUpdate.format = ITextLayoutFormat(format);
            }
            else
            {
               elemToUpdate.setCoreStylesInternal(format);
            }
            return begIdx + rangeLength;
         }
         rangeLength = leaf.textLength;
         return startOffset + rangeLength;
      }
      
      public static function applyTextStyleChange(flowRoot:TextFlow, begChange:int, endChange:int, applyFormat:ITextLayoutFormat, undefineFormat:ITextLayoutFormat) : void
      {
         var elem:FlowLeafElement = null;
         var workIdx:int = begChange;
         while(workIdx < endChange)
         {
            elem = flowRoot.findLeaf(workIdx);
            workIdx = applyCharacterFormat(elem,workIdx,endChange - workIdx,applyFormat,undefineFormat);
         }
      }
      
      public static function setTextStyleChange(flowRoot:TextFlow, begChange:int, endChange:int, coreStyle:Object) : void
      {
         var elem:FlowElement = null;
         var workIdx:int = begChange;
         while(workIdx < endChange)
         {
            elem = flowRoot.findLeaf(workIdx);
            workIdx = setCharacterFormat(FlowLeafElement(elem),coreStyle,workIdx,endChange - workIdx);
         }
      }
      
      public static function splitParagraph(para:ParagraphElement, paraSplitPos:int, pointFormat:ITextLayoutFormat = null) : ParagraphElement
      {
         var newPar:ParagraphElement = null;
         var startIdx:int = 0;
         var lastSpan:FlowLeafElement = null;
         var prevSpan:FlowLeafElement = null;
         var elementIdx:int = 0;
         var newFormattedSpan:SpanElement = null;
         var paraStartAbsolute:int = para.getAbsoluteStart();
         var absSplitPos:int = paraStartAbsolute + paraSplitPos;
         if(paraSplitPos == para.textLength - 1)
         {
            newPar = para.shallowCopy() as ParagraphElement;
            newPar.replaceChildren(0,0,new SpanElement());
            startIdx = para.parent.getChildIndex(para);
            para.parent.replaceChildren(startIdx + 1,startIdx + 1,newPar);
            if(newPar.textLength == 1)
            {
               lastSpan = para.getLastLeaf();
               if(Boolean(lastSpan != null) && Boolean(lastSpan.textLength == 1))
               {
                  elementIdx = lastSpan.parent.getChildIndex(lastSpan);
                  if(elementIdx > 0)
                  {
                     prevSpan = lastSpan.parent.getChildAt(elementIdx - 1) as SpanElement;
                     if(prevSpan != null)
                     {
                        lastSpan = prevSpan;
                     }
                  }
               }
               if(lastSpan != null)
               {
                  ParaEdit.setTextStyleChange(para.getTextFlow(),absSplitPos + 1,absSplitPos + 2,lastSpan.format);
               }
               if(pointFormat != null)
               {
                  ParaEdit.applyTextStyleChange(para.getTextFlow(),absSplitPos + 1,absSplitPos + 2,pointFormat,null);
               }
            }
         }
         else
         {
            newPar = para.splitAtPosition(paraSplitPos) as ParagraphElement;
         }
         if(para.numChildren == 0)
         {
            newFormattedSpan = new SpanElement();
            newFormattedSpan.quickCloneTextLayoutFormat(newPar.getChildAt(0));
            para.replaceChildren(0,0,newFormattedSpan);
         }
         return newPar;
      }
      
      public static function mergeParagraphWithNext(para:ParagraphElement) : Boolean
      {
         var elem:FlowElement = null;
         var indexOfPara:int = para.parent.getChildIndex(para);
         if(indexOfPara == para.parent.numChildren - 1)
         {
            return false;
         }
         var nextPar:ParagraphElement = para.parent.getChildAt(indexOfPara + 1) as ParagraphElement;
         if(nextPar == null)
         {
            return false;
         }
         para.parent.replaceChildren(indexOfPara + 1,indexOfPara + 2,null);
         if(nextPar.textLength <= 1)
         {
            return true;
         }
         while(nextPar.numChildren)
         {
            elem = nextPar.getChildAt(0);
            nextPar.replaceChildren(0,1,null);
            para.replaceChildren(para.numChildren,para.numChildren,elem);
            if(Boolean(para.numChildren > 1) && Boolean(para.getChildAt(para.numChildren - 2).textLength == 0))
            {
               para.replaceChildren(para.numChildren - 2,para.numChildren - 1,null);
            }
         }
         return true;
      }
      
      public static function cacheParagraphStyleInformation(flowRoot:TextFlow, begSel:int, endSel:int, undoArray:Array) : void
      {
         var para:ParagraphElement = null;
         var obj:Object = null;
         while(Boolean(begSel <= endSel) && Boolean(begSel >= 0))
         {
            para = flowRoot.findLeaf(begSel).getParagraph();
            obj = new Object();
            obj.begIdx = para.getAbsoluteStart();
            obj.endIdx = obj.begIdx + para.textLength - 1;
            obj.attributes = para.coreStyles;
            undoArray.push(obj);
            begSel = obj.begIdx + para.textLength;
         }
      }
      
      public static function setParagraphStyleChange(flowRoot:TextFlow, begChange:int, endChange:int, coreStyles:Object) : void
      {
         var para:ParagraphElement = null;
         var beginPara:int = begChange;
         while(beginPara < endChange)
         {
            para = flowRoot.findLeaf(beginPara).getParagraph();
            para.setCoreStylesInternal(coreStyles);
            beginPara = para.getAbsoluteStart() + para.textLength;
         }
      }
      
      public static function applyParagraphStyleChange(flowRoot:TextFlow, begChange:int, endChange:int, applyFormat:ITextLayoutFormat, undefineFormat:ITextLayoutFormat) : void
      {
         var para:ParagraphElement = null;
         var newFormat:TextLayoutFormatValueHolder = null;
         var curIndex:int = begChange;
         while(curIndex <= endChange)
         {
            para = flowRoot.findLeaf(curIndex).getParagraph();
            newFormat = new TextLayoutFormatValueHolder(para.format);
            if(applyFormat)
            {
               newFormat.apply(applyFormat);
            }
            undefineDefinedFormats(newFormat,undefineFormat);
            para.format = newFormat;
            curIndex = para.getAbsoluteStart() + para.textLength;
         }
      }
      
      public static function cacheStyleInformation(flowRoot:TextFlow, begSel:int, endSel:int, undoArray:Array) : void
      {
         var obj:Object = null;
         var objLength:int = 0;
         var elem:FlowElement = flowRoot.findLeaf(begSel);
         var elemLength:int = elem.getAbsoluteStart() + elem.textLength - begSel;
         for(var countRemaining:int = endSel - begSel; true; )
         {
            obj = new Object();
            obj.begIdx = begSel;
            objLength = Math.min(countRemaining,elemLength);
            obj.endIdx = begSel + objLength;
            obj.style = elem.coreStyles;
            undoArray.push(obj);
            countRemaining = countRemaining - Math.min(countRemaining,elemLength);
            if(countRemaining == 0)
            {
               break;
            }
            begSel = obj.endIdx;
            elem = flowRoot.findLeaf(begSel);
            elemLength = elem.textLength;
         }
      }
      
      public static function cacheContainerStyleInformation(flowRoot:TextFlow, begIdx:int, endIdx:int, undoArray:Array) : void
      {
         var controllerIndex:int = 0;
         var controller:ContainerController = null;
         var obj:Object = null;
         if(flowRoot.flowComposer)
         {
            controllerIndex = flowRoot.flowComposer.findControllerIndexAtPosition(begIdx,false);
            if(controllerIndex >= 0)
            {
               while(controllerIndex < flowRoot.flowComposer.numControllers)
               {
                  controller = flowRoot.flowComposer.getControllerAt(controllerIndex);
                  if(controller.absoluteStart >= endIdx)
                  {
                     break;
                  }
                  obj = new Object();
                  obj.container = controller;
                  obj.attributes = controller.coreStyles;
                  undoArray.push(obj);
                  controllerIndex++;
               }
            }
         }
      }
      
      public static function applyContainerStyleChange(flowRoot:TextFlow, begIdx:int, endIdx:int, applyFormat:ITextLayoutFormat, undefineFormat:ITextLayoutFormat) : void
      {
         var controllerIndex:int = 0;
         var controller:ContainerController = null;
         var newFormat:TextLayoutFormatValueHolder = null;
         if(flowRoot.flowComposer)
         {
            controllerIndex = flowRoot.flowComposer.findControllerIndexAtPosition(begIdx,false);
            if(controllerIndex >= 0)
            {
               while(controllerIndex < flowRoot.flowComposer.numControllers)
               {
                  controller = flowRoot.flowComposer.getControllerAt(controllerIndex);
                  if(controller.absoluteStart >= endIdx)
                  {
                     break;
                  }
                  newFormat = new TextLayoutFormatValueHolder(controller.format);
                  if(applyFormat)
                  {
                     newFormat.apply(applyFormat);
                  }
                  undefineDefinedFormats(newFormat,undefineFormat);
                  controller.format = newFormat;
                  controllerIndex++;
               }
            }
         }
      }
      
      public static function setContainerStyleChange(flowRoot:TextFlow, obj:Object) : void
      {
         obj.container.format = obj.attributes as ITextLayoutFormat;
      }
   }
}
