package flashx.textLayout.conversion
{
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.BreakElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.elements.TabElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.elements.LinkElement;
   import flashx.textLayout.elements.DivElement;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.property.StringProperty;
   import flash.utils.Dictionary;
   import flashx.textLayout.elements.GlobalSettings;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.elements.IConfiguration;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class TextLayoutImporter extends BaseTextLayoutImporter
   {
      
      private static var _defaultConfiguration:flashx.textLayout.conversion.ImportExportConfiguration;
      
      private static const _formatImporter:flashx.textLayout.conversion.TLFormatImporter = new flashx.textLayout.conversion.TLFormatImporter(TextLayoutFormatValueHolder,TextLayoutFormat.description);
      
      private static const _idImporter:flashx.textLayout.conversion.SingletonAttributeImporter = new flashx.textLayout.conversion.SingletonAttributeImporter("id");
      
      private static const _styleNameImporter:flashx.textLayout.conversion.SingletonAttributeImporter = new flashx.textLayout.conversion.SingletonAttributeImporter("styleName");
      
      private static const _customFormatImporter:flashx.textLayout.conversion.CustomFormatImporter = new flashx.textLayout.conversion.CustomFormatImporter();
      
      private static const _flowElementFormatImporters:Array = [_formatImporter,_idImporter,_styleNameImporter,_customFormatImporter];
      
      static const _linkDescription:Object = {
         "href":new StringProperty("href",null,false,null),
         "target":new StringProperty("target",null,false,null)
      };
      
      private static const _linkFormatImporter:flashx.textLayout.conversion.TLFormatImporter = new flashx.textLayout.conversion.TLFormatImporter(Dictionary,_linkDescription);
      
      private static const _linkElementFormatImporters:Array = [_linkFormatImporter,_formatImporter,_idImporter,_styleNameImporter,_customFormatImporter];
      
      private static const _imageDescription:Object = {
         "height":InlineGraphicElement.heightPropertyDefinition,
         "width":InlineGraphicElement.widthPropertyDefinition,
         "source":new StringProperty("source",null,false,null),
         "float":new StringProperty("float",null,false,null),
         "rotation":InlineGraphicElement.rotationPropertyDefinition
      };
      
      private static const _ilgFormatImporter:flashx.textLayout.conversion.TLFormatImporter = new flashx.textLayout.conversion.TLFormatImporter(Dictionary,_imageDescription);
      
      private static const _ilgElementFormatImporters:Array = [_ilgFormatImporter,_formatImporter,_idImporter,_styleNameImporter,_customFormatImporter];
       
      protected var bindingsArray:Array;
      
      public function TextLayoutImporter(textFlowConfiguration:IConfiguration)
      {
         super(textFlowConfiguration,flowNS,defaultConfiguration);
      }
      
      public static function get defaultConfiguration() : flashx.textLayout.conversion.ImportExportConfiguration
      {
         if(!_defaultConfiguration)
         {
            _defaultConfiguration = new flashx.textLayout.conversion.ImportExportConfiguration();
            _defaultConfiguration.addIEInfo("TextFlow",TextFlow,BaseTextLayoutImporter.parseTextFlow,BaseTextLayoutExporter.exportTextFlow,true);
            _defaultConfiguration.addIEInfo("br",BreakElement,BaseTextLayoutImporter.parseBreak,BaseTextLayoutExporter.exportFlowElement,false);
            _defaultConfiguration.addIEInfo("p",ParagraphElement,BaseTextLayoutImporter.parsePara,BaseTextLayoutExporter.exportParagraphFormattedElement,true);
            _defaultConfiguration.addIEInfo("span",SpanElement,BaseTextLayoutImporter.parseSpan,BaseTextLayoutExporter.exportSpan,false);
            _defaultConfiguration.addIEInfo("tab",TabElement,BaseTextLayoutImporter.parseTab,BaseTextLayoutExporter.exportFlowElement,false);
            _defaultConfiguration.addIEInfo("tcy",TCYElement,TextLayoutImporter.parseTCY,TextLayoutExporter.exportTCY,false);
            _defaultConfiguration.addIEInfo("a",LinkElement,TextLayoutImporter.parseLink,TextLayoutExporter.exportLink,false);
            _defaultConfiguration.addIEInfo("div",DivElement,TextLayoutImporter.parseDivElement,TextLayoutExporter.exportDiv,true);
            _defaultConfiguration.addIEInfo("img",InlineGraphicElement,TextLayoutImporter.parseInlineGraphic,TextLayoutExporter.exportImage,false);
            _defaultConfiguration.addIEInfo(LinkElement.LINK_NORMAL_FORMAT_NAME,null,TextLayoutImporter.parseLinkNormalFormat,null,false);
            _defaultConfiguration.addIEInfo(LinkElement.LINK_ACTIVE_FORMAT_NAME,null,TextLayoutImporter.parseLinkActiveFormat,null,false);
            _defaultConfiguration.addIEInfo(LinkElement.LINK_HOVER_FORMAT_NAME,null,TextLayoutImporter.parseLinkHoverFormat,null,false);
         }
         return _defaultConfiguration;
      }
      
      public static function restoreDefaults() : void
      {
         _defaultConfiguration = null;
      }
      
      private static function get flowNS() : Namespace
      {
         return new Namespace("flow","http://ns.adobe.com/textLayout/2008");
      }
      
      private static function arrayHasString(arr:Array, str:String) : Boolean
      {
         var item:String = null;
         for each(item in arr)
         {
            if(str == item)
            {
               return true;
            }
         }
         return false;
      }
      
      public static function parseTCY(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var tcyElem:TCYElement = TextLayoutImporter(importFilter).createTCYFromXML(xmlToParse);
         if(importFilter.addChild(parent,tcyElem))
         {
            importFilter.parseFlowGroupElementChildren(xmlToParse,tcyElem);
            if(tcyElem.numChildren == 0)
            {
               tcyElem.addChild(new SpanElement());
            }
         }
      }
      
      public static function parseLink(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var linkElem:LinkElement = TextLayoutImporter(importFilter).createLinkFromXML(xmlToParse);
         if(importFilter.addChild(parent,linkElem))
         {
            importFilter.parseFlowGroupElementChildren(xmlToParse,linkElem);
            if(linkElem.numChildren == 0)
            {
               linkElem.addChild(new SpanElement());
            }
         }
      }
      
      public static function parseLinkNormalFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         parent.linkNormalFormat = TextLayoutImporter(importFilter).createDictionaryFromXML(xmlToParse);
      }
      
      public static function parseLinkActiveFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         parent.linkActiveFormat = TextLayoutImporter(importFilter).createDictionaryFromXML(xmlToParse);
      }
      
      public static function parseLinkHoverFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         parent.linkHoverFormat = TextLayoutImporter(importFilter).createDictionaryFromXML(xmlToParse);
      }
      
      public static function parseDivElement(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var divElem:DivElement = TextLayoutImporter(importFilter).createDivFromXML(xmlToParse);
         if(importFilter.addChild(parent,divElem))
         {
            importFilter.parseFlowGroupElementChildren(xmlToParse,divElem);
            if(divElem.numChildren == 0)
            {
               divElem.addChild(new ParagraphElement());
            }
         }
      }
      
      public static function parseInlineGraphic(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var ilg:InlineGraphicElement = TextLayoutImporter(importFilter).createInlineGraphicFromXML(xmlToParse);
         importFilter.addChild(parent,ilg);
      }
      
      override protected function clear() : void
      {
         this.bindingsArray = null;
         super.clear();
      }
      
      override protected function parseContent(rootStory:XML) : TextFlow
      {
         var rootName:String = rootStory.name().localName;
         var textFlowElement:XML = rootName == "TextFlow"?rootStory:rootStory..TextFlow[0];
         if(!textFlowElement)
         {
            reportError(GlobalSettings.resourceStringFunction("missingTextFlow"));
            return null;
         }
         if(!checkNamespace(textFlowElement))
         {
            return null;
         }
         return parseTextFlow(this,textFlowElement);
      }
      
      private function parseStandardFlowElementAttributes(flowElem:FlowElement, xmlToParse:XML, importers:Array = null) : void
      {
         if(importers == null)
         {
            importers = _flowElementFormatImporters;
         }
         parseAttributes(xmlToParse,importers);
         flowElem.format = this.extractTextFormatAttributesHelper(flowElem.format,_formatImporter) as ITextLayoutFormat;
         flowElem.id = _idImporter.result as String;
         flowElem.styleName = _styleNameImporter.result as String;
         flowElem.userStyles = _customFormatImporter.result as Dictionary;
      }
      
      override public function createTextFlowFromXML(xmlToParse:XML, textFlow:TextFlow = null) : TextFlow
      {
         var flowName:String = null;
         var newFlow:TextFlow = null;
         if(xmlToParse["id"] != undefined)
         {
            flowName = null;
            flowName = xmlToParse["id"];
            newFlow = this.getBoundObjNamed(flowName,TextFlow) as TextFlow;
         }
         if(!checkNamespace(xmlToParse))
         {
            return newFlow;
         }
         if(!newFlow)
         {
            newFlow = new TextFlow(_textFlowConfiguration);
         }
         this.parseStandardFlowElementAttributes(newFlow,xmlToParse);
         parseFlowGroupElementChildren(xmlToParse,newFlow);
         newFlow.normalize();
         newFlow.applyWhiteSpaceCollapse(null);
         return newFlow;
      }
      
      public function createDivFromXML(xmlToParse:XML) : DivElement
      {
         var divElem:DivElement = new DivElement();
         this.parseStandardFlowElementAttributes(divElem,xmlToParse);
         return divElem;
      }
      
      override public function createParagraphFromXML(xmlToParse:XML) : ParagraphElement
      {
         var paraElem:ParagraphElement = new ParagraphElement();
         this.parseStandardFlowElementAttributes(paraElem,xmlToParse);
         return paraElem;
      }
      
      public function createTCYFromXML(xmlToParse:XML) : TCYElement
      {
         var tcyElem:TCYElement = new TCYElement();
         this.parseStandardFlowElementAttributes(tcyElem,xmlToParse);
         return tcyElem;
      }
      
      public function createLinkFromXML(xmlToParse:XML) : LinkElement
      {
         var linkElem:LinkElement = new LinkElement();
         this.parseStandardFlowElementAttributes(linkElem,xmlToParse,_linkElementFormatImporters);
         if(_linkFormatImporter.result)
         {
            linkElem.href = _linkFormatImporter.result["href"] as String;
            linkElem.target = _linkFormatImporter.result["target"] as String;
         }
         return linkElem;
      }
      
      override public function createSpanFromXML(xmlToParse:XML) : SpanElement
      {
         var spanElem:SpanElement = new SpanElement();
         this.parseStandardFlowElementAttributes(spanElem,xmlToParse);
         return spanElem;
      }
      
      public function createInlineGraphicFromXML(xmlToParse:XML) : InlineGraphicElement
      {
         var source:String = null;
         var imgElem:InlineGraphicElement = new InlineGraphicElement();
         this.parseStandardFlowElementAttributes(imgElem,xmlToParse,_ilgElementFormatImporters);
         if(_ilgFormatImporter.result)
         {
            source = _ilgFormatImporter.result["source"];
            imgElem.source = source;
            imgElem.height = InlineGraphicElement.heightPropertyDefinition.setHelper(imgElem.height,_ilgFormatImporter.result["height"]);
            imgElem.width = InlineGraphicElement.widthPropertyDefinition.setHelper(imgElem.width,_ilgFormatImporter.result["width"]);
            imgElem.float = InlineGraphicElement.floatPropertyDefinition.setHelper(imgElem.float,_ilgFormatImporter.result["float"]);
         }
         return imgElem;
      }
      
      public function extractTextFormatAttributesHelper(curAttrs:Object, importer:flashx.textLayout.conversion.TLFormatImporter) : Object
      {
         return extractAttributesHelper(curAttrs,importer);
      }
      
      protected function parseNamedFormatDefinition(xmlToParse:XML, importer:flashx.textLayout.conversion.TLFormatImporter) : void
      {
         var item:XML = null;
         if(!checkNamespace(xmlToParse))
         {
            return;
         }
         var idName:String = xmlToParse.@id.toString();
         if(Boolean(idName == null) || Boolean(idName.length == 0))
         {
            return;
         }
         importer.reset();
         for each(item in xmlToParse.attributes())
         {
            importer.importOneFormat(item.name().localName,item.toString());
         }
         if(!this.bindingsArray)
         {
            this.bindingsArray = new Array();
         }
         this.bindingsArray[idName] = Boolean(importer.result)?importer.result:new importer.classType();
      }
      
      function getBoundObjNamed(name:String, typeClass:Class) : Object
      {
         if(!this.bindingsArray)
         {
            this.bindingsArray = new Array();
         }
         if(this.bindingsArray[name] == null)
         {
            if(typeClass == TextFlow)
            {
               this.bindingsArray[name] = new typeClass(this._textFlowConfiguration);
            }
            else
            {
               this.bindingsArray[name] = new typeClass();
            }
         }
         return this.bindingsArray[name];
      }
      
      public function createDictionaryFromXML(xmlToParse:XML) : Dictionary
      {
         var prop:* = null;
         var val:* = undefined;
         var formatImporters:Array = [_customFormatImporter];
         var formatList:XMLList = xmlToParse..TextLayoutFormat;
         if(formatList.length() != 1)
         {
            reportError(GlobalSettings.resourceStringFunction("expectedExactlyOneTextLayoutFormat",[xmlToParse.name()]));
         }
         var parseThis:XML = formatList.length() > 0?formatList[0]:xmlToParse;
         parseAttributes(parseThis,formatImporters);
         var styleDictionary:Dictionary = _customFormatImporter.result as Dictionary;
         var description:Object = TextLayoutFormat.description;
         for(prop in description)
         {
            val = styleDictionary[prop];
            if(val !== undefined)
            {
               val = description[prop].setHelper(undefined,val);
               if(val !== undefined)
               {
                  styleDictionary[prop] = val;
               }
            }
         }
         return styleDictionary;
      }
   }
}
