package flashx.textLayout.conversion
{
   class ImportExportConfiguration
   {
       
      private var flowElementInfoList:Object;
      
      function ImportExportConfiguration()
      {
         super();
      }
      
      public function addIEInfo(name:String, flowClass:Class, parser:Function, exporter:Function, isParagraphFormattedElement:Boolean) : void
      {
         if(this.flowElementInfoList == null)
         {
            this.flowElementInfoList = new Object();
         }
         this.flowElementInfoList[name] = new FlowElementInfo(flowClass,parser,exporter,isParagraphFormattedElement);
      }
      
      public function overrideIEInfo(name:String, flowClass:Class, parser:Function, exporter:Function) : void
      {
         if(this.flowElementInfoList == null)
         {
            this.flowElementInfoList = new Object();
         }
         this.flowElementInfoList[name].flowClass = flowClass;
         this.flowElementInfoList[name].parser = parser;
         this.flowElementInfoList[name].exporter = exporter;
      }
      
      public function lookup(name:String) : FlowElementInfo
      {
         return Boolean(this.flowElementInfoList)?this.flowElementInfoList[name]:null;
      }
      
      public function lookupName(classToMatch:String) : String
      {
         var name:* = null;
         for(name in this.flowElementInfoList)
         {
            if(this.flowElementInfoList[name].flowClassName == classToMatch)
            {
               return name;
            }
         }
         return null;
      }
      
      public function lookupByClass(classToMatch:String) : FlowElementInfo
      {
         var name:* = null;
         for(name in this.flowElementInfoList)
         {
            if(this.flowElementInfoList[name].flowClassName == classToMatch)
            {
               return this.flowElementInfoList[name];
            }
         }
         return null;
      }
   }
}
