package flashx.textLayout.container
{
   import flashx.textLayout.edit.IInteractionEventHandler;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.tlf_internal;
   import flash.ui.ContextMenu;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.formats.FormatValue;
   import flash.display.Sprite;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.ContainerFormattedElement;
   import flash.display.Shape;
   import flash.utils.Timer;
   import flashx.textLayout.elements.FlowValueHolder;
   import flash.display.DisplayObject;
   import flash.display.InteractiveObject;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.edit.ISelectionManager;
   import flashx.textLayout.compose.TextFlowLine;
   import flash.text.engine.TextLine;
   import flashx.textLayout.utils.Twips;
   import flash.geom.Rectangle;
   import flashx.textLayout.events.TextLayoutEvent;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.compose.FlowDamageType;
   import flash.events.FocusEvent;
   import flash.events.MouseEvent;
   import flash.events.Event;
   import flash.events.TextEvent;
   import flash.events.ContextMenuEvent;
   import flash.geom.Point;
   import flash.events.TimerEvent;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.text.engine.TextLineValidity;
   import flashx.textLayout.edit.EditingMode;
   import flash.events.KeyboardEvent;
   import flash.events.IMEEvent;
   import flash.ui.ContextMenuClipboardItems;
   import flash.display.DisplayObjectContainer;
   import flashx.textLayout.edit.SelectionFormat;
   import flashx.textLayout.events.UpdateCompleteEvent;
   import flashx.textLayout.elements.BackgroundManager;
   import flashx.textLayout.compose.TextLineRecycler;
   import flash.display.BlendMode;
   import flashx.textLayout.property.Property;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.elements.FlowElement;
   
   use namespace tlf_internal;
   
   public class ContainerController implements IInteractionEventHandler, ITextLayoutFormat, ISandboxSupport
   {
      
      private static var _containerControllerInitialFormat:ITextLayoutFormat = createContainerControllerInitialFormat();
      
      private static var tempLineHolder:Sprite = new Sprite();
       
      private var _textFlowCache:TextFlow;
      
      private var _rootElement:ContainerFormattedElement;
      
      private var _absoluteStart:int;
      
      private var _textLength:int;
      
      private var _container:Sprite;
      
      protected var _computedFormat:TextLayoutFormatValueHolder;
      
      private var _columnState:flashx.textLayout.container.ColumnState;
      
      private var _compositionWidth:Number = 0;
      
      private var _compositionHeight:Number = 0;
      
      private var _measureWidth:Boolean;
      
      private var _measureHeight:Boolean;
      
      private var _contentLeft:Number;
      
      private var _contentTop:Number;
      
      private var _contentWidth:Number;
      
      private var _contentHeight:Number;
      
      private var _composeCompleteRatio:Number;
      
      private var _horizontalScrollPolicy:String;
      
      private var _verticalScrollPolicy:String;
      
      private var _xScroll:Number;
      
      private var _yScroll:Number;
      
      private var _minListenersAttached:Boolean = false;
      
      private var _allListenersAttached:Boolean = false;
      
      private var _selectListenersAttached:Boolean = false;
      
      private var _shapesInvalid:Boolean = false;
      
      private var _backgroundShape:Shape;
      
      private var _scrollTimer:Timer = null;
      
      protected var _hasScrollRect:Boolean;
      
      private var _shapeChildren:Array;
      
      private var _formatValueHolder:FlowValueHolder;
      
      private var _containerRoot:DisplayObject;
      
      private var _transparentBGX:Number;
      
      private var _transparentBGY:Number;
      
      private var _transparentBGWidth:Number;
      
      private var _transparentBGHeight:Number;
      
      private var blinkTimer:Timer;
      
      private var blinkObject:DisplayObject;
      
      private var _selectionSprite:Sprite;
      
      public function ContainerController(container:Sprite, compositionWidth:Number = 100, compositionHeight:Number = 100)
      {
         super();
         this.initialize(container,compositionWidth,compositionHeight);
      }
      
      private static function pinValue(value:Number, minimum:Number, maximum:Number) : Number
      {
         return Math.min(Math.max(value,minimum),maximum);
      }
      
      tlf_internal static function createDefaultContextMenu() : ContextMenu
      {
         var contextMenu:ContextMenu = new ContextMenu();
         contextMenu.clipboardMenu = true;
         contextMenu.clipboardItems.clear = true;
         contextMenu.clipboardItems.copy = true;
         contextMenu.clipboardItems.cut = true;
         contextMenu.clipboardItems.paste = true;
         contextMenu.clipboardItems.selectAll = true;
         return contextMenu;
      }
      
      private static function createContainerControllerInitialFormat() : ITextLayoutFormat
      {
         var ccif:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         ccif.columnCount = FormatValue.INHERIT;
         ccif.columnGap = FormatValue.INHERIT;
         ccif.columnWidth = FormatValue.INHERIT;
         ccif.verticalAlign = FormatValue.INHERIT;
         return ccif;
      }
      
      public static function get containerControllerInitialFormat() : ITextLayoutFormat
      {
         return _containerControllerInitialFormat;
      }
      
      public static function set containerControllerInitialFormat(val:ITextLayoutFormat) : void
      {
         _containerControllerInitialFormat = val;
      }
      
      tlf_internal function get allListenersAttached() : Boolean
      {
         return this._allListenersAttached;
      }
      
      tlf_internal function get hasScrollRect() : Boolean
      {
         return this._hasScrollRect;
      }
      
      private function initialize(container:Sprite, compositionWidth:Number, compositionHeight:Number) : void
      {
         this._container = container;
         this._containerRoot = null;
         this._textLength = 0;
         this._absoluteStart = -1;
         this._columnState = new flashx.textLayout.container.ColumnState(null,null,null,0,0);
         this._xScroll = this._yScroll = 0;
         this._contentWidth = this._contentHeight = 0;
         this._composeCompleteRatio = 1;
         if(this._container is InteractiveObject)
         {
            InteractiveObject(this._container).doubleClickEnabled = true;
         }
         this._horizontalScrollPolicy = this._verticalScrollPolicy = String(ScrollPolicy.scrollPolicyPropertyDefinition.defaultValue);
         this._hasScrollRect = false;
         this._shapeChildren = [];
         this.setCompositionSize(compositionWidth,compositionHeight);
         this.format = _containerControllerInitialFormat;
      }
      
      tlf_internal function get effectiveBlockProgression() : String
      {
         return Boolean(this._rootElement)?this._rootElement.computedFormat.blockProgression:BlockProgression.TB;
      }
      
      tlf_internal function getContainerRoot() : DisplayObject
      {
         var x:int = 0;
         if(Boolean(this._containerRoot == null) && Boolean(this._container) && Boolean(this._container.stage))
         {
            try
            {
               x = this._container.stage.numChildren;
               this._containerRoot = this._container.stage;
            }
            catch(e:Error)
            {
               _containerRoot = _container.root;
            }
         }
         return this._containerRoot;
      }
      
      public function get flowComposer() : IFlowComposer
      {
         return Boolean(this.textFlow)?this.textFlow.flowComposer:null;
      }
      
      tlf_internal function get shapesInvalid() : Boolean
      {
         return this._shapesInvalid;
      }
      
      tlf_internal function set shapesInvalid(val:Boolean) : void
      {
         this._shapesInvalid = val;
      }
      
      public function get columnState() : flashx.textLayout.container.ColumnState
      {
         if(this._rootElement == null)
         {
            return null;
         }
         if(this._computedFormat == null)
         {
            this.computedFormat;
         }
         this._columnState.computeColumns();
         return this._columnState;
      }
      
      public function get container() : Sprite
      {
         return this._container;
      }
      
      public function get compositionWidth() : Number
      {
         return this._compositionWidth;
      }
      
      public function get compositionHeight() : Number
      {
         return this._compositionHeight;
      }
      
      tlf_internal function get measureWidth() : Boolean
      {
         return this._measureWidth;
      }
      
      tlf_internal function get measureHeight() : Boolean
      {
         return this._measureHeight;
      }
      
      public function setCompositionSize(w:Number, h:Number) : void
      {
         var widthChanged:Boolean = !(Boolean(this._compositionWidth == w) || Boolean(isNaN(this._compositionWidth)) && Boolean(isNaN(w)));
         var heightChanged:Boolean = !(Boolean(this._compositionHeight == h) || Boolean(isNaN(this._compositionHeight)) && Boolean(isNaN(h)));
         if(Boolean(widthChanged) || Boolean(heightChanged))
         {
            this._compositionHeight = h;
            this._measureHeight = isNaN(this._compositionHeight);
            this._compositionWidth = w;
            this._measureWidth = isNaN(this._compositionWidth);
            if(this._computedFormat)
            {
               this.resetColumnState();
            }
            this.invalidateContents();
            this.attachTransparentBackgroundForHit(false);
         }
      }
      
      public function get textFlow() : TextFlow
      {
         if(Boolean(!this._textFlowCache) && Boolean(this._rootElement))
         {
            this._textFlowCache = this._rootElement.getTextFlow();
         }
         return this._textFlowCache;
      }
      
      public function get rootElement() : ContainerFormattedElement
      {
         return this._rootElement;
      }
      
      tlf_internal function setRootElement(value:ContainerFormattedElement) : void
      {
         if(this._rootElement != value)
         {
            this.clearCompositionResults();
            this.detachContainer();
            this._rootElement = value;
            this._textFlowCache = null;
            this._textLength = 0;
            this._absoluteStart = -1;
            this.attachContainer();
            if(this._rootElement)
            {
               this.formatChanged();
            }
         }
      }
      
      public function get interactionManager() : ISelectionManager
      {
         return Boolean(this.textFlow)?this.textFlow.interactionManager:null;
      }
      
      public function get absoluteStart() : int
      {
         var stopIdx:int = 0;
         var prevController:ContainerController = null;
         if(this._absoluteStart != -1)
         {
            return this._absoluteStart;
         }
         var rslt:int = 0;
         var composer:IFlowComposer = this.flowComposer;
         if(composer)
         {
            stopIdx = composer.getControllerIndex(this);
            if(stopIdx != 0)
            {
               prevController = composer.getControllerAt(stopIdx - 1);
               rslt = prevController.absoluteStart + prevController.textLength;
            }
         }
         this._absoluteStart = rslt;
         return rslt;
      }
      
      public function get textLength() : int
      {
         return this._textLength;
      }
      
      tlf_internal function setTextLengthOnly(numChars:int) : void
      {
         var composer:IFlowComposer = null;
         var idx:int = 0;
         var controller:ContainerController = null;
         if(this._textLength != numChars)
         {
            this._textLength = numChars;
            if(this._absoluteStart != -1)
            {
               composer = this.flowComposer;
               if(composer)
               {
                  idx = composer.getControllerIndex(this) + 1;
                  while(idx < this.flowComposer.numControllers)
                  {
                     controller = composer.getControllerAt(idx++);
                     if(controller._absoluteStart == -1)
                     {
                        break;
                     }
                     controller._absoluteStart = -1;
                  }
               }
            }
         }
      }
      
      tlf_internal function setTextLength(numChars:int) : void
      {
         var verticalText:Boolean = false;
         var flowComposer:IFlowComposer = null;
         var containerAbsoluteStart:int = 0;
         this._composeCompleteRatio = 1;
         if(this.textFlow)
         {
            verticalText = this.effectiveBlockProgression == BlockProgression.RL;
            flowComposer = this.textFlow.flowComposer;
            if(Boolean(numChars != 0) && Boolean(flowComposer.getControllerIndex(this) == flowComposer.numControllers - 1) && (Boolean(!verticalText) && Boolean(this._verticalScrollPolicy != ScrollPolicy.OFF) || Boolean(verticalText) && Boolean(this._horizontalScrollPolicy != ScrollPolicy.OFF)))
            {
               containerAbsoluteStart = this.absoluteStart;
               this._composeCompleteRatio = (this.textFlow.textLength - containerAbsoluteStart) / numChars;
               numChars = this.textFlow.textLength - containerAbsoluteStart;
            }
         }
         this.setTextLengthOnly(numChars);
      }
      
      tlf_internal function updateLength(pos:int, lengthToAdd:int) : void
      {
         this.setTextLengthOnly(this._textLength + lengthToAdd);
      }
      
      public function isDamaged() : Boolean
      {
         return this.flowComposer.isDamaged(this.absoluteStart + this._textLength);
      }
      
      tlf_internal function formatChanged() : void
      {
         this._computedFormat = null;
         this.invalidateContents();
      }
      
      tlf_internal function updateInlineChildren() : void
      {
      }
      
      protected function fillShapeChildren(sc:Array, tempSprite:Sprite) : void
      {
         var scrollAdjustXTW:int = 0;
         var scrollAdjustYTW:int = 0;
         var scrollAdjustWidthTW:int = 0;
         var scrollAdjustHeightTW:int = 0;
         var curLine:TextFlowLine = null;
         var textLine:TextLine = null;
         if(this._textLength == 0)
         {
            return;
         }
         var flowComposer:IFlowComposer = this.flowComposer;
         var wmode:String = this.effectiveBlockProgression;
         var width:Number = !!this._measureWidth?Number(this._contentWidth):Number(this._compositionWidth);
         var height:Number = !!this._measureHeight?Number(this._contentHeight):Number(this._compositionHeight);
         var adjustX:Number = wmode == BlockProgression.RL?Number(this._xScroll - width):Number(this._xScroll);
         var adjustY:Number = this._yScroll;
         scrollAdjustXTW = Twips.round(adjustX);
         scrollAdjustYTW = Twips.round(adjustY);
         scrollAdjustWidthTW = Twips.to(width);
         scrollAdjustHeightTW = Twips.to(height);
         var adjustLines:Boolean = Boolean(wmode == BlockProgression.RL) && (Boolean(this._horizontalScrollPolicy == ScrollPolicy.OFF) && Boolean(this._verticalScrollPolicy == ScrollPolicy.OFF));
         var firstLine:int = flowComposer.findLineIndexAtPosition(this.absoluteStart);
         var lastLine:int = flowComposer.findLineIndexAtPosition(this.absoluteStart + this._textLength - 1);
         for(var lineIndex:int = firstLine; lineIndex <= lastLine; lineIndex++)
         {
            curLine = flowComposer.getLineAt(lineIndex);
            if(!(Boolean(curLine == null) || Boolean(curLine.controller != this)))
            {
               textLine = this.lineIsVisible(wmode,scrollAdjustXTW,scrollAdjustYTW,scrollAdjustWidthTW,scrollAdjustHeightTW,curLine);
               if(textLine)
               {
                  if(adjustLines)
                  {
                     textLine.x = textLine.x - adjustX;
                     textLine.y = textLine.y - adjustY;
                  }
                  sc.push(textLine);
                  if(textLine.parent == null)
                  {
                     tempSprite.addChild(textLine);
                  }
               }
            }
         }
         if(adjustLines)
         {
            this._contentLeft = this._contentLeft - adjustX;
            this._contentTop = this._contentTop - adjustY;
         }
      }
      
      public function get horizontalScrollPolicy() : String
      {
         return this._horizontalScrollPolicy;
      }
      
      public function set horizontalScrollPolicy(scrollPolicy:String) : void
      {
         var newScrollPolicy:String = ScrollPolicy.scrollPolicyPropertyDefinition.setHelper(this._horizontalScrollPolicy,scrollPolicy) as String;
         if(newScrollPolicy != this._horizontalScrollPolicy)
         {
            this._horizontalScrollPolicy = newScrollPolicy;
            if(this._horizontalScrollPolicy == ScrollPolicy.OFF)
            {
               this.horizontalScrollPosition = 0;
            }
            this.formatChanged();
         }
      }
      
      public function get verticalScrollPolicy() : String
      {
         return this._verticalScrollPolicy;
      }
      
      public function set verticalScrollPolicy(scrollPolicy:String) : void
      {
         var newScrollPolicy:String = ScrollPolicy.scrollPolicyPropertyDefinition.setHelper(this._verticalScrollPolicy,scrollPolicy) as String;
         if(newScrollPolicy != this._verticalScrollPolicy)
         {
            this._verticalScrollPolicy = newScrollPolicy;
            if(this._verticalScrollPolicy == ScrollPolicy.OFF)
            {
               this.verticalScrollPosition = 0;
            }
            this.formatChanged();
         }
      }
      
      public function get horizontalScrollPosition() : Number
      {
         return this._xScroll;
      }
      
      public function set horizontalScrollPosition(x:Number) : void
      {
         if(!this._rootElement)
         {
            return;
         }
         if(this._horizontalScrollPolicy == ScrollPolicy.OFF)
         {
            this._xScroll = 0;
            return;
         }
         var oldScroll:Number = this._xScroll;
         var newScroll:Number = this.computeHorizontalScrollPosition(x,true);
         if(newScroll != oldScroll)
         {
            this._shapesInvalid = true;
            this._xScroll = newScroll;
            this.updateForScroll();
         }
      }
      
      private function computeHorizontalScrollPosition(x:Number, okToCompose:Boolean) : Number
      {
         var wmode:String = this.effectiveBlockProgression;
         var curEstimatedWidth:Number = this.contentWidth;
         var newScroll:Number = 0;
         if(Boolean(curEstimatedWidth > this._compositionWidth) && Boolean(!this._measureWidth))
         {
            if(wmode == BlockProgression.RL)
            {
               newScroll = pinValue(x,this._contentLeft + this._compositionWidth,this._contentLeft + curEstimatedWidth);
               if(Boolean(okToCompose) && Boolean(this._composeCompleteRatio != 1) && Boolean(newScroll != this._xScroll))
               {
                  this._xScroll = x;
                  if(this._xScroll > this._contentLeft + this._contentWidth)
                  {
                     this._xScroll = this._contentLeft + this._contentWidth;
                  }
                  this.flowComposer.composeToController(this.flowComposer.getControllerIndex(this));
                  newScroll = pinValue(x,this._contentLeft + this._compositionWidth,this._contentLeft + this._contentWidth);
               }
            }
            else
            {
               newScroll = pinValue(x,this._contentLeft,this._contentLeft + curEstimatedWidth - this._compositionWidth);
            }
         }
         return newScroll;
      }
      
      public function get verticalScrollPosition() : Number
      {
         return this._yScroll;
      }
      
      public function set verticalScrollPosition(y:Number) : void
      {
         if(!this._rootElement)
         {
            return;
         }
         if(this._verticalScrollPolicy == ScrollPolicy.OFF)
         {
            this._yScroll = 0;
            return;
         }
         var oldScroll:Number = this._yScroll;
         var newScroll:Number = this.computeVerticalScrollPosition(y,true);
         if(newScroll != oldScroll)
         {
            this._shapesInvalid = true;
            this._yScroll = newScroll;
            this.updateForScroll();
         }
      }
      
      private function computeVerticalScrollPosition(y:Number, okToCompose:Boolean) : Number
      {
         var newScroll:Number = 0;
         var curcontentHeight:Number = this.contentHeight;
         var wmode:String = this.effectiveBlockProgression;
         if(curcontentHeight > this._compositionHeight)
         {
            newScroll = pinValue(y,this._contentTop,this._contentTop + (curcontentHeight - this._compositionHeight));
            if(Boolean(okToCompose) && Boolean(this._composeCompleteRatio != 1) && Boolean(wmode == BlockProgression.TB))
            {
               this._yScroll = y;
               if(this._yScroll < this._contentTop)
               {
                  this._yScroll = this._contentTop;
               }
               this.flowComposer.composeToController(this.flowComposer.getControllerIndex(this));
               newScroll = pinValue(y,this._contentTop,this._contentTop + (curcontentHeight - this._compositionHeight));
            }
         }
         return newScroll;
      }
      
      public function getContentBounds() : Rectangle
      {
         return new Rectangle(this._contentLeft,this._contentTop,this.contentWidth,this.contentHeight);
      }
      
      tlf_internal function get contentLeft() : Number
      {
         return this._contentLeft;
      }
      
      tlf_internal function get contentTop() : Number
      {
         return this._contentTop;
      }
      
      tlf_internal function get contentHeight() : Number
      {
         return this.effectiveBlockProgression == BlockProgression.TB?Number(this._contentHeight * this._composeCompleteRatio):Number(this._contentHeight);
      }
      
      tlf_internal function get contentWidth() : Number
      {
         return this.effectiveBlockProgression == BlockProgression.RL?Number(this._contentWidth * this._composeCompleteRatio):Number(this._contentWidth);
      }
      
      tlf_internal function setContentBounds(contentLeft:Number, contentTop:Number, contentWidth:Number, contentHeight:Number) : void
      {
         this._contentWidth = contentWidth;
         this._contentHeight = contentHeight;
         this._contentLeft = contentLeft;
         this._contentTop = contentTop;
      }
      
      private function updateForScroll() : void
      {
         var flowComposer:IFlowComposer = this.textFlow.flowComposer;
         flowComposer.updateToController(flowComposer.getControllerIndex(this));
         this.attachTransparentBackgroundForHit(false);
         if(this.textFlow.hasEventListener(TextLayoutEvent.SCROLL))
         {
            this.textFlow.dispatchEvent(new TextLayoutEvent(TextLayoutEvent.SCROLL));
         }
      }
      
      private function get containerScrollRectLeft() : Number
      {
         var rslt:Number = NaN;
         if(Boolean(this.horizontalScrollPolicy == ScrollPolicy.OFF) && Boolean(this.verticalScrollPolicy == ScrollPolicy.OFF))
         {
            rslt = 0;
         }
         else
         {
            rslt = this.effectiveBlockProgression == BlockProgression.RL?Number(this.horizontalScrollPosition - this.compositionWidth):Number(this.horizontalScrollPosition);
         }
         return rslt;
      }
      
      private function get containerScrollRectRight() : Number
      {
         var rslt:Number = this.containerScrollRectLeft + this.compositionWidth;
         return rslt;
      }
      
      private function get containerScrollRectTop() : Number
      {
         var rslt:Number = NaN;
         if(Boolean(this.horizontalScrollPolicy == ScrollPolicy.OFF) && Boolean(this.verticalScrollPolicy == ScrollPolicy.OFF))
         {
            rslt = 0;
         }
         else
         {
            rslt = this.verticalScrollPosition;
         }
         return rslt;
      }
      
      private function get containerScrollRectBottom() : Number
      {
         var rslt:Number = this.containerScrollRectTop + this.compositionHeight;
         return rslt;
      }
      
      public function scrollToRange(activePosition:int, anchorPosition:int) : void
      {
         var nextLine:TextFlowLine = null;
         var lineEnd:int = 0;
         var lastVisibleLine:TextFlowLine = null;
         if(Boolean(!this._hasScrollRect) || Boolean(!this.flowComposer) || Boolean(this.flowComposer.getControllerAt(this.flowComposer.numControllers - 1) != this))
         {
            return;
         }
         var controllerStart:int = this.absoluteStart;
         var lastPosition:int = Math.min(controllerStart + this._textLength,this.textFlow.textLength - 1);
         activePosition = Math.max(controllerStart,Math.min(activePosition,lastPosition));
         anchorPosition = Math.max(controllerStart,Math.min(anchorPosition,lastPosition));
         var verticalText:Boolean = this.effectiveBlockProgression == BlockProgression.RL;
         var begPos:int = Math.min(activePosition,anchorPosition);
         var endPos:int = Math.max(activePosition,anchorPosition);
         var begLineIndex:int = this.flowComposer.findLineIndexAtPosition(begPos,begPos == this.textFlow.textLength);
         var endLineIndex:int = this.flowComposer.findLineIndexAtPosition(endPos,endPos == this.textFlow.textLength);
         var prevLine:TextFlowLine = begLineIndex == 0?null:this.flowComposer.getLineAt(begLineIndex - 1);
         var currLine:TextFlowLine = this.flowComposer.getLineAt(begLineIndex);
         var accumulatedIntersection:int = 0;
         var scrollRectLeft:Number = this.containerScrollRectLeft;
         var scrollRectTop:Number = this.containerScrollRectTop;
         var scrollRectRight:Number = this.containerScrollRectRight;
         var scrollRectBottom:Number = this.containerScrollRectBottom;
         var scrollRect:Rectangle = new Rectangle(scrollRectLeft,scrollRectTop,scrollRectRight - scrollRectLeft,scrollRectBottom - scrollRectTop);
         var lineIndex:int = begLineIndex;
         while(true)
         {
            if(lineIndex <= endLineIndex)
            {
               nextLine = lineIndex + 1 == this.flowComposer.numLines?null:this.flowComposer.getLineAt(lineIndex + 1);
               lineEnd = currLine.absoluteStart + currLine.textLength;
               if(currLine.controller == this)
               {
                  accumulatedIntersection = accumulatedIntersection + currLine.selectionWillIntersectScrollRect(scrollRect,begPos,Math.min(lineEnd,endPos),prevLine,nextLine);
                  if(accumulatedIntersection >= 2)
                  {
                     break;
                  }
               }
               if(lineIndex != endLineIndex)
               {
                  prevLine = currLine;
                  currLine = nextLine;
                  begPos = lineEnd;
                  lineIndex++;
                  continue;
               }
            }
            var rect:Rectangle = this.posToRectangle(activePosition);
            if(!rect)
            {
               this.flowComposer.composeToPosition(activePosition);
               rect = this.posToRectangle(activePosition);
            }
            if(rect)
            {
               if(rect.top < scrollRectTop)
               {
                  this.verticalScrollPosition = rect.top;
               }
               if(verticalText)
               {
                  if(rect.left < scrollRectLeft)
                  {
                     this.horizontalScrollPosition = rect.left + this._compositionWidth;
                  }
                  if(rect.right > scrollRectRight)
                  {
                     this.horizontalScrollPosition = rect.right;
                  }
                  if(this.flowComposer.findLineAtPosition(activePosition).absoluteStart != activePosition)
                  {
                     rect = this.posToRectangle(activePosition - 1);
                  }
                  if(activePosition == anchorPosition)
                  {
                     rect.bottom = rect.bottom + 2;
                  }
                  if(Boolean(rect) && Boolean(rect.bottom > scrollRectBottom))
                  {
                     this.verticalScrollPosition = rect.bottom - this._compositionHeight;
                  }
                  lastVisibleLine = this.getLastVisibleLine();
                  if(Boolean(lastVisibleLine) && Boolean(lastVisibleLine.x - lastVisibleLine.descent - lastVisibleLine.spaceAfter > scrollRectLeft))
                  {
                     this.horizontalScrollPosition = lastVisibleLine.x - lastVisibleLine.descent + this._compositionWidth;
                  }
               }
               else
               {
                  if(rect.bottom > scrollRectBottom)
                  {
                     this.verticalScrollPosition = rect.bottom - this._compositionHeight;
                  }
                  if(rect.left < scrollRectLeft)
                  {
                     this.horizontalScrollPosition = rect.left;
                  }
                  if(this.flowComposer.findLineAtPosition(activePosition).absoluteStart != activePosition)
                  {
                     rect = this.posToRectangle(activePosition - 1);
                  }
                  if(activePosition == anchorPosition)
                  {
                     rect.right = rect.right + 2;
                  }
                  if(Boolean(rect) && Boolean(rect.right > scrollRectRight))
                  {
                     this.horizontalScrollPosition = rect.right - this._compositionWidth;
                  }
                  lastVisibleLine = this.getLastVisibleLine();
                  if(Boolean(rect.top > scrollRectTop) && Boolean(lastVisibleLine) && Boolean(lastVisibleLine.y + lastVisibleLine.height + lastVisibleLine.spaceAfter < scrollRectBottom))
                  {
                     this.verticalScrollPosition = lastVisibleLine.y + lastVisibleLine.height;
                  }
               }
            }
            return;
         }
      }
      
      private function posToRectangle(pos:int) : Rectangle
      {
         var atomBounds:Rectangle = null;
         var leafElement:FlowLeafElement = null;
         var line:TextFlowLine = this.flowComposer.findLineAtPosition(pos);
         if(Boolean(!line.textLineExists) || Boolean(line.isDamaged()))
         {
            return null;
         }
         var textLine:TextLine = line.getTextLine(true);
         var atomIdx:int = textLine.getAtomIndexAtCharIndex(pos - line.paragraph.getAbsoluteStart());
         if(atomIdx > -1)
         {
            atomBounds = textLine.getAtomBounds(atomIdx);
         }
         if(this.effectiveBlockProgression == BlockProgression.RL)
         {
            leafElement = this._rootElement.getTextFlow().findLeaf(pos);
            if(leafElement.getParentByType(TCYElement) != null)
            {
               return new Rectangle(line.x + atomBounds.x + line.y + atomBounds.y + atomBounds.width,atomBounds.height);
            }
         }
         return this.effectiveBlockProgression == BlockProgression.RL?new Rectangle(line.x,line.y + atomBounds.y,line.height,atomBounds.height):new Rectangle(line.x + atomBounds.x,line.y - line.height + line.ascent,atomBounds.width,line.height + textLine.descent);
      }
      
      tlf_internal function resetColumnState() : void
      {
         if(this._rootElement)
         {
            this._columnState.updateInputs(this.effectiveBlockProgression,this._rootElement.computedFormat.direction,this,this._compositionWidth,this._compositionHeight);
         }
      }
      
      public function invalidateContents() : void
      {
         if(Boolean(this.textFlow) && Boolean(this._textLength))
         {
            this.textFlow.damage(this.absoluteStart,this._textLength,FlowDamageType.GEOMETRY,false);
         }
      }
      
      tlf_internal function attachTransparentBackgroundForHit(justClear:Boolean) : void
      {
         var s:Sprite = null;
         var bgwidth:Number = NaN;
         var bgheight:Number = NaN;
         var adjustHorizontalScroll:Boolean = false;
         var bgx:Number = NaN;
         var bgy:Number = NaN;
         if(Boolean(this._minListenersAttached) && Boolean(this.attachTransparentBackground))
         {
            s = this._container as Sprite;
            if(s)
            {
               if(justClear)
               {
                  s.graphics.clear();
                  this._transparentBGX = this._transparentBGY = this._transparentBGWidth = this._transparentBGHeight = NaN;
               }
               else
               {
                  bgwidth = !!this._measureWidth?Number(this._contentWidth):Number(this._compositionWidth);
                  bgheight = !!this._measureHeight?Number(this._contentHeight):Number(this._compositionHeight);
                  adjustHorizontalScroll = Boolean(this.effectiveBlockProgression == BlockProgression.RL) && Boolean(this._horizontalScrollPolicy != ScrollPolicy.OFF);
                  bgx = !!adjustHorizontalScroll?Number(this._xScroll - bgwidth):Number(this._xScroll);
                  bgy = this._yScroll;
                  if(Boolean(bgx != this._transparentBGX) || Boolean(bgy != this._transparentBGY) || Boolean(bgwidth != this._transparentBGWidth) || Boolean(bgheight != this._transparentBGHeight))
                  {
                     s.graphics.clear();
                     if(Boolean(bgwidth != 0) && Boolean(bgheight != 0))
                     {
                        s.graphics.beginFill(0,0);
                        s.graphics.drawRect(bgx,bgy,bgwidth,bgheight);
                        s.graphics.endFill();
                     }
                     this._transparentBGX = bgx;
                     this._transparentBGY = bgy;
                     this._transparentBGWidth = bgwidth;
                     this._transparentBGHeight = bgheight;
                  }
               }
            }
         }
      }
      
      tlf_internal function interactionManagerChanged(newInteractionManager:ISelectionManager) : void
      {
         if(newInteractionManager)
         {
            this.attachContainer();
         }
         else
         {
            this.detachContainer();
         }
      }
      
      tlf_internal function attachContainer() : void
      {
         if(Boolean(!this._minListenersAttached) && Boolean(this.textFlow) && Boolean(this.textFlow.interactionManager))
         {
            this._minListenersAttached = true;
            if(this._container)
            {
               this._container.addEventListener(FocusEvent.FOCUS_IN,this.requiredFocusInHandler);
               this._container.addEventListener(MouseEvent.MOUSE_OVER,this.requiredMouseOverHandler);
               this.attachTransparentBackgroundForHit(false);
               if(Boolean(this._container.stage) && Boolean(this._container.stage.focus == this._container))
               {
                  this.attachAllListeners();
               }
            }
         }
      }
      
      tlf_internal function attachInteractionHandlers() : void
      {
         var receiver:IInteractionEventHandler = this.getInteractionHandler();
         this._container.addEventListener(MouseEvent.MOUSE_DOWN,this.requiredMouseDownHandler);
         this._container.addEventListener(FocusEvent.FOCUS_OUT,this.requiredFocusOutHandler);
         this._container.addEventListener(MouseEvent.DOUBLE_CLICK,receiver.mouseDoubleClickHandler);
         this._container.addEventListener(Event.ACTIVATE,receiver.activateHandler);
         this._container.addEventListener(FocusEvent.MOUSE_FOCUS_CHANGE,receiver.focusChangeHandler);
         this._container.addEventListener(FocusEvent.KEY_FOCUS_CHANGE,receiver.focusChangeHandler);
         this._container.addEventListener(TextEvent.TEXT_INPUT,receiver.textInputHandler);
         this._container.addEventListener(MouseEvent.MOUSE_OUT,receiver.mouseOutHandler);
         this._container.addEventListener(MouseEvent.MOUSE_WHEEL,receiver.mouseWheelHandler);
         this._container.addEventListener(Event.DEACTIVATE,receiver.deactivateHandler);
         this._container.addEventListener("imeStartComposition",receiver.imeStartCompositionHandler);
         if(this._container.contextMenu)
         {
            this._container.contextMenu.addEventListener(ContextMenuEvent.MENU_SELECT,receiver.menuSelectHandler);
         }
         this._container.addEventListener(Event.COPY,receiver.editHandler);
         this._container.addEventListener(Event.SELECT_ALL,receiver.editHandler);
         this._container.addEventListener(Event.CUT,receiver.editHandler);
         this._container.addEventListener(Event.PASTE,receiver.editHandler);
         this._container.addEventListener(Event.CLEAR,receiver.editHandler);
      }
      
      tlf_internal function removeInteractionHandlers() : void
      {
         var receiver:IInteractionEventHandler = this.getInteractionHandler();
         this._container.removeEventListener(MouseEvent.MOUSE_DOWN,this.requiredMouseDownHandler);
         this._container.removeEventListener(FocusEvent.FOCUS_OUT,this.requiredFocusOutHandler);
         this._container.removeEventListener(MouseEvent.DOUBLE_CLICK,receiver.mouseDoubleClickHandler);
         this._container.removeEventListener(Event.ACTIVATE,receiver.activateHandler);
         this._container.removeEventListener(FocusEvent.MOUSE_FOCUS_CHANGE,receiver.focusChangeHandler);
         this._container.removeEventListener(FocusEvent.KEY_FOCUS_CHANGE,receiver.focusChangeHandler);
         this._container.removeEventListener(TextEvent.TEXT_INPUT,receiver.textInputHandler);
         this._container.removeEventListener(MouseEvent.MOUSE_OUT,receiver.mouseOutHandler);
         this._container.removeEventListener(MouseEvent.MOUSE_WHEEL,receiver.mouseWheelHandler);
         this._container.removeEventListener(Event.DEACTIVATE,receiver.deactivateHandler);
         this._container.removeEventListener("imeStartComposition",receiver.imeStartCompositionHandler);
         if(this._container.contextMenu)
         {
            this._container.contextMenu.removeEventListener(ContextMenuEvent.MENU_SELECT,receiver.menuSelectHandler);
         }
         this._container.removeEventListener(Event.COPY,receiver.editHandler);
         this._container.removeEventListener(Event.SELECT_ALL,receiver.editHandler);
         this._container.removeEventListener(Event.CUT,receiver.editHandler);
         this._container.removeEventListener(Event.PASTE,receiver.editHandler);
         this._container.removeEventListener(Event.CLEAR,receiver.editHandler);
         this.clearSelectHandlers();
      }
      
      tlf_internal function detachContainer() : void
      {
         if(this._minListenersAttached)
         {
            if(this._container)
            {
               this._container.removeEventListener(FocusEvent.FOCUS_IN,this.requiredFocusInHandler);
               this._container.removeEventListener(MouseEvent.MOUSE_OVER,this.requiredMouseOverHandler);
               if(this._allListenersAttached)
               {
                  this.removeInteractionHandlers();
                  this._container.contextMenu = null;
                  this.attachTransparentBackgroundForHit(true);
                  this._allListenersAttached = false;
               }
            }
            this._minListenersAttached = false;
         }
      }
      
      private function attachAllListeners() : void
      {
         if(Boolean(!this._allListenersAttached) && Boolean(this.textFlow) && Boolean(this.textFlow.interactionManager))
         {
            this._allListenersAttached = true;
            if(this._container)
            {
               this._container.contextMenu = this.createContextMenu();
               this.attachInteractionHandlers();
            }
         }
      }
      
      protected function createContextMenu() : ContextMenu
      {
         return createDefaultContextMenu();
      }
      
      tlf_internal function scrollTimerHandler(event:Event) : void
      {
         var containerPoint:Point = null;
         var scrollChange:int = 0;
         var mouseEvent:MouseEvent = null;
         var stashedScrollTimer:Timer = null;
         if(!this._scrollTimer)
         {
            return;
         }
         if(Boolean(this.textFlow.interactionManager == null) || Boolean(this.textFlow.interactionManager.activePosition < this.absoluteStart) || Boolean(this.textFlow.interactionManager.activePosition > this.absoluteStart + this.textLength))
         {
            var event:Event = null;
         }
         if(event is MouseEvent)
         {
            this._scrollTimer.stop();
            this._scrollTimer.removeEventListener(TimerEvent.TIMER,this.scrollTimerHandler);
            event.currentTarget.removeEventListener(MouseEvent.MOUSE_UP,this.scrollTimerHandler);
            this._scrollTimer = null;
         }
         else if(!event)
         {
            this._scrollTimer.stop();
            this._scrollTimer.removeEventListener(TimerEvent.TIMER,this.scrollTimerHandler);
            if(this.getContainerRoot())
            {
               this.getContainerRoot().removeEventListener(MouseEvent.MOUSE_UP,this.scrollTimerHandler);
            }
            this._scrollTimer = null;
         }
         else if(this._container.stage)
         {
            containerPoint = new Point(this._container.stage.mouseX,this._container.stage.mouseY);
            containerPoint = this._container.globalToLocal(containerPoint);
            scrollChange = this.autoScrollIfNecessaryInternal(containerPoint);
            if(Boolean(scrollChange != 0) && Boolean(this.interactionManager))
            {
               mouseEvent = new PsuedoMouseEvent(MouseEvent.MOUSE_MOVE,false,false,this._container.stage.mouseX,this._container.stage.mouseY,this._container.stage,false,false,false,true);
               stashedScrollTimer = this._scrollTimer;
               try
               {
                  this._scrollTimer = null;
                  this.interactionManager.mouseMoveHandler(mouseEvent);
               }
               catch(e:Error)
               {
                  throw e;
               }
               finally
               {
                  this._scrollTimer = stashedScrollTimer;
               }
            }
         }
      }
      
      public function autoScrollIfNecessary(mouseX:int, mouseY:int) : void
      {
         var verticalText:Boolean = false;
         var lastController:ContainerController = null;
         var r:Rectangle = null;
         if(this.flowComposer.getControllerAt(this.flowComposer.numControllers - 1) != this)
         {
            verticalText = this.effectiveBlockProgression == BlockProgression.RL;
            lastController = this.flowComposer.getControllerAt(this.flowComposer.numControllers - 1);
            if(Boolean(verticalText) && Boolean(this._horizontalScrollPolicy == ScrollPolicy.OFF) || Boolean(!verticalText) && Boolean(this._verticalScrollPolicy == ScrollPolicy.OFF))
            {
               return;
            }
            r = lastController.container.getBounds(this._container.stage);
            if(verticalText)
            {
               if(Boolean(mouseY >= r.top) && Boolean(mouseY <= r.bottom))
               {
                  lastController.autoScrollIfNecessary(mouseX,mouseY);
               }
            }
            else if(Boolean(mouseX >= r.left) && Boolean(mouseX <= r.right))
            {
               lastController.autoScrollIfNecessary(mouseX,mouseY);
            }
         }
         if(!this._hasScrollRect)
         {
            return;
         }
         var containerPoint:Point = new Point(mouseX,mouseY);
         containerPoint = this._container.globalToLocal(containerPoint);
         this.autoScrollIfNecessaryInternal(containerPoint);
      }
      
      private function autoScrollIfNecessaryInternal(extreme:Point) : int
      {
         var scrollDirection:int = 0;
         if(extreme.y - this.containerScrollRectBottom > 0)
         {
            this.verticalScrollPosition = this.verticalScrollPosition + this.textFlow.configuration.scrollDragPixels;
            scrollDirection = 1;
         }
         else if(extreme.y - this.containerScrollRectTop < 0)
         {
            this.verticalScrollPosition = this.verticalScrollPosition - this.textFlow.configuration.scrollDragPixels;
            scrollDirection = -1;
         }
         if(extreme.x - this.containerScrollRectRight > 0)
         {
            this.horizontalScrollPosition = this.horizontalScrollPosition + this.textFlow.configuration.scrollDragPixels;
            scrollDirection = -1;
         }
         else if(extreme.x - this.containerScrollRectLeft < 0)
         {
            this.horizontalScrollPosition = this.horizontalScrollPosition - this.textFlow.configuration.scrollDragPixels;
            scrollDirection = 1;
         }
         if(Boolean(scrollDirection != 0) && Boolean(!this._scrollTimer))
         {
            this._scrollTimer = new Timer(this.textFlow.configuration.scrollDragDelay);
            this._scrollTimer.addEventListener(TimerEvent.TIMER,this.scrollTimerHandler,false,0,true);
            if(this.getContainerRoot())
            {
               this.getContainerRoot().addEventListener(MouseEvent.MOUSE_UP,this.scrollTimerHandler,false,0,true);
               this.beginMouseCapture();
            }
            this._scrollTimer.start();
         }
         return scrollDirection;
      }
      
      tlf_internal function getFirstVisibleLine() : TextFlowLine
      {
         return Boolean(this._shapeChildren.length)?this._shapeChildren[0].userData:null;
      }
      
      tlf_internal function getLastVisibleLine() : TextFlowLine
      {
         return Boolean(this._shapeChildren.length)?this._shapeChildren[this._shapeChildren.length - 1].userData:null;
      }
      
      public function getScrollDelta(numLines:int) : Number
      {
         var newLineIndex:int = 0;
         var lineIndex:int = 0;
         var newScrollPosition:Number = NaN;
         var lastTextLine:TextLine = null;
         var leaf:FlowLeafElement = null;
         var paragraph:ParagraphElement = null;
         if(this.flowComposer.numLines == 0)
         {
            return 0;
         }
         var firstVisibleLine:TextFlowLine = this.getFirstVisibleLine();
         var lastVisibleLine:TextFlowLine = this.getLastVisibleLine();
         if(numLines > 0)
         {
            lineIndex = this.flowComposer.findLineIndexAtPosition(lastVisibleLine.absoluteStart);
            if(lastVisibleLine)
            {
               lastTextLine = lastVisibleLine.getTextLine(true);
               if(this.effectiveBlockProgression == BlockProgression.TB)
               {
                  if(lastTextLine.y + lastTextLine.descent - this.containerScrollRectBottom > 2)
                  {
                     lineIndex--;
                  }
               }
               else if(this.containerScrollRectLeft - (lastTextLine.x - lastTextLine.descent) > 2)
               {
                  lineIndex--;
               }
            }
            while(Boolean(lineIndex + numLines > this.flowComposer.numLines - 1) && Boolean(this.flowComposer.damageAbsoluteStart < this.textFlow.textLength))
            {
               this.flowComposer.composeToPosition(this.flowComposer.damageAbsoluteStart + 1000);
            }
            newLineIndex = Math.min(this.flowComposer.numLines - 1,lineIndex + numLines);
         }
         if(numLines < 0)
         {
            lineIndex = this.flowComposer.findLineIndexAtPosition(firstVisibleLine.absoluteStart);
            if(firstVisibleLine)
            {
               if(this.effectiveBlockProgression == BlockProgression.TB)
               {
                  if(firstVisibleLine.y + 2 < this.containerScrollRectTop)
                  {
                     lineIndex++;
                  }
               }
               else if(firstVisibleLine.x + firstVisibleLine.ascent > this.containerScrollRectRight + 2)
               {
                  lineIndex++;
               }
            }
            newLineIndex = Math.max(0,lineIndex + numLines);
         }
         var line:TextFlowLine = this.flowComposer.getLineAt(newLineIndex);
         if(line.absoluteStart < this.absoluteStart)
         {
            return 0;
         }
         if(line.validity != TextLineValidity.VALID)
         {
            leaf = this.textFlow.findLeaf(line.absoluteStart);
            paragraph = leaf.getParagraph();
            this.textFlow.flowComposer.composeToPosition(paragraph.getAbsoluteStart() + paragraph.textLength);
            line = this.flowComposer.getLineAt(newLineIndex);
         }
         var verticalText:Boolean = this.effectiveBlockProgression == BlockProgression.RL;
         if(verticalText)
         {
            newScrollPosition = numLines < 0?Number(line.x + line.textHeight):Number(line.x - line.descent + this._compositionWidth);
            return newScrollPosition - this.horizontalScrollPosition;
         }
         newScrollPosition = numLines < 0?Number(line.y):Number(line.y + line.textHeight - this._compositionHeight);
         return newScrollPosition - this.verticalScrollPosition;
      }
      
      public function mouseOverHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.mouseOverHandler(event);
         }
      }
      
      tlf_internal function requiredMouseOverHandler(event:MouseEvent) : void
      {
         this.attachAllListeners();
         this.getInteractionHandler().mouseOverHandler(event);
      }
      
      public function mouseOutHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.mouseOutHandler(event);
         }
      }
      
      public function mouseWheelHandler(event:MouseEvent) : void
      {
         var verticalText:Boolean = this.effectiveBlockProgression == BlockProgression.RL;
         if(verticalText)
         {
            if(Boolean(this.contentWidth > this._compositionWidth) && Boolean(!this._measureWidth))
            {
               this.horizontalScrollPosition = this.horizontalScrollPosition + event.delta * this.textFlow.configuration.scrollMouseWheelMultiplier;
               event.preventDefault();
            }
         }
         else if(Boolean(this.contentHeight > this._compositionHeight) && Boolean(!this._measureHeight))
         {
            this.verticalScrollPosition = this.verticalScrollPosition - event.delta * this.textFlow.configuration.scrollMouseWheelMultiplier;
            event.preventDefault();
         }
      }
      
      public function mouseDownHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.mouseDownHandler(event);
            if(this.interactionManager.hasSelection())
            {
               this.setFocus();
            }
         }
      }
      
      tlf_internal function requiredMouseDownHandler(event:MouseEvent) : void
      {
         var containerRoot:DisplayObject = null;
         if(!this._selectListenersAttached)
         {
            containerRoot = this.getContainerRoot();
            if(containerRoot)
            {
               containerRoot.addEventListener(MouseEvent.MOUSE_MOVE,this.rootMouseMoveHandler,false,0,true);
               containerRoot.addEventListener(MouseEvent.MOUSE_UP,this.rootMouseUpHandler,false,0,true);
               this.beginMouseCapture();
               this._selectListenersAttached = true;
            }
         }
         this.getInteractionHandler().mouseDownHandler(event);
      }
      
      public function mouseUpHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.mouseUpHandler(event);
         }
      }
      
      tlf_internal function rootMouseUpHandler(event:MouseEvent) : void
      {
         this.clearSelectHandlers();
         this.getInteractionHandler().mouseUpHandler(event);
      }
      
      private function clearSelectHandlers() : void
      {
         if(this._selectListenersAttached)
         {
            this.getContainerRoot().removeEventListener(MouseEvent.MOUSE_MOVE,this.rootMouseMoveHandler);
            this.getContainerRoot().removeEventListener(MouseEvent.MOUSE_UP,this.rootMouseUpHandler);
            this.endMouseCapture();
            this._selectListenersAttached = false;
         }
      }
      
      public function beginMouseCapture() : void
      {
         var sandboxManager:ISandboxSupport = this.getInteractionHandler() as ISandboxSupport;
         if(Boolean(sandboxManager) && Boolean(sandboxManager != this))
         {
            sandboxManager.beginMouseCapture();
         }
      }
      
      public function endMouseCapture() : void
      {
         var sandboxManager:ISandboxSupport = this.getInteractionHandler() as ISandboxSupport;
         if(Boolean(sandboxManager) && Boolean(sandboxManager != this))
         {
            sandboxManager.endMouseCapture();
         }
      }
      
      public function mouseUpSomewhere(event:Event) : void
      {
         this.rootMouseUpHandler(null);
         this.scrollTimerHandler(null);
      }
      
      public function mouseMoveSomewhere(event:Event) : void
      {
      }
      
      private function hitOnMyFlowExceptLastContainer(event:MouseEvent) : Boolean
      {
         var tfl:TextFlowLine = null;
         var para:ParagraphElement = null;
         var idx:int = 0;
         if(event.target is TextLine)
         {
            tfl = TextLine(event.target).userData as TextFlowLine;
            if(tfl)
            {
               para = tfl.paragraph;
               if(para.getTextFlow() == this.textFlow)
               {
                  return true;
               }
            }
         }
         else if(event.target is Sprite)
         {
            for(idx = 0; idx < this.textFlow.flowComposer.numControllers - 1; idx++)
            {
               if(this.textFlow.flowComposer.getControllerAt(idx).container == event.target)
               {
                  return true;
               }
            }
         }
         return false;
      }
      
      public function mouseMoveHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            if(Boolean(event.buttonDown) && Boolean(!this.hitOnMyFlowExceptLastContainer(event)))
            {
               this.autoScrollIfNecessary(event.stageX,event.stageY);
            }
            this.interactionManager.mouseMoveHandler(event);
         }
      }
      
      tlf_internal function rootMouseMoveHandler(event:MouseEvent) : void
      {
         this.getInteractionHandler().mouseMoveHandler(event);
      }
      
      public function mouseDoubleClickHandler(event:MouseEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.mouseDoubleClickHandler(event);
            if(this.interactionManager.hasSelection())
            {
               this.setFocus();
            }
         }
      }
      
      tlf_internal function setFocus() : void
      {
         if(this._container.stage)
         {
            this._container.stage.focus = this._container;
         }
      }
      
      tlf_internal function getContainerController(container:DisplayObject) : ContainerController
      {
         var flowComposer:IFlowComposer = null;
         var i:int = 0;
         var controller:ContainerController = null;
         try
         {
            while(container)
            {
               flowComposer = this.flowComposer;
               for(i = 0; i < flowComposer.numControllers; i++)
               {
                  controller = flowComposer.getControllerAt(i);
                  if(controller.container == container)
                  {
                     return controller;
                  }
               }
               var container:DisplayObject = container.parent;
            }
         }
         catch(e:Error)
         {
         }
         return null;
      }
      
      public function focusChangeHandler(event:FocusEvent) : void
      {
         var focusController:ContainerController = this.getContainerController(DisplayObject(event.target));
         var newFocusController:ContainerController = this.getContainerController(event.relatedObject);
         if(newFocusController == focusController)
         {
            event.preventDefault();
         }
      }
      
      public function focusInHandler(event:FocusEvent) : void
      {
         var blinkRate:int = 0;
         if(this.interactionManager)
         {
            this.interactionManager.focusInHandler(event);
            if(this.interactionManager.editingMode == EditingMode.READ_WRITE)
            {
               blinkRate = this.interactionManager.focusedSelectionFormat.pointBlinkRate;
            }
         }
         this.setBlinkInterval(blinkRate);
      }
      
      tlf_internal function requiredFocusInHandler(event:FocusEvent) : void
      {
         this.attachAllListeners();
         this._container.addEventListener(KeyboardEvent.KEY_DOWN,this.getInteractionHandler().keyDownHandler);
         this._container.addEventListener(KeyboardEvent.KEY_UP,this.getInteractionHandler().keyUpHandler);
         this._container.addEventListener(FocusEvent.KEY_FOCUS_CHANGE,this.getInteractionHandler().keyFocusChangeHandler);
         this.getInteractionHandler().focusInHandler(event);
      }
      
      public function focusOutHandler(event:FocusEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.focusOutHandler(event);
            this.setBlinkInterval(this.interactionManager.unfocusedSelectionFormat.pointBlinkRate);
         }
         else
         {
            this.setBlinkInterval(0);
         }
      }
      
      tlf_internal function requiredFocusOutHandler(event:FocusEvent) : void
      {
         this._container.removeEventListener(KeyboardEvent.KEY_DOWN,this.getInteractionHandler().keyDownHandler);
         this._container.removeEventListener(KeyboardEvent.KEY_UP,this.getInteractionHandler().keyUpHandler);
         this._container.removeEventListener(FocusEvent.KEY_FOCUS_CHANGE,this.getInteractionHandler().keyFocusChangeHandler);
         this.getInteractionHandler().focusOutHandler(event);
      }
      
      public function activateHandler(event:Event) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.activateHandler(event);
         }
      }
      
      public function deactivateHandler(event:Event) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.deactivateHandler(event);
         }
      }
      
      public function keyDownHandler(event:KeyboardEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.keyDownHandler(event);
         }
      }
      
      public function keyUpHandler(event:KeyboardEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.keyUpHandler(event);
         }
      }
      
      public function keyFocusChangeHandler(event:FocusEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.keyFocusChangeHandler(event);
         }
      }
      
      public function textInputHandler(event:TextEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.textInputHandler(event);
         }
      }
      
      public function imeStartCompositionHandler(event:IMEEvent) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.imeStartCompositionHandler(event);
         }
      }
      
      public function menuSelectHandler(event:ContextMenuEvent) : void
      {
         var cbItems:ContextMenuClipboardItems = null;
         var tf:DisplayObjectContainer = this._container as DisplayObjectContainer;
         if(this.interactionManager)
         {
            this.interactionManager.menuSelectHandler(event);
         }
         else
         {
            cbItems = tf.contextMenu.clipboardItems;
            cbItems.copy = false;
            cbItems.cut = false;
            cbItems.paste = false;
            cbItems.selectAll = false;
            cbItems.clear = false;
         }
      }
      
      public function editHandler(event:Event) : void
      {
         if(this.interactionManager)
         {
            this.interactionManager.editHandler(event);
         }
         var contextMenu:ContextMenu = this._container.contextMenu;
         if(contextMenu)
         {
            contextMenu.clipboardItems.clear = true;
            contextMenu.clipboardItems.copy = true;
            contextMenu.clipboardItems.cut = true;
            contextMenu.clipboardItems.paste = true;
            contextMenu.clipboardItems.selectAll = true;
         }
      }
      
      public function selectRange(anchorIndex:int, activeIndex:int) : void
      {
         if(Boolean(this.interactionManager) && Boolean(this.interactionManager.editingMode != EditingMode.READ_ONLY))
         {
            this.interactionManager.selectRange(anchorIndex,activeIndex);
         }
      }
      
      private function startBlinkingCursor(obj:DisplayObject, blinkInterval:int) : void
      {
         if(!this.blinkTimer)
         {
            this.blinkTimer = new Timer(blinkInterval,0);
         }
         this.blinkObject = obj;
         this.blinkTimer.addEventListener(TimerEvent.TIMER,this.blinkTimerHandler,false,0,true);
         this.blinkTimer.start();
      }
      
      protected function stopBlinkingCursor() : void
      {
         if(this.blinkTimer)
         {
            this.blinkTimer.stop();
         }
         this.blinkObject = null;
      }
      
      private function blinkTimerHandler(event:TimerEvent) : void
      {
         this.blinkObject.alpha = this.blinkObject.alpha == 1?Number(0):Number(1);
      }
      
      protected function setBlinkInterval(intervalMS:int) : void
      {
         var blinkInterval:int = intervalMS;
         if(blinkInterval == 0)
         {
            if(this.blinkTimer)
            {
               this.blinkTimer.stop();
            }
            if(this.blinkObject)
            {
               this.blinkObject.alpha = 1;
            }
         }
         else if(this.blinkTimer)
         {
            this.blinkTimer.delay = blinkInterval;
            if(this.blinkObject)
            {
               this.blinkTimer.start();
            }
         }
      }
      
      tlf_internal function drawPointSelection(selFormat:SelectionFormat, x:Number, y:Number, w:Number, h:Number) : void
      {
         var selObj:Shape = new Shape();
         if(this.interactionManager.activePosition == this.interactionManager.anchorPosition)
         {
            selObj.graphics.beginFill(selFormat.pointColor);
         }
         else
         {
            selObj.graphics.beginFill(selFormat.rangeColor);
         }
         if(this._hasScrollRect)
         {
            if(this.effectiveBlockProgression == BlockProgression.TB)
            {
               if(x >= this.containerScrollRectRight)
               {
                  x = x - w;
               }
            }
            else if(y >= this.containerScrollRectBottom)
            {
               y = y - h;
            }
         }
         selObj.graphics.drawRect(int(x),int(y),w,h);
         selObj.graphics.endFill();
         if(Boolean(selFormat.pointBlinkRate != 0) && Boolean(this.interactionManager.editingMode == EditingMode.READ_WRITE))
         {
            this.startBlinkingCursor(selObj,selFormat.pointBlinkRate);
         }
         this.addSelectionChild(selObj);
      }
      
      tlf_internal function addSelectionShapes(selFormat:SelectionFormat, selectionAbsoluteStart:int, selectionAbsoluteEnd:int) : void
      {
         var prevLine:TextFlowLine = null;
         var nextLine:TextFlowLine = null;
         var absoluteControllerStart:int = 0;
         var absoluteControllerEnd:int = 0;
         var begLine:int = 0;
         var endLine:int = 0;
         var selObj:Shape = null;
         var line:TextFlowLine = null;
         var idx:int = 0;
         var temp:TextFlowLine = null;
         var lineIdx:int = 0;
         if(Boolean(!this.interactionManager) || Boolean(this._textLength == 0) || Boolean(selectionAbsoluteStart == -1) || Boolean(selectionAbsoluteEnd == -1))
         {
            return;
         }
         if(selectionAbsoluteStart != selectionAbsoluteEnd)
         {
            absoluteControllerStart = this.absoluteStart;
            absoluteControllerEnd = this.absoluteStart + this._textLength;
            if(selectionAbsoluteStart < absoluteControllerStart)
            {
               selectionAbsoluteStart = absoluteControllerStart;
            }
            else if(selectionAbsoluteStart >= absoluteControllerEnd)
            {
               return;
            }
            if(selectionAbsoluteEnd > absoluteControllerEnd)
            {
               selectionAbsoluteEnd = absoluteControllerEnd;
            }
            else if(selectionAbsoluteEnd < absoluteControllerStart)
            {
               return;
            }
            begLine = this.flowComposer.findLineIndexAtPosition(selectionAbsoluteStart);
            endLine = selectionAbsoluteStart == selectionAbsoluteEnd?int(begLine):int(this.flowComposer.findLineIndexAtPosition(selectionAbsoluteEnd));
            if(endLine >= this.flowComposer.numLines)
            {
               endLine = this.flowComposer.numLines - 1;
            }
            selObj = new Shape();
            prevLine = Boolean(begLine)?this.flowComposer.getLineAt(begLine - 1):null;
            line = this.flowComposer.getLineAt(begLine);
            for(idx = begLine; idx <= endLine; idx++)
            {
               nextLine = idx != this.flowComposer.numLines - 1?this.flowComposer.getLineAt(idx + 1):null;
               line.hiliteBlockSelection(selObj,selFormat,DisplayObject(this._container),selectionAbsoluteStart < line.absoluteStart?int(line.absoluteStart):int(selectionAbsoluteStart),selectionAbsoluteEnd > line.absoluteStart + line.textLength?int(line.absoluteStart + line.textLength):int(selectionAbsoluteEnd),prevLine,nextLine);
               temp = line;
               line = nextLine;
               prevLine = temp;
            }
            this.addSelectionChild(selObj);
         }
         else
         {
            lineIdx = this.flowComposer.findLineIndexAtPosition(selectionAbsoluteStart);
            if(lineIdx == this.flowComposer.numLines)
            {
               lineIdx--;
            }
            if(this.flowComposer.getLineAt(lineIdx).controller == this)
            {
               prevLine = lineIdx != 0?this.flowComposer.getLineAt(lineIdx - 1):null;
               nextLine = lineIdx != this.flowComposer.numLines - 1?this.flowComposer.getLineAt(lineIdx + 1):null;
               this.flowComposer.getLineAt(lineIdx).hilitePointSelection(selFormat,selectionAbsoluteStart,DisplayObject(this._container),prevLine,nextLine);
            }
         }
      }
      
      tlf_internal function clearSelectionShapes() : void
      {
         this.stopBlinkingCursor();
         var selectionSprite:DisplayObjectContainer = this.getSelectionSprite(false);
         if(selectionSprite != null)
         {
            if(selectionSprite.parent)
            {
               this.removeSelectionContainer(selectionSprite);
            }
            while(selectionSprite.numChildren > 0)
            {
               selectionSprite.removeChildAt(0);
            }
            return;
         }
      }
      
      tlf_internal function addSelectionChild(child:DisplayObject) : void
      {
         var selectionSprite:DisplayObjectContainer = this.getSelectionSprite(true);
         if(selectionSprite == null)
         {
            return;
         }
         var selFormat:SelectionFormat = this.interactionManager.currentSelectionFormat;
         var curBlendMode:String = this.interactionManager.activePosition == this.interactionManager.anchorPosition?selFormat.pointBlendMode:selFormat.rangeBlendMode;
         var curAlpha:Number = this.interactionManager.activePosition == this.interactionManager.anchorPosition?Number(selFormat.pointAlpha):Number(selFormat.rangeAlpha);
         if(selectionSprite.blendMode != curBlendMode)
         {
            selectionSprite.blendMode = curBlendMode;
         }
         if(selectionSprite.alpha != curAlpha)
         {
            selectionSprite.alpha = curAlpha;
         }
         if(selectionSprite.numChildren == 0)
         {
            this.addSelectionContainer(selectionSprite);
         }
         selectionSprite.addChild(child);
      }
      
      tlf_internal function containsSelectionChild(child:DisplayObject) : Boolean
      {
         var selectionSprite:DisplayObjectContainer = this.getSelectionSprite(false);
         if(selectionSprite == null)
         {
            return false;
         }
         return selectionSprite.contains(child);
      }
      
      tlf_internal function getBackgroundShape() : Shape
      {
         if(!this._backgroundShape)
         {
            this._backgroundShape = new Shape();
            this.addBackgroundShape(this._backgroundShape);
         }
         return this._backgroundShape;
      }
      
      tlf_internal function get effectivePaddingLeft() : Number
      {
         return this.computedFormat.paddingLeft + (Boolean(this._rootElement)?this._rootElement.computedFormat.paddingLeft:0);
      }
      
      tlf_internal function get effectivePaddingRight() : Number
      {
         return this.computedFormat.paddingRight + (Boolean(this._rootElement)?this._rootElement.computedFormat.paddingRight:0);
      }
      
      tlf_internal function get effectivePaddingTop() : Number
      {
         return this.computedFormat.paddingTop + (Boolean(this._rootElement)?this._rootElement.computedFormat.paddingTop:0);
      }
      
      tlf_internal function get effectivePaddingBottom() : Number
      {
         return this.computedFormat.paddingBottom + (Boolean(this._rootElement)?this._rootElement.computedFormat.paddingBottom:0);
      }
      
      tlf_internal function getSelectionSprite(createIfNull:Boolean) : DisplayObjectContainer
      {
         if(Boolean(this._selectionSprite == null) && Boolean(createIfNull))
         {
            this._selectionSprite = new Sprite();
            this._selectionSprite.mouseEnabled = false;
            this._selectionSprite.mouseChildren = false;
         }
         return this._selectionSprite;
      }
      
      protected function get attachTransparentBackground() : Boolean
      {
         return true;
      }
      
      tlf_internal function clearCompositionResults() : void
      {
         var textLine:TextLine = null;
         this.setTextLength(0);
         for each(textLine in this._shapeChildren)
         {
            this.removeTextLine(textLine);
         }
         this._shapeChildren.length = 0;
      }
      
      tlf_internal function updateCompositionShapes() : void
      {
         var newChild:TextLine = null;
         var newChildIdx:int = 0;
         if(!this.shapesInvalid)
         {
            return;
         }
         var scrolled:Boolean = false;
         var tmp:Number = this._yScroll;
         if(Boolean(this.verticalScrollPolicy != ScrollPolicy.OFF) && Boolean(!this._measureHeight))
         {
            this._yScroll = this.computeVerticalScrollPosition(this._yScroll,false);
         }
         scrolled = tmp != this._yScroll;
         tmp = this._xScroll;
         if(Boolean(this.horizontalScrollPolicy != ScrollPolicy.OFF) && Boolean(!this._measureWidth))
         {
            this._xScroll = this.computeHorizontalScrollPosition(this._xScroll,false);
         }
         scrolled = Boolean(scrolled) || Boolean(tmp != this._xScroll);
         var newShapeChildren:Array = [];
         this.fillShapeChildren(newShapeChildren,tempLineHolder);
         var childIdx:int = this.getFirstTextLineChildIndex();
         var oldIdx:int = 0;
         var newIdx:int = 0;
         while(newIdx != newShapeChildren.length)
         {
            newChild = newShapeChildren[newIdx];
            if(newChild == this._shapeChildren[oldIdx])
            {
               childIdx++;
               newIdx++;
               oldIdx++;
            }
            else
            {
               newChildIdx = this._shapeChildren.indexOf(newChild);
               if(newChildIdx == -1)
               {
                  this.addTextLine(newChild,childIdx++);
                  newIdx++;
               }
               else
               {
                  this.removeAndRecycleTextLines(oldIdx,newChildIdx);
                  oldIdx = newChildIdx;
               }
            }
         }
         this.removeAndRecycleTextLines(oldIdx,this._shapeChildren.length);
         this._shapeChildren = newShapeChildren;
         this.shapesInvalid = false;
         this.updateInlineChildren();
         this.updateVisibleRectangle();
         if(Boolean(this._measureWidth) || Boolean(this._measureHeight))
         {
            this.attachTransparentBackgroundForHit(false);
         }
         var tf:TextFlow = this.textFlow;
         if(tf.backgroundManager)
         {
            tf.backgroundManager.onUpdateComplete(this);
         }
         if(Boolean(scrolled) && Boolean(tf.hasEventListener(TextLayoutEvent.SCROLL)))
         {
            tf.dispatchEvent(new TextLayoutEvent(TextLayoutEvent.SCROLL));
         }
         if(tf.hasEventListener(UpdateCompleteEvent.UPDATE_COMPLETE))
         {
            tf.dispatchEvent(new UpdateCompleteEvent(UpdateCompleteEvent.UPDATE_COMPLETE,false,false,tf,this));
         }
         while(tempLineHolder.numChildren)
         {
            tempLineHolder.removeChildAt(0);
         }
      }
      
      private function removeAndRecycleTextLines(beginIndex:int, endIndex:int) : void
      {
         var child:TextLine = null;
         var backgroundManager:BackgroundManager = this.textFlow.backgroundManager;
         while(beginIndex < endIndex)
         {
            child = this._shapeChildren[beginIndex++];
            this.removeTextLine(child);
            if(Boolean(TextLineRecycler.textLineRecyclerEnabled) && Boolean(!child.parent))
            {
               if(child.userData == null)
               {
                  TextLineRecycler.addLineForReuse(child);
                  if(backgroundManager)
                  {
                     backgroundManager.removeLineFromCache(child);
                  }
               }
               else if(child.validity == TextLineValidity.INVALID)
               {
                  if(Boolean(child.nextLine == null) && Boolean(child.previousLine == null) && (Boolean(!child.textBlock) || Boolean(child.textBlock.firstLine != child)))
                  {
                     child.userData.releaseTextLine();
                     child.userData = null;
                     TextLineRecycler.addLineForReuse(child);
                     if(backgroundManager)
                     {
                        backgroundManager.removeLineFromCache(child);
                     }
                  }
               }
            }
         }
      }
      
      protected function getFirstTextLineChildIndex() : int
      {
         var firstTextLine:int = 0;
         for(firstTextLine = 0; firstTextLine < this._container.numChildren; firstTextLine++)
         {
            if(this._container.getChildAt(firstTextLine) is TextLine)
            {
               break;
            }
         }
         return firstTextLine;
      }
      
      protected function addTextLine(textLine:TextLine, index:int) : void
      {
         this._container.addChildAt(textLine,index);
      }
      
      protected function removeTextLine(textLine:TextLine) : void
      {
         if(this._container.contains(textLine))
         {
            this._container.removeChild(textLine);
         }
      }
      
      protected function addBackgroundShape(shape:Shape) : void
      {
         this._container.addChildAt(this._backgroundShape,this.getFirstTextLineChildIndex());
      }
      
      protected function addSelectionContainer(selectionContainer:DisplayObjectContainer) : void
      {
         if(Boolean(selectionContainer.blendMode == BlendMode.NORMAL) && Boolean(selectionContainer.alpha == 1))
         {
            this._container.addChildAt(selectionContainer,this.getFirstTextLineChildIndex());
         }
         else
         {
            this._container.addChild(selectionContainer);
         }
      }
      
      protected function removeSelectionContainer(selectionContainer:DisplayObjectContainer) : void
      {
         selectionContainer.parent.removeChild(selectionContainer);
      }
      
      tlf_internal function get textLines() : Array
      {
         return this._shapeChildren;
      }
      
      protected function updateVisibleRectangle() : void
      {
         var contentRight:Number = NaN;
         var contentBottom:Number = NaN;
         var width:Number = NaN;
         var compositionRight:Number = NaN;
         var height:Number = NaN;
         var compositionBottom:Number = NaN;
         var xOrigin:Number = NaN;
         var xpos:int = 0;
         var ypos:int = 0;
         var rect:Rectangle = null;
         if(Boolean(this.horizontalScrollPolicy == ScrollPolicy.OFF) && Boolean(this.verticalScrollPolicy == ScrollPolicy.OFF))
         {
            if(this._hasScrollRect)
            {
               this._container.scrollRect = null;
               this._hasScrollRect = false;
            }
         }
         else
         {
            contentRight = this._contentLeft + this.contentWidth;
            contentBottom = this._contentTop + this.contentHeight;
            if(this._measureWidth)
            {
               width = this.contentWidth;
               compositionRight = this._contentLeft + width;
            }
            else
            {
               width = this._compositionWidth;
               compositionRight = width;
            }
            if(this._measureHeight)
            {
               height = this.contentHeight;
               compositionBottom = this._contentTop + height;
            }
            else
            {
               height = this._compositionHeight;
               compositionBottom = height;
            }
            xOrigin = this.effectiveBlockProgression == BlockProgression.RL?Number(-width):Number(0);
            xpos = this.horizontalScrollPosition + xOrigin;
            ypos = this.verticalScrollPosition;
            if(Boolean(this.textLength == 0) || Boolean(xpos == 0) && Boolean(ypos == 0) && Boolean(this._contentLeft >= xOrigin) && Boolean(this._contentTop >= 0) && Boolean(contentRight <= compositionRight) && Boolean(contentBottom <= compositionBottom))
            {
               if(this._hasScrollRect)
               {
                  this._container.scrollRect = null;
                  this._hasScrollRect = false;
               }
            }
            else
            {
               rect = this._container.scrollRect;
               if(Boolean(!rect) || Boolean(rect.x != xpos) || Boolean(rect.y != ypos) || Boolean(rect.width != width) || Boolean(rect.height != height))
               {
                  this._container.scrollRect = new Rectangle(xpos,ypos,width,height);
                  this._hasScrollRect = true;
               }
            }
         }
         this.attachTransparentBackgroundForHit(false);
      }
      
      public function get color() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.color:undefined;
      }
      
      public function set color(colorValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().color = colorValue;
         this.formatChanged();
      }
      
      public function get backgroundColor() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.backgroundColor:undefined;
      }
      
      public function set backgroundColor(backgroundColorValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().backgroundColor = backgroundColorValue;
         this.formatChanged();
      }
      
      public function get lineThrough() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineThrough:undefined;
      }
      
      public function set lineThrough(lineThroughValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineThrough = lineThroughValue;
         this.formatChanged();
      }
      
      public function get textAlpha() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlpha:undefined;
      }
      
      public function set textAlpha(textAlphaValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlpha = textAlphaValue;
         this.formatChanged();
      }
      
      public function get backgroundAlpha() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.backgroundAlpha:undefined;
      }
      
      public function set backgroundAlpha(backgroundAlphaValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().backgroundAlpha = backgroundAlphaValue;
         this.formatChanged();
      }
      
      public function get fontSize() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontSize:undefined;
      }
      
      public function set fontSize(fontSizeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontSize = fontSizeValue;
         this.formatChanged();
      }
      
      public function get baselineShift() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.baselineShift:undefined;
      }
      
      public function set baselineShift(baselineShiftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().baselineShift = baselineShiftValue;
         this.formatChanged();
      }
      
      public function get trackingLeft() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.trackingLeft:undefined;
      }
      
      public function set trackingLeft(trackingLeftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().trackingLeft = trackingLeftValue;
         this.formatChanged();
      }
      
      public function get trackingRight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.trackingRight:undefined;
      }
      
      public function set trackingRight(trackingRightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().trackingRight = trackingRightValue;
         this.formatChanged();
      }
      
      public function get lineHeight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineHeight:undefined;
      }
      
      public function set lineHeight(lineHeightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineHeight = lineHeightValue;
         this.formatChanged();
      }
      
      public function get breakOpportunity() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.breakOpportunity:undefined;
      }
      
      public function set breakOpportunity(breakOpportunityValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().breakOpportunity = breakOpportunityValue;
         this.formatChanged();
      }
      
      public function get digitCase() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.digitCase:undefined;
      }
      
      public function set digitCase(digitCaseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().digitCase = digitCaseValue;
         this.formatChanged();
      }
      
      public function get digitWidth() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.digitWidth:undefined;
      }
      
      public function set digitWidth(digitWidthValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().digitWidth = digitWidthValue;
         this.formatChanged();
      }
      
      public function get dominantBaseline() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.dominantBaseline:undefined;
      }
      
      public function set dominantBaseline(dominantBaselineValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().dominantBaseline = dominantBaselineValue;
         this.formatChanged();
      }
      
      public function get kerning() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.kerning:undefined;
      }
      
      public function set kerning(kerningValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().kerning = kerningValue;
         this.formatChanged();
      }
      
      public function get ligatureLevel() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.ligatureLevel:undefined;
      }
      
      public function set ligatureLevel(ligatureLevelValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().ligatureLevel = ligatureLevelValue;
         this.formatChanged();
      }
      
      public function get alignmentBaseline() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.alignmentBaseline:undefined;
      }
      
      public function set alignmentBaseline(alignmentBaselineValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().alignmentBaseline = alignmentBaselineValue;
         this.formatChanged();
      }
      
      public function get locale() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.locale:undefined;
      }
      
      public function set locale(localeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().locale = localeValue;
         this.formatChanged();
      }
      
      public function get typographicCase() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.typographicCase:undefined;
      }
      
      public function set typographicCase(typographicCaseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().typographicCase = typographicCaseValue;
         this.formatChanged();
      }
      
      public function get fontFamily() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontFamily:undefined;
      }
      
      public function set fontFamily(fontFamilyValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontFamily = fontFamilyValue;
         this.formatChanged();
      }
      
      public function get textDecoration() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textDecoration:undefined;
      }
      
      public function set textDecoration(textDecorationValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textDecoration = textDecorationValue;
         this.formatChanged();
      }
      
      public function get fontWeight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontWeight:undefined;
      }
      
      public function set fontWeight(fontWeightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontWeight = fontWeightValue;
         this.formatChanged();
      }
      
      public function get fontStyle() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontStyle:undefined;
      }
      
      public function set fontStyle(fontStyleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontStyle = fontStyleValue;
         this.formatChanged();
      }
      
      public function get whiteSpaceCollapse() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.whiteSpaceCollapse:undefined;
      }
      
      public function set whiteSpaceCollapse(whiteSpaceCollapseValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().whiteSpaceCollapse = whiteSpaceCollapseValue;
         this.formatChanged();
      }
      
      public function get renderingMode() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.renderingMode:undefined;
      }
      
      public function set renderingMode(renderingModeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().renderingMode = renderingModeValue;
         this.formatChanged();
      }
      
      public function get cffHinting() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.cffHinting:undefined;
      }
      
      public function set cffHinting(cffHintingValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().cffHinting = cffHintingValue;
         this.formatChanged();
      }
      
      public function get fontLookup() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.fontLookup:undefined;
      }
      
      public function set fontLookup(fontLookupValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().fontLookup = fontLookupValue;
         this.formatChanged();
      }
      
      public function get textRotation() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textRotation:undefined;
      }
      
      public function set textRotation(textRotationValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textRotation = textRotationValue;
         this.formatChanged();
      }
      
      public function get textIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textIndent:undefined;
      }
      
      public function set textIndent(textIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textIndent = textIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphStartIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphStartIndent:undefined;
      }
      
      public function set paragraphStartIndent(paragraphStartIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphStartIndent = paragraphStartIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphEndIndent() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphEndIndent:undefined;
      }
      
      public function set paragraphEndIndent(paragraphEndIndentValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphEndIndent = paragraphEndIndentValue;
         this.formatChanged();
      }
      
      public function get paragraphSpaceBefore() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphSpaceBefore:undefined;
      }
      
      public function set paragraphSpaceBefore(paragraphSpaceBeforeValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphSpaceBefore = paragraphSpaceBeforeValue;
         this.formatChanged();
      }
      
      public function get paragraphSpaceAfter() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paragraphSpaceAfter:undefined;
      }
      
      public function set paragraphSpaceAfter(paragraphSpaceAfterValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paragraphSpaceAfter = paragraphSpaceAfterValue;
         this.formatChanged();
      }
      
      public function get textAlign() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlign:undefined;
      }
      
      public function set textAlign(textAlignValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlign = textAlignValue;
         this.formatChanged();
      }
      
      public function get textAlignLast() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textAlignLast:undefined;
      }
      
      public function set textAlignLast(textAlignLastValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textAlignLast = textAlignLastValue;
         this.formatChanged();
      }
      
      public function get textJustify() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.textJustify:undefined;
      }
      
      public function set textJustify(textJustifyValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().textJustify = textJustifyValue;
         this.formatChanged();
      }
      
      public function get justificationRule() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.justificationRule:undefined;
      }
      
      public function set justificationRule(justificationRuleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().justificationRule = justificationRuleValue;
         this.formatChanged();
      }
      
      public function get justificationStyle() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.justificationStyle:undefined;
      }
      
      public function set justificationStyle(justificationStyleValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().justificationStyle = justificationStyleValue;
         this.formatChanged();
      }
      
      public function get direction() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.direction:undefined;
      }
      
      public function set direction(directionValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().direction = directionValue;
         this.formatChanged();
      }
      
      public function get tabStops() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.tabStops:undefined;
      }
      
      public function set tabStops(tabStopsValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().tabStops = tabStopsValue;
         this.formatChanged();
      }
      
      public function get leadingModel() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.leadingModel:undefined;
      }
      
      public function set leadingModel(leadingModelValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().leadingModel = leadingModelValue;
         this.formatChanged();
      }
      
      public function get columnGap() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnGap:undefined;
      }
      
      public function set columnGap(columnGapValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnGap = columnGapValue;
         this.formatChanged();
      }
      
      public function get paddingLeft() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingLeft:undefined;
      }
      
      public function set paddingLeft(paddingLeftValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingLeft = paddingLeftValue;
         this.formatChanged();
      }
      
      public function get paddingTop() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingTop:undefined;
      }
      
      public function set paddingTop(paddingTopValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingTop = paddingTopValue;
         this.formatChanged();
      }
      
      public function get paddingRight() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingRight:undefined;
      }
      
      public function set paddingRight(paddingRightValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingRight = paddingRightValue;
         this.formatChanged();
      }
      
      public function get paddingBottom() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.paddingBottom:undefined;
      }
      
      public function set paddingBottom(paddingBottomValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().paddingBottom = paddingBottomValue;
         this.formatChanged();
      }
      
      public function get columnCount() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnCount:undefined;
      }
      
      public function set columnCount(columnCountValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnCount = columnCountValue;
         this.formatChanged();
      }
      
      public function get columnWidth() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.columnWidth:undefined;
      }
      
      public function set columnWidth(columnWidthValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().columnWidth = columnWidthValue;
         this.formatChanged();
      }
      
      public function get firstBaselineOffset() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.firstBaselineOffset:undefined;
      }
      
      public function set firstBaselineOffset(firstBaselineOffsetValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().firstBaselineOffset = firstBaselineOffsetValue;
         this.formatChanged();
      }
      
      public function get verticalAlign() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.verticalAlign:undefined;
      }
      
      public function set verticalAlign(verticalAlignValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().verticalAlign = verticalAlignValue;
         this.formatChanged();
      }
      
      public function get blockProgression() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.blockProgression:undefined;
      }
      
      public function set blockProgression(blockProgressionValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().blockProgression = blockProgressionValue;
         this.formatChanged();
      }
      
      public function get lineBreak() : *
      {
         return Boolean(this._formatValueHolder)?this._formatValueHolder.lineBreak:undefined;
      }
      
      public function set lineBreak(lineBreakValue:*) : void
      {
         this.writableTextLayoutFormatValueHolder().lineBreak = lineBreakValue;
         this.formatChanged();
      }
      
      public function get userStyles() : Object
      {
         var styles:Object = this._formatValueHolder == null?null:this._formatValueHolder.userStyles;
         return Boolean(styles)?Property.shallowCopy(styles):null;
      }
      
      public function set userStyles(styles:Object) : void
      {
         var val:* = null;
         var newStyles:Object = new Object();
         for(val in styles)
         {
            newStyles[val] = styles[val];
         }
         this.writableTextLayoutFormatValueHolder().userStyles = newStyles;
         this.formatChanged();
      }
      
      public function get coreStyles() : Object
      {
         var styles:Object = this._formatValueHolder == null?null:this._formatValueHolder.coreStyles;
         return Boolean(styles)?Property.shallowCopy(styles):null;
      }
      
      public function get format() : ITextLayoutFormat
      {
         return this._formatValueHolder;
      }
      
      public function set format(value:ITextLayoutFormat) : void
      {
         this.formatInternal = value;
         this.formatChanged();
      }
      
      private function writableTextLayoutFormatValueHolder() : FlowValueHolder
      {
         if(this._formatValueHolder == null)
         {
            this._formatValueHolder = new FlowValueHolder();
         }
         return this._formatValueHolder;
      }
      
      tlf_internal function set formatInternal(value:ITextLayoutFormat) : void
      {
         if(value == null)
         {
            if(Boolean(this._formatValueHolder == null) || Boolean(this._formatValueHolder.coreStyles == null))
            {
               return;
            }
            this._formatValueHolder.coreStyles = null;
         }
         else
         {
            this.writableTextLayoutFormatValueHolder().format = value;
         }
      }
      
      public function getStyle(styleProp:String) : *
      {
         if(TextLayoutFormat.description.hasOwnProperty(styleProp))
         {
            return this.computedFormat[styleProp];
         }
         return this.getUserStyleWorker(styleProp);
      }
      
      public function setStyle(styleProp:String, newValue:*) : void
      {
         if(TextLayoutFormat.description[styleProp] !== undefined)
         {
            this[styleProp] = newValue;
         }
         else
         {
            this._formatValueHolder.setUserStyle(styleProp,newValue);
            this.formatChanged();
         }
      }
      
      public function clearStyle(styleProp:String) : void
      {
         this.setStyle(styleProp,undefined);
      }
      
      tlf_internal function getUserStyleWorker(styleProp:String) : *
      {
         var userStyle:* = this._formatValueHolder.getUserStyle(styleProp);
         if(userStyle !== undefined)
         {
            return userStyle;
         }
         var tf:TextFlow = Boolean(this._rootElement)?this._rootElement.getTextFlow():null;
         if(Boolean(tf) && Boolean(tf.formatResolver))
         {
            userStyle = tf.formatResolver.resolveUserFormat(this,styleProp);
            if(userStyle !== undefined)
            {
               return userStyle;
            }
         }
         return Boolean(this._rootElement)?this._rootElement.getUserStyleWorker(styleProp):undefined;
      }
      
      public function get computedFormat() : ITextLayoutFormat
      {
         var parentPrototype:TextLayoutFormatValueHolder = null;
         if(!this._computedFormat)
         {
            parentPrototype = Boolean(this._rootElement)?TextLayoutFormatValueHolder(this._rootElement.computedFormat):null;
            this._computedFormat = FlowElement.createTextLayoutFormatPrototype(this.formatForCascade,parentPrototype);
            this.resetColumnState();
         }
         return this._computedFormat;
      }
      
      tlf_internal function get formatForCascade() : TextLayoutFormatValueHolder
      {
         var tf:TextFlow = null;
         var elemStyle:TextLayoutFormatValueHolder = null;
         var localFormat:ITextLayoutFormat = null;
         var rslt:TextLayoutFormatValueHolder = null;
         if(this._rootElement)
         {
            tf = this._rootElement.getTextFlow();
            if(tf)
            {
               elemStyle = tf.getTextLayoutFormatStyle(this);
               if(elemStyle)
               {
                  localFormat = this._formatValueHolder;
                  if(localFormat == null)
                  {
                     return elemStyle;
                  }
                  rslt = new TextLayoutFormatValueHolder(elemStyle);
                  rslt.apply(localFormat);
                  return rslt;
               }
            }
         }
         return this._formatValueHolder;
      }
      
      tlf_internal function lineIsVisible(wmode:String, scrollXTW:int, scrollYTW:int, scrollWidthTW:int, scrollHeightTW:int, textFlowLine:TextFlowLine) : TextLine
      {
         var textLine:TextLine = null;
         var lineBounds:Rectangle = null;
         if(!textFlowLine.hasLineBounds())
         {
            textLine = textFlowLine.createShape(wmode);
            if(textLine.numChildren == 0)
            {
               if(wmode == BlockProgression.TB)
               {
                  textFlowLine.setLineBounds(Twips.to(textLine.x),Twips.to(textLine.y - textLine.ascent),Twips.to(textLine.textWidth),Twips.to(textLine.textHeight));
               }
               else
               {
                  textFlowLine.setLineBounds(Twips.to(textLine.x - textLine.descent),Twips.to(textLine.y),Twips.to(textLine.textHeight),Twips.to(textLine.textWidth));
               }
            }
            else
            {
               lineBounds = this.getPlacedTextLineBounds(textLine);
               textFlowLine.setLineBounds(Twips.to(lineBounds.x),Twips.to(lineBounds.y),Twips.to(lineBounds.width),Twips.to(lineBounds.height));
            }
         }
         var isVisible:Boolean = textFlowLine.isLineVisible(wmode,scrollXTW,scrollYTW,scrollWidthTW,scrollHeightTW);
         if(!isVisible)
         {
            return null;
         }
         if(!textLine)
         {
            textLine = textFlowLine.createShape(wmode);
         }
         return textLine;
      }
      
      tlf_internal function getPlacedTextLineBounds(textLine:TextLine) : Rectangle
      {
         var curBounds:Rectangle = null;
         if(!textLine.parent)
         {
            tempLineHolder.addChildAt(textLine,0);
            curBounds = textLine.getBounds(tempLineHolder);
            tempLineHolder.removeChildAt(0);
         }
         else
         {
            curBounds = textLine.getBounds(textLine.parent);
         }
         return curBounds;
      }
      
      tlf_internal function getInteractionHandler() : IInteractionEventHandler
      {
         return this;
      }
   }
}

import flash.events.MouseEvent;
import flash.display.InteractiveObject;

class PsuedoMouseEvent extends MouseEvent
{
    
   function PsuedoMouseEvent(type:String, bubbles:Boolean = true, cancelable:Boolean = false, localX:Number = NaN, localY:Number = NaN, relatedObject:InteractiveObject = null, ctrlKey:Boolean = false, altKey:Boolean = false, shiftKey:Boolean = false, buttonDown:Boolean = false)
   {
      super(type,bubbles,cancelable,localX,localY,relatedObject,ctrlKey,altKey,shiftKey,buttonDown);
   }
   
   override public function get currentTarget() : Object
   {
      return relatedObject;
   }
   
   override public function get target() : Object
   {
      return relatedObject;
   }
}
