VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form MainWindow 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "P10 D10 Demo"
   ClientHeight    =   4305
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4215
   Icon            =   "MainWindow.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4305
   ScaleWidth      =   4215
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.Frame gbxDevice 
      Caption         =   "Device"
      Height          =   2295
      Left            =   120
      TabIndex        =   7
      Top             =   1800
      Width           =   3975
      Begin VB.Label lblPressureVal 
         Alignment       =   2  'Zentriert
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "- - -"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FF00&
         Height          =   495
         Left            =   1680
         TabIndex        =   13
         Top             =   1440
         Width           =   2055
      End
      Begin VB.Label lblPressure 
         Caption         =   "Pressure:"
         Height          =   255
         Left            =   240
         TabIndex        =   12
         Top             =   1560
         Width           =   735
      End
      Begin VB.Label lblHeadNumberVal 
         Caption         =   "-"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1680
         TabIndex        =   11
         Top             =   840
         Width           =   2055
      End
      Begin VB.Label lblHeadNumber 
         Caption         =   "Headnumber:"
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   840
         Width           =   1095
      End
      Begin VB.Label lblPresRangeVal 
         Caption         =   "-"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1680
         TabIndex        =   9
         Top             =   360
         Width           =   2055
      End
      Begin VB.Label lblPresRange 
         Caption         =   "Pressure range:"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   1215
      End
   End
   Begin MSCommLib.MSComm COM 
      Left            =   3600
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.Frame gbxCOM 
      Caption         =   "Settings"
      Height          =   1470
      Left            =   120
      TabIndex        =   0
      Top             =   135
      Width           =   3945
      Begin VB.CommandButton btnDisconnect 
         Caption         =   "Disconnect"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2760
         TabIndex        =   6
         Top             =   840
         Width           =   975
      End
      Begin VB.CommandButton btnConnect 
         Caption         =   "Connect"
         Height          =   375
         Left            =   2760
         TabIndex        =   5
         Top             =   360
         Width           =   975
      End
      Begin VB.ComboBox cbxDevice 
         Height          =   315
         Left            =   960
         Style           =   2  'Dropdown-Liste
         TabIndex        =   4
         Top             =   840
         Width           =   975
      End
      Begin VB.ComboBox cbxCOM 
         Height          =   315
         Left            =   960
         Style           =   2  'Dropdown-Liste
         TabIndex        =   1
         Top             =   360
         Width           =   975
      End
      Begin VB.Label lblDevice 
         Caption         =   "Device"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   960
         Width           =   735
      End
      Begin VB.Label lblCOM 
         Caption         =   "COM"
         Height          =   255
         Left            =   240
         TabIndex        =   2
         Top             =   480
         Width           =   735
      End
   End
End
Attribute VB_Name = "MainWindow"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*****************************************************************************
' Compiler:           Visual BASIC 6.0
' Operating system:   WIN NT 4.0 SP 6.0
' Author:             Gerald Burgemeister
' Date:               30.08.2002
'
' Modul MainWindow uses module P10D10Model
'
'*****************************************************************************

Option Explicit
Option Base 0

Dim mCancel As Boolean

Const DELAY_TIME = 100
Const D10_BOOT_DELAY = 3000
Const PRESSURE_READ_DELAY = 500

''''''''''''''''''''''''''''''''''''''''''''''''
' Constructor
Private Sub Form_Load()
  cbxCOM.Clear
  cbxDevice.Clear

  cbxCOM.AddItem ("1")
  cbxCOM.AddItem ("2")
  
  cbxDevice.AddItem ("D10")
  cbxDevice.AddItem ("P10")
  
  cbxCOM.ListIndex = 0
  cbxDevice.ListIndex = 0
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''
' Destructor
Private Sub Form_Unload(Cancel As Integer)
  btnDisconnect_Click
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''
' Message handler
Private Sub btnConnect_Click()
  Dim str As String
  Dim ret As Boolean
  
  MousePointer = vbHourglass
  ret = True
  mCancel = False
  enableControls (False)
  
  'initialize the COM Port
  COM.CommPort = cbxCOM.ListIndex + 1
  COM.Settings = "9600,N,8,1"
      
  ' and try to open it
  If Not COM.PortOpen Then
    COM.PortOpen = True
  End If
  
  'power, boot delay and pollmode are only needed for D10 devices
  If cbxDevice.ListIndex = 0 Then
    PowerOn (True)
    
    delay (D10_BOOT_DELAY)
    
    ' this program needs the D10 in pollmode
    If Not switchD10TempToPollmode() Then
      btnDisconnect_Click
      MsgBox "Could not switch the D10 into pollmode. Please try again"
      ret = False
    End If
  End If
  
  ' read device info
  If ret Then
    delay (DELAY_TIME)
    ret = getZeroScale(str)
    If ret Then
      lblPresRangeVal = str
      
      delay (DELAY_TIME)
      ret = getFullScale(str)
      If ret Then
        lblPresRangeVal = lblPresRangeVal + " .. " + str
        
        delay (DELAY_TIME)
        ret = getPressureUnit(str)
        If ret Then
          lblPresRangeVal = lblPresRangeVal + " " + str
          
          delay (DELAY_TIME)
          ret = getHeadNumber(str)
          If ret Then
            lblHeadNumberVal = str
            
            MousePointer = vbDefault
  
            ' if everything was ok, go into a loop and
            ' request the pressure value every 500 ms
            If ret Then
              Do
                ret = getPressure(str)
                If ret Then
                  lblPressureVal = str
                  delay (PRESSURE_READ_DELAY)
                Else
                  ' it seems that we lost the device
                  btnDisconnect_Click
                  mCancel = True
                End If
              Loop Until mCancel
              
              ' to avoid the error message
              ret = True
            End If
          End If
        End If
      End If
    End If
  End If
  
  If Not ret Then
    MousePointer = vbDefault
    btnDisconnect_Click
    Call MsgBox("An error ocurred. Please connect again.", vbOKOnly + vbError)
  End If
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''
' Message handler
Private Sub btnDisconnect_Click()
  mCancel = True
  
  ' close the port
  If COM.PortOpen Then
    COM.PortOpen = False
  End If

  ' and clear the displays
  lblPresRangeVal = "-"
  lblHeadNumberVal = "-"
  lblPressureVal = "- - -"
  
  enableControls (True)
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''
' a D10 is supplied via the RS232 interface
Private Sub PowerOn(ByVal bOn As Boolean)
  ' caution: always enable RTS before DTR
  COM.RTSEnable = bOn
  COM.DTREnable = bOn
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''
' en/disables the controls
Private Sub enableControls(ByVal enable As Boolean)
  cbxCOM.Enabled = enable
  cbxDevice.Enabled = enable
  btnConnect.Enabled = enable
  btnDisconnect.Enabled = Not enable
End Sub
