@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2021 Alexey Kuryakin kouriakine@mail.ru      ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Ask confirm then call passed command, like example:        ::
::  ask-confirm-call "Confirm" "Yes?" cmd /c echo Done.       ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Preset
set /a verb=0
set /a test=0
set initial=0
set predproc=
set finally=0
set postproc=

:ParseOptions
if /i "%~1" == ""           goto :Help
if /i "%~1" == "/?"         goto :Help
if /i "%~1" == "-h"         goto :Help
if /i "%~1" == "--help"     goto :Help
if /i "%~1" == "--version"  goto :PrintVersion
if /i "%~1" == "-p"         goto :AddPath
if /i "%~1" == "--path"     goto :AddPath
if /i "%~1" == "--verb"     goto :SetVerb
if /i "%~1" == "--test"     goto :SetTest
if /i "%~1" == "-t"         goto :AddTimeout
if /i "%~1" == "--timeout"  goto :AddTimeout
if /i "%~1" == "--finally"  goto :AddFinally
if /i "%~1" == "--initial"  goto :AddInitial
goto :EndOptions
:AddPath
if /i "%~2" == "b" for %%i in ("%~dp0.") do set "PATH=%%~fi;%PATH%"
if /i "%~2" == "e" for %%i in ("%~dp0.") do set "PATH=%PATH%;%%~fi"
shift /1
shift /1
goto :ParseOptions
:SetVerb
set /a verb=1
shift /1
goto :ParseOptions
:SetTest
set /a test=1
shift /1
goto :ParseOptions
:AddTimeout
if not "%~2" == "" set "ask-confirm-timeout=%~2"
shift /1
shift /1
goto :ParseOptions
:AddFinally
if not "%~2" == "" set "postproc=%~2"
if not "%~2" == "" set "finally=1"
shift /1
shift /1
goto :ParseOptions
:AddInitial
if not "%~2" == "" set "predproc=%~2"
if not "%~2" == "" set "initial=1"
shift /1
shift /1
goto :ParseOptions
:EndOptions

:AskConfirm
title ask-confirm.cmd %1 %2
call "%~dp0\ask-confirm.cmd" %1 %2 || exit /b 1
shift /1
shift /1
title %~nx0

:GetCommand
set cmnd=%1
shift /1

:GetArgs
set args=%1
:ParseArgs
shift /1
if "%~1" == "" if [%1] == [] goto :DoneArgs
set args=%args% %1
goto :ParseArgs
:DoneArgs

:CallCommand
if "%test%" == "1" set /a verb=1
if "%verb%" == "1" echo %cmnd% %args%
if "%test%" == "0" if defined predproc if "%initial%" == "1" call %predproc%
if "%test%" == "0" if defined cmnd title %cmnd% %args%
if "%test%" == "0" if defined cmnd call %cmnd% %args%
if "%test%" == "0" if defined postproc if "%finally%" == "1" call %postproc%
exit /b %ERRORLEVEL%
goto :EOF

:PrintVersion
call :Version %~n0
exit /b 0
goto :EOF

:Version
echo %~1 version 1.0
goto :EOF

:Help
call :Version %~n0
echo Copyright ^(c^) 2021 Alexey Kuryakin kouriakine@mail.ru
echo Utility to ask confirm, then call passed command.
echo ====================^> Syntax:
echo  %~n0 [Options] "Title" "Message" cmnd args
echo ====================^> Options:
echo   -p b             =^> add home directory to begin of PATH before call command
echo   -p e             =^> add home directory to end   of PATH before call command
echo   -t,--timeout t   =^> set timeout t seconds to cancel confirmation dialog box
echo   --verb           =^> verbose mode: echo command before call
echo   --test           =^> testing mode: echo command before call, but don't do it
echo   --initial "doit" =^> option to call the command ^(doit^) before cmnd args call
echo   --finally "doit" =^> option to call the command ^(doit^) after  cmnd args call
echo ====================^> Arguments:
echo  Title             =^> Window title   for confirmation
echo  Message           =^> Window message for confirmation
echo  cmnd              =^> Command to execute on confirm
echo  args              =^> Arguments of command
echo ====================^> Example:
echo  call %~n0 --help
echo  call %~n0 --version
echo  call %~n0 -p b -t 30 "Confirm" "Do it?" cmd /c echo Done.
echo  call %~n0 -p b -t 30 --initial "title Test %~n0" "Confirm" "Do it?" cmd /c echo Done.
echo  call %~n0 -p b -t 30 --verb --finally "echo Done. & pause" "Confirm" "Start ping?" ping localhost
exit /b 0
goto :EOF
