@echo off

rem ############################################################
rem Copyright(c) 2015 by Alexey Kuryakin, Sarov Russia 20150723.
rem This script uses to open TCP ports for vboxnet0 connections,
rem uses by ser2net, netcat etc for communications between guest
rem and host operation systems in VirtualBox, + DIM in addition.
rem Assumed that vboxnet0 IP=192.168.56.1 (it is default value).
rem Uses port range 26001-26132 which is'nt IANA registered yet.
rem see http://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml?search=26001
rem ############################################################
:Main
if "%~1" == "" ( call :Usage & goto :EOF )
:CheckUserAccess
unix ismemberof admins 1>nul 2>nul && goto :AccessGranted
echo Access denied to user "%UserName%".
unix sleep 1
goto :EOF
:AccessGranted
echo Access granted to user "%UserName%".
echo.
echo Enable firewall port range for ser2net,netcat etc...
echo.
setlocal
call :CheckArguments %*
call :CheckInterface vboxnet0 vboxnet0found
if "%todo%" == "" ( call :Usage & goto :EOF )
if /I "%todo%" == "show" ( call :FirewallShowPortopening & goto :EOF )
for /L %%i in (2505,1,2505)   do call :FirewallPortopening TCP %%i "DIM DNS"          %mode% "SUBNET"                                        ALL vboxnet0
for /L %%i in (5100,1,5102)   do call :FirewallPortopening TCP %%i "DIM DATA"         %mode% "SUBNET"                                        ALL vboxnet0
for /L %%i in (26001,1,26016) do call :FirewallPortopening TCP %%i "vboxnet0 ser2net" %mode% "CUSTOM addresses = 192.168.56.1/255.255.255.0" ALL vboxnet0
for /L %%i in (26101,1,26102) do call :FirewallPortopening TCP %%i "vboxnet0 netcat"  %mode% "CUSTOM addresses = 192.168.56.1/255.255.255.0" ALL vboxnet0
endlocal
goto :EOF

:FirewallPortopening
if "%~1" == "" goto :EOF & if "%~2" == "" goto :EOF & if "%~3" == "" goto :EOF & if "%~4" == "" goto :EOF & if "%~5" == "" goto :EOF & if "%~6" == "" goto :EOF
if /I "%todo%" == "add"    netsh firewall add    portopening protocol = %~1 port = %~2 name = "%~1 %~2 - %~3" mode = %~4 scope = %~5 profile = %~6    1>nul && echo %todo% %~1 %~2 %~4 success, profile %~6   || echo %todo% %~1 %~2 %~4 failed, profile %~6
if /I "%todo%" == "delete" netsh firewall delete portopening protocol = %~1 port = %~2                                               profile = %~6    1>nul && echo %todo% %~1 %~2     success, profile %~6   || echo %todo% %~1 %~2 %~4 failed, profile %~6
if "%~7" == "" goto :EOF & if "%vboxnet0found%" == "0" goto :EOF
if /I "%todo%" == "add"    netsh firewall add    portopening protocol = %~1 port = %~2 name = "%~1 %~2 - %~3" mode = %~4             interface = %~7  1>nul && echo %todo% %~1 %~2 %~4 success, interface %~7 || echo %todo% %~1 %~2 %~4 failed, interface %~7
if /I "%todo%" == "delete" netsh firewall delete portopening protocol = %~1 port = %~2                                               interface = %~7  1>nul && echo %todo% %~1 %~2     success, interface %~7 || echo %todo% %~1 %~2 %~4 failed, interface %~7
goto :EOF

:CheckArguments
set todo=
set mode=ENABLE
:CheckArgumentsLoop
if "%~1" == "" goto :EOF
call :CheckArgumentsLoop %2 %3 %4 %5 %6 %7 %8 %9
if /I "%~1" == "ADD"      set todo=add
if /I "%~1" == "SHOW"     set todo=show
if /I "%~1" == "DELETE"   set todo=delete
if /I "%~1" == "ENABLE"   set mode=ENABLE
if /I "%~1" == "DISABLE"  set mode=DISABLE
goto :EOF

:FirewallShowPortopening
netsh firewall show portopening verbose = ENABLE 
goto :EOF

:CheckInterface
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
for /F %%j in ('ipconfig ^| unix grep %~1 ^| unix wc -l') do set /a %~2=%%j
goto :EOF

:Usage
echo.
echo Usage:
echo  %~n0               - help
echo  %~n0 show          - show opened ports
echo  %~n0 delete        - delete opened ports
echo  %~n0 add           - add and enable  ports
echo  %~n0 add enable    - add and enable  ports
echo  %~n0 add disable   - add and disable ports
echo.
goto :EOF

:SamplesToCopy
echo Delete ports from profile ALL...
netsh firewall delete portopening protocol = TCP port = 2505 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5100 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5101 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5102 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26001 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26002 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26003 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26004 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26005 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26006 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26007 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26008 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26009 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26010 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26011 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26012 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26013 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26014 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26015 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26016 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26101 profile = ALL
netsh firewall delete portopening protocol = TCP port = 26102 profile = ALL
echo Delete ports from interface vboxnet0...
netsh firewall delete portopening protocol = TCP port = 2505 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5100 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5101 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5102 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26001 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26002 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26003 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26004 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26005 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26006 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26007 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26008 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26009 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26010 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26011 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26012 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26013 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26014 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26015 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26016 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26101 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 26102 interface = vboxnet0
echo Add ports to profile ALL...
netsh firewall add portopening protocol = TCP port = 2505 name = "TCP 2505 - DIM DNS" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5100 name = "TCP 5100 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5101 name = "TCP 5101 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5102 name = "TCP 5102 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 26001 name = "TCP 26001 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26002 name = "TCP 26002 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26003 name = "TCP 26003 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26004 name = "TCP 26004 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26005 name = "TCP 26005 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26006 name = "TCP 26006 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26007 name = "TCP 26007 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26008 name = "TCP 26008 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26009 name = "TCP 26009 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26010 name = "TCP 26010 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26011 name = "TCP 26011 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26012 name = "TCP 26012 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26013 name = "TCP 26013 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26014 name = "TCP 26014 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26015 name = "TCP 26015 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26016 name = "TCP 26016 - vboxnet0 ser2net" mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26101 name = "TCP 26101 - vboxnet0 netcat"  mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
netsh firewall add portopening protocol = TCP port = 26102 name = "TCP 26102 - vboxnet0 netcat"  mode = ENABLE scope = CUSTOM addresses = 192.168.56.1/255.255.255.0 profile = ALL
echo Add ports to interface vboxnet0...
netsh firewall add portopening protocol = TCP port = 2505 name = "TCP 2505 - DIM DNS" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5100 name = "TCP 5100 - DIM DATA" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5101 name = "TCP 5101 - DIM DATA" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5102 name = "TCP 5102 - DIM DATA" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26001 name = "TCP 26001 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26002 name = "TCP 26002 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26003 name = "TCP 26003 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26004 name = "TCP 26004 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26005 name = "TCP 26005 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26006 name = "TCP 26006 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26007 name = "TCP 26007 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26008 name = "TCP 26008 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26009 name = "TCP 26009 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26010 name = "TCP 26010 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26011 name = "TCP 26011 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26012 name = "TCP 26012 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26013 name = "TCP 26013 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26014 name = "TCP 26014 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26015 name = "TCP 26015 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26016 name = "TCP 26016 - vboxnet0 ser2net" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26101 name = "TCP 26101 - vboxnet0 netcat"  mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 26102 name = "TCP 26102 - vboxnet0 netcat"  mode = ENABLE interface = vboxnet0
echo Firewall show firewall portopening...
netsh firewall show portopening verbose = ENABLE 
goto :EOF