unit fmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ActnList, Menus, uhistory, Clipbrd;

type

  { TForm1 }

  TForm1 = class(TForm)
    Memo1          : TMemo;

    actlMain       : TActionList;
    actnCut        : TAction;
    actnCopy       : TAction;
    actnPaste      : TAction;
    actnSelectAll  : TAction;
    actnDelete     : TAction;
    actnUndo       : TAction;
    actnRedo       : TAction;


    menuPopup      : TPopupMenu;
    pmiCut         : TMenuItem;
    pmiCopy        : TMenuItem;
    pmiPaste       : TMenuItem;
    pmiSelectAll   : TMenuItem;
    pmiDelete      : TMenuItem;
    pmiUndo        : TMenuItem;
    pmiRedo        : TMenuItem;
    pmiSeparater01 : TMenuItem;
    pmiSeparater02 : TMenuItem;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
  private
    History: THistory;
    procedure actnTextExecute(Sender: TObject);
    procedure actnCutUpdate(Sender: TObject);
    procedure actnUndoUpdate(Sender: TObject);
  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  History := THistory.Create(Memo1);

  actnCut      .OnExecute := @actnTextExecute;
  actnCopy     .OnExecute := @actnTextExecute;
  actnPaste    .OnExecute := @actnTextExecute;
  actnSelectAll.OnExecute := @actnTextExecute;
  actnDelete   .OnExecute := @actnTextExecute;
  actnUndo     .OnExecute := @actnTextExecute;
  actnRedo     .OnExecute := @actnTextExecute;

  actnCut      .OnUpdate  := @actnCutUpdate;
  actnUndo     .OnUpdate  := @actnUndoUpdate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  History.Free;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  Caption := 'Undo Redo Demo - ' + IntToStr(History.Size);
end;

procedure TForm1.actnTextExecute(Sender: TObject);
begin
  case (Sender as TAction).Name of
  'actnCut'       : Memo1.CutToClipboard;
  'actnCopy'      : Memo1.CopyToClipboard ;
  'actnPaste'     : History.PasteText;
  'actnSelectAll' : Memo1.SelectAll;
  'actnDelete'    : History.DeleteText;
  'actnUndo'      : History.Undo;
  'actnRedo'      : History.Redo;
  end;
  Memo1.SetFocus;
end;

procedure TForm1.actnUndoUpdate(Sender: TObject);
begin
  actnUndo  .Enabled := History.CanUndo;
  actnRedo  .Enabled := History.CanRedo;
end;

procedure TForm1.actnCutUpdate(Sender: TObject);
begin
  actnCut   .Enabled := Memo1.SelLength > 0;
  actnCopy  .Enabled := actnCut.Enabled;
  actnPaste .Enabled := ClipBoard.HasFormat(CF_TEXT);
  actnDelete.Enabled := actnCut.Enabled;
end;

end.

