class: TOP_SsdDetector_CLASS
!panel: ssdDetector/fsm/ssdDetector.pnl
    state: OFF	!color: FwStateOKNotPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) move_to STANDBY
        when ( any_in SSDSIDE_FWSETSTATES not_in_state OFF )  move_to MIXED
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES not_in_state OFF )  move_to MIXED
        action: GO_STANDBY	!visible: 1
            do SWITCH_ON all_in SSDINFRASTRUCTURE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: STANDBY	!color: FwStateOKNotPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( any_in SSDSIDE_FWSETSTATES not_in_state OFF )  move_to MIXED
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state MIXED )  move_to MIXED
        action: GO_OFF	!visible: 1
            do SWITCH_OFF all_in SSDINFRASTRUCTURE_FWSETACTIONS
        action: CONFIGURE(string run_type = "")	!visible: 1
            do GO_LOW_POWER all_in SSDSIDE_FWSETACTIONS
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: DOWNLOADING	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when (  ( all_in SSDSIDE_FWSETSTATES in_state LOW_POWER ) and ( all_in ALIDCS_RUNCU_FWSETSTATES in_state RUN_OK ) and ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) ) move_to STBY_CONFIGURED
        when (  ( all_in SSDSIDE_FWSETSTATES in_state READY ) and ( all_in ALIDCS_RUNCU_FWSETSTATES in_state RUN_OK ) and ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) ) move_to READY
        when (  ( all_in SSDSIDE_FWSETSTATES in_state CONFIGURED ) and ( all_in ALIDCS_RUNCU_FWSETSTATES in_state RUN_OK ) and ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) ) move_to BEAM_TUNING
        when (  ( all_in SSDSIDE_FWSETSTATES in_state CALIBRATING ) and ( all_in ALIDCS_RUNCU_FWSETSTATES in_state RUN_OK ) and ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) ) move_to CALIBRATING
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: STBY_CONFIGURED	!color: FwStateOKNotPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( all_in SSDSIDE_FWSETSTATES in_state OFF ) move_to STANDBY
        when ( any_in SSDSIDE_FWSETSTATES not_in_state LOW_POWER )  move_to MIXED
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STANDBY
        when ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state MIXED )  move_to MIXED
        action: GO_READY	!visible: 1
            do GO_READY all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_READY
        action: GO_STANDBY	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: CONFIGURE(string run_type = "")	!visible: 1
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: PREPARE_FOR_RUN(string run_type = "")	!visible: 1
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: GO_BEAM_TUN	!visible: 1
            do GO_RESET all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_BEAM_TUN
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: BEAM_TUNING	!color: FwStateOKNotPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( all_in SSDSIDE_FWSETSTATES in_state OFF ) move_to STANDBY
        when ( any_in SSDSIDE_FWSETSTATES not_in_state {CONFIGURED,READY} )  move_to MIXED
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STBY_CONF
        when ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state MIXED )  move_to MIXED
        action: GO_READY	!visible: 1
            do GO_READY all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_READY
        action: GO_STBY_CONF	!visible: 0
            do GO_LOW_POWER all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STBY_CONF
        action: CONFIGURE(string run_type = "")	!visible: 0
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: PREPARE_FOR_RUN(string run_type = "")	!visible: 0
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: READY	!color: FwStateOKPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( any_in SSDSIDE_FWSETSTATES not_in_state {READY,MOVING_READY} )  move_to MIXED
        when ( any_in SSDSIDE_FWSETSTATES in_state MOVING_READY )  move_to DOWNLOADING
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STBY_CONF
        when ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state MIXED )  move_to MIXED
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_BEAM_TUN	!visible: 1
            do GO_CONF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_BEAM_TUN
        action: GO_STBY_CONF	!visible: 0
            do GO_LOW_POWER all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STBY_CONF
        action: CONFIGURE(string run_type = "")	!visible: 1
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: PREPARE_FOR_RUN(string run_type = "")	!visible: 0
            do CONFIGURE all_in SSDINFRASTRUCTURE_FWSETACTIONS
            do INHIBIT_RUN all_in ALIDCS_RUNCU_FWSETACTIONS
            move_to DOWNLOADING
        action: CALIBRATE	!visible: 0
            do CALIBRATE all_in SSDSIDE_FWSETACTIONS
            move_to GOING_CALIB
        action: SOR(string run_type = "",string run_no = "",string ddl_list = "",string sor_mode = "")	!visible: 1
            do SOR (run_type = run_type, run_no = run_no, ddl_list = ddl_list, sor_mode =  sor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
    state: MOVING_STBY_CONF	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( all_in SSDSIDE_FWSETSTATES in_state LOW_POWER )  move_to STBY_CONFIGURED
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STANDBY
        action: GO_STANDBY	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: MOVING_STANDBY	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when (  ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state OFF )  ) move_to STANDBY
        action: GO_STANDBY	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: MOVING_BEAM_TUN	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( all_in SSDSIDE_FWSETSTATES in_state CONFIGURED )  move_to BEAM_TUNING
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STANDBY
        action: GO_STANDBY	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: MOVING_READY	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( all_in SSDSIDE_FWSETSTATES in_state READY )  move_to READY
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state NO_COOLING )  do GO_STANDBY
        action: GO_STANDBY	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
            move_to MOVING_STANDBY
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: ERROR	!color: FwStateAttention3
        when ( all_in FWCHILDREN_FWSETSTATES not_in_state {ERROR,NO_CONTROL, NO_COOLING} ) move_to MIXED
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: MIXED	!color: FwStateAttention2
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL,NO_COOLING} ) move_to ERROR
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) and ( all_in SSDSIDE_FWSETSTATES in_state OFF )  )  move_to OFF
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state OFF )  )  move_to STANDBY
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state LOW_POWER )  )  move_to STBY_CONFIGURED
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state READY )  )  move_to READY
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state CONFIGURED )  )  move_to BEAM_TUNING
        when (  ( all_in SSDINFRASTRUCTURE_FWSETSTATES in_state READY ) and ( all_in SSDSIDE_FWSETSTATES in_state CALIBRATING )  )  move_to CALIBRATING
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: CALIBRATING	!color: FwStateOKNotPhysics
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( any_in SSDSIDE_FWSETSTATES not_in_state CALIBRATING )  move_to MIXED
        action: NEXT	!visible: 1
            do NEXT all_in SSDSIDE_FWSETACTIONS
            move_to GOING_CALIB
        action: STOP	!visible: 1
            do GO_READY all_in SSDSIDE_FWSETACTIONS
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: SOR(string run_type = "",string run_no = "",string ddl_list = "",string sor_mode = "")	!visible: 1
            do SOR (run_type = run_type, run_no = run_no, ddl_list = ddl_list, sor_mode = sor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
    state: GOING_CALIB	!color: FwStateAttention1
        when ( any_in FWCHILDREN_FWSETSTATES in_state {ERROR,NO_CONTROL} ) move_to ERROR
        when ( any_in SSDINFRASTRUCTURE_FWSETSTATES in_state OFF ) move_to OFF
        when ( any_in SSDSIDE_FWSETSTATES not_in_state {CALIBRATING,GOING_CALIB} )  move_to MIXED
        when ( all_in SSDSIDE_FWSETSTATES in_state CALIBRATING )  move_to CALIBRATING
        action: GO_OFF	!visible: 1
            do GO_OFF all_in SSDSIDE_FWSETACTIONS
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
            do EOR (run_type = run_type, run_no = run_no, eor_mode = eor_mode) all_in ALIDCS_RUNCU_FWSETACTIONS
        action: ACK_RUN_FAILURE	!visible: 1
            do RESET all_in ALIDCS_RUNCU_FWSETACTIONS
        action: GO_SAFE	!visible: 1
            do GO_SAFE all_in ALIDCSSAFE_CU_FWSETACTIONS
        action: GO_SUPERSAFE	!visible: 1
            do GO_SUPERSAFE all_in ALIDCSSAFE_CU_FWSETACTIONS

object: SSD_DCS is_of_class TOP_SsdDetector_CLASS

class: FwChildrenMode_CLASS
!panel: FwChildrenMode.pnl
    state: Complete	!color: _3DFace
        when ( any_in FWCHILDRENMODE_FWSETSTATES in_state IncompleteDead ) move_to IncompleteDead
        when (  ( any_in FWCHILDRENMODE_FWSETSTATES in_state DEAD ) and ( any_in FWCHILDMODE_FWSETSTATES in_state MANUAL )  ) move_to IncompleteDead
        when ( any_in FWCHILDRENMODE_FWSETSTATES in_state Incomplete )  move_to Incomplete
        when ( any_in FWCHILDMODE_FWSETSTATES not_in_state {Included,ExcludedPerm,LockedOutPerm} )  move_to Incomplete
        when ( any_in FWCHILDRENMODE_FWSETSTATES in_state IncompleteDev )  move_to IncompleteDev
    state: Incomplete	!color: FwStateAttention2
        when ( any_in FWCHILDRENMODE_FWSETSTATES in_state IncompleteDead ) move_to IncompleteDead
        when (  ( any_in FWCHILDRENMODE_FWSETSTATES in_state DEAD ) and ( any_in FWCHILDMODE_FWSETSTATES in_state MANUAL )  ) move_to IncompleteDead
        when (  ( all_in FWCHILDMODE_FWSETSTATES in_state {Included,ExcludedPerm,LockedOutPerm} ) and
       ( all_in FWCHILDRENMODE_FWSETSTATES not_in_state Incomplete )  )  move_to Complete
    state: IncompleteDev	!color: FwStateAttention1
        when ( any_in FWCHILDRENMODE_FWSETSTATES in_state IncompleteDead ) move_to IncompleteDead
        when (  ( any_in FWCHILDRENMODE_FWSETSTATES in_state DEAD ) and ( any_in FWCHILDMODE_FWSETSTATES in_state MANUAL )  ) move_to IncompleteDead
        when (  ( any_in FWCHILDMODE_FWSETSTATES not_in_state {Included,ExcludedPerm,LockedOutPerm} ) or
       ( any_in FWCHILDRENMODE_FWSETSTATES in_state Incomplete )  )  move_to Incomplete
        when (  ( all_in FWCHILDRENMODE_FWSETSTATES not_in_state IncompleteDev )  ) move_to Complete
    state: IncompleteDead	!color: FwStateAttention3
        when (  (  ( all_in FWCHILDRENMODE_FWSETSTATES not_in_state DEAD ) or ( all_in FWCHILDMODE_FWSETSTATES not_in_state MANUAL )  ) and ( all_in FWCHILDRENMODE_FWSETSTATES not_in_state IncompleteDead )  )  move_to Complete

object: SSD_DCS_FWCNM is_of_class FwChildrenMode_CLASS

class: ASS_FwChildrenMode_CLASS/associated
!panel: FwChildrenMode.pnl
    state: Complete	!color: _3DFace
    state: Incomplete	!color: FwStateAttention2
    state: IncompleteDev	!color: FwStateAttention1
    state: IncompleteDead	!color: FwStateAttention3

object: SSD_DCS_RUN::SSD_DCS_RUN_FWCNM is_of_class ASS_FwChildrenMode_CLASS

object: SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM is_of_class ASS_FwChildrenMode_CLASS

object: SSD_SAFE::SSD_SAFE_FWCNM is_of_class ASS_FwChildrenMode_CLASS

object: SSD_SIDE_A::SSD_SIDE_A_FWCNM is_of_class ASS_FwChildrenMode_CLASS

object: SSD_SIDE_C::SSD_SIDE_C_FWCNM is_of_class ASS_FwChildrenMode_CLASS

objectset: FWCHILDRENMODE_FWSETSTATES is_of_class VOID

class: FwMode_CLASS
!panel: FwMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Take(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
            move_to InLocal
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
            move_to Included
        action: Manual	!visible: 0
            move_to Manual
        action: Ignore	!visible: 0
            move_to Ignored
    state: Included	!color: FwStateOKPhysics
        action: Exclude(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 0
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 0
            do ExcludeAll(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
    state: InLocal	!color: FwStateOKNotPhysics
        action: Release(string OWNER = "")	!visible: 1
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: ReleaseAll(string OWNER = "")	!visible: 1
            do ExcludeAll(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
        action: Take(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
            move_to InLocal
    state: Manual	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
            move_to Included
        action: Take(string OWNER = "")	!visible: 1
            do Include(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to InManual
        action: Exclude(string OWNER = "")	!visible: 0
            do Exclude(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: Ignore	!visible: 0
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 0
            do ExcludeAll(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
    state: InManual	!color: FwStateOKNotPhysics
        action: Release(string OWNER = "")	!visible: 1
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
        action: ReleaseAll(string OWNER = "")	!visible: 0
            do ExcludeAll(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: SetInLocal	!visible: 0
            move_to InLocal
    state: Ignored	!color: FwStateOKNotPhysics
        action: Include	!visible: 0
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 0
            do Exclude(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded
        action: Manual	!visible: 0
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) all_in FWCHILDMODE_FWSETACTIONS
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 0
            do ExcludeAll(OWNER=OWNER) all_in FWCHILDMODE_FWSETACTIONS
            move_to Excluded

object: SSD_DCS_FWM is_of_class FwMode_CLASS

class: ASS_FwMode_CLASS/associated
!panel: FwMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Take(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: Manual	!visible: 0
        action: Ignore	!visible: 0
    state: Included	!color: FwStateOKPhysics
        action: Exclude(string OWNER = "")	!visible: 0
        action: Manual(string OWNER = "")	!visible: 0
        action: Ignore(string OWNER = "")	!visible: 0
        action: ExcludeAll(string OWNER = "")	!visible: 0
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: Free(string OWNER = "")	!visible: 0
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
    state: InLocal	!color: FwStateOKNotPhysics
        action: Release(string OWNER = "")	!visible: 1
        action: ReleaseAll(string OWNER = "")	!visible: 1
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: Take(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
    state: Manual	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: Take(string OWNER = "")	!visible: 1
        action: Exclude(string OWNER = "")	!visible: 0
        action: Ignore	!visible: 0
        action: Free(string OWNER = "")	!visible: 0
        action: ExcludeAll(string OWNER = "")	!visible: 0
    state: InManual	!color: FwStateOKNotPhysics
        action: Release(string OWNER = "")	!visible: 1
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: ReleaseAll(string OWNER = "")	!visible: 0
        action: SetInLocal	!visible: 0
    state: Ignored	!color: FwStateOKNotPhysics
        action: Include	!visible: 0
        action: Exclude(string OWNER = "")	!visible: 0
        action: Manual	!visible: 0
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
        action: Free(string OWNER = "")	!visible: 0
        action: ExcludeAll(string OWNER = "")	!visible: 0

object: SSD_DCS_RUN::SSD_DCS_RUN_FWM is_of_class ASS_FwMode_CLASS

object: SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM is_of_class ASS_FwMode_CLASS

object: SSD_SAFE::SSD_SAFE_FWM is_of_class ASS_FwMode_CLASS

object: SSD_SIDE_A::SSD_SIDE_A_FWM is_of_class ASS_FwMode_CLASS

object: SSD_SIDE_C::SSD_SIDE_C_FWM is_of_class ASS_FwMode_CLASS

class: SSD_DCS_RUN_FwChildMode_CLASS

!panel: FwChildMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state {Excluded, Manual} ) then
            !    else
                    move_to Excluded
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
                insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: Manual	!visible: 0
            do Manual SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
            move_to Manual
        action: Ignore	!visible: 0
            do Ignore SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
            move_to Ignored
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 1
            do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
            remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            move_to Excluded
        action: ExcludePerm(string OWNER = "")	!visible: 0
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 0
            move_to LockedOut
    state: Included	!color: FwStateOKPhysics
        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Excluded )  do Exclude
        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Ignored )  move_to IGNORED

        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Manual )  move_to MANUAL

        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Dead )  do Manual

        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Included ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                        do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                        remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                        remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                        remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !       else
            !            move_to Included
            !        endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 1
            do Manual(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 1
            do Ignore(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
            insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
        action: ExcludePerm(string OWNER = "")	!visible: 0
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Included ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Included ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Dead ) then
                        do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                        remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                        remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                        remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                   else
                        move_to Included
                    endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to LockedOut
    state: Manual	!color: FwStateOKNotPhysics
        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Included )  move_to EXCLUDED
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Dead ) then
              move_to Manual
            endif
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state InManual ) then
              do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
              insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
              insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
              insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
              if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Included ) then
                move_to Included
              endif
            move_to Manual
        action: Exclude(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                 do SetInLocal SSD_DCS_RUN::SSD_DCS_RUN_FWM
            endif
            move_to Excluded
        action: Ignore	!visible: 0
            do Ignore SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            !move_to Manual
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                 do SetInLocal SSD_DCS_RUN::SSD_DCS_RUN_FWM
            endif
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 1
            !    else
            !        move_to Included
            !    endif
            !else
            !endif
              do ExcludeAll(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
              remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
              remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
              remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !endif
            !move_to Manual
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                 do SetInLocal SSD_DCS_RUN::SSD_DCS_RUN_FWM
            endif
            move_to Excluded
        action: Manual	!visible: 0
            do Manual SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
            move_to Manual
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                 do SetInLocal SSD_DCS_RUN::SSD_DCS_RUN_FWM
            endif
            move_to LockedOut
    state: Ignored	!color: FwStateOKNotPhysics
        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Included )  move_to INCLUDED

        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Excluded ) move_to EXCLUDED

        when ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state Dead )  do Exclude

        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
            insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Included ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                endif
            else
                do Exclude(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Manual(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
            remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                    remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                    remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETSTATES
                remove SSD_DCS_RUN::SSD_DCS_RUN from ALIDCS_RUNCU_FWSETACTIONS
                remove SSD_DCS_RUN::SSD_DCS_RUN_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
    state: LockedOut	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOut
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
                insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOutPerm	!visible: 0
            move_to LockedOutPerm
    state: ExcludedPerm	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            !    else
            !        move_to Excluded
            !    endif
            !else
            !endif
            !move_to Included
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state {Excluded, Manual} ) then
                move_to ExcludedPerm
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
                insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 0
            move_to Excluded
    state: LockedOutPerm	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_DCS_RUN::SSD_DCS_RUN_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOutPerm
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_DCS_RUN::SSD_DCS_RUN_FWM
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETSTATES
                insert SSD_DCS_RUN::SSD_DCS_RUN in ALIDCS_RUNCU_FWSETACTIONS
                insert SSD_DCS_RUN::SSD_DCS_RUN_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 0
            move_to LockedOut

object: SSD_DCS_RUN_FWM is_of_class SSD_DCS_RUN_FwChildMode_CLASS

class: SSD_INFRASTRUCTURE_FwChildMode_CLASS

!panel: FwChildMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state {Excluded, Manual} ) then
            !    else
                    move_to Excluded
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: Manual	!visible: 0
            do Manual SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
            move_to Manual
        action: Ignore	!visible: 0
            do Ignore SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
            move_to Ignored
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 1
            do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            move_to Excluded
        action: ExcludePerm(string OWNER = "")	!visible: 0
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 0
            move_to LockedOut
    state: Included	!color: FwStateOKPhysics
        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Excluded )  do Exclude
        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Ignored )  move_to IGNORED

        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Manual )  move_to MANUAL

        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Dead )  do Manual

        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Included ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                        do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !       else
            !            move_to Included
            !        endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 1
            do Manual(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 1
            do Ignore(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
        action: ExcludePerm(string OWNER = "")	!visible: 0
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Included ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Included ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Dead ) then
                        do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                        remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                   else
                        move_to Included
                    endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to LockedOut
    state: Manual	!color: FwStateOKNotPhysics
        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Included )  move_to EXCLUDED
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Dead ) then
              move_to Manual
            endif
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state InManual ) then
              do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
              insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
              insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
              insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
              if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Included ) then
                move_to Included
              endif
            move_to Manual
        action: Exclude(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                 do SetInLocal SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            endif
            move_to Excluded
        action: Ignore	!visible: 0
            do Ignore SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            !move_to Manual
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                 do SetInLocal SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            endif
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 1
            !    else
            !        move_to Included
            !    endif
            !else
            !endif
              do ExcludeAll(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
              remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
              remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
              remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !endif
            !move_to Manual
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                 do SetInLocal SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            endif
            move_to Excluded
        action: Manual	!visible: 0
            do Manual SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
            move_to Manual
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                 do SetInLocal SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            endif
            move_to LockedOut
    state: Ignored	!color: FwStateOKNotPhysics
        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Included )  move_to INCLUDED

        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Excluded ) move_to EXCLUDED

        when ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state Dead )  do Exclude

        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Included ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                endif
            else
                do Exclude(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Manual(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
            remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                    remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETSTATES
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE from SSDINFRASTRUCTURE_FWSETACTIONS
                remove SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
    state: LockedOut	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOut
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOutPerm	!visible: 0
            move_to LockedOutPerm
    state: ExcludedPerm	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            !    else
            !        move_to Excluded
            !    endif
            !else
            !endif
            !move_to Included
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state {Excluded, Manual} ) then
                move_to ExcludedPerm
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 0
            move_to Excluded
    state: LockedOutPerm	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOutPerm
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWM
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETSTATES
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE in SSDINFRASTRUCTURE_FWSETACTIONS
                insert SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 0
            move_to LockedOut

object: SSD_INFRASTRUCTURE_FWM is_of_class SSD_INFRASTRUCTURE_FwChildMode_CLASS

class: SSD_SAFE_FwChildMode_CLASS

!panel: FwChildMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state {Excluded, Manual} ) then
            !    else
                    move_to Excluded
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
                insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: Manual	!visible: 0
            do Manual SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
            move_to Manual
        action: Ignore	!visible: 0
            do Ignore SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
            move_to Ignored
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 1
            do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
            remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            move_to Excluded
        action: ExcludePerm(string OWNER = "")	!visible: 0
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 0
            move_to LockedOut
    state: Included	!color: FwStateOKPhysics
        when ( SSD_SAFE::SSD_SAFE_FWM in_state Excluded )  do Exclude
        when ( SSD_SAFE::SSD_SAFE_FWM in_state Ignored )  move_to IGNORED

        when ( SSD_SAFE::SSD_SAFE_FWM in_state Manual )  move_to MANUAL

        when ( SSD_SAFE::SSD_SAFE_FWM in_state Dead )  do Manual

        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Included ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                        do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                        remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                        remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                        remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !       else
            !            move_to Included
            !        endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 1
            do Manual(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 1
            do Ignore(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
            insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
        action: ExcludePerm(string OWNER = "")	!visible: 0
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Included ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Included ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    if ( SSD_SAFE::SSD_SAFE_FWM in_state Dead ) then
                        do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                        remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                        remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                        remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                   else
                        move_to Included
                    endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to LockedOut
    state: Manual	!color: FwStateOKNotPhysics
        when ( SSD_SAFE::SSD_SAFE_FWM in_state Included )  move_to EXCLUDED
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM in_state Dead ) then
              move_to Manual
            endif
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state InManual ) then
              do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
              insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
              insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
              insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
              if ( SSD_SAFE::SSD_SAFE_FWM in_state Included ) then
                move_to Included
              endif
            move_to Manual
        action: Exclude(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                 do SetInLocal SSD_SAFE::SSD_SAFE_FWM
            endif
            move_to Excluded
        action: Ignore	!visible: 0
            do Ignore SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            !move_to Manual
            if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                 do SetInLocal SSD_SAFE::SSD_SAFE_FWM
            endif
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 1
            !    else
            !        move_to Included
            !    endif
            !else
            !endif
              do ExcludeAll(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
              remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
              remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
              remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !endif
            !move_to Manual
            if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                 do SetInLocal SSD_SAFE::SSD_SAFE_FWM
            endif
            move_to Excluded
        action: Manual	!visible: 0
            do Manual SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
            move_to Manual
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                 do SetInLocal SSD_SAFE::SSD_SAFE_FWM
            endif
            move_to LockedOut
    state: Ignored	!color: FwStateOKNotPhysics
        when ( SSD_SAFE::SSD_SAFE_FWM in_state Included )  move_to INCLUDED

        when ( SSD_SAFE::SSD_SAFE_FWM in_state Excluded ) move_to EXCLUDED

        when ( SSD_SAFE::SSD_SAFE_FWM in_state Dead )  do Exclude

        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
            insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Included ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Manual(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
            remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SAFE::SSD_SAFE_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                    remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                    remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SAFE::SSD_SAFE_FWM
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETSTATES
                remove SSD_SAFE::SSD_SAFE from ALIDCSSAFE_CU_FWSETACTIONS
                remove SSD_SAFE::SSD_SAFE_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
    state: LockedOut	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOut
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
                insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOutPerm	!visible: 0
            move_to LockedOutPerm
    state: ExcludedPerm	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            !    else
            !        move_to Excluded
            !    endif
            !else
            !endif
            !move_to Included
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state {Excluded, Manual} ) then
                move_to ExcludedPerm
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
                insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 0
            move_to Excluded
    state: LockedOutPerm	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SAFE::SSD_SAFE_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOutPerm
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SAFE::SSD_SAFE_FWM
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETSTATES
                insert SSD_SAFE::SSD_SAFE in ALIDCSSAFE_CU_FWSETACTIONS
                insert SSD_SAFE::SSD_SAFE_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 0
            move_to LockedOut

object: SSD_SAFE_FWM is_of_class SSD_SAFE_FwChildMode_CLASS

class: SSD_SIDE_A_FwChildMode_CLASS

!panel: FwChildMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state {Excluded, Manual} ) then
            !    else
                    move_to Excluded
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: Manual	!visible: 0
            do Manual SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Ignore	!visible: 0
            do Ignore SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 1
            do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            move_to Excluded
        action: ExcludePerm(string OWNER = "")	!visible: 0
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 0
            move_to LockedOut
    state: Included	!color: FwStateOKPhysics
        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Excluded )  do Exclude
        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Ignored )  move_to IGNORED

        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Manual )  move_to MANUAL

        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Dead )  do Manual

        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Included ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                        do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                        remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                        remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                        remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !       else
            !            move_to Included
            !        endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 1
            do Manual(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 1
            do Ignore(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
            insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
        action: ExcludePerm(string OWNER = "")	!visible: 0
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Included ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Included ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Dead ) then
                        do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                        remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                        remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                        remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                   else
                        move_to Included
                    endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to LockedOut
    state: Manual	!color: FwStateOKNotPhysics
        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Included )  move_to EXCLUDED
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Dead ) then
              move_to Manual
            endif
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state InManual ) then
              do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
              insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
              insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
              insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
              if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Included ) then
                move_to Included
              endif
            move_to Manual
        action: Exclude(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_A::SSD_SIDE_A_FWM
            endif
            move_to Excluded
        action: Ignore	!visible: 0
            do Ignore SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            !move_to Manual
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_A::SSD_SIDE_A_FWM
            endif
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 1
            !    else
            !        move_to Included
            !    endif
            !else
            !endif
              do ExcludeAll(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
              remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
              remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
              remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !endif
            !move_to Manual
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_A::SSD_SIDE_A_FWM
            endif
            move_to Excluded
        action: Manual	!visible: 0
            do Manual SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_A::SSD_SIDE_A_FWM
            endif
            move_to LockedOut
    state: Ignored	!color: FwStateOKNotPhysics
        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Included )  move_to INCLUDED

        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Excluded ) move_to EXCLUDED

        when ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state Dead )  do Exclude

        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
            insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Included ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Manual(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SIDE_A::SSD_SIDE_A_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SIDE_A::SSD_SIDE_A_FWM
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_A::SSD_SIDE_A from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_A::SSD_SIDE_A_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
    state: LockedOut	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOut
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOutPerm	!visible: 0
            move_to LockedOutPerm
    state: ExcludedPerm	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            !    else
            !        move_to Excluded
            !    endif
            !else
            !endif
            !move_to Included
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state {Excluded, Manual} ) then
                move_to ExcludedPerm
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 0
            move_to Excluded
    state: LockedOutPerm	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_A::SSD_SIDE_A_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOutPerm
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_A::SSD_SIDE_A_FWM
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_A::SSD_SIDE_A in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_A::SSD_SIDE_A_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 0
            move_to LockedOut

object: SSD_SIDE_A_FWM is_of_class SSD_SIDE_A_FwChildMode_CLASS

class: SSD_SIDE_C_FwChildMode_CLASS

!panel: FwChildMode.pnl
    state: Excluded	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state {Excluded, Manual} ) then
            !    else
                    move_to Excluded
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: Manual	!visible: 0
            do Manual SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Ignore	!visible: 0
            do Ignore SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 1
            do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            move_to Excluded
        action: ExcludePerm(string OWNER = "")	!visible: 0
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 0
            move_to LockedOut
    state: Included	!color: FwStateOKPhysics
        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Excluded )  do Exclude
        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Ignored )  move_to IGNORED

        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Manual )  move_to MANUAL

        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Dead )  do Manual

        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Included ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                        do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                        remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                        remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                        remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !       else
            !            move_to Included
            !        endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 1
            do Manual(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Ignore(string OWNER = "")	!visible: 1
            do Ignore(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
            insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            move_to Included
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
        action: ExcludePerm(string OWNER = "")	!visible: 0
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Included ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to ExcludedPerm
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Included ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Dead ) then
                        do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                        remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                        remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                        remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                   else
                        move_to Included
                    endif
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to LockedOut
    state: Manual	!color: FwStateOKNotPhysics
        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Included )  move_to EXCLUDED
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Dead ) then
              move_to Manual
            endif
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state InManual ) then
              do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
              insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
              insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
              insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
              if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Included ) then
                move_to Included
              endif
            move_to Manual
        action: Exclude(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_C::SSD_SIDE_C_FWM
            endif
            move_to Excluded
        action: Ignore	!visible: 0
            do Ignore SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
            move_to Ignored
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            !move_to Manual
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_C::SSD_SIDE_C_FWM
            endif
            move_to Excluded
        action: ExcludeAll(string OWNER = "")	!visible: 1
            !    else
            !        move_to Included
            !    endif
            !else
            !endif
              do ExcludeAll(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
              remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
              remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
              remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !endif
            !move_to Manual
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_C::SSD_SIDE_C_FWM
            endif
            move_to Excluded
        action: Manual	!visible: 0
            do Manual SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: Exclude&LockOut(string OWNER = "")	!visible: 1
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            !    move_to Excluded
            !endif
            !    else
            !    endif
            !else
            !endif
            !    move_to Excluded
            !endif
            !move_to Manual
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                 do SetInLocal SSD_SIDE_C::SSD_SIDE_C_FWM
            endif
            move_to LockedOut
    state: Ignored	!color: FwStateOKNotPhysics
        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Included )  move_to INCLUDED

        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Excluded ) move_to EXCLUDED

        when ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state Dead )  do Exclude

        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
            insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            move_to Included
        action: Exclude(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Included ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do Release(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                endif
            else
                do Exclude(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
        action: Manual(string OWNER = "")	!visible: 0
            do Manual(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
            remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
            move_to Manual
        action: SetMode(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 0
            do SetMode(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
        action: Free(string OWNER = "")	!visible: 0
            do Free(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
            move_to Included
        action: ExcludeAll(string OWNER = "")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state {Included,Ignored,Manual} ) then
                if ( SSD_SIDE_C::SSD_SIDE_C_FWM in_state InManual ) then
                    do ReleaseAll(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                    remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                    remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
                else
                    move_to Included
                endif
            else
                do ExcludeAll(OWNER=OWNER) SSD_SIDE_C::SSD_SIDE_C_FWM
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETSTATES
                remove SSD_SIDE_C::SSD_SIDE_C from SSDSIDE_FWSETACTIONS
                remove SSD_SIDE_C::SSD_SIDE_C_FWCNM from FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Excluded
    state: LockedOut	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOut
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOutPerm	!visible: 0
            move_to LockedOutPerm
    state: ExcludedPerm	!color: FwStateOKNotPhysics
        action: Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            !    else
            !        move_to Excluded
            !    endif
            !else
            !endif
            !move_to Included
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state {Excluded, Manual} ) then
                move_to ExcludedPerm
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 1
            move_to LockedOut
        action: Exclude(string OWNER = "")	!visible: 0
            move_to Excluded
    state: LockedOutPerm	!color: FwStateOKNotPhysics
        action: UnLockOut	!visible: 1
            move_to Excluded
        action: UnLockOut&Include(string OWNER = "",string EXCLUSIVE = "YES")	!visible: 1
            if ( SSD_SIDE_C::SSD_SIDE_C_FWM not_in_state Excluded ) then
            !    else
                    move_to LockedOutPerm
            !    endif
            else
                do Include(OWNER=OWNER,EXCLUSIVE=EXCLUSIVE) SSD_SIDE_C::SSD_SIDE_C_FWM
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETSTATES
                insert SSD_SIDE_C::SSD_SIDE_C in SSDSIDE_FWSETACTIONS
                insert SSD_SIDE_C::SSD_SIDE_C_FWCNM in FWCHILDRENMODE_FWSETSTATES
            endif
            move_to Included
        action: LockOut	!visible: 0
            move_to LockedOut

object: SSD_SIDE_C_FWM is_of_class SSD_SIDE_C_FwChildMode_CLASS

objectset: FWCHILDMODE_FWSETSTATES is_of_class VOID {SSD_DCS_RUN_FWM,
	SSD_INFRASTRUCTURE_FWM,
	SSD_SAFE_FWM,
	SSD_SIDE_A_FWM,
	SSD_SIDE_C_FWM }
objectset: FWCHILDMODE_FWSETACTIONS is_of_class VOID {SSD_DCS_RUN_FWM,
	SSD_INFRASTRUCTURE_FWM,
	SSD_SAFE_FWM,
	SSD_SIDE_A_FWM,
	SSD_SIDE_C_FWM }

class: ASS_AliDcs_runCU_CLASS/associated
!panel: aliDcsRunUnit/aliDcsRunCU.pnl
    parameters: string run_no = "uninitialized"
    state: RUN_OK	!color: FwStateOKPhysics
        action: SOR(string run_type = "",string run_no = "",string ddl_list = "",string sor_mode = "")	!visible: 1
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
        action: INHIBIT_RUN	!visible: 1
    state: SOR_PROGRESSING	!color: FwStateAttention1
        action: RESET	!visible: 1
    state: EOR_PROGRESSING	!color: FwStateAttention1
        action: RESET	!visible: 1
    state: SOR_FAILURE	!color: FwStateAttention3
        action: RESET	!visible: 1
    state: EOR_FAILURE	!color: FwStateAttention3
        action: RESET	!visible: 1
    state: RUN_INHIBIT	!color: FwStateOKNotPhysics
        action: EOR(string run_type = "",string run_no = "",string eor_mode = "")	!visible: 1
        action: ALLOW_RUN	!visible: 1

object: SSD_DCS_RUN::SSD_DCS_RUN is_of_class ASS_AliDcs_runCU_CLASS

objectset: ALIDCS_RUNCU_FWSETSTATES is_of_class VOID
objectset: ALIDCS_RUNCU_FWSETACTIONS is_of_class VOID

class: ASS_SsdInfrastructure_CLASS/associated
!panel: ssdDetector/fsm/ssdInfrastructure.pnl
    state: MIXED	!color: FwStateAttention1
        action: RESET	!visible: 1
        action: SWITCH_ON	!visible: 1
        action: SWITCH_OFF	!visible: 1
        action: CONFIGURE	!visible: 1
    state: OFF	!color: FwStateOKNotPhysics
        action: SWITCH_ON	!visible: 1
    state: READY	!color: FwStateOKPhysics
        action: RESET	!visible: 1
        action: SWITCH_OFF	!visible: 1
        action: CONFIGURE	!visible: 1
    state: BUSY	!color: FwStateAttention1
        action: RESET	!visible: 1
        action: SWITCH_OFF	!visible: 1
    state: ERROR	!color: FwStateAttention3
        action: RESET	!visible: 1
        action: SWITCH_ON	!visible: 1
        action: SWITCH_OFF	!visible: 1
    state: NO_CONTROL	!color: FwStateAttention2
        action: RESET	!visible: 1
        action: SWITCH_ON	!visible: 1
        action: SWITCH_OFF	!visible: 1
    state: NO_COOLING	!color: FwStateAttention2
        action: SWITCH_OFF	!visible: 1

object: SSD_INFRASTRUCTURE::SSD_INFRASTRUCTURE is_of_class ASS_SsdInfrastructure_CLASS

objectset: SSDINFRASTRUCTURE_FWSETSTATES is_of_class VOID
objectset: SSDINFRASTRUCTURE_FWSETACTIONS is_of_class VOID

class: ASS_AliDcsSafe_CU_CLASS/associated
!panel: AliDcsSafe_CU.pnl
    state: SUPERSAFE	!color: FwStateOKNotPhysics
        action: RESTORE_SAFE	!visible: 1
    state: SAFE	!color: FwStateOKPhysics
        action: GO_SUPERSAFE	!visible: 1
    state: MOVING_SAFE	!color: FwStateAttention1
    state: MOVING_SUPERSAFE	!color: FwStateAttention1
    state: NOT_SAFE	!color: FwStateAttention2
        action: GO_SAFE	!visible: 1

object: SSD_SAFE::SSD_SAFE is_of_class ASS_AliDcsSafe_CU_CLASS

objectset: ALIDCSSAFE_CU_FWSETSTATES is_of_class VOID
objectset: ALIDCSSAFE_CU_FWSETACTIONS is_of_class VOID

class: ASS_SsdSide_CLASS/associated
!panel: ssdDetector/fsm/ssdSide.pnl
    state: OFF	!color: FwStateOKNotPhysics
        action: GO_LOW_POWER	!visible: 1
        action: GO_RESET	!visible: 1
        action: GO_READY	!visible: 1
    state: READY	!color: FwStateOKPhysics
        action: GO_OFF	!visible: 0
        action: GO_LOW_POWER	!visible: 0
        action: GO_RESET	!visible: 1
        action: GO_CONF	!visible: 1
        action: CALIBRATE	!visible: 0
    state: HV_ONLY	!color: FwStateOKNotPhysics
        action: GO_OFF	!visible: 1
    state: LOW_POWER	!color: FwStateOKNotPhysics
        action: GO_OFF	!visible: 1
        action: GO_RESET	!visible: 1
        action: GO_CONF	!visible: 1
        action: GO_READY	!visible: 1
    state: RESET	!color: FwStateOKNotPhysics
        action: GO_OFF	!visible: 1
        action: GO_LOW_POWER	!visible: 1
        action: GO_CONF	!visible: 1
        action: GO_READY	!visible: 1
    state: CONFIGURED	!color: FwStateOKNotPhysics
        action: GO_OFF	!visible: 0
        action: GO_LOW_POWER	!visible: 0
        action: GO_RESET	!visible: 1
        action: GO_READY	!visible: 1
    state: MIXED	!color: FwStateAttention1
        action: GO_OFF	!visible: 1
        action: GO_LOW_POWER	!visible: 1
        action: GO_RESET	!visible: 1
        action: GO_READY	!visible: 1
    state: ERROR	!color: FwStateAttention3
        action: GO_OFF	!visible: 1
        action: GO_LOW_POWER	!visible: 1
        action: GO_RESET	!visible: 1
        action: GO_READY	!visible: 1
    state: CALIBRATING	!color: FwStateOKNotPhysics
        action: NEXT	!visible: 1
        action: GO_OFF	!visible: 1
        action: GO_LOW_POWER	!visible: 1
        action: GO_RESET	!visible: 1
        action: GO_READY	!visible: 1
    state: GOING_CALIB	!color: FwStateAttention1
        action: GO_OFF	!visible: 1

object: SSD_SIDE_A::SSD_SIDE_A is_of_class ASS_SsdSide_CLASS

object: SSD_SIDE_C::SSD_SIDE_C is_of_class ASS_SsdSide_CLASS

objectset: SSDSIDE_FWSETSTATES is_of_class VOID
objectset: SSDSIDE_FWSETACTIONS is_of_class VOID


objectset: FWCHILDREN_FWSETACTIONS union {ALIDCS_RUNCU_FWSETACTIONS,
	SSDINFRASTRUCTURE_FWSETACTIONS,
	ALIDCSSAFE_CU_FWSETACTIONS,
	SSDSIDE_FWSETACTIONS } is_of_class VOID
objectset: FWCHILDREN_FWSETSTATES union {ALIDCS_RUNCU_FWSETSTATES,
	SSDINFRASTRUCTURE_FWSETSTATES,
	ALIDCSSAFE_CU_FWSETSTATES,
	SSDSIDE_FWSETSTATES } is_of_class VOID

