/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.Format;
import dim.MutableMemory;
import dim.Sizeof;

public class DimData
extends MutableMemory {
    int published;
    int curr_size = 0;
    String format = "";
    Format itsFormat;
    int itsLast = 0;

    public void do_publish() {
        this.itsFormat = new Format(this.format, 1);
        this.published = 1;
    }

    int do_setup(char type, int num) {
        if (this.published == 0) {
            if (this.itsLast == 1) {
                System.out.println("JDIM: Dynamic String Item must be at the end");
                return 0;
            }
            if (this.format != "") {
                this.format = String.valueOf(this.format) + ";";
            }
            this.format = String.valueOf(this.format) + type + ":" + num;
            return 1;
        }
        char ntype = this.itsFormat.getType();
        int nnum = this.itsFormat.getNum();
        if (ntype != type) {
            System.out.println("JDIM: Expected " + ntype + " found " + type);
            return 0;
        }
        if (nnum != num && nnum != 0 && num != 0) {
            System.out.println("JDIM: Expected " + nnum + " items, found " + num);
        }
        if (nnum == 0) {
            return 1;
        }
        return nnum;
    }

    public int setInt(int theData) {
        if (this.do_setup('I', 1) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += 4;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyInt(theData);
        return 1;
    }

    public int setFloat(float theData) {
        if (this.do_setup('F', 1) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += 4;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyFloat(theData);
        return 1;
    }

    public int setDouble(double theData) {
        if (this.do_setup('D', 1) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += 8;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyDouble(theData);
        return 1;
    }

    public int setString(String theData, int max_size) {
        if (this.do_setup('C', max_size) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += max_size;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyString(theData);
        return 1;
    }

    public int setString(String theData) {
        int max_size = this.published == 0 ? this.do_setup('C', theData.length()) : this.do_setup('C', 0);
        if (max_size == 0) {
            return 0;
        }
        this.itsLast = 1;
        int offset = this.curr_size;
        this.curr_size += max_size;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyString(theData);
        return 1;
    }

    public int setIntArray(int[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        if (this.do_setup('I', len) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += size;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyFromIntArray(theData, 0, len);
        return 1;
    }

    public int setFloatArray(float[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        if (this.do_setup('F', len) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += size;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyFromFloatArray(theData, 0, len);
        return 1;
    }

    public int setDoubleArray(double[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 8;
        if (this.do_setup('D', len) == 0) {
            return 0;
        }
        int offset = this.curr_size;
        this.curr_size += size;
        this.setSize(this.curr_size);
        this.setDataStoreOffset(offset);
        this.copyFromDoubleArray(theData, 0, len);
        return 1;
    }
}

