/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FetchConfig;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ForwardOnlyFetcherDecorator
implements FBFetcher {
    private final FBFetcher fetcher;

    ForwardOnlyFetcherDecorator(FBFetcher fetcher) {
        this.fetcher = Objects.requireNonNull(fetcher, "fetcher");
        assert (!(fetcher instanceof FBStatementFetcher)) : "Decorating an instance of FBStatementFetcher is not appropriate as it is already forward-only";
    }

    @Override
    public FetchConfig getFetchConfig() {
        return this.fetcher.getFetchConfig();
    }

    @Override
    public void setReadOnly() throws SQLException {
        this.fetcher.setReadOnly();
    }

    @Override
    public boolean first() throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public boolean last() throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public boolean previous() throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public boolean next() throws SQLException {
        return this.fetcher.next();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public boolean relative(int row) throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public void afterLast() throws SQLException {
        throw ForwardOnlyFetcherDecorator.notScrollable();
    }

    @Override
    public void close() throws SQLException {
        this.fetcher.close();
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.fetcher.close(completionReason);
    }

    @Override
    public boolean isClosed() {
        return this.fetcher.isClosed();
    }

    @Override
    public int getRowNum() throws SQLException {
        return this.fetcher.getRowNum();
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.fetcher.isEmpty();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.fetcher.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.fetcher.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.fetcher.isLast();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.fetcher.isAfterLast();
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
        this.fetcher.insertRow(data);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.fetcher.deleteRow();
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
        this.fetcher.updateRow(data);
    }

    @Override
    public void renotifyCurrentRow() throws SQLException {
        this.fetcher.renotifyCurrentRow();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetcher.getFetchSize();
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetcher.setFetchSize(fetchSize);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetcher.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetcher.setFetchDirection(direction);
    }

    @Override
    public int currentPosition() throws SQLException {
        return this.fetcher.currentPosition();
    }

    @Override
    public int size() throws SQLException {
        return this.fetcher.size();
    }

    @Override
    public void setFetcherListener(FBObjectListener.FetcherListener fetcherListener) {
        this.fetcher.setFetcherListener(fetcherListener);
    }

    private static SQLException notScrollable() {
        return FbExceptionBuilder.toNonTransientException(337248279);
    }
}

