/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;

class FbDeflaterOutputStream
extends DeflaterOutputStream
implements EncryptedStreamSupport {
    private static final System.Logger log = System.getLogger(FbDeflaterOutputStream.class.getName());
    private static final int BUF_SIZE = Math.max(512, JaybirdSystemProperties.getWireDeflateBufferSize(8192));
    private boolean encrypted;

    public FbDeflaterOutputStream(OutputStream out) {
        super(out, new Deflater(), BUF_SIZE, true);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (Throwable throwable) {
            this.buf = new byte[1];
            if (log.isLoggable(System.Logger.Level.TRACE)) {
                log.log(System.Logger.Level.TRACE, "FbDeflaterOutputStream: Uncompressed bytes: {0} to compressed bytes: {1}", this.def.getBytesRead(), this.def.getBytesWritten());
            }
            this.def.end();
            throw throwable;
        }
        this.buf = new byte[1];
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            log.log(System.Logger.Level.TRACE, "FbDeflaterOutputStream: Uncompressed bytes: {0} to compressed bytes: {1}", this.def.getBytesRead(), this.def.getBytesWritten());
        }
        this.def.end();
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Output stream already encrypted");
        }
        this.out = new CipherOutputStream(this.out, cipher);
        this.encrypted = true;
    }
}

