/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.firebirdsql.gds.JaybirdSystemProperties;

final class FbCipherInputStream
extends FilterInputStream {
    private static final int BUF_SIZE = Math.max(512, JaybirdSystemProperties.getWireDecryptBufferSize(8192));
    private final Cipher cipher;
    private byte[] inBuf;
    private byte[] outBuf = null;
    private int outPos = 0;
    private int outLim = 0;
    private boolean eof = false;
    private boolean closed = false;

    public FbCipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.cipher = c;
        this.inBuf = new byte[BUF_SIZE];
    }

    private void ensureCapacity(int inLen) {
        int minLen = this.cipher.getOutputSize(inLen);
        if (this.outBuf == null || this.outBuf.length < minLen) {
            this.outBuf = new byte[minLen];
        }
        this.outPos = 0;
        this.outLim = 0;
    }

    private int getMoreData() throws IOException {
        if (this.eof) {
            return -1;
        }
        int readin = this.in.read(this.inBuf);
        if (readin == -1) {
            this.eof = true;
            this.ensureCapacity(0);
            try {
                this.outLim = this.cipher.doFinal(this.outBuf, 0);
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
                throw new IOException(e);
            }
            return this.outLim == 0 ? -1 : this.outLim;
        }
        this.ensureCapacity(readin);
        try {
            this.outLim = this.cipher.update(this.inBuf, 0, readin, this.outBuf, this.outPos);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        return this.outLim;
    }

    @Override
    public int read() throws IOException {
        if (this.outPos >= this.outLim) {
            int i;
            while ((i = this.getMoreData()) == 0) {
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.outBuf[this.outPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.outPos >= this.outLim) {
            int i;
            while ((i = this.getMoreData()) == 0) {
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = Math.min(this.outLim - this.outPos, len);
        if (b != null) {
            System.arraycopy(this.outBuf, this.outPos, b, off, available);
        }
        this.outPos += available;
        return available;
    }

    @Override
    public long skip(long n) {
        int toSkip = (int)Math.min((long)(this.outLim - this.outPos), n);
        if (toSkip < 0) {
            return 0L;
        }
        this.outPos += toSkip;
        return toSkip;
    }

    @Override
    public int available() {
        return this.outLim - this.outPos;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.in.close();
            if (!this.eof) {
                this.ensureCapacity(0);
                try {
                    this.cipher.doFinal(this.outBuf, 0);
                }
                catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.outBuf = null;
            this.inBuf = new byte[1];
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

