////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWKIT.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// UART (serial port) terminal GUI for CRW-DAQ.                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20230708 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

program uartterminal;
{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}
uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 {$IFDEF UNIX} unix, baseunix, termio,  {$ENDIF}
 sysutils, classes, math, interfaces, forms,
 form_uartterminalgui,
 _crw_alloc, _crw_str, _crw_fio, _crw_rtc, _crw_serio, _crw_uart;

begin
  RequireDerivedFormResource:=True;
  Application.Scaled:=True;
  Application.Initialize;
  Application.CreateForm(TFormUartTerminalGui, FormUartTerminalGui);
  Application.Run;
end.

