#!/bin/bash

##########################################################
# Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function fatal(){
 1>&2 echo -ne "\n\n$2\n\n";
 exit $1;
};

# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function make_color_table_txt(){
 unix barbmp --colors | tr '[:upper:]' '[:lower:]' | tr '=' ' ' | tr '$' ' ' | xargs -n 2;
};

function make_color_table_sh(){
 echo "declare -A color_table=();";
 echo "function add_color_table(){ color_table[\$1]=\$2; };";
 echo "function get_color_table(){ echo \"\${color_table[\$1]}\"; };";
 echo "function init_color_table(){";
 unix barbmp --colors | tr '[:upper:]' '[:lower:]' | tr '=' ' ' | tr '$' ' ' | xargs -n 2 | xargs -n 1 -I '{}' echo " add_color_table {};";
 echo "};";
};

function make_color_table_c(){
 echo "void init_color_table(){";
 unix barbmp --colors | tr '[:upper:]' '[:lower:]' | tr '=' ' ' | tr '$' ' ' | xargs -n 2 | xargs -n 1 -I '{}' echo " add_color_table(\"{});" | sed 's/\b \b/\",0x/';
 echo "};";
};


function main(){
 local txt="$scriptHOME/color_table.txt";
 make_color_table_txt > $txt;
 local sh="$scriptHOME/color_table.sh";
 make_color_table_sh > $sh;
 local c="$scriptHOME/color_table.c";
 make_color_table_c > $c;
};

main "$@";

##############
## END OF FILE
##############
