/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jaybird.util.StringUtils;
import org.firebirdsql.jaybird.util.UncheckedSQLException;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

final class FBRowUpdater
implements FirebirdRowUpdater {
    private static final int EST_COLUMN_SIZE = 13;
    private static final int EST_STATEMENT_SIZE = 64;
    private static final String ROW_INSERT = "insert";
    private static final String ROW_CURRENT = "current";
    private static final String ROW_UPDATE = "update";
    private static final String ROW_OLD = "old";
    private static final byte[][] EMPTY_2D_BYTES = new byte[0][];
    private final String tableName;
    private final FBObjectListener.ResultSetListener rsListener;
    private final GDSHelper gdsHelper;
    private final RowDescriptor rowDescriptor;
    private final List<FBField> fields;
    private final QuoteStrategy quoteStrategy;
    private final FbStatement[] statements = new FbStatement[4];
    private final List<FieldDescriptor> keyColumns;
    private final RowValue newRow;
    private RowValue oldRow;
    private boolean inInsertRow;
    private boolean closed;
    private boolean processing;
    private static final int UPDATE_STATEMENT_TYPE = 0;
    private static final int DELETE_STATEMENT_TYPE = 1;
    private static final int INSERT_STATEMENT_TYPE = 2;
    private static final int SELECT_STATEMENT_TYPE = 3;

    FBRowUpdater(FBConnection connection, RowDescriptor rowDescriptor, boolean cached, FBObjectListener.ResultSetListener rsListener) throws SQLException {
        this.tableName = FBRowUpdater.requireSingleTableName(rowDescriptor);
        this.keyColumns = FBRowUpdater.deriveKeyColumns(this.tableName, rowDescriptor, connection.getMetaData());
        this.rsListener = rsListener;
        this.gdsHelper = connection.getGDSHelper();
        this.quoteStrategy = connection.getQuoteStrategy();
        this.fields = this.createFields(rowDescriptor, cached);
        this.newRow = rowDescriptor.createDefaultFieldValues();
        this.rowDescriptor = rowDescriptor;
    }

    private List<FBField> createFields(RowDescriptor rowDescriptor, boolean cached) throws SQLException {
        try {
            return StreamSupport.stream(rowDescriptor.spliterator(), false).map(fieldDescriptor -> this.createFieldUnchecked((FieldDescriptor)fieldDescriptor, cached)).toList();
        }
        catch (UncheckedSQLException e) {
            throw e.getCause();
        }
    }

    private FBField createFieldUnchecked(FieldDescriptor fieldDescriptor, boolean cached) {
        try {
            return FBField.createField(fieldDescriptor, new FieldDataProviderImpl(fieldDescriptor.getPosition()), this.gdsHelper, cached);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    private static String requireSingleTableName(RowDescriptor rowDescriptor) throws SQLException {
        String tableName = null;
        for (FieldDescriptor fieldDescriptor : rowDescriptor) {
            if (tableName == null) {
                tableName = fieldDescriptor.getOriginalTableName();
                continue;
            }
            if (Objects.equals(tableName, fieldDescriptor.getOriginalTableName())) continue;
            throw new FBResultSetNotUpdatableException("Underlying result set references at least two relations: %s and %s.".formatted(tableName, fieldDescriptor.getOriginalTableName()));
        }
        if (StringUtils.isNullOrEmpty(tableName)) {
            throw new FBResultSetNotUpdatableException("Underlying result set references no relations");
        }
        return tableName;
    }

    private void notifyExecutionStarted() throws SQLException {
        if (this.closed) {
            throw new SQLException("Corresponding result set is closed.", "24000");
        }
        if (this.processing) {
            return;
        }
        this.rsListener.executionStarted(this);
        this.processing = true;
    }

    private void notifyExecutionCompleted(boolean success) throws SQLException {
        if (!this.processing) {
            return;
        }
        this.rsListener.executionCompleted(this, success);
        this.processing = false;
    }

    private void deallocateStatement(FbStatement handle, SQLExceptionChainBuilder chain) {
        if (handle == null) {
            return;
        }
        try {
            handle.close();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        for (FbStatement statement : this.statements) {
            this.deallocateStatement(statement, chain);
        }
        try {
            this.notifyExecutionCompleted(true);
        }
        catch (SQLException e) {
            chain.append(e);
        }
        chain.throwIfPresent();
    }

    @Override
    public void setRow(RowValue row) {
        this.oldRow = row;
        this.newRow.reset();
        this.inInsertRow = false;
    }

    @Override
    public void cancelRowUpdates() {
        this.newRow.reset();
        this.inInsertRow = false;
    }

    @Override
    public FBField getField(int fieldPosition) {
        return this.fields.get(fieldPosition);
    }

    private static List<FieldDescriptor> deriveKeyColumns(String tableName, RowDescriptor rowDescriptor, DatabaseMetaData dbmd) throws SQLException {
        List<FieldDescriptor> keyColumns = FBRowUpdater.keyColumnsOfBestRowIdentifier(tableName, rowDescriptor, dbmd);
        if (keyColumns.isEmpty() && (keyColumns = FBRowUpdater.keyColumnsOfDbKey(rowDescriptor)).isEmpty()) {
            throw new FBResultSetNotUpdatableException("Underlying result set does not contain all columns that form 'best row identifier' and no RDB$DB_KEY was available as fallback");
        }
        return List.copyOf(keyColumns);
    }

    private static List<FieldDescriptor> keyColumnsOfBestRowIdentifier(String tableName, RowDescriptor rowDescriptor, DatabaseMetaData dbmd) throws SQLException {
        try (ResultSet bestRowIdentifier = dbmd.getBestRowIdentifier("", "", tableName, 1, true);){
            int bestRowIdentifierColumnCount = 0;
            ArrayList<FieldDescriptor> keyColumns = new ArrayList<FieldDescriptor>();
            while (bestRowIdentifier.next()) {
                ++bestRowIdentifierColumnCount;
                String columnName = bestRowIdentifier.getString(2);
                if (columnName == null) continue;
                for (FieldDescriptor fieldDescriptor : rowDescriptor) {
                    if ("RDB$DB_KEY".equals(columnName) && fieldDescriptor.isDbKey()) {
                        List<FieldDescriptor> list = List.of(fieldDescriptor);
                        return list;
                    }
                    if (!columnName.equals(fieldDescriptor.getOriginalName())) continue;
                    keyColumns.add(fieldDescriptor);
                }
                if (keyColumns.size() == bestRowIdentifierColumnCount) continue;
                List list = List.of();
                return list;
            }
            ArrayList<FieldDescriptor> arrayList = keyColumns;
            return arrayList;
        }
    }

    private static List<FieldDescriptor> keyColumnsOfDbKey(RowDescriptor rowDescriptor) {
        for (FieldDescriptor fieldDescriptor : rowDescriptor) {
            if (!fieldDescriptor.isDbKey()) continue;
            return List.of(fieldDescriptor);
        }
        return List.of();
    }

    private void appendWhereClause(StringBuilder sb) {
        sb.append("where ");
        if (this.keyColumns.get(0).isDbKey()) {
            sb.append("RDB$DB_KEY=?");
            return;
        }
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.keyColumns) {
            if (first) {
                first = false;
            } else {
                sb.append("\nand ");
            }
            this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), sb).append("=?");
        }
    }

    private String buildUpdateStatement() {
        StringBuilder sb = new StringBuilder(64 + this.newRow.initializedCount() * 13).append("update ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append(" set ");
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
            if (!this.newRow.isInitialized(fieldDescriptor.getPosition()) || fieldDescriptor.isDbKey()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n\t");
            }
            this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), sb).append("=?");
        }
        sb.append('\n');
        this.appendWhereClause(sb);
        return sb.toString();
    }

    private String buildDeleteStatement() {
        StringBuilder sb = new StringBuilder(64).append("delete from ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb);
        return sb.toString();
    }

    private String buildInsertStatement() {
        int initializedColumnCount = this.newRow.initializedCount();
        StringBuilder columns = new StringBuilder(initializedColumnCount * 13);
        StringBuilder params = new StringBuilder(initializedColumnCount * 2);
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
            if (!this.newRow.isInitialized(fieldDescriptor.getPosition()) || fieldDescriptor.isDbKey()) continue;
            if (first) {
                first = false;
            } else {
                columns.append(',');
                params.append(',');
            }
            this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), columns);
            params.append('?');
        }
        StringBuilder sb = new StringBuilder(27 + this.tableName.length() + columns.length() + params.length()).append("insert into ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append(" (").append((CharSequence)columns).append(") values (").append((CharSequence)params).append(')');
        return sb.toString();
    }

    private String buildSelectStatement() {
        StringBuilder columns = new StringBuilder(this.rowDescriptor.getCount() * 13);
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
            if (first) {
                first = false;
            } else {
                columns.append(',');
            }
            if (fieldDescriptor.isDbKey()) {
                columns.append("RDB$DB_KEY");
                continue;
            }
            this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), columns);
        }
        StringBuilder sb = new StringBuilder(64 + columns.length()).append("select ").append((CharSequence)columns).append("\nfrom ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyRow(int statementType) throws SQLException {
        try (LockCloseable ignored = this.gdsHelper.withLock();){
            boolean success = false;
            try {
                this.notifyExecutionStarted();
                this.executeStatement(statementType, this.getStatementWithTransaction(statementType));
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private FbStatement getStatementWithTransaction(int statementType) throws SQLException {
        FbStatement stmt = this.statements[statementType];
        if (stmt == null) {
            this.statements[statementType] = this.gdsHelper.allocateStatement();
            return this.statements[statementType];
        }
        stmt.setTransaction(this.gdsHelper.getCurrentTransaction());
        return stmt;
    }

    @Override
    public void updateRow() throws SQLException {
        this.modifyRow(0);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.modifyRow(1);
    }

    @Override
    public void insertRow() throws SQLException {
        this.modifyRow(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        try (LockCloseable ignored = this.gdsHelper.withLock();){
            boolean success = false;
            try {
                this.notifyExecutionStarted();
                FbStatement selectStatement = this.getStatementWithTransaction(3);
                RowListener rowListener = new RowListener();
                selectStatement.addStatementListener(rowListener);
                try {
                    this.executeStatement(3, selectStatement);
                    selectStatement.fetchRows(10);
                    List<RowValue> rows = rowListener.getRows();
                    if (rows.isEmpty()) {
                        throw new SQLException("No rows could be fetched.");
                    }
                    if (rows.size() > 1) {
                        throw new SQLException("More then one row fetched.");
                    }
                    this.setRow(rows.get(0));
                }
                finally {
                    selectStatement.removeStatementListener(rowListener);
                    selectStatement.closeCursor();
                }
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private void executeStatement(int statementType, FbStatement stmt) throws SQLException {
        if (statementType != 2) {
            if (this.inInsertRow) {
                throw new SQLException("Only insertRow() is allowed when result set is positioned on insert row.");
            }
            if (this.oldRow == null) {
                throw new SQLException("Result set is not positioned on a row.");
            }
        }
        this.flushFields();
        stmt.prepare(this.generateStatementText(statementType));
        ArrayList<byte[]> params = new ArrayList<byte[]>(this.newRow.initializedCount() + this.keyColumns.size());
        if (statementType == 0 || statementType == 2) {
            for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
                if (!this.newRow.isInitialized(fieldDescriptor.getPosition()) || fieldDescriptor.isDbKey()) continue;
                params.add(this.newRow.getFieldData(fieldDescriptor.getPosition()));
            }
        }
        if (statementType != 2) {
            for (FieldDescriptor keyColumn : this.keyColumns) {
                params.add(this.oldRow.getFieldData(keyColumn.getPosition()));
            }
        }
        stmt.execute(RowValue.of((byte[][])params.toArray((T[])EMPTY_2D_BYTES)));
    }

    private void flushFields() throws SQLException {
        for (FBField field : this.fields) {
            if (!(field instanceof FBFlushableField)) continue;
            FBFlushableField flushableField = (FBFlushableField)((Object)field);
            flushableField.flushCachedData();
        }
    }

    private String generateStatementText(int statementType) {
        return switch (statementType) {
            case 0 -> this.buildUpdateStatement();
            case 1 -> this.buildDeleteStatement();
            case 2 -> this.buildInsertStatement();
            case 3 -> this.buildSelectStatement();
            default -> throw new IllegalArgumentException("Incorrect statement type specified.");
        };
    }

    @Override
    public RowValue getNewRow() throws SQLException {
        if (this.inInsertRow) {
            throw FBRowUpdater.wrongRow(ROW_UPDATE, ROW_INSERT);
        }
        RowValue newRowCopy = this.rowDescriptor.createDefaultFieldValues();
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            byte[] fieldData = this.getFieldData(i);
            newRowCopy.setFieldData(i, fieldData != null ? (byte[])fieldData.clone() : null);
        }
        return newRowCopy;
    }

    private byte[] getFieldData(int field) {
        RowValue source = this.newRow.isInitialized(field) || this.inInsertRow ? this.newRow : this.oldRow;
        return source.getFieldData(field);
    }

    @Override
    public RowValue getInsertRow() throws SQLException {
        if (this.inInsertRow) {
            RowValue newRowCopy = this.newRow.deepCopy();
            newRowCopy.initializeFields();
            return newRowCopy;
        }
        throw FBRowUpdater.wrongRow(ROW_INSERT, ROW_CURRENT);
    }

    @Override
    public RowValue getOldRow() throws SQLException {
        if (this.inInsertRow) {
            throw FBRowUpdater.wrongRow(ROW_OLD, ROW_INSERT);
        }
        return this.oldRow;
    }

    private static SQLException wrongRow(String expectedRow, String actualRow) {
        return new SQLException("Cannot return %s row, currently positioned on %s row".formatted(expectedRow, actualRow));
    }

    @Override
    public void moveToInsertRow() {
        this.inInsertRow = true;
        this.newRow.reset();
    }

    @Override
    public void moveToCurrentRow() {
        this.inInsertRow = false;
        this.newRow.reset();
    }

    private final class FieldDataProviderImpl
    implements FieldDataProvider {
        private final int field;

        FieldDataProviderImpl(int field) {
            this.field = field;
        }

        @Override
        public byte[] getFieldData() {
            return FBRowUpdater.this.getFieldData(this.field);
        }

        @Override
        public void setFieldData(byte[] data) {
            FBRowUpdater.this.newRow.setFieldData(this.field, data);
        }
    }

    private static final class RowListener
    implements StatementListener {
        private final List<RowValue> rows = new ArrayList<RowValue>(1);

        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        public List<RowValue> getRows() {
            return this.rows;
        }
    }
}

