/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public final class PluginLoader {
    private static final Set<ClassSource> DEFAULT_SOURCES = Collections.unmodifiableSet(EnumSet.allOf(ClassSource.class));

    private PluginLoader() {
    }

    public static <T> Collection<T> findPlugins(Class<T> spiClass, Collection<String> fallbackClassNames) {
        return PluginLoader.findPlugins(spiClass, fallbackClassNames, DEFAULT_SOURCES);
    }

    public static <T> Collection<T> findPlugins(Class<T> spiClass, Collection<String> fallbackClassNames, ClassSource classSource) {
        return PluginLoader.findPlugins(spiClass, fallbackClassNames, Set.of(classSource));
    }

    public static <T> Collection<T> findPlugins(Class<T> spiClass, Collection<String> fallbackClassNames, ClassSource ... classSources) {
        EnumSet<ClassSource> classSourceSet = EnumSet.noneOf(ClassSource.class);
        classSourceSet.addAll(Arrays.asList(classSources));
        return PluginLoader.findPlugins(spiClass, fallbackClassNames, classSourceSet);
    }

    public static <T> Collection<T> findPlugins(Class<T> spiClass, Collection<String> fallbackClassNames, Set<ClassSource> classSources) {
        if (!spiClass.isInterface()) {
            throw new IllegalArgumentException("excepted interface type, received " + String.valueOf(spiClass));
        }
        if (classSources.isEmpty()) {
            throw new IllegalArgumentException("at least one ClassSource is required");
        }
        Collection<ClassLoader> classLoaders = PluginLoader.classLoadersForLoading(spiClass, classSources);
        LinkedHashSet<T> plugins = new LinkedHashSet<T>();
        for (ClassLoader cl : classLoaders) {
            plugins.addAll(PluginLoader.findPlugins(spiClass, cl));
        }
        if (!plugins.isEmpty()) {
            return plugins;
        }
        return PluginLoader.loadFallbackPlugins(spiClass, fallbackClassNames, classLoaders);
    }

    private static <T> Set<T> findPlugins(Class<T> spiClass, ClassLoader cl) {
        ServiceLoader<T> pluginLoader = ServiceLoader.load(spiClass, cl);
        Iterator<T> pluginIterator = pluginLoader.iterator();
        LinkedHashSet<T> plugins = new LinkedHashSet<T>();
        for (int retry = 0; retry < 2; ++retry) {
            try {
                while (pluginIterator.hasNext()) {
                    try {
                        plugins.add(pluginIterator.next());
                    }
                    catch (Exception | ServiceConfigurationError e) {
                        String message = "Could not load " + spiClass.getSimpleName() + " (skipping)";
                        System.Logger log = System.getLogger(PluginLoader.class.getName());
                        log.log(System.Logger.Level.ERROR, message + "; see debug level for stacktrace");
                        log.log(System.Logger.Level.DEBUG, message, e);
                    }
                }
                break;
            }
            catch (ServiceConfigurationError e) {
                System.getLogger(PluginLoader.class.getName()).log(System.Logger.Level.ERROR, "Error finding next " + spiClass.getSimpleName(), (Throwable)e);
                continue;
            }
        }
        return plugins;
    }

    private static <T> Set<T> loadFallbackPlugins(Class<T> spiClass, Collection<String> fallbackClassNames, Collection<ClassLoader> classLoaders) {
        System.getLogger(PluginLoader.class.getName()).log(System.Logger.Level.WARNING, "Could not find any {0} through service loader; using fallback strategy", spiClass.getSimpleName());
        LinkedHashSet<T> plugins = new LinkedHashSet<T>();
        for (ClassLoader cl : classLoaders) {
            for (String className : fallbackClassNames) {
                try {
                    Class<?> clazz = Class.forName(className, false, cl);
                    if (!spiClass.isAssignableFrom(clazz)) {
                        System.getLogger(PluginLoader.class.getName()).log(System.Logger.Level.WARNING, "Class {0} is not an instance of plugin type {1}", className, spiClass.getName());
                        continue;
                    }
                    plugins.add(spiClass.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                }
                catch (Exception e) {
                    System.Logger log = System.getLogger(PluginLoader.class.getName());
                    if (!log.isLoggable(System.Logger.Level.WARNING)) continue;
                    String message = "Unable to load " + spiClass.getSimpleName() + " " + className + " as fallback; skipping";
                    log.log(System.Logger.Level.WARNING, message + "; see debug level for stacktrace");
                    log.log(System.Logger.Level.DEBUG, message, (Throwable)e);
                }
            }
            if (plugins.isEmpty()) continue;
            return plugins;
        }
        return Set.of();
    }

    private static Collection<ClassLoader> classLoadersForLoading(Class<?> spiClass, Set<ClassSource> classSources) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(classSources.size());
        for (ClassSource classSource : classSources) {
            ClassLoader cl = classSource.getClassLoader(spiClass);
            if (cl == null || classLoaders.contains(cl)) continue;
            classLoaders.add(cl);
        }
        return classLoaders;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ClassSource {
        PLUGIN_CLASS_LOADER{

            @Override
            @Nullable ClassLoader getClassLoader(Class<?> spiClass) {
                ClassLoader cl = spiClass.getClassLoader();
                return cl != null ? cl : ClassLoader.getSystemClassLoader();
            }
        }
        ,
        CONTEXT_CLASS_LOADER{

            @Override
            @Nullable ClassLoader getClassLoader(Class<?> spiClass) {
                return Thread.currentThread().getContextClassLoader();
            }
        };


        abstract @Nullable ClassLoader getClassLoader(Class<?> var1);
    }
}

