/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;

public final class StatementInfoProcessor
implements InfoProcessor<InfoProcessor.StatementInfo> {
    private static final System.Logger log = System.getLogger(StatementInfoProcessor.class.getName());
    private final AbstractFbStatement statement;
    private final FbDatabase database;

    public StatementInfoProcessor(AbstractFbStatement statement, FbDatabase database) {
        this.statement = statement;
        this.database = database;
    }

    @Override
    public InfoProcessor.StatementInfo process(byte[] infoResponse) throws SQLException {
        StatementInfo info = new StatementInfo(this.statement.getDefaultSqlInfoSize(), infoResponse);
        block5: while ((info.currentItem = info.buffer[info.currentIndex++]) != 1) {
            switch (info.currentItem) {
                case 21: {
                    info.statementType = StatementType.valueOf(this.readIntValue(info));
                    continue block5;
                }
                case 2: {
                    this.handleTruncatedInfo(info);
                    continue block5;
                }
                case 4: 
                case 5: {
                    if (info.buffer[info.currentIndex] == 2) continue block5;
                    this.handleDescriptors(info);
                    continue block5;
                }
            }
            log.log(System.Logger.Level.DEBUG, "Unexpected item type %d", info.currentItem);
            throw FbExceptionBuilder.toException(335544583);
        }
        return info;
    }

    private void handleTruncatedInfo(StatementInfo info) throws SQLException {
        byte[] originalInfo = this.statement.getStatementInfoRequestItems();
        byte[] newInfoItems = new byte[originalInfo.length + 8];
        int newIndex = 0;
        for (byte infoItem : originalInfo) {
            assert (newIndex < newInfoItems.length) : "newInfoItems size too short";
            if (infoItem == 4 || infoItem == 5) {
                RowDescriptorBuilder currentBuilder = infoItem == 4 ? info.fieldBuilder : info.parameterBuilder;
                int descriptorIndex = currentBuilder != null ? currentBuilder.getFirstUnprocessedIndex() + 1 : 1;
                newInfoItems[newIndex++] = 20;
                newInfoItems[newIndex++] = 2;
                newInfoItems[newIndex++] = (byte)(descriptorIndex & 0xFF);
                newInfoItems[newIndex++] = (byte)(descriptorIndex >> 8);
                newInfoItems[newIndex++] = infoItem;
                continue;
            }
            newInfoItems[newIndex++] = infoItem;
        }
        assert (newIndex == newInfoItems.length) : "newInfoItems size too long";
        info.requestBufferSize = Math.min(2 * info.requestBufferSize, this.statement.getMaxSqlInfoSize());
        info.buffer = this.statement.getSqlInfo(newInfoItems, info.requestBufferSize);
        info.currentIndex = 0;
    }

    private void handleDescriptors(StatementInfo info) throws SQLException {
        ++info.currentIndex;
        int descriptorCount = this.readIntValue(info);
        if (descriptorCount == 0) {
            return;
        }
        if (info.currentItem == 4) {
            if (info.fieldBuilder == null) {
                info.fieldBuilder = new RowDescriptorBuilder(descriptorCount, this.database.getDatatypeCoder());
            }
            this.processDescriptors(info, info.fieldBuilder);
        } else if (info.currentItem == 5) {
            if (info.parameterBuilder == null) {
                info.parameterBuilder = new RowDescriptorBuilder(descriptorCount, this.database.getDatatypeCoder());
            }
            this.processDescriptors(info, info.parameterBuilder);
        }
    }

    private void processDescriptors(StatementInfo info, RowDescriptorBuilder rdb) throws SQLException {
        int fieldCount = rdb.getFirstUnprocessedIndex();
        block14: while (fieldCount < rdb.getSize()) {
            info.currentItem = info.buffer[info.currentIndex++];
            switch (info.currentItem) {
                case 9: {
                    rdb.setFieldIndex(this.readIntValue(info) - 1);
                    continue block14;
                }
                case 11: {
                    rdb.setType(this.readIntValue(info));
                    continue block14;
                }
                case 12: {
                    rdb.setSubType(this.readIntValue(info));
                    continue block14;
                }
                case 13: {
                    rdb.setScale(this.readIntValue(info));
                    continue block14;
                }
                case 14: {
                    rdb.setLength(this.readIntValue(info));
                    continue block14;
                }
                case 16: {
                    rdb.setOriginalName(this.readStringValue(info));
                    continue block14;
                }
                case 19: {
                    rdb.setFieldName(this.readStringValue(info));
                    continue block14;
                }
                case 17: {
                    rdb.setOriginalTableName(this.readStringValue(info));
                    continue block14;
                }
                case 25: {
                    rdb.setTableAlias(this.readStringValue(info));
                    continue block14;
                }
                case 18: {
                    rdb.setOwnerName(this.readStringValue(info));
                    continue block14;
                }
                case 8: {
                    rdb.addField();
                    ++fieldCount;
                    continue block14;
                }
                case 2: {
                    rdb.resetField();
                    --info.currentIndex;
                    return;
                }
            }
            log.log(System.Logger.Level.DEBUG, "Unexpected item type %d", info.currentItem);
            throw FbExceptionBuilder.toException(335544583);
        }
    }

    private int readIntValue(StatementInfo info) {
        int len = VaxEncoding.iscVaxInteger2(info.buffer, info.currentIndex);
        info.currentIndex += 2;
        int value = VaxEncoding.iscVaxInteger(info.buffer, info.currentIndex, len);
        info.currentIndex += len;
        return value;
    }

    private String readStringValue(StatementInfo info) {
        int len = VaxEncoding.iscVaxInteger2(info.buffer, info.currentIndex);
        info.currentIndex += 2;
        String value = this.database.getEncoding().decodeFromCharset(info.buffer, info.currentIndex, len);
        info.currentIndex += len;
        return value;
    }

    private final class StatementInfo
    implements InfoProcessor.StatementInfo {
        private int requestBufferSize;
        private int currentIndex;
        private byte currentItem;
        private StatementType statementType = StatementType.NONE;
        private RowDescriptorBuilder fieldBuilder;
        private RowDescriptorBuilder parameterBuilder;
        private byte[] buffer;

        private StatementInfo(int initialRequestBufferSize, byte[] initialBuffer) {
            this.requestBufferSize = initialRequestBufferSize;
            this.buffer = initialBuffer;
        }

        @Override
        public StatementType getStatementType() {
            return this.statementType;
        }

        @Override
        public RowDescriptor getFields() {
            return this.fieldBuilder != null ? this.fieldBuilder.toRowDescriptor() : StatementInfoProcessor.this.database.emptyRowDescriptor();
        }

        @Override
        public RowDescriptor getParameters() {
            return this.parameterBuilder != null ? this.parameterBuilder.toRowDescriptor() : StatementInfoProcessor.this.database.emptyRowDescriptor();
        }
    }
}

