/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.List;
import java.util.Objects;
import org.firebirdsql.gds.MessageLookup;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public abstract class MessageTemplate {
    private static final MessageLookup MESSAGE_LOOKUP = new MessageLookup();

    MessageTemplate() {
    }

    public static MessageTemplate of(int errorCode) {
        return MESSAGE_LOOKUP.getMessageTemplate(errorCode);
    }

    public abstract int errorCode();

    public abstract @Nullable String sqlState();

    public abstract MessageTemplate withDefaultSqlState(String var1);

    public abstract MessageTemplate withSqlState(String var1);

    public final String toMessage(List<? extends @Nullable Object> parameters) {
        StringBuilder messageBuffer = new StringBuilder(0);
        this.appendMessage(messageBuffer, parameters);
        return messageBuffer.toString();
    }

    public abstract void appendMessage(StringBuilder var1, List<? extends @Nullable Object> var2);

    public final void appendErrorInfoSuffix(StringBuilder messageBuffer) {
        messageBuffer.append(" [SQLState:").append(this.sqlState()).append(", ISC error code:").append(this.errorCode()).append(']');
    }

    static String validateSqlState(String sqlState) {
        if (Objects.requireNonNull(sqlState, "sqlState").length() != 5) {
            throw new IllegalArgumentException("Value of sqlState must be a 5 character string");
        }
        return sqlState;
    }
}

