@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2021 Alexey Kuryakin kouriakine@mail.ru      ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Ask input then call passed command, like example:          ::
::  ask-input-call "Ask" "Name:" "James" echo Hello @*.       ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Preset
set /a verb=0
set /a test=0
set initial=0
set predproc=
set finally=0
set postproc=

:ParseOptions
if /i "%~1" == ""           goto :Help
if /i "%~1" == "/?"         goto :Help
if /i "%~1" == "-h"         goto :Help
if /i "%~1" == "--help"     goto :Help
if /i "%~1" == "--version"  goto :PrintVersion
if /i "%~1" == "-p"         goto :AddPath
if /i "%~1" == "--path"     goto :AddPath
if /i "%~1" == "--verb"     goto :SetVerb
if /i "%~1" == "--test"     goto :SetTest
if /i "%~1" == "--finally"  goto :AddFinally
if /i "%~1" == "--initial"  goto :AddInitial
goto :EndOptions
:AddPath
if /i "%~2" == "b" for %%i in ("%~dp0.") do set "PATH=%%~fi;%PATH%"
if /i "%~2" == "e" for %%i in ("%~dp0.") do set "PATH=%PATH%;%%~fi"
shift /1
shift /1
goto :ParseOptions
:SetVerb
set /a verb=1
shift /1
goto :ParseOptions
:SetTest
set /a test=1
shift /1
goto :ParseOptions
:AddFinally
if not "%~2" == "" set "postproc=%~2"
if not "%~2" == "" set "finally=1"
shift /1
shift /1
goto :ParseOptions
:AddInitial
if not "%~2" == "" set "predproc=%~2"
if not "%~2" == "" set "initial=1"
shift /1
shift /1
goto :ParseOptions
:EndOptions

:AskInput
set result=
title ask-input.cmd %1 %2 %3
for /f "delims=" %%i in ('call "%~dp0\ask-input.cmd" %1 %2 %3 -n result') do set "%%i" || exit /b 1
if not defined result exit /b 1
if "%result%" == "" exit /b 1
shift /1
shift /1
shift /1
title %~nx0

:GetCommand
set cmnd=%1
shift /1

:GetArgs
set args=%1
:ParseArgs
shift /1
if "%~1" == "" if [%1] == [] goto :DoneArgs
set args=%args% %1
goto :ParseArgs
:DoneArgs

:ApplyPlaceHolder
if defined args set args=%args:@*=!result!%

:CallCommand
if "%test%" == "1" set /a verb=1
if "%verb%" == "1" echo %cmnd% %args%
if "%test%" == "0" if defined predproc if "%initial%" == "1" call %predproc%
if "%test%" == "0" if defined cmnd title %cmnd% %args%
if "%test%" == "0" if defined cmnd call %cmnd% %args%
if "%test%" == "0" if defined postproc if "%finally%" == "1" call %postproc%
exit /b %ERRORLEVEL%
goto :EOF

:PrintVersion
call :Version %~n0
exit /b 0
goto :EOF

:Version
echo %~1 version 1.0
goto :EOF

:Help
call :Version %~n0
echo Copyright ^(c^) 2021 Alexey Kuryakin kouriakine@mail.ru
echo Utility to ask input, then call passed command.
echo ====================^> Syntax:
echo  %~n0 [Options] "Title" "Message" "Default" cmnd args
echo ====================^> Options:
echo   -p b             =^> add home directory to begin of PATH before call command
echo   -p e             =^> add home directory to end   of PATH before call command
echo   --verb           =^> verbose mode: echo command before call
echo   --test           =^> testing mode: echo command before call, but don't do it
echo   --initial "doit" =^> option to call the command ^(doit^) before cmnd args call
echo   --finally "doit" =^> option to call the command ^(doit^) after  cmnd args call
echo ====================^> Arguments:
echo  Title             =^> Window title   for input box
echo  Message           =^> Window message for input box
echo  Default           =^> Default value  for input box
echo  cmnd              =^> Command to call after input box
echo  args              =^> Arguments of command with placeholder replacement
echo                    =^> ^(i.e replace substring @* to input result string^)
echo ====================^> Example:
echo  call %~n0 --help
echo  call %~n0 --version
echo  call %~n0 --test "Ask" "Test" "demo" echo Test input: @*
echo  call %~n0 --verb "Ping" "HostName to ping:" "localhost" ping @*
echo  call %~n0 "Ping" "HostName to ping:" "localhost" start "ping @*" ping -t @*
echo  call %~n0 --finally "echo Done & pause" "Ask" "Name:" "James" echo Hello @*.
echo  call %~n0 --initial "title Test %~n0" "Input" "Your name:" "James Bond" cmd /c echo Hello @*.
exit /b 0
goto :EOF
