package spark.utils
{
   import mx.core.mx_internal;
   import flash.display.DisplayObject;
   import flash.filters.ShaderFilter;
   import spark.core.MaskType;
   import mx.graphics.shaderClasses.LuminosityMaskShader;
   import flash.display.DisplayObjectContainer;
   import mx.core.UIComponent;
   import mx.core.UIComponentGlobals;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class MaskUtil
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function MaskUtil()
      {
         super();
      }
      
      mx_internal static function applyLuminositySettings(mask:DisplayObject, maskType:String, luminosityInvert:Boolean, luminosityClip:Boolean) : void
      {
         var shaderFilterIndex:int = 0;
         var shaderFilter:ShaderFilter = null;
         if(Boolean(!mask) || Boolean(maskType != MaskType.LUMINOSITY) || Boolean(mask.filters.length == 0))
         {
            return;
         }
         var len:int = mask.filters.length;
         for(shaderFilterIndex = 0; shaderFilterIndex < len; )
         {
            if(Boolean(mask.filters[shaderFilterIndex] is ShaderFilter) && Boolean(ShaderFilter(mask.filters[shaderFilterIndex]).shader is LuminosityMaskShader))
            {
               shaderFilter = mask.filters[shaderFilterIndex];
               break;
            }
            shaderFilterIndex++;
         }
         if(shaderFilter)
         {
            LuminosityMaskShader(shaderFilter.shader).mode = calculateLuminositySettings(luminosityInvert,luminosityClip);
            mask.filters[shaderFilterIndex] = shaderFilter;
            mask.filters = mask.filters;
         }
      }
      
      mx_internal static function applyMask(mask:DisplayObject, parent:DisplayObjectContainer) : void
      {
         if(!mask)
         {
            return;
         }
         var maskComp:UIComponent = mask as UIComponent;
         if(maskComp)
         {
            if(parent)
            {
               UIComponent(parent).addingChild(maskComp);
               UIComponent(parent).childAdded(maskComp);
            }
            UIComponentGlobals.layoutManager.validateClient(maskComp,true);
            maskComp.invalidateDisplayList();
            maskComp.setActualSize(maskComp.getExplicitOrMeasuredWidth(),maskComp.getExplicitOrMeasuredHeight());
         }
      }
      
      mx_internal static function applyMaskType(mask:DisplayObject, maskType:String, luminosityInvert:Boolean, luminosityClip:Boolean, drawnDisplayObject:DisplayObject) : void
      {
         var luminosityMaskShader:LuminosityMaskShader = null;
         var shaderFilter:ShaderFilter = null;
         if(!mask)
         {
            return;
         }
         if(maskType == MaskType.CLIP)
         {
            mask.cacheAsBitmap = false;
            mask.filters = [];
         }
         else if(maskType == MaskType.ALPHA)
         {
            mask.cacheAsBitmap = true;
            drawnDisplayObject.cacheAsBitmap = true;
         }
         else if(maskType == MaskType.LUMINOSITY)
         {
            mask.cacheAsBitmap = true;
            drawnDisplayObject.cacheAsBitmap = true;
            luminosityMaskShader = new LuminosityMaskShader();
            luminosityMaskShader.mode = calculateLuminositySettings(luminosityInvert,luminosityClip);
            shaderFilter = new ShaderFilter(luminosityMaskShader);
            mask.filters = [shaderFilter];
         }
      }
      
      private static function calculateLuminositySettings(luminosityInvert:Boolean, luminosityClip:Boolean) : int
      {
         var mode:int = 0;
         if(luminosityInvert)
         {
            mode = mode + 1;
         }
         if(luminosityClip)
         {
            mode = mode + 2;
         }
         return mode;
      }
   }
}
