package spark.components.supportClasses
{
   import mx.core.UIComponent;
   import mx.core.mx_internal;
   import flash.geom.Rectangle;
   import flash.display.DisplayObject;
   import flash.display.Shape;
   import flash.events.Event;
   import flash.display.Graphics;
   import flash.text.engine.TextLine;
   import flashx.textLayout.compose.TextLineRecycler;
   import mx.core.IFlexModuleFactory;
   import flash.text.engine.FontLookup;
   import mx.resources.ResourceManager;
   import mx.resources.IResourceManager;
   import mx.events.FlexEvent;
   
   use namespace mx_internal;
   
   [AccessibilityClass(implementation="spark.accessibility.TextBaseAccImpl")]
   [Style(inherit="no",name="backgroundColor",format="Color",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="backgroundAlpha",type="Number")]
   public class TextBase extends UIComponent
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var truncationIndicatorResource:String;
      
      mx_internal static var createAccessibilityImplementation:Function;
       
      mx_internal var bounds:Rectangle;
      
      mx_internal var textLines:Vector.<DisplayObject>;
      
      mx_internal var isOverset:Boolean = false;
      
      mx_internal var hasScrollRect:Boolean = false;
      
      mx_internal var invalidateCompose:Boolean = true;
      
      mx_internal var _composeWidth:Number;
      
      mx_internal var _composeHeight:Number;
      
      private var _widthConstraint:Number = NaN;
      
      private var _measuredOneTextLine:Boolean = false;
      
      private var _backgroundShape:Shape;
      
      private var visibleChanged:Boolean = false;
      
      private var _isTruncated:Boolean = false;
      
      private var _maxDisplayedLines:int = 0;
      
      private var _showTruncationTip:Boolean = false;
      
      [Inspectable(category="General")]
      mx_internal var _text:String = "";
      
      public function TextBase()
      {
         this.bounds = new Rectangle(0,0,NaN,NaN);
         this.textLines = new Vector.<DisplayObject>();
         super();
         mouseChildren = false;
         var resourceManager:IResourceManager = ResourceManager.getInstance();
         if(!truncationIndicatorResource)
         {
            truncationIndicatorResource = resourceManager.getString("core","truncationIndicator");
         }
         addEventListener(FlexEvent.UPDATE_COMPLETE,this.updateCompleteHandler);
         resourceManager.addEventListener(Event.CHANGE,this.resourceManager_changeHandler,false,0,true);
         this._backgroundShape = new Shape();
         addChild(this._backgroundShape);
      }
      
      override protected function initializeAccessibility() : void
      {
         if(TextBase.createAccessibilityImplementation != null)
         {
            TextBase.createAccessibilityImplementation(this);
         }
      }
      
      [Inspectable(category="General")]
      override public function get baselinePosition() : Number
      {
         if(!validateBaselinePosition())
         {
            return NaN;
         }
         if(this.textLines.length == 0)
         {
            this.createEmptyTextLine(this._composeHeight);
         }
         return this.textLines.length > 0?Number(this.textLines[0].y):Number(0);
      }
      
      override public function set visible(value:Boolean) : void
      {
         super.visible = value;
         this.visibleChanged = true;
         invalidateDisplayList();
      }
      
      public function get isTruncated() : Boolean
      {
         return Boolean(this._isTruncated);
      }
      
      mx_internal function setIsTruncated(value:Boolean) : void
      {
         if(this._isTruncated != value)
         {
            this._isTruncated = value;
            if(this.showTruncationTip)
            {
               toolTip = !!this._isTruncated?this.text:null;
            }
            dispatchEvent(new Event("isTruncatedChanged"));
         }
      }
      
      [Inspectable(minValue="-1")]
      public function get maxDisplayedLines() : int
      {
         return this._maxDisplayedLines;
      }
      
      public function set maxDisplayedLines(value:int) : void
      {
         if(value != this._maxDisplayedLines)
         {
            this._maxDisplayedLines = value;
            this.invalidateTextLines();
            invalidateSize();
            invalidateDisplayList();
         }
      }
      
      public function get showTruncationTip() : Boolean
      {
         return this._showTruncationTip;
      }
      
      public function set showTruncationTip(value:Boolean) : void
      {
         this._showTruncationTip = value;
      }
      
      public function get text() : String
      {
         return this._text;
      }
      
      public function set text(value:String) : void
      {
         if(value != this._text)
         {
            this._text = value;
            this.invalidateTextLines();
            invalidateSize();
            invalidateDisplayList();
         }
      }
      
      override protected function measure() : void
      {
         var constrainedWidth:Number = !isNaN(this._widthConstraint)?Number(this._widthConstraint):Number(explicitWidth);
         var fontSize:Number = getStyle("fontSize");
         var allLinesComposed:Boolean = this.composeTextLines(Math.max(constrainedWidth,fontSize),Math.max(explicitHeight,fontSize));
         invalidateDisplayList();
         var newMeasuredHeight:Number = Math.ceil(this.bounds.bottom);
         if(Boolean(!isNaN(this._widthConstraint)) && Boolean(measuredHeight == newMeasuredHeight))
         {
            return;
         }
         super.measure();
         measuredWidth = Math.ceil(this.bounds.right);
         measuredHeight = newMeasuredHeight;
         this._measuredOneTextLine = Boolean(allLinesComposed) && Boolean(this.textLines.length == 1);
      }
      
      override public function setLayoutBoundsSize(width:Number, height:Number, postLayoutTransform:Boolean = true) : void
      {
         super.setLayoutBoundsSize(width,height,postLayoutTransform);
         if(this._widthConstraint == width)
         {
            return;
         }
         if(getStyle("lineBreak") == "explicit")
         {
            return;
         }
         if(canSkipMeasurement())
         {
            return;
         }
         if(!isNaN(explicitHeight))
         {
            return;
         }
         var constrainedWidth:Boolean = Boolean(!isNaN(width)) && Boolean(width != measuredWidth) && Boolean(width != 0);
         if(!constrainedWidth)
         {
            return;
         }
         if(Boolean(this._measuredOneTextLine) && Boolean(width > measuredWidth))
         {
            return;
         }
         if(Boolean(postLayoutTransform) && Boolean(hasComplexLayoutMatrix))
         {
            return;
         }
         this._widthConstraint = width;
         invalidateSize();
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         var compose:Boolean = false;
         var clipText:Boolean = false;
         var contentHeight:Number = Math.ceil(this.bounds.bottom);
         var contentWidth:Number = Math.ceil(this.bounds.right);
         if(Boolean(this.invalidateCompose) || Boolean(this.composeForAlignStyles(unscaledWidth,unscaledHeight,contentWidth,contentHeight)))
         {
            compose = true;
         }
         else if(unscaledHeight != contentHeight)
         {
            if(this.composeOnHeightChange(unscaledHeight,contentHeight))
            {
               compose = true;
            }
            else if(unscaledHeight < contentHeight)
            {
               clipText = true;
            }
         }
         if(Boolean(!compose) && Boolean(unscaledWidth != contentWidth))
         {
            if(this.composeOnWidthChange(unscaledWidth,contentWidth))
            {
               compose = true;
            }
            else if(Boolean(getStyle("lineBreak") == "explicit") && Boolean(unscaledWidth < contentWidth))
            {
               clipText = true;
            }
         }
         if(compose)
         {
            this.composeTextLines(unscaledWidth,unscaledHeight);
         }
         if(this.isOverset)
         {
            clipText = true;
         }
         this.clip(clipText,unscaledWidth,unscaledHeight);
         var backgroundColor:* = getStyle("backgroundColor");
         var backgroundAlpha:Number = getStyle("backgroundAlpha");
         if(backgroundColor === undefined)
         {
            backgroundColor = 0;
            backgroundAlpha = 0;
         }
         var g:Graphics = this._backgroundShape.graphics;
         g.clear();
         g.beginFill(uint(backgroundColor),backgroundAlpha);
         g.drawRect(0,0,unscaledWidth,unscaledHeight);
         g.endFill();
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         super.styleChanged(styleProp);
         this.invalidateTextLines();
      }
      
      mx_internal function createEmptyTextLine(height:Number = NaN) : void
      {
      }
      
      mx_internal function invalidateTextLines() : void
      {
         this.invalidateCompose = true;
      }
      
      private function composeForAlignStyles(unscaledWidth:Number, unscaledHeight:Number, contentWidth:Number, contentHeight:Number) : Boolean
      {
         var direction:String = null;
         var textAlign:String = null;
         var leftAligned:Boolean = false;
         var verticalAlign:String = null;
         var topAligned:Boolean = false;
         var width:Number = !!isNaN(this._composeWidth)?Number(contentWidth):Number(this._composeWidth);
         if(unscaledWidth != width)
         {
            direction = getStyle("direction");
            textAlign = getStyle("textAlign");
            leftAligned = Boolean(textAlign == "left") || Boolean(textAlign == "start") && Boolean(direction == "ltr") || Boolean(textAlign == "end") && Boolean(direction == "rtl");
            if(!leftAligned)
            {
               return true;
            }
         }
         var height:Number = !!isNaN(this._composeHeight)?Number(contentHeight):Number(this._composeHeight);
         if(unscaledHeight != height)
         {
            verticalAlign = getStyle("verticalAlign");
            topAligned = verticalAlign == "top";
            if(!topAligned)
            {
               return true;
            }
         }
         return false;
      }
      
      private function composeOnHeightChange(unscaledHeight:Number, contentHeight:Number) : Boolean
      {
         if(Boolean(unscaledHeight > contentHeight) && (Boolean(this.isOverset) || Boolean(!isNaN(this._composeHeight))))
         {
            return true;
         }
         if(Boolean(this.maxDisplayedLines != 0) && Boolean(getStyle("lineBreak") == "toFit"))
         {
            if(this.maxDisplayedLines == -1)
            {
               return true;
            }
            if(Boolean(this.maxDisplayedLines > 0) && (Boolean(unscaledHeight < contentHeight) || Boolean(this.textLines.length != this.maxDisplayedLines)))
            {
               return true;
            }
         }
         if(getStyle("blockProgression") != "tb")
         {
            return true;
         }
         return false;
      }
      
      private function composeOnWidthChange(unscaledWidth:Number, contentWidth:Number) : Boolean
      {
         if(getStyle("lineBreak") == "toFit")
         {
            if(Boolean(isNaN(this._composeWidth)) || Boolean(this._composeWidth != unscaledWidth))
            {
               return true;
            }
         }
         if(getStyle("blockProgression") != "tb")
         {
            return true;
         }
         return false;
      }
      
      mx_internal function composeTextLines(width:Number = NaN, height:Number = NaN) : Boolean
      {
         this._composeWidth = width;
         this._composeHeight = height;
         this.setIsTruncated(false);
         return false;
      }
      
      mx_internal function addTextLines() : void
      {
         var textLine:DisplayObject = null;
         var n:int = this.textLines.length;
         if(n == 0)
         {
            return;
         }
         for(var i:int = n - 1; i >= 0; i--)
         {
            textLine = this.textLines[i];
            $addChildAt(textLine,1);
         }
      }
      
      mx_internal function removeTextLines() : void
      {
         var textLine:DisplayObject = null;
         var parent:UIComponent = null;
         var n:int = this.textLines.length;
         if(n == 0)
         {
            return;
         }
         for(var i:int = 0; i < n; i++)
         {
            textLine = this.textLines[i];
            parent = textLine.parent as UIComponent;
            if(parent)
            {
               UIComponent(textLine.parent).$removeChild(textLine);
            }
         }
      }
      
      mx_internal function releaseTextLines(textLinesVector:Vector.<DisplayObject> = null) : void
      {
         var textLine:DisplayObject = null;
         if(!textLinesVector)
         {
            textLinesVector = this.textLines;
         }
         var n:int = textLinesVector.length;
         for(var i:int = 0; i < n; i++)
         {
            textLine = textLinesVector[i];
            if(textLine is TextLine)
            {
               TextLineRecycler.addLineForReuse(TextLine(textLine));
            }
         }
         textLinesVector.length = 0;
      }
      
      mx_internal function isTextOverset(composeWidth:Number, composeHeight:Number) : Boolean
      {
         var compositionRect:Rectangle = new Rectangle(0,0,composeWidth,composeHeight);
         compositionRect.inflate(0.25,0.25);
         var contentRect:Rectangle = this.bounds;
         var isOverset:Boolean = Boolean(contentRect.top < compositionRect.top) || Boolean(contentRect.left < compositionRect.left) || Boolean(!isNaN(compositionRect.bottom)) && Boolean(contentRect.bottom > compositionRect.bottom) || Boolean(!isNaN(compositionRect.right)) && Boolean(contentRect.right > compositionRect.right);
         return isOverset;
      }
      
      mx_internal function clip(clipText:Boolean, w:Number, h:Number) : void
      {
         var r:Rectangle = null;
         if(clipText)
         {
            r = scrollRect;
            if(r)
            {
               r.x = 0;
               r.y = 0;
               r.width = w;
               r.height = h;
            }
            else
            {
               r = new Rectangle(0,0,w,h);
            }
            scrollRect = r;
            this.hasScrollRect = true;
         }
         else if(this.hasScrollRect)
         {
            scrollRect = null;
            this.hasScrollRect = false;
         }
      }
      
      mx_internal function getEmbeddedFontContext() : IFlexModuleFactory
      {
         var fontContext:IFlexModuleFactory = null;
         var font:String = null;
         var bold:Boolean = false;
         var italic:Boolean = false;
         var fontLookup:String = getStyle("fontLookup");
         if(fontLookup != FontLookup.DEVICE)
         {
            font = getStyle("fontFamily");
            bold = getStyle("fontWeight") == "bold";
            italic = getStyle("fontStyle") == "italic";
            fontContext = getFontContext(font,bold,italic,true);
         }
         return fontContext;
      }
      
      private function resourceManager_changeHandler(event:Event) : void
      {
         var resourceManager:IResourceManager = ResourceManager.getInstance();
         truncationIndicatorResource = resourceManager.getString("core","truncationIndicator");
         if(this.maxDisplayedLines != 0)
         {
            this.invalidateTextLines();
            invalidateSize();
            invalidateDisplayList();
         }
      }
      
      private function updateCompleteHandler(event:FlexEvent) : void
      {
         this._widthConstraint = NaN;
      }
   }
}
