package spark.components.supportClasses
{
   import mx.managers.IFocusManagerComponent;
   import mx.core.IIMESupport;
   import mx.core.mx_internal;
   import spark.components.RichEditableText;
   import flash.system.Capabilities;
   import flash.accessibility.AccessibilityProperties;
   import mx.utils.BitFlagUtil;
   import spark.components.TextSelectionHighlighting;
   import flash.accessibility.Accessibility;
   import flashx.textLayout.events.SelectionEvent;
   import spark.events.TextOperationEvent;
   import mx.events.FlexEvent;
   import flash.display.DisplayObject;
   import flashx.textLayout.elements.TextFlow;
   import flash.events.FocusEvent;
   import flash.events.Event;
   
   use namespace mx_internal;
   
   [Event(name="change",type="spark.events.TextOperationEvent")]
   [Event(name="changing",type="spark.events.TextOperationEvent")]
   [Event(name="selectionChange",type="mx.events.FlexEvent")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="focusAlpha",theme="spark",type="Number")]
   [Style(inherit="yes",name="contentBackgroundColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="contentBackgroundAlpha",theme="spark",type="Number")]
   [Style(inherit="no",name="borderVisible",theme="spark",type="Boolean")]
   [Style(inherit="no",name="borderColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="borderAlpha",theme="spark",type="Number")]
   [Style(inherit="yes",name="unfocusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="inactiveTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="focusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="whiteSpaceCollapse",type="String",enumeration="collapse,preserve")]
   [Style(inherit="yes",name="textRotation",type="String",enumeration="auto,rotate0,rotate90,rotate180,rotate270")]
   [Style(minValue="0.0",inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="yes",name="tabStops",type="String")]
   [Style(inherit="yes",name="paragraphStartIndent",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceBefore",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceAfter",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphEndIndent",format="length",type="Number")]
   [Style(inherit="yes",name="leadingModel",type="String",enumeration="auto,romanUp,ideographicTopUp,ideographicCenterUp,ideographicTopDown,ideographicCenterDown,ascentDescentUp")]
   [Style(inherit="yes",name="firstBaselineOffset",type="Object")]
   [Style(inherit="yes",name="breakOpportunity",type="String",enumeration="auto,all,any,none")]
   [Style(inherit="yes",name="blockProgression",type="String",enumeration="tb,rl")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="no",name="verticalAlign",type="String",enumeration="top,middle,bottom,justify")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingRight",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingLeft",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(inherit="no",name="lineBreak",type="String",enumeration="toFit,explicit")]
   public class SkinnableTextBase extends SkinnableComponent implements IFocusManagerComponent, IIMESupport
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const CONTENT_PROPERTY_FLAG:uint = 1 << 0;
      
      private static const DISPLAY_AS_PASSWORD_PROPERTY_FLAG:uint = 1 << 1;
      
      private static const EDITABLE_PROPERTY_FLAG:uint = 1 << 2;
      
      private static const HEIGHT_IN_LINES_PROPERTY_FLAG:uint = 1 << 3;
      
      private static const IME_MODE_PROPERTY_FLAG:uint = 1 << 4;
      
      private static const MAX_CHARS_PROPERTY_FLAG:uint = 1 << 5;
      
      private static const MAX_HEIGHT_PROPERTY_FLAG:uint = 1 << 6;
      
      private static const MAX_WIDTH_PROPERTY_FLAG:uint = 1 << 7;
      
      private static const RESTRICT_PROPERTY_FLAG:uint = 1 << 8;
      
      private static const SELECTABLE_PROPERTY_FLAG:uint = 1 << 9;
      
      private static const SELECTION_HIGHLIGHTING_FLAG:uint = 1 << 10;
      
      private static const TEXT_PROPERTY_FLAG:uint = 1 << 11;
      
      private static const TEXT_FLOW_PROPERTY_FLAG:uint = 1 << 12;
      
      private static const WIDTH_IN_CHARS_PROPERTY_FLAG:uint = 1 << 13;
       
      [SkinPart(required="false")]
      public var textDisplay:RichEditableText;
      
      private var textDisplayProperties:Object;
      
      private var _accessibilityProperties:AccessibilityProperties = null;
      
      private var accessibilityPropertiesChanged:Boolean = false;
      
      private var _tabIndex:int = -1;
      
      public function SkinnableTextBase()
      {
         this.textDisplayProperties = {};
         super();
      }
      
      override public function set accessibilityEnabled(value:Boolean) : void
      {
         if(!Capabilities.hasAccessibility)
         {
            return;
         }
         if(!this.accessibilityProperties)
         {
            this.accessibilityProperties = new AccessibilityProperties();
         }
         this.accessibilityProperties.silent = !value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      override public function set accessibilityDescription(value:String) : void
      {
         if(!Capabilities.hasAccessibility)
         {
            return;
         }
         if(!this.accessibilityProperties)
         {
            this.accessibilityProperties = new AccessibilityProperties();
         }
         this.accessibilityProperties.description = value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      override public function set accessibilityName(value:String) : void
      {
         if(!Capabilities.hasAccessibility)
         {
            return;
         }
         if(!this.accessibilityProperties)
         {
            this.accessibilityProperties = new AccessibilityProperties();
         }
         this.accessibilityProperties.name = value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      override public function get accessibilityProperties() : AccessibilityProperties
      {
         return this._accessibilityProperties;
      }
      
      override public function set accessibilityProperties(value:AccessibilityProperties) : void
      {
         this._accessibilityProperties = value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      override public function set accessibilityShortcut(value:String) : void
      {
         if(!Capabilities.hasAccessibility)
         {
            return;
         }
         if(!this.accessibilityProperties)
         {
            this.accessibilityProperties = new AccessibilityProperties();
         }
         this.accessibilityProperties.shortcut = value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      override public function get baselinePosition() : Number
      {
         return getBaselinePositionForPart(this.textDisplay);
      }
      
      override public function get maxWidth() : Number
      {
         if(this.textDisplay)
         {
            return this.textDisplay.maxWidth;
         }
         var v:* = this.textDisplayProperties.maxWidth;
         return v === undefined?Number(super.maxWidth):Number(v);
      }
      
      override public function set maxWidth(value:Number) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.maxWidth = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),MAX_WIDTH_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.maxWidth = value;
         }
         invalidateProperties();
      }
      
      override public function get tabIndex() : int
      {
         return this._tabIndex;
      }
      
      override public function set tabIndex(value:int) : void
      {
         this._tabIndex = value;
         this.accessibilityPropertiesChanged = true;
         invalidateProperties();
      }
      
      public function get displayAsPassword() : Boolean
      {
         if(this.textDisplay)
         {
            return this.textDisplay.displayAsPassword;
         }
         var v:* = this.textDisplayProperties.displayAsPassword;
         return v === undefined?Boolean(false):Boolean(v);
      }
      
      public function set displayAsPassword(value:Boolean) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.displayAsPassword = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),DISPLAY_AS_PASSWORD_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.displayAsPassword = value;
         }
         invalidateProperties();
      }
      
      public function get editable() : Boolean
      {
         if(this.textDisplay)
         {
            return this.textDisplay.editable;
         }
         var v:* = this.textDisplayProperties.editable;
         return v === undefined?Boolean(true):Boolean(v);
      }
      
      public function set editable(value:Boolean) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.editable = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),EDITABLE_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.editable = value;
         }
         invalidateProperties();
      }
      
      public function get enableIME() : Boolean
      {
         return this.editable;
      }
      
      public function get imeMode() : String
      {
         if(this.textDisplay)
         {
            return this.textDisplay.imeMode;
         }
         var v:* = this.textDisplayProperties.imeMode;
         return v === undefined?null:v;
      }
      
      public function set imeMode(value:String) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.imeMode = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),IME_MODE_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.imeMode = value;
         }
         invalidateProperties();
      }
      
      [Inspectable(minValue="0.0")]
      public function get maxChars() : int
      {
         if(this.textDisplay)
         {
            return this.textDisplay.maxChars;
         }
         var v:* = this.textDisplayProperties.maxChars;
         return v === undefined?int(0):int(v);
      }
      
      public function set maxChars(value:int) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.maxChars = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),MAX_CHARS_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.maxChars = value;
         }
         invalidateProperties();
      }
      
      public function get restrict() : String
      {
         if(this.textDisplay)
         {
            return this.textDisplay.restrict;
         }
         var v:* = this.textDisplayProperties.restrict;
         return v === undefined?null:v;
      }
      
      public function set restrict(value:String) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.restrict = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),RESTRICT_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.restrict = value;
         }
         invalidateProperties();
      }
      
      public function get selectable() : Boolean
      {
         if(this.textDisplay)
         {
            return this.textDisplay.selectable;
         }
         var v:* = this.textDisplayProperties.selectable;
         return v === undefined?Boolean(true):Boolean(v);
      }
      
      public function set selectable(value:Boolean) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.selectable = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),SELECTABLE_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.selectable = value;
         }
         invalidateProperties();
      }
      
      [Bindable("selectionChange")]
      public function get selectionActivePosition() : int
      {
         return Boolean(this.textDisplay)?int(this.textDisplay.selectionActivePosition):int(-1);
      }
      
      [Bindable("selectionChange")]
      public function get selectionAnchorPosition() : int
      {
         return Boolean(this.textDisplay)?int(this.textDisplay.selectionAnchorPosition):int(-1);
      }
      
      public function get selectionHighlighting() : String
      {
         if(this.textDisplay)
         {
            return this.textDisplay.selectionHighlighting;
         }
         var v:* = this.textDisplayProperties.selectionHighlighting;
         return v === undefined?TextSelectionHighlighting.WHEN_FOCUSED:v;
      }
      
      public function set selectionHighlighting(value:String) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.selectionHighlighting = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),SELECTION_HIGHLIGHTING_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.selectionHighlighting = value;
         }
         invalidateProperties();
      }
      
      [Inspectable(category="General")]
      public function get text() : String
      {
         if(this.textDisplay)
         {
            return this.textDisplay.text;
         }
         var v:* = this.textDisplayProperties.text;
         return v === undefined?"":v;
      }
      
      public function set text(value:String) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.text = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),TEXT_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.text = value;
            this.textDisplayProperties.content = undefined;
            this.textDisplayProperties.textFlow = undefined;
         }
         invalidateProperties();
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(this.accessibilityPropertiesChanged)
         {
            if(this.textDisplay)
            {
               this.textDisplay.accessibilityProperties = this._accessibilityProperties;
               this.textDisplay.tabIndex = this._tabIndex;
               if(Capabilities.hasAccessibility)
               {
                  Accessibility.updateProperties();
               }
            }
            this.accessibilityPropertiesChanged = false;
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == this.textDisplay)
         {
            this.textDisplayAdded();
            this.textDisplay.focusEnabled = false;
            this.textDisplay.addEventListener(SelectionEvent.SELECTION_CHANGE,this.textDisplay_selectionChangeHandler);
            this.textDisplay.addEventListener(TextOperationEvent.CHANGING,this.textDisplay_changingHandler);
            this.textDisplay.addEventListener(TextOperationEvent.CHANGE,this.textDisplay_changeHandler);
            this.textDisplay.addEventListener(FlexEvent.ENTER,this.textDisplay_enterHandler);
            this.textDisplay.addEventListener(FlexEvent.VALUE_COMMIT,this.textDisplay_valueCommitHandler);
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         super.partRemoved(partName,instance);
         if(instance == this.textDisplay)
         {
            this.textDisplayRemoved();
            this.textDisplay.removeEventListener(SelectionEvent.SELECTION_CHANGE,this.textDisplay_selectionChangeHandler);
            this.textDisplay.removeEventListener(TextOperationEvent.CHANGING,this.textDisplay_changingHandler);
            this.textDisplay.removeEventListener(TextOperationEvent.CHANGE,this.textDisplay_changeHandler);
            this.textDisplay.removeEventListener(FlexEvent.ENTER,this.textDisplay_enterHandler);
            this.textDisplay.removeEventListener(FlexEvent.VALUE_COMMIT,this.textDisplay_valueCommitHandler);
         }
      }
      
      override protected function getCurrentSkinState() : String
      {
         return !!enabled?"normal":"disabled";
      }
      
      override public function setFocus() : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.setFocus();
         }
      }
      
      override protected function isOurFocus(target:DisplayObject) : Boolean
      {
         return Boolean(target == this.textDisplay) || Boolean(super.isOurFocus(target));
      }
      
      public function insertText(text:String) : void
      {
         if(!this.textDisplay)
         {
            return;
         }
         this.textDisplay.insertText(text);
         invalidateProperties();
      }
      
      public function appendText(text:String) : void
      {
         if(!this.textDisplay)
         {
            return;
         }
         this.textDisplay.appendText(text);
         invalidateProperties();
      }
      
      public function selectRange(anchorIndex:int, activeIndex:int) : void
      {
         if(!this.textDisplay)
         {
            return;
         }
         this.textDisplay.selectRange(anchorIndex,activeIndex);
         invalidateProperties();
      }
      
      public function selectAll() : void
      {
         if(!this.textDisplay)
         {
            return;
         }
         this.textDisplay.selectAll();
         invalidateProperties();
      }
      
      mx_internal function setContent(value:Object) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.content = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),CONTENT_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.content = value;
            this.textDisplayProperties.text = undefined;
            this.textDisplayProperties.textFlow = undefined;
         }
         invalidateProperties();
      }
      
      mx_internal function getHeightInLines() : Number
      {
         if(this.textDisplay)
         {
            return this.textDisplay.heightInLines;
         }
         var v:* = this.textDisplayProperties.heightInLines;
         return v === undefined?Number(NaN):Number(v);
      }
      
      mx_internal function setHeightInLines(value:Number) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.heightInLines = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),HEIGHT_IN_LINES_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.heightInLines = value;
         }
         invalidateProperties();
      }
      
      mx_internal function getTextFlow() : TextFlow
      {
         if(this.textDisplay)
         {
            return this.textDisplay.textFlow;
         }
         var v:* = this.textDisplayProperties.textFlow;
         return v === undefined?null:v;
      }
      
      mx_internal function setTextFlow(value:TextFlow) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.textFlow = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),TEXT_FLOW_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.textFlow = value;
            this.textDisplayProperties.text = undefined;
            this.textDisplayProperties.content = undefined;
         }
         invalidateProperties();
      }
      
      mx_internal function getWidthInChars() : Number
      {
         if(this.textDisplay)
         {
            return this.textDisplay.widthInChars;
         }
         var v:* = this.textDisplayProperties.widthInChars;
         return v === undefined?Number(NaN):Number(v);
      }
      
      mx_internal function setWidthInChars(value:Number) : void
      {
         if(this.textDisplay)
         {
            this.textDisplay.widthInChars = value;
            this.textDisplayProperties = BitFlagUtil.update(uint(this.textDisplayProperties),WIDTH_IN_CHARS_PROPERTY_FLAG,true);
         }
         else
         {
            this.textDisplayProperties.widthInChars = value;
         }
         invalidateProperties();
      }
      
      private function textDisplayAdded() : void
      {
         var newTextDisplayProperties:uint = 0;
         if(this.textDisplayProperties.content !== undefined)
         {
            this.textDisplay.content = this.textDisplayProperties.content;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),CONTENT_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.displayAsPassword !== undefined)
         {
            this.textDisplay.displayAsPassword = this.textDisplayProperties.displayAsPassword;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),DISPLAY_AS_PASSWORD_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.editable !== undefined)
         {
            this.textDisplay.editable = this.textDisplayProperties.editable;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),EDITABLE_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.heightInLines !== undefined)
         {
            this.textDisplay.heightInLines = this.textDisplayProperties.heightInLines;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),HEIGHT_IN_LINES_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.imeMode !== undefined)
         {
            this.textDisplay.imeMode = this.textDisplayProperties.imeMode;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),IME_MODE_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.maxChars !== undefined)
         {
            this.textDisplay.maxChars = this.textDisplayProperties.maxChars;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),MAX_CHARS_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.maxHeight !== undefined)
         {
            this.textDisplay.maxHeight = this.textDisplayProperties.maxHeight;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),MAX_HEIGHT_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.maxWidth !== undefined)
         {
            this.textDisplay.maxWidth = this.textDisplayProperties.maxWidth;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),MAX_WIDTH_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.restrict !== undefined)
         {
            this.textDisplay.restrict = this.textDisplayProperties.restrict;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),RESTRICT_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.selectable !== undefined)
         {
            this.textDisplay.selectable = this.textDisplayProperties.selectable;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),SELECTABLE_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.selectionHighlighting !== undefined)
         {
            this.textDisplay.selectionHighlighting = this.textDisplayProperties.selectionHighlighting;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),SELECTION_HIGHLIGHTING_FLAG,true);
         }
         if(this.textDisplayProperties.text != null)
         {
            this.textDisplay.text = this.textDisplayProperties.text;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),TEXT_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.textFlow !== undefined)
         {
            this.textDisplay.textFlow = this.textDisplayProperties.textFlow;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),TEXT_FLOW_PROPERTY_FLAG,true);
         }
         if(this.textDisplayProperties.widthInChars !== undefined)
         {
            this.textDisplay.widthInChars = this.textDisplayProperties.widthInChars;
            newTextDisplayProperties = BitFlagUtil.update(uint(newTextDisplayProperties),WIDTH_IN_CHARS_PROPERTY_FLAG,true);
         }
         this.textDisplayProperties = newTextDisplayProperties;
      }
      
      private function textDisplayRemoved() : void
      {
         var newTextDisplayProperties:Object = {};
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),DISPLAY_AS_PASSWORD_PROPERTY_FLAG))
         {
            newTextDisplayProperties.displayAsPassword = this.textDisplay.displayAsPassword;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),EDITABLE_PROPERTY_FLAG))
         {
            newTextDisplayProperties.editable = this.textDisplay.editable;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),HEIGHT_IN_LINES_PROPERTY_FLAG))
         {
            newTextDisplayProperties.heightInLines = this.textDisplay.heightInLines;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),IME_MODE_PROPERTY_FLAG))
         {
            newTextDisplayProperties.imeMode = this.textDisplay.imeMode;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),MAX_CHARS_PROPERTY_FLAG))
         {
            newTextDisplayProperties.maxChars = this.textDisplay.maxChars;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),MAX_HEIGHT_PROPERTY_FLAG))
         {
            newTextDisplayProperties.maxHeight = this.textDisplay.maxHeight;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),MAX_WIDTH_PROPERTY_FLAG))
         {
            newTextDisplayProperties.maxWidth = this.textDisplay.maxWidth;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),RESTRICT_PROPERTY_FLAG))
         {
            newTextDisplayProperties.restrict = this.textDisplay.restrict;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),SELECTABLE_PROPERTY_FLAG))
         {
            newTextDisplayProperties.selectable = this.textDisplay.selectable;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),SELECTION_HIGHLIGHTING_FLAG))
         {
            newTextDisplayProperties.selectionHighlighting = this.textDisplay.selectionHighlighting;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),TEXT_PROPERTY_FLAG))
         {
            newTextDisplayProperties.text = this.textDisplay.text;
         }
         if(Boolean(BitFlagUtil.isSet(uint(this.textDisplayProperties),TEXT_FLOW_PROPERTY_FLAG)) || Boolean(BitFlagUtil.isSet(uint(this.textDisplayProperties),CONTENT_PROPERTY_FLAG)))
         {
            newTextDisplayProperties.textFlow = this.textDisplay.textFlow;
         }
         if(BitFlagUtil.isSet(uint(this.textDisplayProperties),WIDTH_IN_CHARS_PROPERTY_FLAG))
         {
            newTextDisplayProperties.widthInChars = this.textDisplay.widthInChars;
         }
         this.textDisplayProperties = newTextDisplayProperties;
      }
      
      override protected function focusInHandler(event:FocusEvent) : void
      {
         if(event.target == this)
         {
            this.setFocus();
            return;
         }
         if(Boolean(enabled) && Boolean(this.editable) && Boolean(focusManager))
         {
            focusManager.showFocusIndicator = true;
         }
         super.focusInHandler(event);
      }
      
      private function textDisplay_selectionChangeHandler(event:Event) : void
      {
         dispatchEvent(event);
      }
      
      private function textDisplay_changeHandler(event:TextOperationEvent) : void
      {
         invalidateDisplayList();
         dispatchEvent(event);
      }
      
      private function textDisplay_changingHandler(event:TextOperationEvent) : void
      {
         var newEvent:Event = event.clone();
         dispatchEvent(newEvent);
         if(newEvent.isDefaultPrevented())
         {
            event.preventDefault();
         }
      }
      
      private function textDisplay_enterHandler(event:Event) : void
      {
         dispatchEvent(event);
      }
      
      private function textDisplay_valueCommitHandler(event:Event) : void
      {
         dispatchEvent(event);
      }
   }
}
