package spark.components.supportClasses
{
   import spark.components.SkinnableDataContainer;
   import mx.core.mx_internal;
   import mx.collections.IList;
   import mx.collections.ArrayList;
   import mx.core.IVisualElement;
   import mx.events.CollectionEvent;
   import spark.layouts.supportClasses.LayoutBase;
   import spark.events.IndexChangeEvent;
   import mx.events.FlexEvent;
   import spark.components.IItemRenderer;
   import spark.utils.LabelUtil;
   import flash.events.Event;
   import mx.events.CollectionEventKind;
   
   use namespace mx_internal;
   
   [AccessibilityClass(implementation="spark.accessibility.ListBaseAccImpl")]
   [Event(name="caretChange",type="spark.events.IndexChangeEvent")]
   [Event(name="change",type="spark.events.IndexChangeEvent")]
   [Event(name="changing",type="spark.events.IndexChangeEvent")]
   public class ListBase extends SkinnableDataContainer
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      public static const NO_SELECTION:int = -1;
      
      mx_internal static const NO_PROPOSED_SELECTION:int = -2;
      
      private static const NO_CARET:int = -1;
      
      mx_internal static var CUSTOM_SELECTED_ITEM:int = -3;
      
      mx_internal static var createAccessibilityImplementation:Function;
       
      mx_internal var allowCustomSelectedItem:Boolean = false;
      
      mx_internal var dispatchChangeAfterSelection:Boolean = false;
      
      private var dataProviderChanged:Boolean;
      
      public var arrowKeysWrapFocus:Boolean;
      
      mx_internal var _caretIndex:Number = -1;
      
      mx_internal var doingWholesaleChanges:Boolean = false;
      
      private var _labelField:String = "label";
      
      private var labelFieldOrFunctionChanged:Boolean;
      
      private var _labelFunction:Function;
      
      private var _requireSelection:Boolean = false;
      
      private var requireSelectionChanged:Boolean = false;
      
      mx_internal var _proposedSelectedIndex:int = -2;
      
      mx_internal var selectedIndexAdjusted:Boolean = false;
      
      mx_internal var caretIndexAdjusted:Boolean = false;
      
      mx_internal var _selectedIndex:int = -1;
      
      mx_internal var _pendingSelectedItem;
      
      private var _selectedItem;
      
      private var _useVirtualLayout:Boolean = false;
      
      public function ListBase()
      {
         super();
      }
      
      override public function get baselinePosition() : Number
      {
         var originalProvider:IList = null;
         var result:Number = NaN;
         if(!validateBaselinePosition())
         {
            return NaN;
         }
         var isNull:Boolean = dataProvider == null;
         var isEmpty:Boolean = Boolean(dataProvider != null) && Boolean(dataProvider.length == 0);
         if(Boolean(isNull) || Boolean(isEmpty))
         {
            originalProvider = !!isEmpty?dataProvider:null;
            this.dataProvider = new ArrayList([new Object()]);
            validateNow();
         }
         if(Boolean(!dataGroup) || Boolean(dataGroup.numElements == 0))
         {
            return super.baselinePosition;
         }
         var listItem:Object = Boolean(dataGroup)?dataGroup.getElementAt(0):undefined;
         if(!listItem)
         {
            return super.baselinePosition;
         }
         if("baselinePosition" in listItem)
         {
            result = getSkinPartPosition(IVisualElement(listItem)).y + listItem.baselinePosition;
         }
         else
         {
            super.baselinePosition;
         }
         if(Boolean(isNull) || Boolean(isEmpty))
         {
            if(isNull)
            {
               this.dataProvider = null;
            }
            else if(isEmpty)
            {
               this.dataProvider = originalProvider;
            }
            validateNow();
         }
         return result;
      }
      
      override public function set dataProvider(value:IList) : void
      {
         if(dataProvider)
         {
            dataProvider.removeEventListener(CollectionEvent.COLLECTION_CHANGE,this.dataProvider_collectionChangeHandler);
         }
         this.dataProviderChanged = true;
         this.doingWholesaleChanges = true;
         if(value)
         {
            value.addEventListener(CollectionEvent.COLLECTION_CHANGE,this.dataProvider_collectionChangeHandler);
         }
         super.dataProvider = value;
         invalidateProperties();
      }
      
      override public function set layout(value:LayoutBase) : void
      {
         if(this.useVirtualLayout)
         {
            value.useVirtualLayout = true;
         }
         super.layout = value;
      }
      
      [Bindable("caretChange")]
      public function get caretIndex() : Number
      {
         return this._caretIndex;
      }
      
      public function get labelField() : String
      {
         return this._labelField;
      }
      
      public function set labelField(value:String) : void
      {
         if(value == this._labelField)
         {
            return;
         }
         this._labelField = value;
         this.labelFieldOrFunctionChanged = true;
         invalidateProperties();
      }
      
      public function get labelFunction() : Function
      {
         return this._labelFunction;
      }
      
      public function set labelFunction(value:Function) : void
      {
         if(value == this._labelFunction)
         {
            return;
         }
         this._labelFunction = value;
         this.labelFieldOrFunctionChanged = true;
         invalidateProperties();
      }
      
      public function get requireSelection() : Boolean
      {
         return this._requireSelection;
      }
      
      public function set requireSelection(value:Boolean) : void
      {
         if(value == this._requireSelection)
         {
            return;
         }
         this._requireSelection = value;
         if(value == true)
         {
            this.requireSelectionChanged = true;
            invalidateProperties();
         }
      }
      
      [Bindable("valueCommit")]
      [Bindable("change")]
      public function get selectedIndex() : int
      {
         if(this._proposedSelectedIndex != NO_PROPOSED_SELECTION)
         {
            return this._proposedSelectedIndex;
         }
         return this._selectedIndex;
      }
      
      public function set selectedIndex(value:int) : void
      {
         this.setSelectedIndex(value,false);
      }
      
      mx_internal function setSelectedIndex(value:int, dispatchChangeEvent:Boolean = false) : void
      {
         if(value == this.selectedIndex)
         {
            return;
         }
         if(dispatchChangeEvent)
         {
            this.dispatchChangeAfterSelection = dispatchChangeEvent;
         }
         this._proposedSelectedIndex = value;
         invalidateProperties();
      }
      
      [Bindable("valueCommit")]
      [Bindable("change")]
      public function get selectedItem() : *
      {
         if(this._pendingSelectedItem !== undefined)
         {
            return this._pendingSelectedItem;
         }
         if(Boolean(this.allowCustomSelectedItem) && Boolean(this.selectedIndex == CUSTOM_SELECTED_ITEM))
         {
            return this._selectedItem;
         }
         if(Boolean(this.selectedIndex == NO_SELECTION) || Boolean(dataProvider == null))
         {
            return undefined;
         }
         return dataProvider.length > this.selectedIndex?dataProvider.getItemAt(this.selectedIndex):undefined;
      }
      
      public function set selectedItem(value:*) : void
      {
         this.setSelectedItem(value,false);
      }
      
      mx_internal function setSelectedItem(value:*, dispatchChangeEvent:Boolean = false) : void
      {
         if(this.selectedItem === value)
         {
            return;
         }
         if(dispatchChangeEvent)
         {
            this.dispatchChangeAfterSelection = dispatchChangeEvent;
         }
         this._pendingSelectedItem = value;
         invalidateProperties();
      }
      
      public function get useVirtualLayout() : Boolean
      {
         return Boolean(layout)?Boolean(layout.useVirtualLayout):Boolean(this._useVirtualLayout);
      }
      
      public function set useVirtualLayout(value:Boolean) : void
      {
         if(value == this.useVirtualLayout)
         {
            return;
         }
         this._useVirtualLayout = value;
         if(layout)
         {
            layout.useVirtualLayout = value;
         }
      }
      
      override protected function initializeAccessibility() : void
      {
         if(ListBase.createAccessibilityImplementation != null)
         {
            ListBase.createAccessibilityImplementation(this);
         }
      }
      
      override protected function commitProperties() : void
      {
         var e:IndexChangeEvent = null;
         var itemIndex:int = 0;
         var n:int = 0;
         var changedSelection:Boolean = false;
         super.commitProperties();
         if(this.dataProviderChanged)
         {
            this.dataProviderChanged = false;
            this.doingWholesaleChanges = false;
            if(Boolean(this.selectedIndex >= 0) && Boolean(dataProvider) && Boolean(this.selectedIndex < dataProvider.length))
            {
               this.itemSelected(this.selectedIndex,true);
            }
            else if(this.requireSelection)
            {
               this._proposedSelectedIndex = 0;
            }
            else
            {
               this.setSelectedIndex(-1,false);
            }
         }
         if(this.requireSelectionChanged)
         {
            this.requireSelectionChanged = false;
            if(Boolean(this.requireSelection && this.selectedIndex == NO_SELECTION) && Boolean(dataProvider) && Boolean(dataProvider.length > 0))
            {
               this._proposedSelectedIndex = 0;
            }
         }
         if(this._pendingSelectedItem !== undefined)
         {
            if(dataProvider)
            {
               this._proposedSelectedIndex = dataProvider.getItemIndex(this._pendingSelectedItem);
            }
            if(Boolean(this.allowCustomSelectedItem) && Boolean(this._proposedSelectedIndex == -1))
            {
               this._proposedSelectedIndex = CUSTOM_SELECTED_ITEM;
               this._selectedItem = this._pendingSelectedItem;
            }
            this._pendingSelectedItem = undefined;
         }
         if(this._proposedSelectedIndex != NO_PROPOSED_SELECTION)
         {
            changedSelection = this.commitSelection();
         }
         if(this.selectedIndexAdjusted)
         {
            this.selectedIndexAdjusted = false;
            if(!changedSelection)
            {
               dispatchEvent(new FlexEvent(FlexEvent.VALUE_COMMIT));
            }
         }
         if(this.caretIndexAdjusted)
         {
            this.caretIndexAdjusted = false;
            if(!changedSelection)
            {
               this.itemShowingCaret(this.selectedIndex,true);
               this._caretIndex = this.selectedIndex;
               e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
               e.oldIndex = this.caretIndex;
               e.newIndex = this.caretIndex;
               dispatchEvent(e);
            }
         }
         if(this.labelFieldOrFunctionChanged)
         {
            if(dataGroup)
            {
               if(Boolean(layout) && Boolean(layout.useVirtualLayout))
               {
                  for each(itemIndex in dataGroup.getItemIndicesInView())
                  {
                     this.updateRendererLabelProperty(itemIndex);
                  }
               }
               else
               {
                  n = dataGroup.numElements;
                  for(itemIndex = 0; itemIndex < n; itemIndex++)
                  {
                     this.updateRendererLabelProperty(itemIndex);
                  }
               }
            }
            this.labelFieldOrFunctionChanged = false;
         }
      }
      
      private function updateRendererLabelProperty(itemIndex:int) : void
      {
         var renderer:IItemRenderer = dataGroup.getElementAt(itemIndex) as IItemRenderer;
         if(renderer)
         {
            renderer.label = this.itemToLabel(renderer.data);
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == dataGroup)
         {
            if(Boolean(this._useVirtualLayout) && Boolean(dataGroup.layout))
            {
               dataGroup.layout.useVirtualLayout = true;
            }
         }
      }
      
      override public function updateRenderer(renderer:IVisualElement, itemIndex:int, data:Object) : void
      {
         var transitions:Array = null;
         if(renderer is IItemRenderer)
         {
            if(renderer is ItemRenderer)
            {
               ItemRenderer(renderer).playTransitions = false;
            }
            IItemRenderer(renderer).showsCaret = false;
            if(renderer is ItemRenderer)
            {
               ItemRenderer(renderer).playTransitions = true;
            }
         }
         this.itemSelected(itemIndex,this.isItemIndexSelected(itemIndex));
         if(this.isItemIndexShowingCaret(itemIndex))
         {
            this.itemShowingCaret(itemIndex,true);
         }
         super.updateRenderer(renderer,itemIndex,data);
      }
      
      override public function itemToLabel(item:Object) : String
      {
         return LabelUtil.itemToLabel(item,this.labelField,this.labelFunction);
      }
      
      protected function itemSelected(index:int, selected:Boolean) : void
      {
      }
      
      protected function itemShowingCaret(index:int, showsCaret:Boolean) : void
      {
      }
      
      mx_internal function isItemIndexSelected(index:int) : Boolean
      {
         return index == this.selectedIndex;
      }
      
      mx_internal function isItemIndexShowingCaret(index:int) : Boolean
      {
         return index == this.caretIndex;
      }
      
      mx_internal function setCurrentCaretIndex(value:Number) : void
      {
         this.itemShowingCaret(this.caretIndex,false);
         this._caretIndex = value;
         if(this.caretIndex != CUSTOM_SELECTED_ITEM)
         {
            this.itemShowingCaret(this.caretIndex,true);
         }
      }
      
      protected function commitSelection(dispatchChangedEvents:Boolean = true) : Boolean
      {
         var e:IndexChangeEvent = null;
         var maxIndex:int = Boolean(dataProvider)?int(dataProvider.length - 1):int(-1);
         var oldSelectedIndex:int = this._selectedIndex;
         var oldCaretIndex:int = this._caretIndex;
         if(Boolean(!this.allowCustomSelectedItem) || Boolean(this._proposedSelectedIndex != CUSTOM_SELECTED_ITEM))
         {
            if(this._proposedSelectedIndex < NO_SELECTION)
            {
               this._proposedSelectedIndex = NO_SELECTION;
            }
            if(this._proposedSelectedIndex > maxIndex)
            {
               this._proposedSelectedIndex = maxIndex;
            }
            if(Boolean(this.requireSelection && this._proposedSelectedIndex == NO_SELECTION) && Boolean(dataProvider) && Boolean(dataProvider.length > 0))
            {
               this._proposedSelectedIndex = NO_PROPOSED_SELECTION;
               return false;
            }
         }
         var tmpProposedIndex:int = this._proposedSelectedIndex;
         if(this.dispatchChangeAfterSelection)
         {
            e = new IndexChangeEvent(IndexChangeEvent.CHANGING,false,true);
            e.oldIndex = this._selectedIndex;
            e.newIndex = this._proposedSelectedIndex;
            if(!dispatchEvent(e))
            {
               this._proposedSelectedIndex = NO_PROPOSED_SELECTION;
               return false;
            }
         }
         this._selectedIndex = tmpProposedIndex;
         this._proposedSelectedIndex = NO_PROPOSED_SELECTION;
         if(oldSelectedIndex != NO_SELECTION)
         {
            this.itemSelected(oldSelectedIndex,false);
         }
         if(Boolean(this._selectedIndex != NO_SELECTION) && Boolean(this._selectedIndex != CUSTOM_SELECTED_ITEM))
         {
            this.itemSelected(this._selectedIndex,true);
         }
         this.setCurrentCaretIndex(this._selectedIndex);
         if(dispatchChangedEvents)
         {
            if(this.dispatchChangeAfterSelection)
            {
               e = new IndexChangeEvent(IndexChangeEvent.CHANGE);
               e.oldIndex = oldSelectedIndex;
               e.newIndex = this._selectedIndex;
               dispatchEvent(e);
               this.dispatchChangeAfterSelection = false;
            }
            else
            {
               dispatchEvent(new FlexEvent(FlexEvent.VALUE_COMMIT));
            }
            e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
            e.oldIndex = oldCaretIndex;
            e.newIndex = this.caretIndex;
            dispatchEvent(e);
         }
         return true;
      }
      
      protected function adjustSelection(newIndex:int, add:Boolean = false) : void
      {
         if(this._proposedSelectedIndex != NO_PROPOSED_SELECTION)
         {
            this._proposedSelectedIndex = newIndex;
         }
         else
         {
            this._selectedIndex = newIndex;
         }
         this.selectedIndexAdjusted = true;
         invalidateProperties();
      }
      
      protected function itemAdded(index:int) : void
      {
         if(this.doingWholesaleChanges)
         {
            return;
         }
         if(this.selectedIndex == NO_SELECTION)
         {
            if(this.requireSelection)
            {
               this.adjustSelection(index);
            }
         }
         else if(index <= this.selectedIndex)
         {
            this.adjustSelection(this.selectedIndex + 1);
         }
      }
      
      protected function itemRemoved(index:int) : void
      {
         if(Boolean(this.selectedIndex == NO_SELECTION) || Boolean(this.doingWholesaleChanges))
         {
            return;
         }
         if(index == this.selectedIndex)
         {
            if(Boolean(this.requireSelection) && Boolean(dataProvider) && Boolean(dataProvider.length > 0))
            {
               if(index == 0)
               {
                  this._proposedSelectedIndex = 0;
                  invalidateProperties();
               }
               else
               {
                  this.setSelectedIndex(0,false);
               }
            }
            else
            {
               this.adjustSelection(-1);
            }
         }
         else if(index < this.selectedIndex)
         {
            this.adjustSelection(this.selectedIndex - 1);
         }
      }
      
      protected function dataProvider_collectionChangeHandler(event:Event) : void
      {
         var ce:CollectionEvent = null;
         if(event is CollectionEvent)
         {
            ce = CollectionEvent(event);
            if(ce.kind == CollectionEventKind.ADD)
            {
               this.itemAdded(ce.location);
            }
            else if(ce.kind == CollectionEventKind.REMOVE)
            {
               this.itemRemoved(ce.location);
            }
            else if(ce.kind == CollectionEventKind.RESET)
            {
               if(dataProvider.length == 0)
               {
                  this.setSelectedIndex(NO_SELECTION,false);
                  this.setCurrentCaretIndex(NO_CARET);
               }
               else
               {
                  this.dataProviderChanged = true;
                  invalidateProperties();
               }
            }
            else if(ce.kind == CollectionEventKind.REFRESH)
            {
               this.setSelectedIndex(NO_SELECTION,false);
               this.setCurrentCaretIndex(NO_CARET);
            }
            else if(Boolean(ce.kind == CollectionEventKind.REPLACE) || Boolean(ce.kind == CollectionEventKind.MOVE))
            {
            }
         }
      }
   }
}
