package spark.components.supportClasses
{
   import spark.components.List;
   import mx.core.mx_internal;
   import flash.display.DisplayObject;
   import mx.collections.IList;
   import spark.events.DropDownEvent;
   import spark.events.IndexChangeEvent;
   import flash.geom.Point;
   import flash.events.Event;
   import mx.events.CollectionEvent;
   import flash.events.MouseEvent;
   import flash.events.KeyboardEvent;
   import spark.core.NavigationUnit;
   import flash.events.FocusEvent;
   import mx.events.FlexEvent;
   
   use namespace mx_internal;
   
   [AccessibilityClass(implementation="spark.accessibility.DropDownListBaseAccImpl")]
   [Exclude(kind="property",name="selectedItems")]
   [Exclude(kind="property",name="selectedIndices")]
   [Exclude(kind="property",name="dropEnabled")]
   [Exclude(kind="property",name="dragMoveEnabled")]
   [Exclude(kind="property",name="dragEnabled")]
   [Exclude(kind="property",name="allowMultipleSelection")]
   [SkinState("open")]
   [Event(name="open",type="spark.events.DropDownEvent")]
   [Event(name="close",type="spark.events.DropDownEvent")]
   [Style(inherit="no",name="dropShadowVisible",theme="spark",type="Boolean")]
   [Style(inherit="no",name="cornerRadius",format="Length",theme="spark",type="Number")]
   public class DropDownListBase extends List
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var createAccessibilityImplementation:Function;
      
      mx_internal static var PAGE_SIZE:int = 5;
       
      [SkinPart(required="false")]
      public var dropDown:DisplayObject;
      
      [SkinPart(required="true")]
      public var openButton:spark.components.supportClasses.ButtonBase;
      
      private var labelChanged:Boolean = false;
      
      private var _dropDownController:spark.components.supportClasses.DropDownController;
      
      private var _userProposedSelectedIndex:Number = -1;
      
      public function DropDownListBase()
      {
         super();
         super.allowMultipleSelection = false;
         this.dropDownController = new spark.components.supportClasses.DropDownController();
      }
      
      override public function set allowMultipleSelection(value:Boolean) : void
      {
      }
      
      override public function set dataProvider(value:IList) : void
      {
         if(dataProvider === value)
         {
            return;
         }
         super.dataProvider = value;
         this.labelChanged = true;
         invalidateProperties();
      }
      
      override public function set dragEnabled(value:Boolean) : void
      {
      }
      
      override public function set dragMoveEnabled(value:Boolean) : void
      {
      }
      
      override public function set dropEnabled(value:Boolean) : void
      {
      }
      
      override public function set labelField(value:String) : void
      {
         if(labelField == value)
         {
            return;
         }
         super.labelField = value;
         this.labelChanged = true;
         invalidateProperties();
      }
      
      override public function set labelFunction(value:Function) : void
      {
         if(labelFunction == value)
         {
            return;
         }
         super.labelFunction = value;
         this.labelChanged = true;
         invalidateProperties();
      }
      
      protected function get dropDownController() : spark.components.supportClasses.DropDownController
      {
         return this._dropDownController;
      }
      
      protected function set dropDownController(value:spark.components.supportClasses.DropDownController) : void
      {
         if(this._dropDownController == value)
         {
            return;
         }
         this._dropDownController = value;
         this._dropDownController.addEventListener(DropDownEvent.OPEN,this.dropDownController_openHandler);
         this._dropDownController.addEventListener(DropDownEvent.CLOSE,this.dropDownController_closeHandler);
         if(this.openButton)
         {
            this._dropDownController.openButton = this.openButton;
         }
         if(this.dropDown)
         {
            this._dropDownController.dropDown = this.dropDown;
         }
      }
      
      public function get isDropDownOpen() : Boolean
      {
         if(this.dropDownController)
         {
            return this.dropDownController.isOpen;
         }
         return false;
      }
      
      mx_internal function set userProposedSelectedIndex(value:Number) : void
      {
         this._userProposedSelectedIndex = value;
      }
      
      mx_internal function get userProposedSelectedIndex() : Number
      {
         return this._userProposedSelectedIndex;
      }
      
      override protected function initializeAccessibility() : void
      {
         if(DropDownListBase.createAccessibilityImplementation != null)
         {
            DropDownListBase.createAccessibilityImplementation(this);
         }
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(this.labelChanged)
         {
            this.labelChanged = false;
            this.updateLabelDisplay();
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == this.openButton)
         {
            if(this.dropDownController)
            {
               this.dropDownController.openButton = this.openButton;
            }
         }
         else if(Boolean(instance == this.dropDown) && Boolean(this.dropDownController))
         {
            this.dropDownController.dropDown = this.dropDown;
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         if(this.dropDownController)
         {
            if(instance == this.openButton)
            {
               this.dropDownController.openButton = null;
            }
            if(instance == this.dropDown)
            {
               this.dropDownController.dropDown = null;
            }
         }
         super.partRemoved(partName,instance);
      }
      
      override protected function getCurrentSkinState() : String
      {
         return !enabled?"disabled":!!this.isDropDownOpen?"open":"normal";
      }
      
      override protected function commitSelection(dispatchChangedEvents:Boolean = true) : Boolean
      {
         var retVal:Boolean = super.commitSelection(dispatchChangedEvents);
         this.updateLabelDisplay();
         return retVal;
      }
      
      override mx_internal function isItemIndexSelected(index:int) : Boolean
      {
         return this.userProposedSelectedIndex == index;
      }
      
      public function openDropDown() : void
      {
         this.dropDownController.openDropDown();
      }
      
      public function closeDropDown(commit:Boolean) : void
      {
         this.dropDownController.closeDropDown(commit);
      }
      
      mx_internal function updateLabelDisplay(displayItem:* = undefined) : void
      {
      }
      
      mx_internal function changeHighlightedSelection(newIndex:int, scrollToTop:Boolean = false) : void
      {
         itemSelected(this.userProposedSelectedIndex,false);
         this.userProposedSelectedIndex = newIndex;
         itemSelected(this.userProposedSelectedIndex,true);
         this.positionIndexInView(this.userProposedSelectedIndex,!!scrollToTop?Number(0):Number(NaN));
         var e:IndexChangeEvent = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
         e.oldIndex = caretIndex;
         setCurrentCaretIndex(this.userProposedSelectedIndex);
         e.newIndex = caretIndex;
         dispatchEvent(e);
      }
      
      mx_internal function positionIndexInView(index:int, topOffset:Number = NaN, bottomOffset:Number = NaN, leftOffset:Number = NaN, rightOffset:Number = NaN) : void
      {
         if(!layout)
         {
            return;
         }
         var spDelta:Point = dataGroup.layout.getScrollPositionDeltaToElementHelper(index,topOffset,bottomOffset,leftOffset,rightOffset);
         if(spDelta)
         {
            dataGroup.horizontalScrollPosition = dataGroup.horizontalScrollPosition + spDelta.x;
            dataGroup.verticalScrollPosition = dataGroup.verticalScrollPosition + spDelta.y;
         }
      }
      
      override mx_internal function findKey(eventCode:int) : Boolean
      {
         var matchingIndex:Number = NaN;
         var keyString:String = null;
         var startIndex:int = 0;
         if(Boolean(!dataProvider) || Boolean(dataProvider.length == 0))
         {
            return false;
         }
         if(Boolean(eventCode >= 33) && Boolean(eventCode <= 126))
         {
            keyString = String.fromCharCode(eventCode);
            startIndex = !!this.isDropDownOpen?int(this.userProposedSelectedIndex + 1):int(selectedIndex + 1);
            startIndex = Math.max(0,startIndex);
            matchingIndex = findStringLoop(keyString,startIndex,dataProvider.length);
            if(matchingIndex == -1)
            {
               matchingIndex = findStringLoop(keyString,0,startIndex);
            }
            if(matchingIndex != -1)
            {
               if(this.isDropDownOpen)
               {
                  this.changeHighlightedSelection(matchingIndex);
               }
               else
               {
                  setSelectedIndex(matchingIndex,true);
               }
               return true;
            }
         }
         return false;
      }
      
      override protected function dataProvider_collectionChangeHandler(event:Event) : void
      {
         super.dataProvider_collectionChangeHandler(event);
         if(event is CollectionEvent)
         {
            this.labelChanged = true;
            invalidateProperties();
         }
      }
      
      override protected function item_mouseDownHandler(event:MouseEvent) : void
      {
         super.item_mouseDownHandler(event);
         this.userProposedSelectedIndex = selectedIndex;
         this.closeDropDown(true);
      }
      
      override protected function keyDownHandler(event:KeyboardEvent) : void
      {
         var navigationUnit:uint = 0;
         var proposedNewIndex:int = 0;
         var currentIndex:int = 0;
         var maxIndex:int = 0;
         if(!enabled)
         {
            return;
         }
         if(!this.dropDownController.processKeyDown(event))
         {
            navigationUnit = mapKeycodeForLayoutDirection(event);
            if(this.findKey(event.charCode))
            {
               event.preventDefault();
               return;
            }
            if(!NavigationUnit.isNavigationUnit(navigationUnit))
            {
               return;
            }
            proposedNewIndex = NO_SELECTION;
            if(this.isDropDownOpen)
            {
               currentIndex = this.userProposedSelectedIndex < NO_SELECTION?int(NO_SELECTION):int(this.userProposedSelectedIndex);
               proposedNewIndex = layout.getNavigationDestinationIndex(currentIndex,navigationUnit,arrowKeysWrapFocus);
               if(proposedNewIndex != NO_SELECTION)
               {
                  this.changeHighlightedSelection(proposedNewIndex);
                  event.preventDefault();
               }
            }
            else if(dataProvider)
            {
               maxIndex = dataProvider.length - 1;
               currentIndex = caretIndex < NO_SELECTION?int(NO_SELECTION):int(caretIndex);
               switch(navigationUnit)
               {
                  case NavigationUnit.UP:
                     if(Boolean(arrowKeysWrapFocus) && (Boolean(currentIndex == 0) || Boolean(currentIndex == NO_SELECTION) || Boolean(currentIndex == CUSTOM_SELECTED_ITEM)))
                     {
                        proposedNewIndex = maxIndex;
                     }
                     else
                     {
                        proposedNewIndex = currentIndex - 1;
                     }
                     event.preventDefault();
                     break;
                  case NavigationUnit.DOWN:
                     if(Boolean(arrowKeysWrapFocus) && (Boolean(currentIndex == maxIndex) || Boolean(currentIndex == NO_SELECTION) || Boolean(currentIndex == CUSTOM_SELECTED_ITEM)))
                     {
                        proposedNewIndex = 0;
                     }
                     else
                     {
                        proposedNewIndex = currentIndex + 1;
                     }
                     event.preventDefault();
                     break;
                  case NavigationUnit.PAGE_UP:
                     proposedNewIndex = currentIndex == NO_SELECTION?int(NO_SELECTION):int(Math.max(currentIndex - PAGE_SIZE,0));
                     event.preventDefault();
                     break;
                  case NavigationUnit.PAGE_DOWN:
                     proposedNewIndex = currentIndex == NO_SELECTION?int(PAGE_SIZE):int(currentIndex + PAGE_SIZE);
                     event.preventDefault();
                     break;
                  case NavigationUnit.HOME:
                     proposedNewIndex = 0;
                     event.preventDefault();
                     break;
                  case NavigationUnit.END:
                     proposedNewIndex = maxIndex;
                     event.preventDefault();
               }
               proposedNewIndex = Math.min(proposedNewIndex,maxIndex);
               if(proposedNewIndex >= 0)
               {
                  setSelectedIndex(proposedNewIndex,true);
               }
            }
         }
         else
         {
            event.preventDefault();
         }
      }
      
      override protected function focusOutHandler(event:FocusEvent) : void
      {
         if(isOurFocus(DisplayObject(event.target)))
         {
            this.dropDownController.processFocusOut(event);
         }
         super.focusOutHandler(event);
      }
      
      mx_internal function dropDownController_openHandler(event:DropDownEvent) : void
      {
         addEventListener(FlexEvent.UPDATE_COMPLETE,this.open_updateCompleteHandler);
         this.userProposedSelectedIndex = selectedIndex;
         invalidateSkinState();
      }
      
      mx_internal function open_updateCompleteHandler(event:FlexEvent) : void
      {
         removeEventListener(FlexEvent.UPDATE_COMPLETE,this.open_updateCompleteHandler);
         this.positionIndexInView(selectedIndex,0);
         dispatchEvent(new DropDownEvent(DropDownEvent.OPEN));
      }
      
      protected function dropDownController_closeHandler(event:DropDownEvent) : void
      {
         addEventListener(FlexEvent.UPDATE_COMPLETE,this.close_updateCompleteHandler);
         invalidateSkinState();
         if(!event.isDefaultPrevented())
         {
            setSelectedIndex(this.userProposedSelectedIndex,true);
         }
         else
         {
            this.changeHighlightedSelection(selectedIndex);
         }
      }
      
      private function close_updateCompleteHandler(event:FlexEvent) : void
      {
         removeEventListener(FlexEvent.UPDATE_COMPLETE,this.close_updateCompleteHandler);
         dispatchEvent(new DropDownEvent(DropDownEvent.CLOSE));
      }
   }
}
