package spark.components
{
   import spark.components.supportClasses.SkinnableComponent;
   import mx.managers.IFocusManagerComponent;
   import mx.core.IVisualElementContainer;
   import mx.core.mx_internal;
   import spark.core.IViewport;
   import flash.events.Event;
   import mx.events.PropertyChangeEvent;
   import mx.core.IVisualElement;
   import spark.components.supportClasses.ScrollerLayout;
   import flash.events.MouseEvent;
   import flash.events.KeyboardEvent;
   import flash.text.TextField;
   import spark.core.NavigationUnit;
   import flash.ui.Keyboard;
   import mx.core.LayoutDirection;
   import mx.core.IInvalidating;
   
   use namespace mx_internal;
   
   [IconFile("Scroller.png")]
   [DefaultProperty("viewport")]
   [ResourceBundle("components")]
   [Style(inherit="no",name="verticalScrollPolicy",type="String",enumeration="off,on,auto")]
   [Style(inherit="yes",name="symbolColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="rollOverColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="no",name="horizontalScrollPolicy",type="String",enumeration="off,on,auto")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="contentBackgroundColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="contentBackgroundAlpha",theme="spark",type="Number")]
   [Style(arrayType="uint",inherit="yes",name="alternatingItemColors",format="Color",theme="spark",type="Array")]
   [Style(inherit="yes",name="unfocusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="inactiveTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="focusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="whiteSpaceCollapse",type="String",enumeration="collapse,preserve")]
   [Style(inherit="yes",name="textRotation",type="String",enumeration="auto,rotate0,rotate90,rotate180,rotate270")]
   [Style(minValue="0.0",inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="yes",name="tabStops",type="String")]
   [Style(inherit="yes",name="paragraphStartIndent",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceBefore",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceAfter",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphEndIndent",format="length",type="Number")]
   [Style(inherit="yes",name="leadingModel",type="String",enumeration="auto,romanUp,ideographicTopUp,ideographicCenterUp,ideographicTopDown,ideographicCenterDown,ascentDescentUp")]
   [Style(inherit="yes",name="firstBaselineOffset",type="Object")]
   [Style(inherit="yes",name="breakOpportunity",type="String",enumeration="auto,all,any,none")]
   [Style(inherit="yes",name="blockProgression",type="String",enumeration="tb,rl")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   public class Scroller extends SkinnableComponent implements IFocusManagerComponent, IVisualElementContainer
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var _42694078horizontalScrollBar:spark.components.HScrollBar;
      
      private var _1618627376verticalScrollBar:spark.components.VScrollBar;
      
      private var _viewport:IViewport;
      
      private var _minViewportInset:Number = 0;
      
      private var _measuredSizeIncludesScrollBars:Boolean = true;
      
      public function Scroller()
      {
         super();
         hasFocusableChildren = true;
         focusEnabled = false;
      }
      
      private function invalidateSkin() : void
      {
         if(skin)
         {
            skin.invalidateSize();
            skin.invalidateDisplayList();
         }
      }
      
      [Bindable(event="viewportChanged")]
      public function get viewport() : IViewport
      {
         return this._viewport;
      }
      
      public function set viewport(value:IViewport) : void
      {
         if(value == this._viewport)
         {
            return;
         }
         this.uninstallViewport();
         this._viewport = value;
         this.installViewport();
         dispatchEvent(new Event("viewportChanged"));
      }
      
      private function installViewport() : void
      {
         if(Boolean(skin) && Boolean(this.viewport))
         {
            this.viewport.clipAndEnableScrolling = true;
            Group(skin).addElementAt(this.viewport,0);
            this.viewport.addEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.viewport_propertyChangeHandler);
         }
         if(this.verticalScrollBar)
         {
            this.verticalScrollBar.viewport = this.viewport;
         }
         if(this.horizontalScrollBar)
         {
            this.horizontalScrollBar.viewport = this.viewport;
         }
      }
      
      private function uninstallViewport() : void
      {
         if(this.horizontalScrollBar)
         {
            this.horizontalScrollBar.viewport = null;
         }
         if(this.verticalScrollBar)
         {
            this.verticalScrollBar.viewport = null;
         }
         if(Boolean(skin) && Boolean(this.viewport))
         {
            this.viewport.clipAndEnableScrolling = false;
            Group(skin).removeElement(this.viewport);
            this.viewport.removeEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.viewport_propertyChangeHandler);
         }
      }
      
      [Inspectable(category="General")]
      public function get minViewportInset() : Number
      {
         return this._minViewportInset;
      }
      
      public function set minViewportInset(value:Number) : void
      {
         if(value == this._minViewportInset)
         {
            return;
         }
         this._minViewportInset = value;
         this.invalidateSkin();
      }
      
      public function get measuredSizeIncludesScrollBars() : Boolean
      {
         return this._measuredSizeIncludesScrollBars;
      }
      
      public function set measuredSizeIncludesScrollBars(value:Boolean) : void
      {
         if(value == this._measuredSizeIncludesScrollBars)
         {
            return;
         }
         this._measuredSizeIncludesScrollBars = value;
         this.invalidateSkin();
      }
      
      private function viewport_propertyChangeHandler(event:PropertyChangeEvent) : void
      {
         switch(event.property)
         {
            case "contentWidth":
            case "contentHeight":
               this.invalidateSkin();
         }
      }
      
      public function get numElements() : int
      {
         return Boolean(this.viewport)?int(1):int(0);
      }
      
      public function getElementAt(index:int) : IVisualElement
      {
         if(Boolean(this.viewport) && Boolean(index == 0))
         {
            return this.viewport;
         }
         throw new RangeError(resourceManager.getString("components","indexOutOfRange",[index]));
      }
      
      public function getElementIndex(element:IVisualElement) : int
      {
         if(Boolean(element != null) && Boolean(element == this.viewport))
         {
            return 0;
         }
         throw ArgumentError(resourceManager.getString("components","elementNotFoundInScroller",[element]));
      }
      
      public function addElement(element:IVisualElement) : IVisualElement
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function addElementAt(element:IVisualElement, index:int) : IVisualElement
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function removeElement(element:IVisualElement) : IVisualElement
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function removeElementAt(index:int) : IVisualElement
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function removeAllElements() : void
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function setElementIndex(element:IVisualElement, index:int) : void
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function swapElements(element1:IVisualElement, element2:IVisualElement) : void
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      public function swapElementsAt(index1:int, index2:int) : void
      {
         throw new ArgumentError(resourceManager.getString("components","operationNotSupported"));
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         var allStyles:Boolean = Boolean(styleProp == null) || Boolean(styleProp == "styleName");
         super.styleChanged(styleProp);
         if(Boolean(allStyles) || Boolean(styleProp == "horizontalScrollPolicy") || Boolean(styleProp == "verticalScrollPolicy"))
         {
            this.invalidateSkin();
         }
      }
      
      override protected function attachSkin() : void
      {
         super.attachSkin();
         Group(skin).layout = new ScrollerLayout();
         this.installViewport();
         skin.addEventListener(MouseEvent.MOUSE_WHEEL,this.skin_mouseWheelHandler);
      }
      
      override protected function detachSkin() : void
      {
         this.uninstallViewport();
         Group(skin).layout = null;
         skin.removeEventListener(MouseEvent.MOUSE_WHEEL,this.skin_mouseWheelHandler);
         super.detachSkin();
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == this.verticalScrollBar)
         {
            this.verticalScrollBar.viewport = this.viewport;
         }
         else if(instance == this.horizontalScrollBar)
         {
            this.horizontalScrollBar.viewport = this.viewport;
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         super.partRemoved(partName,instance);
         if(instance == this.verticalScrollBar)
         {
            this.verticalScrollBar.viewport = null;
         }
         else if(instance == this.horizontalScrollBar)
         {
            this.horizontalScrollBar.viewport = null;
         }
      }
      
      override protected function keyDownHandler(event:KeyboardEvent) : void
      {
         var vspDelta:Number = NaN;
         var hspDelta:Number = NaN;
         super.keyDownHandler(event);
         var vp:IViewport = this.viewport;
         if(Boolean(!vp) || Boolean(event.isDefaultPrevented()))
         {
            return;
         }
         if(getFocus() is TextField)
         {
            return;
         }
         if(Boolean(this.verticalScrollBar) && Boolean(this.verticalScrollBar.visible))
         {
            vspDelta = NaN;
            switch(event.keyCode)
            {
               case Keyboard.UP:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.UP);
                  break;
               case Keyboard.DOWN:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.DOWN);
                  break;
               case Keyboard.PAGE_UP:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.PAGE_UP);
                  break;
               case Keyboard.PAGE_DOWN:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.PAGE_DOWN);
                  break;
               case Keyboard.HOME:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.HOME);
                  break;
               case Keyboard.END:
                  vspDelta = vp.getVerticalScrollPositionDelta(NavigationUnit.END);
            }
            if(!isNaN(vspDelta))
            {
               vp.verticalScrollPosition = vp.verticalScrollPosition + vspDelta;
               event.preventDefault();
            }
         }
         if(Boolean(this.horizontalScrollBar) && Boolean(this.horizontalScrollBar.visible))
         {
            hspDelta = NaN;
            switch(event.keyCode)
            {
               case Keyboard.LEFT:
                  hspDelta = layoutDirection == LayoutDirection.LTR?Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.LEFT)):Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.RIGHT));
                  break;
               case Keyboard.RIGHT:
                  hspDelta = layoutDirection == LayoutDirection.LTR?Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.RIGHT)):Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.LEFT));
                  break;
               case Keyboard.HOME:
                  hspDelta = vp.getHorizontalScrollPositionDelta(NavigationUnit.HOME);
                  break;
               case Keyboard.END:
                  hspDelta = vp.getHorizontalScrollPositionDelta(NavigationUnit.END);
                  break;
               case Keyboard.PAGE_UP:
                  if(Boolean(!this.verticalScrollBar) || Boolean(!this.verticalScrollBar.visible))
                  {
                     hspDelta = Boolean(LayoutDirection.LTR)?Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.LEFT)):Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.RIGHT));
                  }
                  break;
               case Keyboard.PAGE_DOWN:
                  if(Boolean(!this.verticalScrollBar) || Boolean(!this.verticalScrollBar.visible))
                  {
                     hspDelta = Boolean(LayoutDirection.LTR)?Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.RIGHT)):Number(vp.getHorizontalScrollPositionDelta(NavigationUnit.LEFT));
                  }
            }
            if(!isNaN(hspDelta))
            {
               vp.horizontalScrollPosition = vp.horizontalScrollPosition + hspDelta;
               event.preventDefault();
            }
         }
      }
      
      private function skin_mouseWheelHandler(event:MouseEvent) : void
      {
         var navigationUnit:uint = 0;
         var vStep:int = 0;
         var vspDelta:Number = NaN;
         var hStep:int = 0;
         var hspDelta:Number = NaN;
         var vp:IViewport = this.viewport;
         if(Boolean(event.isDefaultPrevented()) || Boolean(!vp) || Boolean(!vp.visible))
         {
            return;
         }
         var nSteps:uint = Math.abs(event.delta);
         if(Boolean(this.verticalScrollBar) && Boolean(this.verticalScrollBar.visible))
         {
            navigationUnit = event.delta < 0?uint(NavigationUnit.DOWN):uint(NavigationUnit.UP);
            for(vStep = 0; vStep < nSteps; vStep++)
            {
               vspDelta = vp.getVerticalScrollPositionDelta(navigationUnit);
               if(!isNaN(vspDelta))
               {
                  vp.verticalScrollPosition = vp.verticalScrollPosition + vspDelta;
                  if(vp is IInvalidating)
                  {
                     IInvalidating(vp).validateNow();
                  }
               }
            }
            event.preventDefault();
         }
         else if(Boolean(this.horizontalScrollBar) && Boolean(this.horizontalScrollBar.visible))
         {
            navigationUnit = event.delta < 0?uint(NavigationUnit.RIGHT):uint(NavigationUnit.LEFT);
            for(hStep = 0; hStep < nSteps; hStep++)
            {
               hspDelta = vp.getHorizontalScrollPositionDelta(navigationUnit);
               if(!isNaN(hspDelta))
               {
                  vp.horizontalScrollPosition = vp.horizontalScrollPosition + hspDelta;
                  if(vp is IInvalidating)
                  {
                     IInvalidating(vp).validateNow();
                  }
               }
            }
            event.preventDefault();
         }
      }
      
      [Bindable(event="propertyChange")]
      [SkinPart(required="false")]
      public function get horizontalScrollBar() : spark.components.HScrollBar
      {
         return this._42694078horizontalScrollBar;
      }
      
      public function set horizontalScrollBar(param1:spark.components.HScrollBar) : void
      {
         var _loc2_:Object = this._42694078horizontalScrollBar;
         if(_loc2_ !== param1)
         {
            this._42694078horizontalScrollBar = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"horizontalScrollBar",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      [SkinPart(required="false")]
      public function get verticalScrollBar() : spark.components.VScrollBar
      {
         return this._1618627376verticalScrollBar;
      }
      
      public function set verticalScrollBar(param1:spark.components.VScrollBar) : void
      {
         var _loc2_:Object = this._1618627376verticalScrollBar;
         if(_loc2_ !== param1)
         {
            this._1618627376verticalScrollBar = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"verticalScrollBar",_loc2_,param1));
            }
         }
      }
   }
}
