package spark.components
{
   import spark.components.supportClasses.TextBase;
   import mx.core.mx_internal;
   import flash.text.engine.TextBlock;
   import flash.text.engine.TextElement;
   import flash.text.engine.SpaceJustifier;
   import flash.text.engine.EastAsianJustifier;
   import mx.core.IEmbeddedFontRegistry;
   import mx.core.Singleton;
   import mx.core.IFlexModuleFactory;
   import flash.text.engine.ElementFormat;
   import flash.text.engine.FontDescription;
   import flash.text.engine.FontLookup;
   import flash.text.engine.TextBaseline;
   import flash.text.engine.Kerning;
   import flash.text.engine.LineJustification;
   import flash.display.DisplayObject;
   import flash.geom.Rectangle;
   import flash.text.engine.TextLine;
   import flash.text.engine.FontMetrics;
   import flash.display.Shape;
   import flash.display.Graphics;
   import flashx.textLayout.compose.ISWFContext;
   import flashx.textLayout.compose.TextLineRecycler;
   
   use namespace mx_internal;
   
   [IconFile("Label.png")]
   [DefaultProperty("text")]
   [Style(inherit="no",name="verticalAlign",type="String",enumeration="top,middle,bottom,justify")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingRight",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingLeft",format="Length",type="Number")]
   [Style(minValue="0.0",maxValue="1000.0",inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(inherit="no",name="lineBreak",type="String",enumeration="toFit,explicit")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   public class Label extends TextBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var staticTextBlock:TextBlock;
      
      private static var staticTextElement:TextElement;
      
      private static var staticSpaceJustifier:SpaceJustifier;
      
      private static var staticEastAsianJustifier:EastAsianJustifier;
      
      private static var recreateTextLine:Function;
      
      private static var _embeddedFontRegistry:IEmbeddedFontRegistry;
      
      {
         initClass();
      }
      
      private var embeddedFontContext:IFlexModuleFactory;
      
      private var elementFormat:ElementFormat;
      
      public function Label()
      {
         super();
      }
      
      private static function initClass() : void
      {
         staticTextBlock = new TextBlock();
         staticTextElement = new TextElement();
         staticSpaceJustifier = new SpaceJustifier();
         staticEastAsianJustifier = new EastAsianJustifier();
         if("recreateTextLine" in staticTextBlock)
         {
            recreateTextLine = staticTextBlock["recreateTextLine"];
         }
      }
      
      private static function get embeddedFontRegistry() : IEmbeddedFontRegistry
      {
         if(!_embeddedFontRegistry)
         {
            _embeddedFontRegistry = IEmbeddedFontRegistry(Singleton.getInstance("mx.core::IEmbeddedFontRegistry"));
         }
         return _embeddedFontRegistry;
      }
      
      private static function getNumberOrPercentOf(value:Object, n:Number) : Number
      {
         var len:int = 0;
         var percent:Number = NaN;
         if(value is Number)
         {
            return Number(value);
         }
         if(value is String)
         {
            len = String(value).length;
            if(Boolean(len >= 1) && Boolean(value.charAt(len - 1) == "%"))
            {
               percent = Number(value.substring(0,len - 1));
               return percent / 100 * n;
            }
         }
         return NaN;
      }
      
      override public function stylesInitialized() : void
      {
         super.stylesInitialized();
         this.elementFormat = null;
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         super.styleChanged(styleProp);
         this.elementFormat = null;
      }
      
      override mx_internal function composeTextLines(width:Number = NaN, height:Number = NaN) : Boolean
      {
         super.composeTextLines(width,height);
         if(!this.elementFormat)
         {
            this.elementFormat = this.createElementFormat();
         }
         bounds.x = 0;
         bounds.y = 0;
         bounds.width = width;
         bounds.height = height;
         removeTextLines();
         releaseTextLines();
         var allLinesComposed:Boolean = this.createTextLines(this.elementFormat);
         var lb:String = getStyle("lineBreak");
         if(Boolean(maxDisplayedLines) && Boolean(!this.doesComposedTextFit(height,width,allLinesComposed,maxDisplayedLines,lb)))
         {
            this.truncateText(width,height,lb);
         }
         this.releaseLinesFromTextBlock();
         addTextLines();
         isOverset = isTextOverset(width,height);
         invalidateCompose = false;
         return allLinesComposed;
      }
      
      private function createElementFormat() : ElementFormat
      {
         var s:String = null;
         var locale:String = null;
         var lowercaseLocale:String = null;
         this.embeddedFontContext = getEmbeddedFontContext();
         var fontDescription:FontDescription = new FontDescription();
         s = getStyle("cffHinting");
         if(s != null)
         {
            fontDescription.cffHinting = s;
         }
         s = getStyle("fontLookup");
         if(s != null)
         {
            if(s == "auto")
            {
               s = Boolean(this.embeddedFontContext)?FontLookup.EMBEDDED_CFF:FontLookup.DEVICE;
            }
            else if(Boolean(s == FontLookup.EMBEDDED_CFF) && Boolean(!this.embeddedFontContext))
            {
               s = FontLookup.DEVICE;
            }
            fontDescription.fontLookup = s;
         }
         s = getStyle("fontFamily");
         if(s != null)
         {
            fontDescription.fontName = s;
         }
         s = getStyle("fontStyle");
         if(s != null)
         {
            fontDescription.fontPosture = s;
         }
         s = getStyle("fontWeight");
         if(s != null)
         {
            fontDescription.fontWeight = s;
         }
         s = getStyle("renderingMode");
         if(s != null)
         {
            fontDescription.renderingMode = s;
         }
         var elementFormat:ElementFormat = new ElementFormat();
         s = getStyle("alignmentBaseline");
         if(s != null)
         {
            elementFormat.alignmentBaseline = s;
         }
         elementFormat.alpha = getStyle("textAlpha");
         elementFormat.baselineShift = -getStyle("baselineShift");
         elementFormat.color = getStyle("color");
         s = getStyle("digitCase");
         if(s != null)
         {
            elementFormat.digitCase = s;
         }
         s = getStyle("digitWidth");
         if(s != null)
         {
            elementFormat.digitWidth = s;
         }
         s = getStyle("dominantBaseline");
         if(s != null)
         {
            if(s == "auto")
            {
               s = TextBaseline.ROMAN;
               locale = getStyle("locale");
               if(locale != null)
               {
                  lowercaseLocale = locale.toLowerCase();
                  if(Boolean(lowercaseLocale.indexOf("ja") == 0) || Boolean(lowercaseLocale.indexOf("zh") == 0))
                  {
                     s = TextBaseline.IDEOGRAPHIC_CENTER;
                  }
               }
            }
            elementFormat.dominantBaseline = s;
         }
         elementFormat.fontDescription = fontDescription;
         elementFormat.fontSize = getStyle("fontSize");
         this.setKerning(elementFormat);
         s = getStyle("ligatureLevel");
         if(s != null)
         {
            elementFormat.ligatureLevel = s;
         }
         s = getStyle("locale");
         if(s != null)
         {
            elementFormat.locale = s;
         }
         this.setTracking(elementFormat);
         s = getStyle("typographicCase");
         if(s != null)
         {
            elementFormat.typographicCase = s;
         }
         return elementFormat;
      }
      
      private function setKerning(elementFormat:ElementFormat) : void
      {
         var kerning:Object = getStyle("kerning");
         if(kerning === "default")
         {
            kerning = Kerning.AUTO;
         }
         else if(kerning === true)
         {
            kerning = Kerning.ON;
         }
         else if(kerning === false)
         {
            kerning = Kerning.OFF;
         }
         if(kerning != null)
         {
            elementFormat.kerning = String(kerning);
         }
      }
      
      private function setTracking(elementFormat:ElementFormat) : void
      {
         var value:Number = NaN;
         var trackingLeft:Object = getStyle("trackingLeft");
         var trackingRight:Object = getStyle("trackingRight");
         var fontSize:Number = elementFormat.fontSize;
         value = getNumberOrPercentOf(trackingLeft,fontSize);
         if(!isNaN(value))
         {
            elementFormat.trackingLeft = value;
         }
         value = getNumberOrPercentOf(trackingRight,fontSize);
         if(!isNaN(value))
         {
            elementFormat.trackingRight = value;
         }
      }
      
      private function createTextLines(elementFormat:ElementFormat) : Boolean
      {
         var lineJustification:String = null;
         var locale:String = null;
         var lowercaseLocale:String = null;
         var direction:String = getStyle("direction");
         var justificationRule:String = getStyle("justificationRule");
         var justificationStyle:String = getStyle("justificationStyle");
         var textAlign:String = getStyle("textAlign");
         var textAlignLast:String = getStyle("textAlignLast");
         var textJustify:String = getStyle("textJustify");
         if(justificationRule == "auto")
         {
            justificationRule = "space";
            locale = getStyle("locale");
            if(locale != null)
            {
               lowercaseLocale = locale.toLowerCase();
               if(Boolean(lowercaseLocale.indexOf("ja") == 0) || Boolean(lowercaseLocale.indexOf("zh") == 0))
               {
                  justificationRule = "eastAsian";
               }
            }
         }
         if(justificationStyle == "auto")
         {
            justificationStyle = "pushInKinsoku";
         }
         staticTextElement.text = Boolean(text != null) && Boolean(text.length > 0)?text:" ";
         staticTextElement.elementFormat = elementFormat;
         staticTextBlock.content = staticTextElement;
         staticTextBlock.bidiLevel = direction == "ltr"?int(0):int(1);
         if(textAlign == "justify")
         {
            lineJustification = textAlignLast == "justify"?LineJustification.ALL_INCLUDING_LAST:LineJustification.ALL_BUT_LAST;
         }
         else
         {
            lineJustification = LineJustification.UNJUSTIFIED;
         }
         if(justificationRule == "space")
         {
            staticSpaceJustifier.lineJustification = lineJustification;
            staticSpaceJustifier.letterSpacing = textJustify == "distribute";
            staticTextBlock.textJustifier = staticSpaceJustifier;
         }
         else
         {
            staticEastAsianJustifier.lineJustification = lineJustification;
            staticEastAsianJustifier.justificationStyle = justificationStyle;
            staticTextBlock.textJustifier = staticEastAsianJustifier;
         }
         return this.createTextLinesFromTextBlock(staticTextBlock,textLines,bounds);
      }
      
      private function createTextLinesFromTextBlock(textBlock:TextBlock, textLines:Vector.<DisplayObject>, bounds:Rectangle) : Boolean
      {
         var actualLineHeight:Number = NaN;
         var nextTextLine:TextLine = null;
         var textLine:TextLine = null;
         var extraLine:Boolean = false;
         var previousTextLine:TextLine = null;
         var len:int = 0;
         var percent:Number = NaN;
         var recycleLine:TextLine = null;
         var elementFormat:ElementFormat = null;
         var fontMetrics:FontMetrics = null;
         var shape:Shape = null;
         var g:Graphics = null;
         releaseTextLines(textLines);
         var direction:String = getStyle("direction");
         var lineBreak:String = getStyle("lineBreak");
         var lineHeight:Object = getStyle("lineHeight");
         var lineThrough:Boolean = getStyle("lineThrough");
         var paddingBottom:Number = getStyle("paddingBottom");
         var paddingLeft:Number = getStyle("paddingLeft");
         var paddingRight:Number = getStyle("paddingRight");
         var paddingTop:Number = getStyle("paddingTop");
         var textAlign:String = getStyle("textAlign");
         var textAlignLast:String = getStyle("textAlignLast");
         var textDecoration:String = getStyle("textDecoration");
         var verticalAlign:String = getStyle("verticalAlign");
         var innerWidth:Number = bounds.width - paddingLeft - paddingRight;
         var innerHeight:Number = bounds.height - paddingTop - paddingBottom;
         var measureWidth:Boolean = isNaN(innerWidth);
         if(measureWidth)
         {
            innerWidth = maxWidth;
         }
         var maxLineWidth:Number = lineBreak == "explicit"?Number(TextLine.MAX_LINE_WIDTH):Number(innerWidth);
         if(Boolean(innerWidth < 0) || Boolean(innerHeight < 0) || Boolean(!textBlock))
         {
            bounds.width = 0;
            bounds.height = 0;
            return false;
         }
         var fontSize:Number = staticTextElement.elementFormat.fontSize;
         if(lineHeight is Number)
         {
            actualLineHeight = Number(lineHeight);
         }
         else if(lineHeight is String)
         {
            len = lineHeight.length;
            percent = Number(String(lineHeight).substring(0,len - 1));
            actualLineHeight = percent / 100 * fontSize;
         }
         if(isNaN(actualLineHeight))
         {
            actualLineHeight = 1.2 * fontSize;
         }
         var maxTextWidth:Number = 0;
         var totalTextHeight:Number = 0;
         var n:int = 0;
         var nextY:Number = 0;
         var swfContext:ISWFContext = ISWFContext(this.embeddedFontContext);
         var createdAllLines:Boolean = false;
         while(true)
         {
            recycleLine = TextLineRecycler.getLineForReuse();
            if(recycleLine)
            {
               if(swfContext)
               {
                  nextTextLine = swfContext.callInContext(textBlock["recreateTextLine"],textBlock,[recycleLine,textLine,maxLineWidth]);
               }
               else
               {
                  nextTextLine = recreateTextLine(recycleLine,textLine,maxLineWidth);
               }
            }
            else if(swfContext)
            {
               nextTextLine = swfContext.callInContext(textBlock.createTextLine,textBlock,[textLine,maxLineWidth]);
            }
            else
            {
               nextTextLine = textBlock.createTextLine(textLine,maxLineWidth);
            }
            if(!nextTextLine)
            {
               createdAllLines = !extraLine;
               break;
            }
            nextY = nextY + (n == 0?nextTextLine.ascent:actualLineHeight);
            if(Boolean(verticalAlign == "top") && Boolean(nextY - nextTextLine.ascent > innerHeight))
            {
               if(!extraLine)
               {
                  extraLine = true;
               }
               else
               {
                  break;
               }
            }
            textLine = nextTextLine;
            textLines[_loc56_] = textLine;
            textLine.y = nextY;
            maxTextWidth = Math.max(maxTextWidth,textLine.textWidth);
            totalTextHeight = totalTextHeight + textLine.textHeight;
            if(Boolean(lineThrough) || Boolean(textDecoration == "underline"))
            {
               elementFormat = TextElement(textBlock.content).elementFormat;
               if(this.embeddedFontContext)
               {
                  fontMetrics = this.embeddedFontContext.callInContext(elementFormat.getFontMetrics,elementFormat,null);
               }
               else
               {
                  fontMetrics = elementFormat.getFontMetrics();
               }
               shape = new Shape();
               g = shape.graphics;
               if(lineThrough)
               {
                  g.lineStyle(fontMetrics.strikethroughThickness,elementFormat.color,elementFormat.alpha);
                  g.moveTo(0,fontMetrics.strikethroughOffset);
                  g.lineTo(textLine.textWidth,fontMetrics.strikethroughOffset);
               }
               if(textDecoration == "underline")
               {
                  g.lineStyle(fontMetrics.underlineThickness,elementFormat.color,elementFormat.alpha);
                  g.moveTo(0,fontMetrics.underlineOffset);
                  g.lineTo(textLine.textWidth,fontMetrics.underlineOffset);
               }
               textLine.addChild(shape);
            }
         }
         if(n == 0)
         {
            bounds.width = paddingLeft + paddingRight;
            bounds.height = paddingTop + paddingBottom;
            return false;
         }
         if(measureWidth)
         {
            innerWidth = maxTextWidth;
         }
         if(isNaN(bounds.height))
         {
            innerHeight = textLine.y + textLine.descent;
         }
         var leftAligned:Boolean = Boolean(textAlign == "start") && Boolean(direction == "ltr") || Boolean(textAlign == "end") && Boolean(direction == "rtl") || Boolean(textAlign == "left") || Boolean(textAlign == "justify");
         var centerAligned:Boolean = textAlign == "center";
         var rightAligned:Boolean = Boolean(textAlign == "start") && Boolean(direction == "rtl") || Boolean(textAlign == "end") && Boolean(direction == "ltr") || Boolean(textAlign == "right");
         var leftOffset:Number = bounds.left + paddingLeft;
         var centerOffset:Number = leftOffset + innerWidth / 2;
         var rightOffset:Number = leftOffset + innerWidth;
         var topOffset:Number = bounds.top + paddingTop;
         var bottomOffset:Number = innerHeight - (textLine.y + textLine.descent);
         var middleOffset:Number = bottomOffset / 2;
         bottomOffset = bottomOffset + topOffset;
         middleOffset = middleOffset + topOffset;
         var leading:Number = (innerHeight - totalTextHeight) / (n - 1);
         var y:Number = 0;
         var lastLineIsSpecial:Boolean = Boolean(textAlign == "justify") && Boolean(createdAllLines);
         var minX:Number = innerWidth;
         var minY:Number = innerHeight;
         var maxX:Number = 0;
         var clipping:Boolean = Boolean(n)?Boolean(textLines[n - 1].y + TextLine(textLines[n - 1]).descent > innerHeight):Boolean(false);
         for(var i:int = 0; i < n; i++)
         {
            textLine = TextLine(textLines[i]);
            if(Boolean(lastLineIsSpecial) && Boolean(i == n - 1))
            {
               leftAligned = Boolean(textAlignLast == "start") && Boolean(direction == "ltr") || Boolean(textAlignLast == "end") && Boolean(direction == "rtl") || Boolean(textAlignLast == "left") || Boolean(textAlignLast == "justify");
               centerAligned = textAlignLast == "center";
               rightAligned = Boolean(textAlignLast == "start") && Boolean(direction == "rtl") || Boolean(textAlignLast == "end") && Boolean(direction == "ltr") || Boolean(textAlignLast == "right");
            }
            if(leftAligned)
            {
               textLine.x = leftOffset;
            }
            else if(centerAligned)
            {
               textLine.x = centerOffset - textLine.textWidth / 2;
            }
            else if(rightAligned)
            {
               textLine.x = rightOffset - textLine.textWidth;
            }
            if(Boolean(verticalAlign == "top") || Boolean(!createdAllLines) || Boolean(clipping))
            {
               textLine.y = textLine.y + topOffset;
            }
            else if(verticalAlign == "middle")
            {
               textLine.y = textLine.y + middleOffset;
            }
            else if(verticalAlign == "bottom")
            {
               textLine.y = textLine.y + bottomOffset;
            }
            else if(verticalAlign == "justify")
            {
               y = y + (i == 0?topOffset + textLine.ascent:previousTextLine.descent + leading + textLine.ascent);
               textLine.y = y;
               previousTextLine = textLine;
            }
            minX = Math.min(minX,textLine.x);
            minY = Math.min(minY,textLine.y - textLine.ascent);
            maxX = Math.max(maxX,textLine.x + textLine.textWidth);
         }
         bounds.x = minX - paddingLeft;
         bounds.y = minY - paddingTop;
         bounds.right = maxX + paddingRight;
         bounds.bottom = textLine.y + textLine.descent + paddingBottom;
         return createdAllLines;
      }
      
      override mx_internal function createEmptyTextLine(height:Number = NaN) : void
      {
         staticTextElement.text = " ";
         bounds.width = NaN;
         bounds.height = height;
         this.createTextLinesFromTextBlock(staticTextBlock,textLines,bounds);
         this.releaseLinesFromTextBlock();
      }
      
      private function doesComposedTextFit(height:Number, width:Number, createdAllLines:Boolean, lineCountLimit:int, lineBreak:String) : Boolean
      {
         if(!createdAllLines)
         {
            return false;
         }
         if(Boolean(lineCountLimit != -1) && Boolean(textLines.length > lineCountLimit))
         {
            return false;
         }
         if(lineBreak == "explicit")
         {
            if(bounds.right > width)
            {
               return false;
            }
         }
         if(Boolean(!textLines.length) || Boolean(isNaN(height)))
         {
            return true;
         }
         var lastLine:TextLine = TextLine(textLines[textLines.length - 1]);
         var lastLineExtent:Number = lastLine.y + lastLine.descent;
         return lastLineExtent <= height;
      }
      
      private function truncateText(width:Number, height:Number, lineBreak:String) : void
      {
         var extraLine:Boolean = false;
         var indicatorLines:Vector.<DisplayObject> = null;
         var indicatorBounds:Rectangle = null;
         var measuredTextLine:TextLine = null;
         var allowedWidth:Number = NaN;
         var truncateAtCharPosition:int = 0;
         var truncText:String = null;
         var createdAllLines:Boolean = false;
         var oldCharPosition:int = 0;
         var paddingBottom:Number = NaN;
         var paddingLeft:Number = NaN;
         var paddingRight:Number = NaN;
         var paddingTop:Number = NaN;
         var lineCountLimit:int = maxDisplayedLines;
         var somethingFit:Boolean = false;
         var truncLineIndex:int = 0;
         if(lineBreak == "explicit")
         {
            this.truncateExplicitLineBreakText(width,height);
            return;
         }
         truncLineIndex = this.computeLastAllowedLineIndex(height,lineCountLimit);
         if(truncLineIndex + 1 < textLines.length)
         {
            truncLineIndex++;
            extraLine = true;
         }
         if(truncLineIndex >= 0)
         {
            staticTextElement.text = truncationIndicatorResource;
            indicatorLines = new Vector.<DisplayObject>();
            indicatorBounds = new Rectangle(0,0,width,NaN);
            this.createTextLinesFromTextBlock(staticTextBlock,indicatorLines,indicatorBounds);
            this.releaseLinesFromTextBlock();
            truncLineIndex = truncLineIndex - (indicatorLines.length - 1);
            if(truncLineIndex >= 0)
            {
               measuredTextLine = TextLine(indicatorLines[indicatorLines.length - 1]);
               allowedWidth = measuredTextLine.specifiedWidth - measuredTextLine.unjustifiedTextWidth;
               measuredTextLine = null;
               releaseTextLines(indicatorLines);
               truncateAtCharPosition = this.getTruncationPosition(TextLine(textLines[truncLineIndex]),allowedWidth,extraLine);
               do
               {
                  truncText = text.slice(0,truncateAtCharPosition) + truncationIndicatorResource;
                  bounds.x = 0;
                  bounds.y = 0;
                  bounds.width = width;
                  bounds.height = height;
                  staticTextElement.text = truncText;
                  createdAllLines = this.createTextLinesFromTextBlock(staticTextBlock,textLines,bounds);
                  if(this.doesComposedTextFit(height,width,createdAllLines,lineCountLimit,lineBreak))
                  {
                     somethingFit = true;
                     break;
                  }
                  if(truncateAtCharPosition == 0)
                  {
                     break;
                  }
                  oldCharPosition = truncateAtCharPosition;
                  truncateAtCharPosition = this.getNextTruncationPosition(truncLineIndex,truncateAtCharPosition);
                  if(oldCharPosition == truncateAtCharPosition)
                  {
                     break;
                  }
               }
               while(true);
               
            }
         }
         if(!somethingFit)
         {
            releaseTextLines();
            paddingBottom = getStyle("paddingBottom");
            paddingLeft = getStyle("paddingLeft");
            paddingRight = getStyle("paddingRight");
            paddingTop = getStyle("paddingTop");
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = paddingLeft + paddingRight;
            bounds.height = paddingTop + paddingBottom;
         }
         setIsTruncated(true);
      }
      
      private function truncateExplicitLineBreakText(width:Number, height:Number) : void
      {
         var line:TextLine = null;
         var lineLength:int = 0;
         var lineStr:String = null;
         var clippedLines:Vector.<DisplayObject> = null;
         staticTextElement.text = truncationIndicatorResource;
         var indicatorLines:Vector.<DisplayObject> = new Vector.<DisplayObject>();
         var indicatorBounds:Rectangle = new Rectangle(0,0,width,NaN);
         this.createTextLinesFromTextBlock(staticTextBlock,indicatorLines,indicatorBounds);
         this.releaseLinesFromTextBlock();
         var n:int = textLines.length;
         for(var i:int = 0; i < n; i++)
         {
            line = textLines[i] as TextLine;
            if(line.x + line.width > width)
            {
               lineLength = line.rawTextLength;
               while(--lineLength > 0)
               {
                  lineStr = text.substr(line.textBlockBeginIndex,lineLength);
                  lineStr = lineStr + truncationIndicatorResource;
                  staticTextElement.text = lineStr;
                  clippedLines = new Vector.<DisplayObject>();
                  this.createTextLinesFromTextBlock(staticTextBlock,clippedLines,indicatorBounds);
                  this.releaseLinesFromTextBlock();
                  if(Boolean(clippedLines.length == 1) && Boolean(clippedLines[0].x + clippedLines[0].width <= width))
                  {
                     clippedLines[0].x = line.x;
                     clippedLines[0].y = line.y;
                     textLines[i] = clippedLines[0];
                     break;
                  }
               }
            }
         }
      }
      
      private function computeLastAllowedLineIndex(height:Number, lineCountLimit:int) : int
      {
         var textLine:TextLine = null;
         var truncationLineIndex:int = textLines.length - 1;
         if(truncationLineIndex < 0)
         {
            return truncationLineIndex;
         }
         if(!isNaN(height))
         {
            do
            {
               textLine = TextLine(textLines[truncationLineIndex]);
               if(textLine.y + textLine.descent <= height)
               {
                  break;
               }
               truncationLineIndex--;
            }
            while(truncationLineIndex >= 0);
            
         }
         if(Boolean(lineCountLimit != -1) && Boolean(lineCountLimit <= truncationLineIndex))
         {
            truncationLineIndex = lineCountLimit - 1;
         }
         return truncationLineIndex;
      }
      
      private function getTruncationPosition(line:TextLine, allowedWidth:Number, extraLine:Boolean) : int
      {
         var atomIndex:int = 0;
         var atomBounds:Rectangle = null;
         var consumedWidth:Number = 0;
         var charPosition:int = line.textBlockBeginIndex;
         while(charPosition < line.textBlockBeginIndex + line.rawTextLength)
         {
            atomIndex = line.getAtomIndexAtCharIndex(charPosition);
            if(extraLine)
            {
               if(Boolean(charPosition != line.textBlockBeginIndex) && Boolean(line.getAtomWordBoundaryOnLeft(atomIndex)))
               {
                  break;
               }
            }
            else
            {
               atomBounds = line.getAtomBounds(atomIndex);
               consumedWidth = consumedWidth + atomBounds.width;
               if(consumedWidth > allowedWidth)
               {
                  break;
               }
            }
            charPosition = line.getAtomTextBlockEndIndex(atomIndex);
         }
         line.flushAtomData();
         return charPosition;
      }
      
      private function getNextTruncationPosition(truncationLineIndex:int, truncateAtCharPosition:int) : int
      {
         truncateAtCharPosition--;
         var line:TextLine = TextLine(textLines[truncationLineIndex]);
         while(!(Boolean(truncateAtCharPosition >= line.textBlockBeginIndex) && Boolean(truncateAtCharPosition < line.textBlockBeginIndex + line.rawTextLength)))
         {
            if(truncateAtCharPosition < line.textBlockBeginIndex)
            {
               truncationLineIndex--;
               if(truncationLineIndex < 0)
               {
                  return truncateAtCharPosition;
               }
            }
            else
            {
               truncationLineIndex++;
               if(truncationLineIndex >= textLines.length)
               {
                  return truncateAtCharPosition;
               }
            }
            line = TextLine(textLines[truncationLineIndex]);
            if(false)
            {
               break;
            }
         }
         var atomIndex:int = line.getAtomIndexAtCharIndex(truncateAtCharPosition);
         var nextTruncationPosition:int = line.getAtomTextBlockBeginIndex(atomIndex);
         line.flushAtomData();
         return nextTruncationPosition;
      }
      
      private function releaseLinesFromTextBlock() : void
      {
         var firstLine:TextLine = staticTextBlock.firstLine;
         var lastLine:TextLine = staticTextBlock.lastLine;
         if(firstLine)
         {
            staticTextBlock.releaseLines(firstLine,lastLine);
         }
      }
   }
}
