package spark.components
{
   import spark.components.supportClasses.DropDownListBase;
   import mx.core.mx_internal;
   import spark.components.supportClasses.TextBase;
   import mx.core.UIComponentGlobals;
   import spark.utils.LabelUtil;
   
   use namespace mx_internal;
   
   [IconFile("DropDownList.png")]
   public class DropDownList extends DropDownListBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      [SkinPart(required="false")]
      public var labelDisplay:TextBase;
      
      private var labelChanged:Boolean = false;
      
      private var labelDisplayExplicitWidth:Number;
      
      private var labelDisplayExplicitHeight:Number;
      
      private var sizeSetByTypicalItem:Boolean;
      
      private var _prompt:String = "";
      
      public function DropDownList()
      {
         super();
      }
      
      override public function get baselinePosition() : Number
      {
         return getBaselinePositionForPart(this.labelDisplay);
      }
      
      public function get prompt() : String
      {
         return this._prompt;
      }
      
      public function set prompt(value:String) : void
      {
         if(this._prompt == value)
         {
            return;
         }
         this._prompt = value;
         this.labelChanged = true;
         invalidateProperties();
      }
      
      override public function set typicalItem(value:Object) : void
      {
         super.typicalItem = value;
         invalidateSize();
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(this.labelChanged)
         {
            this.labelChanged = false;
            this.updateLabelDisplay();
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == this.labelDisplay)
         {
            this.labelChanged = true;
            invalidateProperties();
         }
      }
      
      override protected function measure() : void
      {
         if(Boolean(this.labelDisplay) && Boolean(typicalItem != null))
         {
            if(!this.sizeSetByTypicalItem)
            {
               this.labelDisplayExplicitWidth = this.labelDisplay.explicitWidth;
               this.labelDisplayExplicitHeight = this.labelDisplay.explicitHeight;
               this.sizeSetByTypicalItem = true;
            }
            this.labelDisplay.explicitWidth = NaN;
            this.labelDisplay.explicitHeight = NaN;
            this.updateLabelDisplay(typicalItem);
            UIComponentGlobals.layoutManager.validateClient(skin,true);
            this.labelDisplay.width = this.labelDisplay.measuredWidth;
            this.labelDisplay.height = this.labelDisplay.measuredHeight;
            this.updateLabelDisplay();
         }
         else if(Boolean(this.sizeSetByTypicalItem) && Boolean(typicalItem == null))
         {
            this.labelDisplay.width = this.labelDisplayExplicitWidth;
            this.labelDisplay.height = this.labelDisplayExplicitHeight;
            this.sizeSetByTypicalItem = false;
         }
         super.measure();
      }
      
      override mx_internal function updateLabelDisplay(displayItem:* = undefined) : void
      {
         if(this.labelDisplay)
         {
            if(displayItem == undefined)
            {
               displayItem = selectedItem;
            }
            if(Boolean(displayItem != null) && Boolean(displayItem != undefined))
            {
               this.labelDisplay.text = LabelUtil.itemToLabel(displayItem,labelField,labelFunction);
            }
            else
            {
               this.labelDisplay.text = this.prompt;
            }
         }
      }
   }
}
