package org.alivepdf.pages
{
   import org.alivepdf.layout.Size;
   import org.alivepdf.layout.Unit;
   import org.alivepdf.events.PagingEvent;
   import org.alivepdf.layout.Orientation;
   
   public final class Page
   {
       
      private var _width:Number;
      
      private var _height:Number;
      
      private var _fwPt:Number;
      
      private var _fhPt:Number;
      
      private var _wPt:Number;
      
      private var _hPt:Number;
      
      private var _fw:Number;
      
      private var _fh:Number;
      
      private var _w:Number;
      
      private var _h:Number;
      
      private var _rotation:Number;
      
      private var _page:int;
      
      private var _pageTransition:String;
      
      private var _content:String;
      
      private var _annots:String;
      
      private var _orientation:String;
      
      private var _size:Size;
      
      private var _format:Array;
      
      private var _k:Number;
      
      private var _unit:String;
      
      private var _advanceTiming:int;
      
      public function Page(orientation:String, unit:String = "Mm", size:Size = null, rotation:Number = 0)
      {
         super();
         this._orientation = orientation;
         this._rotation = rotation;
         this._unit = this.setUnit(unit);
         if(size == null)
         {
            size = Size.A4;
         }
         this._size = Size.getSize(size).clone();
         if(this._size != null)
         {
            this._format = this._size.dimensions;
            this._fwPt = this._format[0];
            this._fhPt = this._format[1];
            this._fw = this._fwPt / this._k;
            this._fh = this._fhPt / this._k;
            if(this._orientation == Orientation.PORTRAIT)
            {
               this.wPt = this._fwPt;
               this.hPt = this._fhPt;
               this.w = this._fw;
               this.h = this._fh;
               this._width = this.wPt;
               this._height = this.hPt;
            }
            else if(this._orientation == Orientation.LANDSCAPE)
            {
               this.wPt = this._fhPt;
               this.hPt = this._fwPt;
               this.w = this._fh;
               this.h = this._fw;
               this._width = this.wPt;
               this._height = this.hPt;
            }
            else
            {
               throw new RangeError("Incorrect orientation: " + orientation);
            }
            this._annots = new String();
            this._content = new String();
            this.transitions = new String();
            return;
         }
         throw new RangeError("Incorrect dimensions.");
      }
      
      public function get advanceTiming() : int
      {
         return this._advanceTiming;
      }
      
      public function set advanceTiming(value:int) : void
      {
         this._advanceTiming = value;
      }
      
      public function clone() : Page
      {
         var page:Page = new Page(this.orientation,this._unit,this.size,this.rotation);
         page.content = this.content;
         page.transitions = this.transitions;
         return page;
      }
      
      public function get orientation() : String
      {
         return this._orientation;
      }
      
      public function setUnit(unit:String) : String
      {
         if(unit == Unit.POINT)
         {
            this._k = 1;
         }
         else if(unit == Unit.MM)
         {
            this._k = 72 / 25.4;
         }
         else if(unit == Unit.CM)
         {
            this._k = 72 / 2.54;
         }
         else if(unit == Unit.INCHES)
         {
            this._k = 72;
         }
         else
         {
            throw new RangeError("Incorrect unit: " + unit);
         }
         return unit;
      }
      
      public function rotate(rotation:Number) : void
      {
         if(rotation % 90)
         {
            throw new RangeError("Rotation must be a multiple of 90");
         }
         this._rotation = rotation;
      }
      
      private function paging(evt:PagingEvent) : void
      {
         this._page = evt.page;
      }
      
      public function resize(width:Number, height:Number, resolution:Number) : void
      {
         this.width = this._fwPt = this.wPt = width;
         this.height = this._fhPt = this.hPt = height;
         this.w = this.wPt / resolution;
         this.h = this.hPt / resolution;
      }
      
      public function addTransition(style:String = "R", duration:Number = 1, dimension:String = "H", motionDirection:String = "I", transitionDirection:int = 0) : void
      {
         this.transitions = "/Trans << /Type /Trans /D " + duration + " /S /" + style + " /Dm /" + dimension + " /M /" + motionDirection + " /Di /" + transitionDirection + " >>";
      }
      
      public function setAdvanceTiming(timing:int) : void
      {
         this.advanceTiming = timing;
      }
      
      public function set width(width:Number) : void
      {
         this._format[0] = this._width = width;
      }
      
      public function get width() : Number
      {
         return this._width;
      }
      
      public function set height(height:Number) : void
      {
         this._format[1] = this._height = height;
      }
      
      public function get height() : Number
      {
         return this._height;
      }
      
      public function set wPt(wPt:Number) : void
      {
         this._wPt = wPt;
      }
      
      public function get wPt() : Number
      {
         return this._wPt;
      }
      
      public function set hPt(hPt:Number) : void
      {
         this._hPt = hPt;
      }
      
      public function get hPt() : Number
      {
         return this._hPt;
      }
      
      public function set w(w:Number) : void
      {
         this._w = w;
      }
      
      public function get w() : Number
      {
         return this._w;
      }
      
      public function set h(h:Number) : void
      {
         this._h = h;
      }
      
      public function get h() : Number
      {
         return this._h;
      }
      
      public function get size() : Size
      {
         return this._size;
      }
      
      public function set size(size:Size) : void
      {
         this._size = size;
      }
      
      public function set rotation(rotation:Number) : void
      {
         this._rotation = rotation;
      }
      
      public function get rotation() : Number
      {
         return this._rotation;
      }
      
      public function get number() : uint
      {
         return this._page;
      }
      
      public function set number(num:uint) : void
      {
         this._page = num;
      }
      
      public function set content(content:String) : void
      {
         this._content = content;
      }
      
      public function get content() : String
      {
         return this._content;
      }
      
      public function get transitions() : String
      {
         return this._pageTransition;
      }
      
      public function set transitions(transition:String) : void
      {
         this._pageTransition = transition;
      }
      
      public function get annotations() : String
      {
         return this._annots;
      }
      
      public function set annotations(annotation:String) : void
      {
         this._annots = annotation;
      }
      
      public function toString() : String
      {
         return "[Page orientation=" + this._orientation + " number=" + this.number + " width=" + (this.w >> 0) + " height=" + (this.h >> 0) + "]";
      }
   }
}
