package org.alivepdf.data
{
   import org.alivepdf.colors.IColor;
   import org.alivepdf.serializer.ISerializer;
   import flash.utils.ByteArray;
   import org.alivepdf.export.Export;
   import org.alivepdf.export.CSVExport;
   
   public class Grid
   {
       
      private var _data:Array;
      
      private var _width:Number;
      
      private var _height:Number;
      
      private var _x:int;
      
      private var _y:int;
      
      private var _columns:Array;
      
      private var _borderColor:IColor;
      
      private var _borderAlpha:Number;
      
      private var _joints:String;
      
      private var _backgroundColor:IColor;
      
      private var _headerColor:IColor;
      
      private var _cellColor:IColor;
      
      private var _alternateRowColor:Boolean;
      
      private var _serializer:ISerializer;
      
      public function Grid(data:Array, width:Number, height:Number, headerColor:IColor, cellColor:IColor, alternateRowColor:Boolean, borderColor:IColor, borderAlpha:Number = 1, joints:String = "0 j", columns:Array = null)
      {
         super();
         this._data = data;
         this._width = width;
         this._height = height;
         this._borderColor = borderColor;
         this._borderAlpha = borderAlpha;
         this._joints = joints;
         this._headerColor = headerColor;
         this._cellColor = cellColor;
         this._alternateRowColor = alternateRowColor;
         if(columns != null)
         {
            this.columns = columns;
         }
      }
      
      public function export(type:String = "csv") : ByteArray
      {
         if(type == Export.CSV)
         {
            this._serializer = new CSVExport(this._data,this._columns);
         }
         return this._serializer.serialize();
      }
      
      public function get columns() : Array
      {
         return this._columns;
      }
      
      public function set columns(columns:Array) : void
      {
         this._columns = columns;
      }
      
      public function get width() : Number
      {
         return this._width;
      }
      
      public function get height() : Number
      {
         return this._height;
      }
      
      public function get x() : int
      {
         return this._x;
      }
      
      public function get y() : int
      {
         return this._y;
      }
      
      public function set x(x:int) : void
      {
         this._x = x;
      }
      
      public function set y(y:int) : void
      {
         this._y = y;
      }
      
      public function get borderColor() : IColor
      {
         return this._borderColor;
      }
      
      public function get borderAlpha() : Number
      {
         return this._borderAlpha;
      }
      
      public function get joints() : String
      {
         return this._joints;
      }
      
      public function get headerColor() : IColor
      {
         return this._headerColor;
      }
      
      public function get cellColor() : IColor
      {
         return this._cellColor;
      }
      
      public function get alternateRowColor() : Boolean
      {
         return this._alternateRowColor;
      }
      
      public function get dataProvider() : Array
      {
         return this._data;
      }
      
      public function toString() : String
      {
         return "[Grid cells=" + this._data.length + " alternateRowColor=" + this._alternateRowColor + " x=" + this.x + " y=" + this.y + "]";
      }
   }
}
