package mx.styles
{
   import mx.core.mx_internal;
   import flash.display.DisplayObject;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class CSSMergedStyleDeclaration extends mx.styles.CSSStyleDeclaration
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var style:mx.styles.CSSStyleDeclaration;
      
      private var parentStyle:mx.styles.CSSStyleDeclaration;
      
      private var updateOverrides:Boolean;
      
      private var _defaultFactory:Function;
      
      private var _factory:Function;
      
      public function CSSMergedStyleDeclaration(style:mx.styles.CSSStyleDeclaration, parentStyle:mx.styles.CSSStyleDeclaration, selector:Object = null, styleManager:IStyleManager2 = null, setSelector:Boolean = false)
      {
         var i:uint = 0;
         var n:uint = 0;
         var effectsArray:Array = null;
         super(selector,styleManager,setSelector);
         this.style = style;
         this.parentStyle = parentStyle;
         if(Boolean(style) && Boolean(style.effects))
         {
            effects = [];
            effectsArray = style.effects;
            n = effectsArray.length;
            for(i = 0; i < n; i++)
            {
               effects[i] = effectsArray[i];
            }
         }
         if(Boolean(parentStyle) && Boolean(parentStyle.effects))
         {
            if(!effects)
            {
               effects = [];
            }
            effectsArray = parentStyle.effects;
            n = effectsArray.length;
            for(i = 0; i < n; i++)
            {
               effects[i] = effectsArray[i];
               if(effects.indexOf(effectsArray[i]) == -1)
               {
                  effects[i] = effectsArray[i];
               }
            }
         }
         this.updateOverrides = true;
      }
      
      [Inspectable(environment="none")]
      override public function get defaultFactory() : Function
      {
         if(this._defaultFactory != null)
         {
            return this._defaultFactory;
         }
         if(Boolean(this.style != null) && Boolean(this.style.defaultFactory != null) || Boolean(this.parentStyle != null) && Boolean(this.parentStyle.defaultFactory != null))
         {
            this._defaultFactory = function():void
            {
               if(Boolean(parentStyle) && Boolean(parentStyle.defaultFactory != null))
               {
                  parentStyle.defaultFactory.apply(this);
               }
               if(Boolean(style) && Boolean(style.defaultFactory != null))
               {
                  style.defaultFactory.apply(this);
               }
            };
         }
         return this._defaultFactory;
      }
      
      override public function set defaultFactory(f:Function) : void
      {
      }
      
      [Inspectable(environment="none")]
      override public function get factory() : Function
      {
         if(this._factory != null)
         {
            return this._factory;
         }
         if(Boolean(this.style != null) && Boolean(this.style.factory != null) || Boolean(this.parentStyle != null) && Boolean(this.parentStyle.factory != null))
         {
            this._factory = function():void
            {
               if(Boolean(parentStyle) && Boolean(parentStyle.factory != null))
               {
                  parentStyle.factory.apply(this);
               }
               if(Boolean(style) && Boolean(style.factory != null))
               {
                  style.factory.apply(this);
               }
            };
         }
         return this._factory;
      }
      
      override public function set factory(f:Function) : void
      {
      }
      
      override public function get overrides() : Object
      {
         var obj:* = null;
         var childOverrides:Object = null;
         var parentOverrides:Object = null;
         if(!this.updateOverrides)
         {
            return super.overrides;
         }
         var mergedOverrides:Object = null;
         if(Boolean(this.style) && Boolean(this.style.overrides))
         {
            mergedOverrides = [];
            childOverrides = this.style.overrides;
            for(obj in childOverrides)
            {
               mergedOverrides[obj] = childOverrides[obj];
            }
         }
         if(Boolean(this.parentStyle) && Boolean(this.parentStyle.overrides))
         {
            if(!mergedOverrides)
            {
               mergedOverrides = [];
            }
            parentOverrides = this.parentStyle.overrides;
            for(obj in parentOverrides)
            {
               if(mergedOverrides[obj] === undefined)
               {
                  mergedOverrides[obj] = parentOverrides[obj];
               }
            }
         }
         super.overrides = mergedOverrides;
         this.updateOverrides = false;
         return mergedOverrides;
      }
      
      override public function set overrides(o:Object) : void
      {
      }
      
      override public function setStyle(styleProp:String, newValue:*) : void
      {
      }
      
      override mx_internal function addStyleToProtoChain(chain:Object, target:DisplayObject, filterMap:Object = null) : Object
      {
         if(this.style)
         {
            return this.style.addStyleToProtoChain(chain,target,filterMap);
         }
         if(this.parentStyle)
         {
            return this.parentStyle.addStyleToProtoChain(chain,target,filterMap);
         }
         return chain;
      }
   }
}
