package mx.effects
{
   import mx.core.mx_internal;
   import mx.effects.effectClasses.ZoomInstance;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.effects.Scale",since="4.0")]
   public class Zoom extends TweenEffect
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var AFFECTED_PROPERTIES:Array = ["scaleX","scaleY","x","y","width","height"];
       
      [Inspectable(defaultValue="false",category="Other")]
      public var captureRollEvents:Boolean;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var originX:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var originY:Number;
      
      [Inspectable(defaultValue="0.01",category="General")]
      public var zoomHeightFrom:Number;
      
      [Inspectable(defaultValue="1",category="General")]
      public var zoomHeightTo:Number;
      
      [Inspectable(defaultValue="0.01",category="General")]
      public var zoomWidthFrom:Number;
      
      [Inspectable(defaultValue="1",category="General")]
      public var zoomWidthTo:Number;
      
      public function Zoom(target:Object = null)
      {
         super(target);
         instanceClass = ZoomInstance;
         applyActualDimensions = false;
         relevantProperties = ["scaleX","scaleY","width","height","visible"];
      }
      
      override public function getAffectedProperties() : Array
      {
         return AFFECTED_PROPERTIES;
      }
      
      override protected function initInstance(instance:IEffectInstance) : void
      {
         var zoomInstance:ZoomInstance = null;
         super.initInstance(instance);
         zoomInstance = ZoomInstance(instance);
         zoomInstance.zoomWidthFrom = this.zoomWidthFrom;
         zoomInstance.zoomWidthTo = this.zoomWidthTo;
         zoomInstance.zoomHeightFrom = this.zoomHeightFrom;
         zoomInstance.zoomHeightTo = this.zoomHeightTo;
         zoomInstance.originX = this.originX;
         zoomInstance.originY = this.originY;
         zoomInstance.captureRollEvents = this.captureRollEvents;
      }
   }
}
