package mx.core
{
   import mx.automation.IAutomationObject;
   import mx.styles.ISimpleStyleClient;
   import mx.managers.IToolTipManagerClient;
   import flash.text.TextFormat;
   import mx.resources.IResourceManager;
   import flash.display.DisplayObjectContainer;
   import flash.text.TextLineMetrics;
   import mx.utils.NameUtil;
   import flash.text.TextFieldType;
   import flash.display.Sprite;
   import flash.geom.Matrix;
   import mx.styles.StyleProtoChain;
   import mx.styles.IStyleManager2;
   import mx.styles.StyleManager;
   import mx.managers.ISystemManager;
   import flash.display.DisplayObject;
   import mx.managers.ToolTipManager;
   import flash.events.Event;
   import mx.styles.IStyleClient;
   import mx.managers.SystemManager;
   import flash.text.TextFormatAlign;
   import mx.utils.StringUtil;
   import mx.resources.ResourceManager;
   
   use namespace mx_internal;
   
   [ResourceBundle("core")]
   [Style(inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="no",name="textFieldClass",type="Class")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="left,center,right")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="letterSpacing",type="Number")]
   [Style(inherit="yes",name="kerning",type="Boolean")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontThickness",type="Number")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontSharpness",type="Number")]
   [Style(inherit="yes",name="fontGridFitType",type="String",enumeration="none,pixel,subpixel")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="fontAntiAliasType",type="String",enumeration="normal,advanced")]
   [Style(inherit="yes",name="disabledColor",format="Color",type="uint")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl,inherit")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="no",name="paddingRight",format="Length",type="Number")]
   [Style(inherit="no",name="paddingLeft",format="Length",type="Number")]
   [Style(inherit="yes",name="leading",format="Length",type="Number")]
   public class UITextField extends FlexTextField implements IAutomationObject, IIMESupport, IFlexModule, IInvalidating, ISimpleStyleClient, IToolTipManagerClient, IUITextField
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static const TEXT_WIDTH_PADDING:int = 5;
      
      mx_internal static const TEXT_HEIGHT_PADDING:int = 4;
      
      private static var truncationIndicatorResource:String;
      
      mx_internal static var debuggingBorders:Boolean = false;
      
      private static var noEmbeddedFonts:Boolean;
      
      private static var _embeddedFontRegistry:mx.core.IEmbeddedFontRegistry;
       
      private var cachedTextFormat:TextFormat;
      
      private var invalidateDisplayListFlag:Boolean = true;
      
      mx_internal var styleChangedFlag:Boolean = true;
      
      private var explicitHTMLText:String = null;
      
      mx_internal var explicitColor:uint = 4.294967295E9;
      
      private var resourceManager:IResourceManager;
      
      private var untruncatedText:String;
      
      private var mirror:Boolean = false;
      
      private var _x:Number = 0;
      
      mx_internal var _parent:DisplayObjectContainer;
      
      private var _automationDelegate:IAutomationObject;
      
      private var _automationName:String;
      
      private var _document:Object;
      
      private var _enabled:Boolean = true;
      
      private var _explicitHeight:Number;
      
      private var _explicitWidth:Number;
      
      private var _ignorePadding:Boolean = true;
      
      private var _imeMode:String = null;
      
      private var _includeInLayout:Boolean = true;
      
      private var _inheritingStyles:Object;
      
      private var _initialized:Boolean = false;
      
      private var _moduleFactory:mx.core.IFlexModuleFactory;
      
      private var _nestLevel:int = 0;
      
      private var _nonInheritingStyles:Object;
      
      private var _processedDescriptors:Boolean = true;
      
      private var _styleName:Object;
      
      mx_internal var _toolTip:String;
      
      private var _updateCompletePendingFlag:Boolean = false;
      
      private var _owner:DisplayObjectContainer;
      
      public function UITextField()
      {
         this.resourceManager = ResourceManager.getInstance();
         this._inheritingStyles = StyleProtoChain.STYLE_UNINITIALIZED;
         this._nonInheritingStyles = StyleProtoChain.STYLE_UNINITIALIZED;
         super();
         super.text = "";
         focusRect = false;
         selectable = false;
         tabEnabled = false;
         if(debuggingBorders)
         {
            border = true;
         }
         if(!truncationIndicatorResource)
         {
            truncationIndicatorResource = this.resourceManager.getString("core","truncationIndicator");
         }
         addEventListener(Event.CHANGE,this.changeHandler);
         addEventListener("textFieldStyleChange",this.textFieldStyleChangeHandler);
         this.resourceManager.addEventListener(Event.CHANGE,this.resourceManager_changeHandler,false,0,true);
      }
      
      private static function get embeddedFontRegistry() : mx.core.IEmbeddedFontRegistry
      {
         if(Boolean(!_embeddedFontRegistry) && Boolean(!noEmbeddedFonts))
         {
            try
            {
               _embeddedFontRegistry = IEmbeddedFontRegistry(Singleton.getInstance("mx.core::IEmbeddedFontRegistry"));
            }
            catch(e:Error)
            {
               noEmbeddedFonts = true;
            }
         }
         return _embeddedFontRegistry;
      }
      
      override public function set x(value:Number) : void
      {
         this._x = value;
         super.x = value;
         if(this.mirror)
         {
            this.validateTransformMatrix();
         }
      }
      
      override public function get x() : Number
      {
         return !!this.mirror?Number(this._x):Number(super.x);
      }
      
      override public function set width(value:Number) : void
      {
         super.width = value;
         if(this.mirror)
         {
            this.validateTransformMatrix();
         }
      }
      
      override public function set htmlText(value:String) : void
      {
         if(!value)
         {
            value = "";
         }
         if(Boolean(this.isHTML) && Boolean(super.htmlText == value))
         {
            return;
         }
         if(Boolean(this.cachedTextFormat) && Boolean(styleSheet == null))
         {
            defaultTextFormat = this.cachedTextFormat;
         }
         super.htmlText = value;
         this.explicitHTMLText = value;
         if(this.invalidateDisplayListFlag)
         {
            this.validateNow();
         }
      }
      
      override public function get parent() : DisplayObjectContainer
      {
         return Boolean(this._parent)?this._parent:super.parent;
      }
      
      override public function set text(value:String) : void
      {
         if(!value)
         {
            value = "";
         }
         if(Boolean(!this.isHTML) && Boolean(super.text == value))
         {
            return;
         }
         super.text = value;
         this.explicitHTMLText = null;
         if(this.invalidateDisplayListFlag)
         {
            this.validateNow();
         }
      }
      
      override public function set textColor(value:uint) : void
      {
         this.setColor(value);
      }
      
      public function get automationDelegate() : Object
      {
         return this._automationDelegate;
      }
      
      public function set automationDelegate(value:Object) : void
      {
         this._automationDelegate = value as IAutomationObject;
      }
      
      public function get automationName() : String
      {
         if(this._automationName)
         {
            return this._automationName;
         }
         if(this.automationDelegate)
         {
            return this.automationDelegate.automationName;
         }
         return "";
      }
      
      public function set automationName(value:String) : void
      {
         this._automationName = value;
      }
      
      public function get automationValue() : Array
      {
         if(this.automationDelegate)
         {
            return this.automationDelegate.automationValue;
         }
         return [""];
      }
      
      public function get automationOwner() : DisplayObjectContainer
      {
         return this.owner;
      }
      
      public function get automationParent() : DisplayObjectContainer
      {
         return this.parent;
      }
      
      public function get automationEnabled() : Boolean
      {
         return this.enabled;
      }
      
      public function get automationVisible() : Boolean
      {
         return visible;
      }
      
      public function get baselinePosition() : Number
      {
         var tlm:TextLineMetrics = null;
         if(!this.parent)
         {
            return NaN;
         }
         var isEmpty:Boolean = text == "";
         if(isEmpty)
         {
            super.text = "Wj";
         }
         tlm = getLineMetrics(0);
         if(isEmpty)
         {
            super.text = "";
         }
         return 2 + tlm.ascent;
      }
      
      public function get className() : String
      {
         return NameUtil.getUnqualifiedClassName(this);
      }
      
      public function get document() : Object
      {
         return this._document;
      }
      
      public function set document(value:Object) : void
      {
         this._document = value;
      }
      
      public function get enableIME() : Boolean
      {
         return type == TextFieldType.INPUT;
      }
      
      public function get enabled() : Boolean
      {
         return this._enabled;
      }
      
      public function set enabled(value:Boolean) : void
      {
         mouseEnabled = value;
         this._enabled = value;
         this.styleChanged("color");
      }
      
      public function get explicitHeight() : Number
      {
         return this._explicitHeight;
      }
      
      public function set explicitHeight(value:Number) : void
      {
         this._explicitHeight = value;
      }
      
      public function get explicitMaxHeight() : Number
      {
         return NaN;
      }
      
      public function get explicitMaxWidth() : Number
      {
         return NaN;
      }
      
      public function get explicitMinHeight() : Number
      {
         return NaN;
      }
      
      public function get explicitMinWidth() : Number
      {
         return NaN;
      }
      
      public function get explicitWidth() : Number
      {
         return this._explicitWidth;
      }
      
      public function set explicitWidth(value:Number) : void
      {
         this._explicitWidth = value;
      }
      
      public function get focusPane() : Sprite
      {
         return null;
      }
      
      public function set focusPane(value:Sprite) : void
      {
      }
      
      public function get ignorePadding() : Boolean
      {
         return this._ignorePadding;
      }
      
      public function set ignorePadding(value:Boolean) : void
      {
         this._ignorePadding = value;
         this.styleChanged(null);
      }
      
      public function get imeMode() : String
      {
         return this._imeMode;
      }
      
      public function set imeMode(value:String) : void
      {
         this._imeMode = value;
      }
      
      public function get includeInLayout() : Boolean
      {
         return this._includeInLayout;
      }
      
      public function set includeInLayout(value:Boolean) : void
      {
         var p:IInvalidating = null;
         if(this._includeInLayout != value)
         {
            this._includeInLayout = value;
            p = this.parent as IInvalidating;
            if(p)
            {
               p.invalidateSize();
               p.invalidateDisplayList();
            }
         }
      }
      
      public function get inheritingStyles() : Object
      {
         return this._inheritingStyles;
      }
      
      public function set inheritingStyles(value:Object) : void
      {
         this._inheritingStyles = value;
      }
      
      public function get initialized() : Boolean
      {
         return this._initialized;
      }
      
      public function set initialized(value:Boolean) : void
      {
         this._initialized = value;
      }
      
      private function get isHTML() : Boolean
      {
         return this.explicitHTMLText != null;
      }
      
      public function get isPopUp() : Boolean
      {
         return false;
      }
      
      public function set isPopUp(value:Boolean) : void
      {
      }
      
      public function get maxHeight() : Number
      {
         return UIComponent.DEFAULT_MAX_HEIGHT;
      }
      
      public function get maxWidth() : Number
      {
         return UIComponent.DEFAULT_MAX_WIDTH;
      }
      
      public function get measuredHeight() : Number
      {
         this.validateNow();
         if(Boolean(!stage) || Boolean(embedFonts))
         {
            return this.textHeight + TEXT_HEIGHT_PADDING;
         }
         var m:Matrix = transform.concatenatedMatrix;
         return Math.abs(this.textHeight * m.a / m.d) + TEXT_HEIGHT_PADDING;
      }
      
      public function get measuredMinHeight() : Number
      {
         return 0;
      }
      
      public function set measuredMinHeight(value:Number) : void
      {
      }
      
      public function get measuredMinWidth() : Number
      {
         return 0;
      }
      
      public function set measuredMinWidth(value:Number) : void
      {
      }
      
      public function get measuredWidth() : Number
      {
         this.validateNow();
         if(Boolean(!stage) || Boolean(embedFonts))
         {
            return textWidth + TEXT_WIDTH_PADDING;
         }
         var m:Matrix = transform.concatenatedMatrix;
         return Math.abs(textWidth * m.a / m.d) + TEXT_WIDTH_PADDING;
      }
      
      public function get minHeight() : Number
      {
         return 0;
      }
      
      public function get minWidth() : Number
      {
         return 0;
      }
      
      [Inspectable(environment="none")]
      public function get moduleFactory() : mx.core.IFlexModuleFactory
      {
         return this._moduleFactory;
      }
      
      public function set moduleFactory(factory:mx.core.IFlexModuleFactory) : void
      {
         this._moduleFactory = factory;
      }
      
      public function get nestLevel() : int
      {
         return this._nestLevel;
      }
      
      public function set nestLevel(value:int) : void
      {
         if(Boolean(value > 1) && Boolean(this._nestLevel != value))
         {
            this._nestLevel = value;
            StyleProtoChain.initTextField(this);
            this.styleChangedFlag = true;
            this.validateNow();
         }
      }
      
      public function get nonInheritingStyles() : Object
      {
         return this._nonInheritingStyles;
      }
      
      public function set nonInheritingStyles(value:Object) : void
      {
         this._nonInheritingStyles = value;
      }
      
      public function get percentHeight() : Number
      {
         return NaN;
      }
      
      public function set percentHeight(value:Number) : void
      {
      }
      
      public function get percentWidth() : Number
      {
         return NaN;
      }
      
      public function set percentWidth(value:Number) : void
      {
      }
      
      public function get processedDescriptors() : Boolean
      {
         return this._processedDescriptors;
      }
      
      public function set processedDescriptors(value:Boolean) : void
      {
         this._processedDescriptors = value;
      }
      
      public function get styleManager() : IStyleManager2
      {
         return StyleManager.getStyleManager(this.moduleFactory);
      }
      
      public function get styleName() : Object
      {
         return this._styleName;
      }
      
      public function set styleName(value:Object) : void
      {
         if(this._styleName === value)
         {
            return;
         }
         this._styleName = value;
         if(this.parent)
         {
            StyleProtoChain.initTextField(this);
            this.styleChanged("styleName");
         }
      }
      
      public function get systemManager() : ISystemManager
      {
         var ui:IUIComponent = null;
         var o:DisplayObject = this.parent;
         while(o)
         {
            ui = o as IUIComponent;
            if(ui)
            {
               return ui.systemManager;
            }
            o = o.parent;
         }
         return null;
      }
      
      public function set systemManager(value:ISystemManager) : void
      {
      }
      
      public function get nonZeroTextHeight() : Number
      {
         var result:Number = NaN;
         if(super.text == "")
         {
            super.text = "Wj";
            result = this.textHeight;
            super.text = "";
            return result;
         }
         return this.textHeight;
      }
      
      override public function get textHeight() : Number
      {
         var result:Number = super.textHeight;
         if(numLines > 1)
         {
            result = result + getLineMetrics(1).leading;
         }
         return result;
      }
      
      public function get toolTip() : String
      {
         return this._toolTip;
      }
      
      public function set toolTip(value:String) : void
      {
         var oldValue:String = this._toolTip;
         this._toolTip = value;
         ToolTipManager.registerToolTip(this,oldValue,value);
      }
      
      public function get tweeningProperties() : Array
      {
         return null;
      }
      
      public function set tweeningProperties(value:Array) : void
      {
      }
      
      public function get updateCompletePendingFlag() : Boolean
      {
         return this._updateCompletePendingFlag;
      }
      
      public function set updateCompletePendingFlag(value:Boolean) : void
      {
         this._updateCompletePendingFlag = value;
      }
      
      override public function setTextFormat(format:TextFormat, beginIndex:int = -1, endIndex:int = -1) : void
      {
         if(styleSheet)
         {
            return;
         }
         super.setTextFormat(format,beginIndex,endIndex);
         dispatchEvent(new Event("textFormatChange"));
      }
      
      override public function insertXMLText(beginIndex:int, endIndex:int, richText:String, pasting:Boolean = false) : void
      {
         super.insertXMLText(beginIndex,endIndex,richText,pasting);
         dispatchEvent(new Event("textInsert"));
      }
      
      override public function replaceText(beginIndex:int, endIndex:int, newText:String) : void
      {
         super.replaceText(beginIndex,endIndex,newText);
         dispatchEvent(new Event("textReplace"));
      }
      
      public function initialize() : void
      {
      }
      
      public function getExplicitOrMeasuredWidth() : Number
      {
         return !isNaN(this.explicitWidth)?Number(this.explicitWidth):Number(this.measuredWidth);
      }
      
      public function getExplicitOrMeasuredHeight() : Number
      {
         return !isNaN(this.explicitHeight)?Number(this.explicitHeight):Number(this.measuredHeight);
      }
      
      public function setVisible(visible:Boolean, noEvent:Boolean = false) : void
      {
         this.visible = visible;
      }
      
      public function setFocus() : void
      {
         this.systemManager.stage.focus = this;
      }
      
      public function getUITextFormat() : UITextFormat
      {
         this.validateNow();
         var textFormat:UITextFormat = new UITextFormat(this.creatingSystemManager());
         textFormat.moduleFactory = this.moduleFactory;
         textFormat.copyFrom(getTextFormat());
         textFormat.antiAliasType = antiAliasType;
         textFormat.gridFitType = gridFitType;
         textFormat.sharpness = sharpness;
         textFormat.thickness = thickness;
         return textFormat;
      }
      
      public function move(x:Number, y:Number) : void
      {
         if(this.x != x)
         {
            this.x = x;
         }
         if(this.y != y)
         {
            this.y = y;
         }
      }
      
      public function setActualSize(w:Number, h:Number) : void
      {
         if(width != w)
         {
            this.width = w;
         }
         if(height != h)
         {
            height = h;
         }
      }
      
      public function getStyle(styleProp:String) : *
      {
         if(this.styleManager.inheritingStyles[styleProp])
         {
            return Boolean(this.inheritingStyles)?this.inheritingStyles[styleProp]:IStyleClient(this.parent).getStyle(styleProp);
         }
         return Boolean(this.nonInheritingStyles)?this.nonInheritingStyles[styleProp]:IStyleClient(this.parent).getStyle(styleProp);
      }
      
      public function setStyle(styleProp:String, value:*) : void
      {
      }
      
      public function parentChanged(p:DisplayObjectContainer) : void
      {
         if(!p)
         {
            this._parent = null;
            this._nestLevel = 0;
         }
         else if(p is IStyleClient)
         {
            this._parent = p;
         }
         else if(p is SystemManager)
         {
            this._parent = p;
         }
         else
         {
            this._parent = p.parent;
         }
      }
      
      public function styleChanged(styleProp:String) : void
      {
         this.styleChangedFlag = true;
         if(!this.invalidateDisplayListFlag)
         {
            this.invalidateDisplayListFlag = true;
            if("callLater" in this.parent)
            {
               Object(this.parent).callLater(this.validateNow);
            }
         }
      }
      
      public function validateNow() : void
      {
         var oldMirror:Boolean = false;
         var textFormat:TextFormat = null;
         var fontModuleFactory:mx.core.IFlexModuleFactory = null;
         if(!this.parent)
         {
            return;
         }
         if(Boolean(!isNaN(this.explicitWidth)) && Boolean(super.width != this.explicitWidth))
         {
            this.width = this.explicitWidth > 4?Number(this.explicitWidth):Number(4);
         }
         if(Boolean(!isNaN(this.explicitHeight)) && Boolean(super.height != this.explicitHeight))
         {
            super.height = this.explicitHeight;
         }
         if(this.styleChangedFlag)
         {
            oldMirror = this.mirror;
            this.mirror = this.getStyle("layoutDirection") == LayoutDirection.RTL;
            if(Boolean(this.mirror) || Boolean(oldMirror))
            {
               this.validateTransformMatrix();
            }
         }
         if(this.styleChangedFlag)
         {
            textFormat = this.getTextStyles();
            if(textFormat.font)
            {
               fontModuleFactory = Boolean(noEmbeddedFonts) || Boolean(!embeddedFontRegistry)?null:embeddedFontRegistry.getAssociatedModuleFactory(textFormat.font,textFormat.bold,textFormat.italic,this,this.moduleFactory,this.creatingSystemManager(),false);
               embedFonts = fontModuleFactory != null;
            }
            else
            {
               embedFonts = this.getStyle("embedFonts");
            }
            if(this.getStyle("fontAntiAliasType") != undefined)
            {
               antiAliasType = this.getStyle("fontAntiAliasType");
               gridFitType = this.getStyle("fontGridFitType");
               sharpness = this.getStyle("fontSharpness");
               thickness = this.getStyle("fontThickness");
            }
            if(!styleSheet)
            {
               super.setTextFormat(textFormat);
               defaultTextFormat = textFormat;
            }
            dispatchEvent(new Event("textFieldStyleChange"));
         }
         this.styleChangedFlag = false;
         this.invalidateDisplayListFlag = false;
      }
      
      private function validateTransformMatrix() : void
      {
         var mirrorMatrix:Matrix = null;
         var defaultMatrix:Matrix = null;
         if(this.mirror)
         {
            mirrorMatrix = this.transform.matrix;
            mirrorMatrix.a = -1;
            mirrorMatrix.tx = this._x + width;
            transform.matrix = mirrorMatrix;
         }
         else
         {
            defaultMatrix = new Matrix();
            defaultMatrix.tx = this._x;
            defaultMatrix.ty = y;
            transform.matrix = defaultMatrix;
         }
      }
      
      public function getTextStyles() : TextFormat
      {
         var textFormat:TextFormat = new TextFormat();
         var textAlign:String = this.getStyle("textAlign");
         var direction:String = this.getStyle("direction");
         if(textAlign == "start")
         {
            textAlign = direction == "ltr"?TextFormatAlign.LEFT:TextFormatAlign.RIGHT;
         }
         else if(textAlign == "end")
         {
            textAlign = direction == "ltr"?TextFormatAlign.RIGHT:TextFormatAlign.LEFT;
         }
         else if(Boolean(textAlign == "justify") && Boolean(direction == "rtl"))
         {
            textAlign = TextFormatAlign.RIGHT;
         }
         textFormat.align = textAlign;
         textFormat.bold = this.getStyle("fontWeight") == "bold";
         if(this.enabled)
         {
            if(this.explicitColor == StyleManager.NOT_A_COLOR)
            {
               textFormat.color = this.getStyle("color");
            }
            else
            {
               textFormat.color = this.explicitColor;
            }
         }
         else
         {
            textFormat.color = this.getStyle("disabledColor");
         }
         textFormat.font = StringUtil.trimArrayElements(this.getStyle("fontFamily"),",");
         textFormat.indent = this.getStyle("textIndent");
         textFormat.italic = this.getStyle("fontStyle") == "italic";
         var kerning:* = this.getStyle("kerning");
         if(Boolean(kerning == "auto") || Boolean(kerning == "on"))
         {
            kerning = true;
         }
         else if(Boolean(kerning == "default") || Boolean(kerning == "off"))
         {
            kerning = false;
         }
         textFormat.kerning = kerning;
         textFormat.leading = this.getStyle("leading");
         textFormat.leftMargin = !!this.ignorePadding?0:this.getStyle("paddingLeft");
         textFormat.letterSpacing = this.getStyle("letterSpacing");
         textFormat.rightMargin = !!this.ignorePadding?0:this.getStyle("paddingRight");
         textFormat.size = this.getStyle("fontSize");
         textFormat.underline = this.getStyle("textDecoration") == "underline";
         this.cachedTextFormat = textFormat;
         return textFormat;
      }
      
      public function setColor(color:uint) : void
      {
         this.explicitColor = color;
         this.styleChangedFlag = true;
         this.invalidateDisplayListFlag = true;
         this.validateNow();
      }
      
      public function invalidateSize() : void
      {
         this.invalidateDisplayListFlag = true;
      }
      
      public function invalidateDisplayList() : void
      {
         this.invalidateDisplayListFlag = true;
      }
      
      public function invalidateProperties() : void
      {
      }
      
      public function truncateToFit(truncationIndicator:String = null) : Boolean
      {
         var s:String = null;
         if(!truncationIndicator)
         {
            truncationIndicator = truncationIndicatorResource;
         }
         this.validateNow();
         var originalText:String = super.text;
         this.untruncatedText = originalText;
         var w:Number = width;
         if(Boolean(originalText != "") && Boolean(textWidth + TEXT_WIDTH_PADDING > w + 1.0e-14))
         {
            s = super.text = originalText;
            originalText.slice(0,Math.floor(w / (textWidth + TEXT_WIDTH_PADDING) * originalText.length));
            while(Boolean(s.length > 1) && Boolean(textWidth + TEXT_WIDTH_PADDING > w))
            {
               s = s.slice(0,-1);
               super.text = s + truncationIndicator;
            }
            return true;
         }
         return false;
      }
      
      private function changeHandler(event:Event) : void
      {
         this.explicitHTMLText = null;
      }
      
      private function textFieldStyleChangeHandler(event:Event) : void
      {
         if(this.explicitHTMLText != null)
         {
            super.htmlText = this.explicitHTMLText;
         }
      }
      
      private function resourceManager_changeHandler(event:Event) : void
      {
         truncationIndicatorResource = this.resourceManager.getString("core","truncationIndicator");
         if(this.untruncatedText != null)
         {
            super.text = this.untruncatedText;
            this.truncateToFit();
         }
      }
      
      public function owns(child:DisplayObject) : Boolean
      {
         return child == this;
      }
      
      public function get owner() : DisplayObjectContainer
      {
         return Boolean(this._owner)?this._owner:this.parent;
      }
      
      public function set owner(value:DisplayObjectContainer) : void
      {
         this._owner = value;
      }
      
      private function creatingSystemManager() : ISystemManager
      {
         return Boolean(this.moduleFactory != null) && Boolean(this.moduleFactory is ISystemManager)?ISystemManager(this.moduleFactory):this.systemManager;
      }
      
      public function replayAutomatableEvent(event:Event) : Boolean
      {
         if(this.automationDelegate)
         {
            return this.automationDelegate.replayAutomatableEvent(event);
         }
         return false;
      }
      
      public function createAutomationIDPart(child:IAutomationObject) : Object
      {
         return null;
      }
      
      public function createAutomationIDPartWithRequiredProperties(child:IAutomationObject, properties:Array) : Object
      {
         return null;
      }
      
      public function resolveAutomationIDPart(criteria:Object) : Array
      {
         return [];
      }
      
      public function getAutomationChildAt(index:int) : IAutomationObject
      {
         return null;
      }
      
      public function getAutomationChildren() : Array
      {
         return null;
      }
      
      public function get numAutomationChildren() : int
      {
         return 0;
      }
      
      public function get showInAutomationHierarchy() : Boolean
      {
         return true;
      }
      
      public function set showInAutomationHierarchy(value:Boolean) : void
      {
      }
      
      public function get automationTabularData() : Object
      {
         return null;
      }
   }
}
