package mx.core
{
   use namespace mx_internal;
   
   public class DragSource
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var dataHolder:Object;
      
      private var formatHandlers:Object;
      
      private var _formats:Array;
      
      public function DragSource()
      {
         this.dataHolder = {};
         this.formatHandlers = {};
         this._formats = [];
         super();
      }
      
      public function get formats() : Array
      {
         return this._formats;
      }
      
      public function addData(data:Object, format:String) : void
      {
         this._formats.push(format);
         this.dataHolder[format] = data;
      }
      
      public function addHandler(handler:Function, format:String) : void
      {
         this._formats.push(format);
         this.formatHandlers[format] = handler;
      }
      
      public function dataForFormat(format:String) : Object
      {
         var data:Object = this.dataHolder[format];
         if(data)
         {
            return data;
         }
         if(this.formatHandlers[format])
         {
            return this.formatHandlers[format]();
         }
         return null;
      }
      
      public function hasFormat(format:String) : Boolean
      {
         var n:int = this._formats.length;
         for(var i:int = 0; i < n; i++)
         {
            if(this._formats[i] == format)
            {
               return true;
            }
         }
         return false;
      }
   }
}
