package mx.containers
{
   import mx.core.Container;
   import mx.containers.utilityClasses.IConstraintLayout;
   import mx.core.IFontContextComponent;
   import mx.core.mx_internal;
   import mx.containers.utilityClasses.Layout;
   import mx.core.IFlexDisplayObject;
   import mx.controls.Button;
   import mx.core.EdgeMetrics;
   import mx.core.UIComponentCachePolicy;
   import mx.containers.utilityClasses.ConstraintColumn;
   import mx.containers.utilityClasses.ConstraintRow;
   import mx.core.IUIComponent;
   import mx.core.IFlexModuleFactory;
   import mx.core.ContainerLayout;
   import mx.containers.utilityClasses.CanvasLayout;
   import mx.containers.utilityClasses.BoxLayout;
   import flash.events.Event;
   import mx.core.IUITextField;
   import mx.core.UIComponent;
   import flash.display.DisplayObject;
   import mx.styles.IStyleClient;
   import mx.styles.ISimpleStyleClient;
   import flash.events.MouseEvent;
   import mx.styles.StyleProxy;
   import flash.geom.Rectangle;
   import flash.display.Graphics;
   import flash.utils.getQualifiedClassName;
   import mx.core.UITextField;
   import mx.core.UITextFormat;
   import flash.text.TextLineMetrics;
   import mx.automation.IAutomationObject;
   import mx.events.SandboxMouseEvent;
   import mx.events.CloseEvent;
   import mx.effects.EffectManager;
   import mx.core.EventPriority;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.Panel",since="4.0")]
   [IconFile("Panel.png")]
   [AccessibilityClass(implementation="mx.accessibility.PanelAccImpl")]
   [Exclude(kind="effect",name="focusOutEffect")]
   [Exclude(kind="effect",name="focusInEffect")]
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusSkin")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Exclude(kind="event",name="focusOut")]
   [Exclude(kind="event",name="focusIn")]
   [Effect(name="resizeStartEffect",event="resizeStart")]
   [Effect(name="resizeEndEffect",event="resizeEnd")]
   [Style(inherit="no",name="titleStyleName",type="String")]
   [Style(inherit="no",name="titleBackgroundSkin",type="Class")]
   [Style(inherit="no",name="statusStyleName",type="String")]
   [Style(inherit="no",name="shadowDistance",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="shadowDirection",theme="halo",type="String",enumeration="left,center,right")]
   [Style(inherit="no",name="roundedBottomCorners",theme="halo",type="Boolean")]
   [Style(inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(arrayType="Number",inherit="no",name="highlightAlphas",theme="halo",type="Array")]
   [Style(inherit="no",name="headerHeight",format="Length",type="Number")]
   [Style(arrayType="uint",inherit="yes",name="headerColors",format="Color",theme="halo",type="Array")]
   [Style(arrayType="uint",inherit="yes",name="footerColors",format="Color",theme="halo",type="Array")]
   [Style(inherit="no",name="dropShadowEnabled",theme="halo",type="Boolean")]
   [Style(inherit="no",name="cornerRadius",format="Length",theme="halo, spark",type="Number")]
   [Style(inherit="no",name="controlBarStyleName",type="String")]
   [Style(inherit="no",name="borderThicknessTop",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="borderThicknessRight",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="borderThicknessLeft",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="borderThicknessBottom",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="borderAlpha",theme="halo, spark",type="Number")]
   [Style(inherit="yes",name="modalTransparencyDuration",format="Time",type="Number")]
   [Style(inherit="yes",name="modalTransparencyColor",format="Color",type="uint")]
   [Style(inherit="yes",name="modalTransparencyBlur",type="Number")]
   [Style(inherit="yes",name="modalTransparency",type="Number")]
   [Style(inherit="no",name="verticalGap",format="Length",type="Number")]
   [Style(inherit="no",name="horizontalGap",format="Length",type="Number")]
   [Style(inherit="no",name="verticalAlign",type="String",enumeration="bottom,middle,top")]
   [Style(inherit="no",name="horizontalAlign",type="String",enumeration="left,center,right")]
   public class Panel extends Container implements IConstraintLayout, IFontContextComponent
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const HEADER_PADDING:Number = 14;
      
      mx_internal static var createAccessibilityImplementation:Function;
      
      private static var _closeButtonStyleFilters:Object = {
         "closeButtonUpSkin":"closeButtonUpSkin",
         "closeButtonOverSkin":"closeButtonOverSkin",
         "closeButtonDownSkin":"closeButtonDownSkin",
         "closeButtonDisabledSkin":"closeButtonDisabledSkin",
         "closeButtonSkin":"closeButtonSkin",
         "repeatDelay":"repeatDelay",
         "repeatInterval":"repeatInterval"
      };
       
      private var layoutObject:Layout;
      
      mx_internal var _showCloseButton:Boolean = false;
      
      mx_internal var titleBarBackground:IFlexDisplayObject;
      
      mx_internal var titleIconObject:Object = null;
      
      mx_internal var closeButton:Button;
      
      private var initializing:Boolean = true;
      
      private var panelViewMetrics:EdgeMetrics;
      
      private var regX:Number;
      
      private var regY:Number;
      
      private var checkedForAutoSetRoundedCorners:Boolean;
      
      private var autoSetRoundedCorners:Boolean;
      
      private var _constraintColumns:Array;
      
      private var _constraintRows:Array;
      
      protected var controlBar:IUIComponent;
      
      private var _layout:String = "vertical";
      
      private var _status:String = "";
      
      private var _statusChanged:Boolean = false;
      
      protected var statusTextField:IUITextField;
      
      private var _title:String = "";
      
      private var _titleChanged:Boolean = false;
      
      protected var titleBar:UIComponent;
      
      private var _titleIcon:Class;
      
      private var _titleIconChanged:Boolean = false;
      
      protected var titleTextField:IUITextField;
      
      public function Panel()
      {
         this._constraintColumns = [];
         this._constraintRows = [];
         super();
         addEventListener("resizeStart",EffectManager.eventHandler,false,EventPriority.EFFECT);
         addEventListener("resizeEnd",EffectManager.eventHandler,false,EventPriority.EFFECT);
         this.layoutObject = new BoxLayout();
         this.layoutObject.target = this;
         showInAutomationHierarchy = true;
      }
      
      override public function get baselinePosition() : Number
      {
         if(!validateBaselinePosition())
         {
            return NaN;
         }
         return this.titleBar.y + this.titleTextField.y + this.titleTextField.baselinePosition;
      }
      
      override public function set cacheAsBitmap(value:Boolean) : void
      {
         super.cacheAsBitmap = value;
         if(Boolean(cacheAsBitmap) && Boolean(!contentPane) && Boolean(cachePolicy != UIComponentCachePolicy.OFF) && Boolean(getStyle("backgroundColor")))
         {
            createContentPane();
            invalidateDisplayList();
         }
      }
      
      [Inspectable(defaultValue="true",category="General",enumeration="true,false")]
      override public function set enabled(value:Boolean) : void
      {
         super.enabled = value;
         if(this.titleTextField)
         {
            this.titleTextField.enabled = value;
         }
         if(this.statusTextField)
         {
            this.statusTextField.enabled = value;
         }
         if(this.controlBar)
         {
            this.controlBar.enabled = value;
         }
         if(this.closeButton)
         {
            this.closeButton.enabled = value;
         }
      }
      
      protected function get closeButtonStyleFilters() : Object
      {
         return _closeButtonStyleFilters;
      }
      
      [Inspectable(arrayType="mx.containers.utilityClasses.ConstraintColumn")]
      [ArrayElementType("mx.containers.utilityClasses.ConstraintColumn")]
      public function get constraintColumns() : Array
      {
         return this._constraintColumns;
      }
      
      public function set constraintColumns(value:Array) : void
      {
         var n:int = 0;
         var i:int = 0;
         if(value != this._constraintColumns)
         {
            n = value.length;
            for(i = 0; i < n; i++)
            {
               ConstraintColumn(value[i]).container = this;
            }
            this._constraintColumns = value;
            invalidateSize();
            invalidateDisplayList();
         }
      }
      
      [Inspectable(arrayType="mx.containers.utilityClasses.ConstraintRow")]
      [ArrayElementType("mx.containers.utilityClasses.ConstraintRow")]
      public function get constraintRows() : Array
      {
         return this._constraintRows;
      }
      
      public function set constraintRows(value:Array) : void
      {
         var n:int = 0;
         var i:int = 0;
         if(value != this._constraintRows)
         {
            n = value.length;
            for(i = 0; i < n; i++)
            {
               ConstraintRow(value[i]).container = this;
            }
            this._constraintRows = value;
            invalidateSize();
            invalidateDisplayList();
         }
      }
      
      mx_internal function get _controlBar() : IUIComponent
      {
         return this.controlBar;
      }
      
      public function get fontContext() : IFlexModuleFactory
      {
         return moduleFactory;
      }
      
      public function set fontContext(moduleFactory:IFlexModuleFactory) : void
      {
         this.moduleFactory = moduleFactory;
      }
      
      [Inspectable(defaultValue="vertical",category="General",enumeration="vertical,horizontal,absolute")]
      [Bindable("layoutChanged")]
      public function get layout() : String
      {
         return this._layout;
      }
      
      public function set layout(value:String) : void
      {
         if(this._layout != value)
         {
            this._layout = value;
            if(this.layoutObject)
            {
               this.layoutObject.target = null;
            }
            if(this._layout == ContainerLayout.ABSOLUTE)
            {
               this.layoutObject = new CanvasLayout();
            }
            else
            {
               this.layoutObject = new BoxLayout();
               if(this._layout == ContainerLayout.VERTICAL)
               {
                  BoxLayout(this.layoutObject).direction = BoxDirection.VERTICAL;
               }
               else
               {
                  BoxLayout(this.layoutObject).direction = BoxDirection.HORIZONTAL;
               }
            }
            if(this.layoutObject)
            {
               this.layoutObject.target = this;
            }
            invalidateSize();
            invalidateDisplayList();
            dispatchEvent(new Event("layoutChanged"));
         }
      }
      
      [Inspectable(defaultValue="",category="General")]
      [Bindable("statusChanged")]
      public function get status() : String
      {
         return this._status;
      }
      
      public function set status(value:String) : void
      {
         this._status = value;
         this._statusChanged = true;
         invalidateProperties();
         dispatchEvent(new Event("statusChanged"));
      }
      
      [Inspectable(defaultValue="",category="General")]
      [Bindable("titleChanged")]
      public function get title() : String
      {
         return this._title;
      }
      
      public function set title(value:String) : void
      {
         this._title = value;
         this._titleChanged = true;
         invalidateProperties();
         invalidateSize();
         invalidateViewMetricsAndPadding();
         dispatchEvent(new Event("titleChanged"));
      }
      
      [Inspectable(defaultValue="",format="EmbeddedFile",category="General")]
      [Bindable("titleIconChanged")]
      public function get titleIcon() : Class
      {
         return this._titleIcon;
      }
      
      public function set titleIcon(value:Class) : void
      {
         this._titleIcon = value;
         this._titleIconChanged = true;
         invalidateProperties();
         invalidateSize();
         dispatchEvent(new Event("titleIconChanged"));
      }
      
      override mx_internal function get usePadding() : Boolean
      {
         return this.layout != ContainerLayout.ABSOLUTE;
      }
      
      override public function getChildIndex(child:DisplayObject) : int
      {
         if(Boolean(this.controlBar) && Boolean(child == this.controlBar))
         {
            return numChildren;
         }
         return super.getChildIndex(child);
      }
      
      override protected function initializeAccessibility() : void
      {
         if(Panel.createAccessibilityImplementation != null)
         {
            Panel.createAccessibilityImplementation(this);
         }
      }
      
      override protected function createChildren() : void
      {
         var titleBarBackgroundClass:Class = null;
         var backgroundUIComponent:IStyleClient = null;
         var backgroundStyleable:ISimpleStyleClient = null;
         super.createChildren();
         if(!this.titleBar)
         {
            this.titleBar = new UIComponent();
            this.titleBar.visible = false;
            this.titleBar.addEventListener(MouseEvent.MOUSE_DOWN,this.titleBar_mouseDownHandler);
            rawChildren.addChild(this.titleBar);
         }
         if(!this.titleBarBackground)
         {
            titleBarBackgroundClass = getStyle("titleBackgroundSkin");
            if(titleBarBackgroundClass)
            {
               this.titleBarBackground = new titleBarBackgroundClass();
               backgroundUIComponent = this.titleBarBackground as IStyleClient;
               if(backgroundUIComponent)
               {
                  backgroundUIComponent.setStyle("backgroundImage",undefined);
               }
               backgroundStyleable = this.titleBarBackground as ISimpleStyleClient;
               if(backgroundStyleable)
               {
                  backgroundStyleable.styleName = this;
               }
               this.titleBar.addChild(DisplayObject(this.titleBarBackground));
            }
         }
         this.createTitleTextField(-1);
         this.createStatusTextField(-1);
         if(!this.closeButton)
         {
            this.closeButton = new Button();
            this.closeButton.styleName = new StyleProxy(this,this.closeButtonStyleFilters);
            this.closeButton.upSkinName = "closeButtonUpSkin";
            this.closeButton.overSkinName = "closeButtonOverSkin";
            this.closeButton.downSkinName = "closeButtonDownSkin";
            this.closeButton.disabledSkinName = "closeButtonDisabledSkin";
            this.closeButton.skinName = "closeButtonSkin";
            this.closeButton.explicitWidth = this.closeButton.explicitHeight = 16;
            this.closeButton.focusEnabled = false;
            this.closeButton.visible = false;
            this.closeButton.enabled = enabled;
            this.closeButton.addEventListener(MouseEvent.CLICK,this.closeButton_clickHandler);
            this.titleBar.addChild(this.closeButton);
            this.closeButton.owner = this;
         }
      }
      
      override protected function commitProperties() : void
      {
         var childIndex:int = 0;
         super.commitProperties();
         if(hasFontContextChanged())
         {
            if(this.titleTextField)
            {
               childIndex = this.titleBar.getChildIndex(DisplayObject(this.titleTextField));
               this.removeTitleTextField();
               this.createTitleTextField(childIndex);
               this._titleChanged = true;
            }
            if(this.statusTextField)
            {
               childIndex = this.titleBar.getChildIndex(DisplayObject(this.statusTextField));
               this.removeStatusTextField();
               this.createStatusTextField(childIndex);
               this._statusChanged = true;
            }
         }
         if(this._titleChanged)
         {
            this._titleChanged = false;
            this.titleTextField.text = this._title;
            if(initialized)
            {
               this.layoutChrome(unscaledWidth,unscaledHeight);
            }
         }
         if(this._titleIconChanged)
         {
            this._titleIconChanged = false;
            if(this.titleIconObject)
            {
               this.titleBar.removeChild(DisplayObject(this.titleIconObject));
               this.titleIconObject = null;
            }
            if(this._titleIcon)
            {
               this.titleIconObject = new this._titleIcon();
               this.titleBar.addChild(DisplayObject(this.titleIconObject));
            }
            if(initialized)
            {
               this.layoutChrome(unscaledWidth,unscaledHeight);
            }
         }
         if(this._statusChanged)
         {
            this._statusChanged = false;
            this.statusTextField.text = this._status;
            if(initialized)
            {
               this.layoutChrome(unscaledWidth,unscaledHeight);
            }
         }
      }
      
      override protected function measure() : void
      {
         var controlWidth:Number = NaN;
         super.measure();
         this.layoutObject.measure();
         var textSize:Rectangle = this.measureHeaderText();
         var textWidth:Number = textSize.width;
         var textHeight:Number = textSize.height;
         var bm:EdgeMetrics = EdgeMetrics.EMPTY;
         textWidth = textWidth + (bm.left + bm.right);
         var offset:Number = 5;
         textWidth = textWidth + offset * 2;
         if(this.titleIconObject)
         {
            textWidth = textWidth + this.titleIconObject.width;
         }
         if(this.closeButton)
         {
            textWidth = textWidth + (this.closeButton.getExplicitOrMeasuredWidth() + 6);
         }
         measuredMinWidth = Math.max(textWidth,measuredMinWidth);
         measuredWidth = Math.max(textWidth,measuredWidth);
         if(Boolean(this.controlBar) && Boolean(this.controlBar.includeInLayout))
         {
            controlWidth = this.controlBar.getExplicitOrMeasuredWidth() + bm.left + bm.right;
            measuredWidth = Math.max(measuredWidth,controlWidth);
         }
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         this.layoutObject.updateDisplayList(unscaledWidth,unscaledHeight);
         if(border)
         {
            border.visible = true;
         }
         this.titleBar.visible = true;
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         var titleStyleName:String = null;
         var statusStyleName:String = null;
         var controlBarStyleName:String = null;
         var titleBackgroundSkinClass:Class = null;
         var backgroundUIComponent:IStyleClient = null;
         var backgroundStyleable:ISimpleStyleClient = null;
         var allStyles:Boolean = Boolean(!styleProp) || Boolean(styleProp == "styleName");
         super.styleChanged(styleProp);
         if(Boolean(allStyles) || Boolean(styleProp == "titleStyleName"))
         {
            if(this.titleTextField)
            {
               titleStyleName = getStyle("titleStyleName");
               this.titleTextField.styleName = titleStyleName;
            }
         }
         if(Boolean(allStyles) || Boolean(styleProp == "statusStyleName"))
         {
            if(this.statusTextField)
            {
               statusStyleName = getStyle("statusStyleName");
               this.statusTextField.styleName = statusStyleName;
            }
         }
         if(Boolean(allStyles) || Boolean(styleProp == "controlBarStyleName"))
         {
            if(Boolean(this.controlBar) && Boolean(this.controlBar is ISimpleStyleClient))
            {
               controlBarStyleName = getStyle("controlBarStyleName");
               ISimpleStyleClient(this.controlBar).styleName = controlBarStyleName;
            }
         }
         if(Boolean(allStyles) || Boolean(styleProp == "titleBackgroundSkin"))
         {
            if(this.titleBar)
            {
               titleBackgroundSkinClass = getStyle("titleBackgroundSkin");
               if(titleBackgroundSkinClass)
               {
                  if(this.titleBarBackground)
                  {
                     this.titleBar.removeChild(DisplayObject(this.titleBarBackground));
                     this.titleBarBackground = null;
                  }
                  this.titleBarBackground = new titleBackgroundSkinClass();
                  backgroundUIComponent = this.titleBarBackground as IStyleClient;
                  if(backgroundUIComponent)
                  {
                     backgroundUIComponent.setStyle("backgroundImage",undefined);
                  }
                  backgroundStyleable = this.titleBarBackground as ISimpleStyleClient;
                  if(backgroundStyleable)
                  {
                     backgroundStyleable.styleName = this;
                  }
                  this.titleBar.addChildAt(DisplayObject(this.titleBarBackground),0);
               }
            }
         }
      }
      
      override protected function layoutChrome(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var titleBarWidth:Number = NaN;
         var g:Graphics = null;
         var leftOffset:Number = NaN;
         var rightOffset:Number = NaN;
         var h:Number = NaN;
         var offset:Number = NaN;
         var borderWidth:Number = NaN;
         var statusX:Number = NaN;
         var minX:Number = NaN;
         var cx:Number = NaN;
         var cy:Number = NaN;
         var cw:Number = NaN;
         var ch:Number = NaN;
         super.layoutChrome(unscaledWidth,unscaledHeight);
         var em:EdgeMetrics = EdgeMetrics.EMPTY;
         var bt:Number = getStyle("borderThickness");
         if(Boolean(getQualifiedClassName(border) == "mx.skins.halo::PanelSkin") && Boolean(getStyle("borderStyle") != "default") && Boolean(bt))
         {
            em = new EdgeMetrics(bt,bt,bt,bt);
         }
         var bm:EdgeMetrics = em;
         var x:Number = bm.left;
         var y:Number = bm.top;
         var headerHeight:Number = this.getHeaderHeight();
         if(Boolean(headerHeight > 0) && Boolean(height >= headerHeight))
         {
            titleBarWidth = unscaledWidth - bm.left - bm.right;
            this.showTitleBar(true);
            this.titleBar.mouseChildren = true;
            this.titleBar.mouseEnabled = true;
            g = this.titleBar.graphics;
            g.clear();
            g.beginFill(16777215,0);
            g.drawRect(0,0,titleBarWidth,headerHeight);
            g.endFill();
            g.lineStyle(0,0,0);
            g.drawRect(0,0,titleBarWidth,unscaledHeight);
            this.titleBar.move(x,y);
            this.titleBar.setActualSize(titleBarWidth,headerHeight);
            if(this.titleBarBackground)
            {
               this.titleBarBackground.move(0,0);
               IFlexDisplayObject(this.titleBarBackground).setActualSize(titleBarWidth,headerHeight);
            }
            this.closeButton.visible = this._showCloseButton;
            if(this._showCloseButton)
            {
               this.closeButton.setActualSize(this.closeButton.getExplicitOrMeasuredWidth(),this.closeButton.getExplicitOrMeasuredHeight());
               this.closeButton.move(unscaledWidth - x - bm.right - 10 - this.closeButton.getExplicitOrMeasuredWidth(),(headerHeight - this.closeButton.getExplicitOrMeasuredHeight()) / 2);
            }
            leftOffset = 10;
            rightOffset = 10;
            if(this.titleIconObject)
            {
               h = this.titleIconObject.height;
               offset = (headerHeight - h) / 2;
               this.titleIconObject.move(leftOffset,offset);
               leftOffset = leftOffset + (this.titleIconObject.width + 4);
            }
            h = this.titleTextField.getUITextFormat().measureText(this.titleTextField.text).height;
            offset = (headerHeight - h) / 2;
            borderWidth = bm.left + bm.right;
            this.titleTextField.move(leftOffset,offset - 1);
            this.titleTextField.setActualSize(Math.max(0,unscaledWidth - leftOffset - rightOffset - borderWidth),h + UITextField.TEXT_HEIGHT_PADDING);
            h = this.statusTextField.text != ""?Number(this.statusTextField.getUITextFormat().measureText(this.statusTextField.text).height):Number(0);
            offset = (headerHeight - h) / 2;
            statusX = unscaledWidth - rightOffset - 4 - borderWidth - this.statusTextField.textWidth;
            if(this._showCloseButton)
            {
               statusX = statusX - (this.closeButton.getExplicitOrMeasuredWidth() + 4);
            }
            this.statusTextField.move(statusX,offset - 1);
            this.statusTextField.setActualSize(this.statusTextField.textWidth + 8,this.statusTextField.textHeight + UITextField.TEXT_HEIGHT_PADDING);
            minX = this.titleTextField.x + this.titleTextField.textWidth + 8;
            if(this.statusTextField.x < minX)
            {
               this.statusTextField.width = Math.max(this.statusTextField.width - (minX - this.statusTextField.x),0);
               this.statusTextField.x = minX;
            }
         }
         else if(this.titleBar)
         {
            this.showTitleBar(false);
            this.titleBar.mouseChildren = false;
            this.titleBar.mouseEnabled = false;
         }
         if(this.controlBar)
         {
            cx = this.controlBar.x;
            cy = this.controlBar.y;
            cw = this.controlBar.width;
            ch = this.controlBar.height;
            this.controlBar.setActualSize(unscaledWidth - (bm.left + bm.right),this.controlBar.getExplicitOrMeasuredHeight());
            this.controlBar.move(bm.left,unscaledHeight - bm.bottom - this.controlBar.getExplicitOrMeasuredHeight());
            if(this.controlBar.includeInLayout)
            {
               this.controlBar.visible = this.controlBar.y >= bm.top;
            }
            if(Boolean(cx != this.controlBar.x) || Boolean(cy != this.controlBar.y) || Boolean(cw != this.controlBar.width) || Boolean(ch != this.controlBar.height))
            {
               invalidateDisplayList();
            }
         }
      }
      
      override public function createComponentsFromDescriptors(recurse:Boolean = true) : void
      {
         var oldChildDocument:Object = null;
         super.createComponentsFromDescriptors();
         if(numChildren == 0)
         {
            this.setControlBar(null);
            return;
         }
         var lastChild:IUIComponent = IUIComponent(getChildAt(numChildren - 1));
         if(lastChild is ControlBar)
         {
            oldChildDocument = lastChild.document;
            if(contentPane)
            {
               contentPane.removeChild(DisplayObject(lastChild));
            }
            else
            {
               removeChild(DisplayObject(lastChild));
            }
            lastChild.document = oldChildDocument;
            rawChildren.addChild(DisplayObject(lastChild));
            this.setControlBar(lastChild);
         }
         else
         {
            this.setControlBar(null);
         }
      }
      
      mx_internal function createTitleTextField(childIndex:int) : void
      {
         var titleStyleName:String = null;
         if(!this.titleTextField)
         {
            this.titleTextField = IUITextField(createInFontContext(UITextField));
            this.titleTextField.selectable = false;
            if(childIndex == -1)
            {
               this.titleBar.addChild(DisplayObject(this.titleTextField));
            }
            else
            {
               this.titleBar.addChildAt(DisplayObject(this.titleTextField),childIndex);
            }
            titleStyleName = getStyle("titleStyleName");
            this.titleTextField.styleName = titleStyleName;
            this.titleTextField.text = this.title;
            this.titleTextField.enabled = enabled;
         }
      }
      
      mx_internal function removeTitleTextField() : void
      {
         if(Boolean(this.titleBar) && Boolean(this.titleTextField))
         {
            this.titleBar.removeChild(DisplayObject(this.titleTextField));
            this.titleTextField = null;
         }
      }
      
      mx_internal function createStatusTextField(childIndex:int) : void
      {
         var statusStyleName:String = null;
         if(Boolean(this.titleBar) && Boolean(!this.statusTextField))
         {
            this.statusTextField = IUITextField(createInFontContext(UITextField));
            this.statusTextField.selectable = false;
            if(childIndex == -1)
            {
               this.titleBar.addChild(DisplayObject(this.statusTextField));
            }
            else
            {
               this.titleBar.addChildAt(DisplayObject(this.statusTextField),childIndex);
            }
            statusStyleName = getStyle("statusStyleName");
            this.statusTextField.styleName = statusStyleName;
            this.statusTextField.text = this.status;
            this.statusTextField.enabled = enabled;
         }
      }
      
      mx_internal function removeStatusTextField() : void
      {
         if(Boolean(this.titleBar) && Boolean(this.statusTextField))
         {
            this.titleBar.removeChild(DisplayObject(this.statusTextField));
            this.statusTextField = null;
         }
      }
      
      private function measureHeaderText(useDummyString:Boolean = false) : Rectangle
      {
         var textFormat:UITextFormat = null;
         var metrics:TextLineMetrics = null;
         var textWidth:Number = 20;
         var textHeight:Number = 14;
         if(Boolean(this.titleTextField) && Boolean(this.titleTextField.text))
         {
            this.titleTextField.validateNow();
            textFormat = this.titleTextField.getUITextFormat();
            metrics = textFormat.measureText(this.titleTextField.text,false);
            textWidth = metrics.width;
            textHeight = metrics.height;
         }
         else if(useDummyString)
         {
            if(this.titleTextField)
            {
               textFormat = this.titleTextField.getUITextFormat();
               metrics = textFormat.measureText("Wj",false);
               textWidth = metrics.width;
               textHeight = metrics.height;
            }
         }
         if(Boolean(this.statusTextField) && Boolean(this.statusTextField.text))
         {
            this.statusTextField.validateNow();
            textFormat = this.statusTextField.getUITextFormat();
            metrics = textFormat.measureText(this.statusTextField.text,false);
            textWidth = Math.max(textWidth,metrics.width);
            textHeight = Math.max(textHeight,metrics.height);
         }
         return new Rectangle(0,0,Math.round(textWidth),Math.round(textHeight));
      }
      
      protected function getHeaderHeight() : Number
      {
         var headerHeight:Number = getStyle("headerHeight");
         if(isNaN(headerHeight))
         {
            headerHeight = this.measureHeaderText().height + HEADER_PADDING;
         }
         return headerHeight;
      }
      
      mx_internal function getHeaderHeightProxy(useDummyString:Boolean = false) : Number
      {
         var headerHeight:Number = getStyle("headerHeight");
         if(isNaN(headerHeight))
         {
            headerHeight = this.measureHeaderText(useDummyString).height + HEADER_PADDING;
         }
         return headerHeight;
      }
      
      private function showTitleBar(show:Boolean) : void
      {
         var child:DisplayObject = null;
         this.titleBar.visible = show;
         var n:int = this.titleBar.numChildren;
         for(var i:int = 0; i < n; i++)
         {
            child = this.titleBar.getChildAt(i);
            child.visible = show;
         }
      }
      
      private function setControlBar(newControlBar:IUIComponent) : void
      {
         if(newControlBar == this.controlBar)
         {
            return;
         }
         this.controlBar = newControlBar;
         if(!this.checkedForAutoSetRoundedCorners)
         {
            this.checkedForAutoSetRoundedCorners = true;
            this.autoSetRoundedCorners = Boolean(styleDeclaration)?Boolean(styleDeclaration.getStyle("roundedBottomCorners") === undefined):Boolean(true);
         }
         if(this.autoSetRoundedCorners)
         {
            setStyle("roundedBottomCorners",this.controlBar != null);
         }
         var controlBarStyleName:String = getStyle("controlBarStyleName");
         if(Boolean(controlBarStyleName) && Boolean(this.controlBar is ISimpleStyleClient))
         {
            ISimpleStyleClient(this.controlBar).styleName = controlBarStyleName;
         }
         if(this.controlBar)
         {
            this.controlBar.enabled = enabled;
         }
         if(this.controlBar is IAutomationObject)
         {
            IAutomationObject(this.controlBar).showInAutomationHierarchy = false;
         }
         invalidateViewMetricsAndPadding();
         invalidateSize();
         invalidateDisplayList();
      }
      
      protected function startDragging(event:MouseEvent) : void
      {
         this.regX = event.stageX - x;
         this.regY = event.stageY - y;
         var sbRoot:DisplayObject = systemManager.getSandboxRoot();
         sbRoot.addEventListener(MouseEvent.MOUSE_MOVE,this.systemManager_mouseMoveHandler,true);
         sbRoot.addEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         sbRoot.addEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.stage_mouseLeaveHandler);
         systemManager.deployMouseShields(true);
      }
      
      protected function stopDragging() : void
      {
         var sbRoot:DisplayObject = systemManager.getSandboxRoot();
         sbRoot.removeEventListener(MouseEvent.MOUSE_MOVE,this.systemManager_mouseMoveHandler,true);
         sbRoot.removeEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         sbRoot.removeEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.stage_mouseLeaveHandler);
         this.regX = NaN;
         this.regY = NaN;
         systemManager.deployMouseShields(false);
      }
      
      mx_internal function getTitleBar() : UIComponent
      {
         return this.titleBar;
      }
      
      mx_internal function getTitleTextField() : IUITextField
      {
         return this.titleTextField;
      }
      
      mx_internal function getStatusTextField() : IUITextField
      {
         return this.statusTextField;
      }
      
      mx_internal function getControlBar() : IUIComponent
      {
         return this.controlBar;
      }
      
      private function titleBar_mouseDownHandler(event:MouseEvent) : void
      {
         if(event.target == this.closeButton)
         {
            return;
         }
         if(Boolean(enabled) && Boolean(isPopUp) && Boolean(isNaN(this.regX)))
         {
            this.startDragging(event);
         }
      }
      
      private function systemManager_mouseMoveHandler(event:MouseEvent) : void
      {
         event.stopImmediatePropagation();
         if(Boolean(isNaN(this.regX)) || Boolean(isNaN(this.regY)))
         {
            return;
         }
         move(event.stageX - this.regX,event.stageY - this.regY);
      }
      
      private function systemManager_mouseUpHandler(event:MouseEvent) : void
      {
         if(!isNaN(this.regX))
         {
            this.stopDragging();
         }
      }
      
      private function stage_mouseLeaveHandler(event:Event) : void
      {
         if(!isNaN(this.regX))
         {
            this.stopDragging();
         }
      }
      
      private function closeButton_clickHandler(event:MouseEvent) : void
      {
         dispatchEvent(new CloseEvent(CloseEvent.CLOSE));
      }
   }
}
